/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.config;

import chemaxon.marvin.services.DynamicArgument;
import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceDescriptor;
import chemaxon.marvin.services.ServiceDescriptorWriter;
import java.io.OutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLBasedServiceDescriptorWriter
implements ServiceDescriptorWriter {
    @Override
    public void writeServiceDescriptors(List<ServiceDescriptor> descriptors, OutputStream output) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("Services");
            document.appendChild(root);
            for (ServiceDescriptor descriptor : descriptors) {
                Element element = document.createElement("Service");
                element.setAttribute("name", descriptor.getName());
                if (descriptor.getAlias() != null) {
                    element.setAttribute("alias", descriptor.getAlias());
                }
                element.setAttribute("method", descriptor.getMethodName());
                element.setAttribute("descriptor", descriptor.getClass().getCanonicalName());
                element.setAttribute("url", descriptor.getURL());
                for (String key : descriptor.getPropertyKeys()) {
                    String value = descriptor.getProperty(key);
                    if (value == null) continue;
                    element.setAttribute(key, value);
                }
                List<ServiceArgument<?>> arguments = descriptor.getArguments();
                if (arguments.size() > 0) {
                    Element argumentsElement = document.createElement("Arguments");
                    for (ServiceArgument<?> argument : arguments) {
                        Element argumentElement = document.createElement("Argument");
                        if (argument instanceof DynamicArgument) {
                            Element evaluatorElement = document.createElement("Evaluate");
                            if (((DynamicArgument)argument).getExpression() != null) {
                                evaluatorElement.setAttribute("expression", ((DynamicArgument)argument).getExpression());
                            }
                            evaluatorElement.setAttribute("class", argument.getClass().getCanonicalName());
                            argumentElement.appendChild(evaluatorElement);
                        }
                        if (argument.getValue() != null) {
                            argumentElement.setAttribute("value", String.valueOf(argument.getValue()));
                        }
                        argumentElement.setAttribute("class", argument.getType() == null ? "null" : argument.getType().getCanonicalName());
                        if (argument.getAlias() != null) {
                            argumentElement.setAttribute("alias", argument.getAlias());
                        }
                        if (argument.getName() != null) {
                            argumentElement.setAttribute("name", argument.getName());
                        }
                        argumentsElement.appendChild(argumentElement);
                    }
                    element.appendChild(argumentsElement);
                }
                root.appendChild(element);
            }
            Transformer optimusPrime = TransformerFactory.newInstance().newTransformer();
            optimusPrime.setOutputProperty("encoding", "UTF-8");
            optimusPrime.setOutputProperty("indent", "yes");
            optimusPrime.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            optimusPrime.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            optimusPrime.transform(new DOMSource(document), new StreamResult(output));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

