/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.httpservice;

import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceDescriptorEditor;
import chemaxon.marvin.services.httpservice.HTTPServiceDescriptor;
import chemaxon.marvin.services.ui.ArgumentEditorFactory;
import chemaxon.marvin.services.ui.ServiceArgumentEditor;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class HTTPServiceDescriptorEditor
implements ServiceDescriptorEditor<HTTPServiceDescriptor> {
    private static final Set<Class<?>> supportedClasses = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Double.class, Integer.class, String.class)));
    private JPanel mainPanel = null;
    private JTextField urlText = null;
    private JComboBox methodCombo = null;
    private ServiceArgumentEditor argumentEditor = null;
    private boolean valid = false;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            CellConstraints cc = new CellConstraints();
            FormLayout layout = new FormLayout("pref, 2dlu, fill:min:grow, 4dlu, fill:min:grow, 2dlu, pref", "2dlu, min, 2dlu, min, 2dlu, min, 2dlu, fill:min:grow, 2dlu");
            layout.setColumnGroups((int[][])new int[][]{{3, 5}});
            this.mainPanel = new JPanel((LayoutManager)layout);
            this.mainPanel.add((Component)new JLabel("Service URL: "), cc.xy(1, 2));
            this.mainPanel.add((Component)this.getURLText(), cc.xyw(3, 2, 5));
            this.mainPanel.add((Component)new JLabel("Call Method: "), cc.xy(1, 4));
            this.mainPanel.add((Component)this.getMethodCombo(), cc.xyw(3, 4, 5));
            this.mainPanel.add((Component)new JScrollPane(this.getArgumentEditor().getEditor()), cc.xyw(1, 8, 7));
        }
        return this.mainPanel;
    }

    private JTextField getURLText() {
        if (this.urlText == null) {
            this.urlText = new JTextField();
            this.urlText.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChanges(DocumentEvent e) {
                    HTTPServiceDescriptorEditor.this.validate();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChanges(e);
                }
            });
        }
        return this.urlText;
    }

    private ServiceArgumentEditor getArgumentEditor() {
        if (this.argumentEditor == null) {
            this.argumentEditor = ArgumentEditorFactory.createServiceArgumentEditor(true, supportedClasses);
            Component editor = this.argumentEditor.getEditor();
            if (editor instanceof JTable) {
                ((JTable)editor).getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        HTTPServiceDescriptorEditor.this.validate();
                    }
                });
            }
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    HTTPServiceDescriptorEditor.this.validate();
                }
            };
            this.argumentEditor.getEditor().addPropertyChangeListener("serviceArgument", listener);
        }
        return this.argumentEditor;
    }

    private void validate() {
        boolean oldValue = this.valid;
        try {
            URL url = new URL(this.getURLText().getText());
            this.valid = url.getHost().length() > 0;
        }
        catch (MalformedURLException e) {
            this.valid = false;
        }
        this.valid = this.valid && this.getArgumentEditor().hasValidArguments();
        this.getEditor().firePropertyChange("EditorValid", oldValue, this.valid);
    }

    private JComboBox getMethodCombo() {
        if (this.methodCombo == null) {
            this.methodCombo = new JComboBox<String>(new String[]{"GET", "POST"});
        }
        return this.methodCombo;
    }

    @Override
    public JComponent getEditor() {
        return this.getMainPanel();
    }

    @Override
    public HTTPServiceDescriptor getDescriptor() {
        Component editor = this.argumentEditor.getEditor();
        if (editor instanceof JTable && ((JTable)editor).getCellEditor() != null && !((JTable)editor).getCellEditor().stopCellEditing()) {
            ((JTable)editor).getCellEditor().cancelCellEditing();
        }
        this.validate();
        if (this.isValid()) {
            HTTPServiceDescriptor descriptor = new HTTPServiceDescriptor();
            descriptor.setURL(this.getURLText().getText().trim());
            descriptor.setMethodName(String.valueOf(this.getMethodCombo().getSelectedItem()));
            for (ServiceArgument<?> argument : this.getArgumentEditor().getServiceArguments()) {
                descriptor.addArgument(argument);
            }
            return descriptor;
        }
        return null;
    }

    @Override
    public void setDescriptor(HTTPServiceDescriptor descriptor) {
        this.getURLText().setText(descriptor == null ? "" : descriptor.getURL());
        this.getMethodCombo().setSelectedItem(descriptor == null ? "GET" : descriptor.getMethodName());
        this.getArgumentEditor().setServiceArguments(descriptor == null ? Collections.EMPTY_LIST : descriptor.getArguments());
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }
}

