/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.json;

import chemaxon.marvin.services.ServiceException;
import chemaxon.marvin.services.json.JsonServiceDescriptor;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonProcessor {
    public static final HashMap<String, Class<?>> typeMap = new HashMap();
    private boolean valid = false;
    private JSONObject descriptor = null;
    private String serviceURL = null;

    public JsonProcessor() {
        typeMap.put("number", Double.class);
        typeMap.put("string", String.class);
        typeMap.put("int", Integer.class);
        typeMap.put("integer", Integer.class);
        typeMap.put("double", Double.class);
        typeMap.put("boolean", Boolean.class);
        typeMap.put("object", Object.class);
    }

    public static String createMessage(JsonServiceDescriptor descriptor, Object[] arguments) throws ServiceException {
        JSONObject messageObject = new JSONObject();
        try {
            messageObject.append("method", (Object)descriptor.getMethodName());
            JSONObject parameterObject = new JSONObject();
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] instanceof Collection) {
                    JSONArray array = new JSONArray((Collection)arguments[i]);
                    parameterObject.append(descriptor.getArguments().get(i).getName(), (Object)array);
                    continue;
                }
                parameterObject.append(descriptor.getArguments().get(i).getName(), arguments[i]);
            }
            messageObject.append("params", (Object)parameterObject);
            messageObject.append("id", (Object)JsonServiceDescriptor.getId(descriptor.getMethodName()));
        }
        catch (JSONException e) {
            throw new ServiceException("JSON message can not be created:" + e.getMessage());
        }
        return messageObject.toString();
    }

    public static JSONObject extractResult(String resultText, JsonServiceDescriptor descriptor) throws ServiceException {
        JSONObject response = null;
        try {
            response = new JSONObject(resultText);
        }
        catch (JSONException e) {
            throw new ServiceException("JSON result can not be extracted: " + e.getMessage());
        }
        return response;
    }

    public String getServiceURL() {
        if (this.isValid()) {
            return this.serviceURL;
        }
        return "";
    }

    public void setURI(String URI2) throws Exception {
        URL descriptorUrl = new URL(URI2);
        BufferedReader in = new BufferedReader(new InputStreamReader(descriptorUrl.openStream()));
        try {
            String inputLine;
            StringBuilder descriptorBuilder = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                descriptorBuilder.append(inputLine);
            }
            this.descriptor = new JSONObject(descriptorBuilder.toString());
            URL service = new URL(this.descriptor.get("id").toString());
            this.serviceURL = service.toString();
            this.valid = true;
        }
        catch (Exception e) {
            this.valid = false;
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public String[] getOperations() {
        if (this.isValid()) {
            String[] entrySet = JSONObject.getNames((JSONObject)this.descriptor);
            LinkedList<String> operations = new LinkedList<String>();
            for (String entry : entrySet) {
                try {
                    JSONObject operation = this.descriptor.getJSONObject(entry);
                    if (!operation.get("type").equals("method")) {
                    }
                }
                catch (Exception e) {}
                continue;
                operations.add(entry);
            }
            return operations.toArray(new String[0]);
        }
        return null;
    }

    public List<String[]> getParameters(String operationName) throws ServiceException {
        if (this.isValid()) {
            try {
                JSONObject method = this.descriptor.getJSONObject(operationName);
                LinkedList<String[]> parameters = new LinkedList<String[]>();
                JSONArray params = method.getJSONArray("params");
                for (int i = 0; i < params.length(); ++i) {
                    JSONObject parameter = params.getJSONObject(i);
                    parameters.add(new String[]{parameter.getString("name"), parameter.getString("type")});
                }
                return parameters;
            }
            catch (JSONException e) {
                throw new ServiceException("Parameters of operation: " + operationName + " can not be extracted!");
            }
        }
        return null;
    }

    public Class<?> getReturnType(String operationName) throws ServiceException {
        if (this.isValid()) {
            try {
                JSONObject method = this.descriptor.getJSONObject(operationName);
                JSONObject returnType = method.getJSONObject("returns");
                return typeMap.get(returnType.getString("type"));
            }
            catch (JSONException e) {
                throw new ServiceException("Return type of operation: " + operationName + " can not be extracted!");
            }
        }
        return null;
    }

    public JsonServiceDescriptor.Method getMethod(String operationName) {
        if (this.isValid()) {
            try {
                JSONObject operation = this.descriptor.getJSONObject(operationName);
                String method = operation.get("method").toString();
                if (method.equalsIgnoreCase("post")) {
                    return JsonServiceDescriptor.Method.POST;
                }
                return JsonServiceDescriptor.Method.GET;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object getValueOf(JSONObject result) throws ServiceException {
        try {
            return JsonProcessor.extractFromJSON(result);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage());
        }
    }

    private static Object extractFromJSON(Object target) throws JSONException {
        if (target instanceof JSONArray) {
            JSONArray array = (JSONArray)target;
            if (array.length() == 1) {
                return JsonProcessor.extractFromJSON(array.get(0));
            }
            Object[] resultArray = new Object[array.length()];
            for (int i = 0; i < array.length(); ++i) {
                resultArray[i] = JsonProcessor.extractFromJSON(array.get(i));
            }
            return resultArray;
        }
        if (target instanceof JSONObject) {
            if (target == JSONObject.NULL) {
                return null;
            }
            JSONObject object = (JSONObject)target;
            String[] names = JSONObject.getNames((JSONObject)object);
            HashMap<String, Object> resultObject = new HashMap<String, Object>();
            for (int i = 0; i < names.length; ++i) {
                resultObject.put(names[i], JsonProcessor.extractFromJSON(object.get(names[i])));
            }
            return resultObject;
        }
        if (target instanceof String) {
            return target;
        }
        if (target instanceof Boolean) {
            return target;
        }
        if (target instanceof Number) {
            return target;
        }
        return null;
    }

    public String getDescription(String operationName) {
        if (this.isValid()) {
            try {
                JSONObject operation = this.descriptor.getJSONObject(operationName);
                return operation.get("description").toString();
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return null;
    }
}

