/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.json;

import chemaxon.marvin.services.ServiceException;
import chemaxon.marvin.services.ServiceHandler;
import chemaxon.marvin.services.json.JsonProcessor;
import chemaxon.marvin.services.json.JsonServiceDescriptor;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.json.JSONObject;

public class JsonServiceHandler
extends ServiceHandler<JsonServiceDescriptor> {
    @Override
    public Object callService(JsonServiceDescriptor descriptor, Object ... arguments) throws ServiceException {
        Object retVal = null;
        String answer = "";
        try {
            if (descriptor.getRequestMethod() == JsonServiceDescriptor.Method.GET) {
                answer = this.sendGETRequest(descriptor, arguments);
            } else {
                String content = JsonProcessor.createMessage(descriptor, arguments);
                answer = this.sendPOSTRequest(descriptor, content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceException(e.getMessage());
        }
        JSONObject jsonAnswer = JsonProcessor.extractResult(answer, descriptor);
        retVal = JsonProcessor.getValueOf(jsonAnswer);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendPOSTRequest(JsonServiceDescriptor descriptor, String content) throws MalformedURLException, IOException, ProtocolException, UnsupportedEncodingException {
        URL url = new URL(descriptor.getURL());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Content-type", "application/jsonrequest");
        OutputStream out = connection.getOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
            writer.write(content);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (IOException e) {
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter output = new OutputStreamWriter(bos);
        InputStream in = connection.getInputStream();
        try {
            InputStreamReader reader = new InputStreamReader(in);
            char[] buffer = new char[1024];
            int read = 0;
            while ((read = reader.read(buffer)) >= 0) {
                output.write(buffer, 0, read);
            }
            output.flush();
            ((Reader)reader).close();
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return bos.toString("UTF-8");
    }

    private String sendGETRequest(JsonServiceDescriptor descriptor, Object[] arguments) throws MalformedURLException, IOException, ProtocolException, UnsupportedEncodingException {
        StringBuffer address = new StringBuffer(descriptor.getURL());
        if (!address.toString().endsWith("/")) {
            address.append("/");
        }
        address.append(URLEncoder.encode(descriptor.getMethodName(), "UTF-8"));
        StringBuilder dataBuilder = new StringBuilder();
        for (int i = 0; i < descriptor.getArgumentCount(); ++i) {
            dataBuilder.append(URLEncoder.encode(descriptor.getArgument(i).getName(), "UTF-8"));
            dataBuilder.append("=");
            dataBuilder.append(URLEncoder.encode(arguments[i].toString(), "UTF-8"));
            if (i + 1 >= descriptor.getArgumentCount()) continue;
            dataBuilder.append("&");
        }
        if (descriptor.getArgumentCount() > 0) {
            address.append("?");
            address.append(dataBuilder.toString());
        }
        URL url = new URL(address.toString());
        URLConnection connection = url.openConnection();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuffer result = new StringBuffer();
        String data = null;
        while ((data = reader.readLine()) != null) {
            result.append(data);
        }
        return result.toString();
    }
}

