/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.localservice;

import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceDescriptorEditor;
import chemaxon.marvin.services.localservice.Alias;
import chemaxon.marvin.services.localservice.Description;
import chemaxon.marvin.services.localservice.LocalServiceDescriptor;
import chemaxon.marvin.services.ui.ArgumentEditorFactory;
import chemaxon.marvin.services.ui.ServiceArgumentEditor;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LocalServiceDescriptorEditor
implements ServiceDescriptorEditor<LocalServiceDescriptor> {
    public static final String PROPERTY_KEY_LAST_USED_DIR = "localServiceDescriptorEditorLastUsedDir";
    private JPanel mainPanel = null;
    private JTextField fileNameText = null;
    private JTree methodTree = null;
    private ServiceArgumentEditor argumentEditor = null;
    private JFileChooser fileChooser = null;
    private JSplitPane splitPane = null;
    private boolean valid = false;
    private String[] argumentAliases = null;
    private String methodAlias = null;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private static final Set<Class<?>> supportedClasses = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(MDocument.class, Molecule.class, String.class, Integer.class, Long.class, Double.class, Float.class, Boolean.class)));
    private Action BROWSE_ACTION = new AbstractAction("Browse"){

        @Override
        public void actionPerformed(ActionEvent e) {
            File dir;
            String path;
            Object userSettings = LocalServiceDescriptorEditor.this.getEditor().getClientProperty("UserSettings");
            if (userSettings instanceof UserSettings && (path = ((UserSettings)userSettings).getProperty(LocalServiceDescriptorEditor.PROPERTY_KEY_LAST_USED_DIR)) != null && (dir = new File(path)).canRead()) {
                LocalServiceDescriptorEditor.this.getFileChooser().setCurrentDirectory(dir);
            }
            if (LocalServiceDescriptorEditor.this.getFileChooser().showOpenDialog(LocalServiceDescriptorEditor.this.getEditor()) == 0) {
                if (userSettings instanceof UserSettings) {
                    ((UserSettings)userSettings).setProperty(LocalServiceDescriptorEditor.PROPERTY_KEY_LAST_USED_DIR, LocalServiceDescriptorEditor.this.getFileChooser().getCurrentDirectory().getAbsolutePath());
                }
                LocalServiceDescriptorEditor.this.fileNameText.setText(LocalServiceDescriptorEditor.this.getFileChooser().getSelectedFile().getAbsolutePath());
                LocalServiceDescriptorEditor.this.updateTree(LocalServiceDescriptorEditor.this.getFileChooser().getSelectedFile());
                LocalServiceDescriptorEditor.this.validate();
            }
        }
    };

    @Override
    public JComponent getEditor() {
        return this.getMainPanel();
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            CellConstraints cc = new CellConstraints();
            FormLayout layout = new FormLayout("pref, 2dlu, fill:min:grow, 4dlu, fill:min:grow, 2dlu, pref", "2dlu, min, 2dlu, min, 2dlu, fill:min:grow, 2dlu");
            layout.setColumnGroups((int[][])new int[][]{{3, 5}});
            this.mainPanel = new JPanel((LayoutManager)layout);
            this.mainPanel.add((Component)new JLabel("Java Archive (JAR): "), cc.xy(1, 2));
            this.mainPanel.add((Component)this.getFileNameText(), cc.xyw(3, 2, 3));
            this.mainPanel.add((Component)new JButton(this.BROWSE_ACTION), cc.xy(7, 2));
            this.mainPanel.add((Component)new JLabel("Select a function"), cc.xyw(1, 4, 7));
            this.mainPanel.add((Component)this.getSplitPane(), cc.xyw(1, 6, 7));
        }
        return this.mainPanel;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane(0, true, new JScrollPane(this.getMethodTree()), new JScrollPane(this.getArgumentEditor().getEditor()));
            this.splitPane.setResizeWeight(1.0);
            this.getArgumentEditor().getEditor().getParent().setBackground(this.getArgumentEditor().getEditor().getBackground());
        }
        return this.splitPane;
    }

    private JTextField getFileNameText() {
        if (this.fileNameText == null) {
            this.fileNameText = new JTextField();
            this.fileNameText.setEditable(false);
        }
        return this.fileNameText;
    }

    private JTree getMethodTree() {
        if (this.methodTree == null) {
            this.methodTree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.methodTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.methodTree.setRootVisible(false);
            this.methodTree.getSelectionModel().setSelectionMode(1);
            this.methodTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath path = e.getNewLeadSelectionPath();
                    LocalServiceDescriptorEditor.this.updateArgumentTable((TreeNode)(path == null ? null : path.getLastPathComponent()));
                    LocalServiceDescriptorEditor.this.validate();
                }
            });
        }
        return this.methodTree;
    }

    private ServiceArgumentEditor getArgumentEditor() {
        if (this.argumentEditor == null) {
            this.argumentEditor = ArgumentEditorFactory.createServiceArgumentEditor();
            Component editor = this.argumentEditor.getEditor();
            if (editor instanceof JTable) {
                ((JTable)editor).getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        LocalServiceDescriptorEditor.this.validate();
                    }
                });
            }
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    LocalServiceDescriptorEditor.this.validate();
                }
            };
            this.argumentEditor.getEditor().addPropertyChangeListener("serviceArgument", listener);
            this.updateArgumentTable(null);
        }
        return this.argumentEditor;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            try {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".jar");
                    }

                    @Override
                    public String getDescription() {
                        return "Java Archive File (*.jar)";
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileChooser;
    }

    private void updateTree(File file) {
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        if (file != null && file.canRead()) {
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                try {
                    loader = new URLClassLoader(new URL[]{file.toURI().toURL()}, loader);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, e.getMessage(), e);
                }
                JarInputStream stream = new JarInputStream(new FileInputStream(file));
                JarEntry entry = stream.getNextJarEntry();
                ArrayList<MethodDescriptor> entries = new ArrayList<MethodDescriptor>();
                while (entry != null) {
                    if (entry.getName().endsWith(".class")) {
                        String className = entry.getName().substring(0, entry.getName().length() - 6).replaceAll("/", "\\.");
                        Class<?> classInFile = Class.forName(className, false, loader);
                        boolean hasDefaultConstructor = false;
                        Constructor<?>[] constructors = classInFile.getConstructors();
                        for (int i = 0; i < constructors.length && !hasDefaultConstructor; ++i) {
                            if (constructors[i].getParameterTypes().length != 0) continue;
                            hasDefaultConstructor = true;
                        }
                        if (hasDefaultConstructor) {
                            for (Method method : classInFile.getMethods()) {
                                boolean skip = false;
                                if (method.getParameterTypes().length <= 0) continue;
                                Class<?>[] params = method.getParameterTypes();
                                for (int i = 0; i < params.length && !skip; ++i) {
                                    if (supportedClasses.contains(params[i])) continue;
                                    skip = true;
                                }
                                if (skip) continue;
                                entries.add(new MethodDescriptor(classInFile, method));
                            }
                        }
                    }
                    entry = stream.getNextJarEntry();
                }
                Collections.sort(entries, new Comparator<MethodDescriptor>(){

                    @Override
                    public int compare(MethodDescriptor o1, MethodDescriptor o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                for (MethodDescriptor descriptor : entries) {
                    StringBuilder builder = new StringBuilder(descriptor.getMethodClass().getName());
                    builder.append("/");
                    builder.append(descriptor.getMethod().getName());
                    builder.append(descriptor.getArgumentString());
                    String[] path = builder.toString().split("/");
                    MutableTreeNode node = (MutableTreeNode)model.getRoot();
                    for (int i = 0; i < path.length; ++i) {
                        MutableTreeNode nextNode = null;
                        for (int j = 0; j < node.getChildCount() && nextNode == null; ++j) {
                            if (!((DefaultMutableTreeNode)node.getChildAt(j)).getUserObject().equals(path[i])) continue;
                            nextNode = (MutableTreeNode)node.getChildAt(j);
                        }
                        if (nextNode == null) {
                            nextNode = new DefaultMutableTreeNode(path[i]);
                            if (i + 1 >= path.length) {
                                nextNode.setUserObject(descriptor);
                            }
                            node.insert(nextNode, node.getChildCount());
                        }
                        node = nextNode;
                    }
                }
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, t.getMessage(), t);
                JOptionPane.showMessageDialog(this.getEditor(), "Can not load jar file", "File error", 0);
                this.getFileNameText().setText("");
            }
        }
        this.getMethodTree().setModel(model);
    }

    private void updateArgumentTable(TreeNode node) {
        Component editor = this.getArgumentEditor().getEditor();
        if (editor instanceof JTable) {
            ((DefaultTableModel)((JTable)editor).getModel()).setRowCount(0);
        }
        if (node instanceof DefaultMutableTreeNode && node.isLeaf() && ((DefaultMutableTreeNode)node).getUserObject() instanceof MethodDescriptor) {
            Description descriptionAnnotation;
            MethodDescriptor descriptor = (MethodDescriptor)((DefaultMutableTreeNode)node).getUserObject();
            Alias aliasAnnotation = descriptor.method.getAnnotation(Alias.class);
            if (aliasAnnotation != null) {
                this.methodAlias = aliasAnnotation.name();
                this.argumentAliases = new String[descriptor.method.getParameterTypes().length];
                this.propertyChangeSupport.firePropertyChange("PreferredName", null, aliasAnnotation.name());
                for (int i = 0; i < this.argumentAliases.length; ++i) {
                    if (i >= aliasAnnotation.params().length) continue;
                    this.argumentAliases[i] = aliasAnnotation.params()[i];
                }
            } else {
                this.methodAlias = null;
                this.argumentAliases = null;
            }
            if ((descriptionAnnotation = descriptor.method.getAnnotation(Description.class)) != null) {
                this.propertyChangeSupport.firePropertyChange("PreferredDescription", null, descriptionAnnotation.value());
            }
            if (editor instanceof JTable) {
                for (int i = 0; i < descriptor.method.getParameterTypes().length; ++i) {
                    ((DefaultTableModel)((JTable)editor).getModel()).addRow(new Object[]{descriptor.method.getParameterTypes()[i], this.argumentAliases == null ? null : this.argumentAliases[i], null, null});
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component editor = LocalServiceDescriptorEditor.this.getArgumentEditor().getEditor();
                if (editor instanceof JTable) {
                    if (((JTable)editor).getRowCount() > 0) {
                        int prefLoc = LocalServiceDescriptorEditor.this.getSplitPane().getHeight() - ((JTable)editor).getTableHeader().getHeight();
                        for (int i = 0; i < ((JTable)editor).getRowCount(); ++i) {
                            prefLoc -= ((JTable)editor).getRowHeight(i) + ((JTable)editor).getRowMargin();
                        }
                        LocalServiceDescriptorEditor.this.getSplitPane().setDividerLocation(prefLoc -= ((JTable)editor).getRowHeight());
                    } else if (((JTable)editor).isDisplayable()) {
                        LocalServiceDescriptorEditor.this.getSplitPane().setDividerLocation(1.0);
                    }
                }
            }
        });
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private void validate() {
        TreePath path = this.getMethodTree().getSelectionPath();
        boolean oldValue = this.valid;
        boolean valid = path == null ? false : ((TreeNode)path.getLastPathComponent()).isLeaf();
        this.valid = valid = valid && this.getArgumentEditor().hasValidArguments();
        this.getEditor().firePropertyChange("EditorValid", oldValue, valid);
    }

    @Override
    public void setDescriptor(LocalServiceDescriptor descriptor) {
        if (descriptor == null) {
            this.getFileNameText().setText("");
            this.updateTree(null);
        } else {
            String fileName = descriptor.getURL();
            if (fileName == null) {
                this.getFileNameText().setText("");
            } else {
                this.getFileNameText().setText(fileName);
                this.updateTree(new File(fileName));
                TreePath path = LocalServiceDescriptorEditor.getMatchingMethodPath(this.getMethodTree().getModel().getRoot(), descriptor);
                this.getMethodTree().setSelectionPath(path);
                if (path != null) {
                    final List<ServiceArgument<?>> args = descriptor.getArguments();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LocalServiceDescriptorEditor.this.getArgumentEditor().setServiceArguments(args);
                        }
                    });
                }
            }
        }
    }

    @Override
    public LocalServiceDescriptor getDescriptor() {
        Component editor = this.getArgumentEditor().getEditor();
        if (editor instanceof JTable && ((JTable)editor).getCellEditor() != null && !((JTable)editor).getCellEditor().stopCellEditing()) {
            ((JTable)editor).getCellEditor().cancelCellEditing();
        }
        this.validate();
        if (this.isValid()) {
            DefaultMutableTreeNode node;
            TreePath path;
            if (editor instanceof JTable && ((JTable)editor).getCellEditor() != null && !((JTable)editor).getCellEditor().stopCellEditing()) {
                ((JTable)editor).getCellEditor().cancelCellEditing();
            }
            if ((path = this.getMethodTree().getSelectionPath()) != null && path.getLastPathComponent() instanceof DefaultMutableTreeNode && ((TreeNode)path.getLastPathComponent()).isLeaf() && (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof MethodDescriptor) {
                MethodDescriptor method = (MethodDescriptor)node.getUserObject();
                LocalServiceDescriptor descriptor = new LocalServiceDescriptor();
                descriptor.setURL(this.getFileNameText().getText());
                descriptor.setClassName(method.getMethodClass().getName());
                descriptor.setMethodName(method.getMethod().getName());
                for (ServiceArgument<?> argument : this.getArgumentEditor().getServiceArguments()) {
                    descriptor.addArgument(argument);
                }
                if (this.methodAlias != null) {
                    descriptor.setAlias(this.methodAlias);
                }
                if (this.argumentAliases != null) {
                    for (int i = 0; i < this.argumentAliases.length; ++i) {
                        if (i >= descriptor.getArgumentCount()) continue;
                        descriptor.getArgument(i).setAlias(this.argumentAliases[i]);
                    }
                }
                return descriptor;
            }
        }
        return null;
    }

    private static TreeNode getMatchingClassNode(DefaultMutableTreeNode root, String className) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (!(root.getChildAt(i) instanceof DefaultMutableTreeNode) || !className.equals(((DefaultMutableTreeNode)root.getChildAt(i)).getUserObject())) continue;
            return root.getChildAt(i);
        }
        return null;
    }

    private static boolean isMatchingDescriptors(MethodDescriptor methodDescriptor, LocalServiceDescriptor serviceDescriptor) {
        if (methodDescriptor.getMethod().getName().equals(serviceDescriptor.getMethodName())) {
            List<ServiceArgument<?>> serviceArguments = serviceDescriptor.getArguments();
            Class<?>[] args = methodDescriptor.getMethod().getParameterTypes();
            if (serviceArguments.size() == args.length) {
                boolean match = true;
                for (int i = 0; i < args.length && match; ++i) {
                    if (args[i].getName().equals(serviceArguments.get(i).getType().getName())) continue;
                    match = false;
                }
                return match;
            }
        }
        return false;
    }

    private static TreePath getMatchingMethodPath(Object root, LocalServiceDescriptor descriptor) {
        TreeNode classNode;
        if (root instanceof DefaultMutableTreeNode && (classNode = LocalServiceDescriptorEditor.getMatchingClassNode((DefaultMutableTreeNode)root, descriptor.getClassName())) instanceof DefaultMutableTreeNode) {
            for (int i = 0; i < classNode.getChildCount(); ++i) {
                DefaultMutableTreeNode methodNode;
                if (!(classNode.getChildAt(i) instanceof DefaultMutableTreeNode) || !((methodNode = (DefaultMutableTreeNode)classNode.getChildAt(i)).getUserObject() instanceof MethodDescriptor) || !LocalServiceDescriptorEditor.isMatchingDescriptors((MethodDescriptor)methodNode.getUserObject(), descriptor)) continue;
                return new TreePath(new Object[]{root, classNode, methodNode});
            }
        }
        return null;
    }

    private static final class MethodDescriptor {
        private final Class<?> methodClass;
        private final Method method;

        public MethodDescriptor(Class<?> methodClass, Method method) {
            this.methodClass = methodClass;
            this.method = method;
        }

        public String getArgumentString() {
            StringBuilder buffer = new StringBuilder("(");
            Class<?>[] params = this.method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                buffer.append(params[i].getName());
                if (i + 1 >= params.length) continue;
                buffer.append(", ");
            }
            buffer.append(")");
            return buffer.toString();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.method.getName());
            builder.append(this.getArgumentString());
            return builder.toString();
        }

        public Class<?> getMethodClass() {
            return this.methodClass;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

