/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.localservice;

import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceException;
import chemaxon.marvin.services.ServiceHandler;
import chemaxon.marvin.services.localservice.LocalServiceDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalServiceHandler
extends ServiceHandler<LocalServiceDescriptor> {
    private static final Map<String, Class<?>> classCache = Collections.synchronizedMap(new HashMap());
    private static final Map<String, Method> methodCache = Collections.synchronizedMap(new HashMap());

    @Override
    public Object callService(LocalServiceDescriptor descriptor, Object ... arguments) throws ServiceException {
        Object retVal = null;
        try {
            Method method = this.getServiceMethod(descriptor);
            if (method != null) {
                Class<?> serviceClass = classCache.get(descriptor.getClassName());
                retVal = method.invoke(serviceClass.newInstance(), arguments);
            }
        }
        catch (Throwable cause) {
            throw new ServiceException(cause);
        }
        return retVal;
    }

    protected Class<?> getServiceClass(LocalServiceDescriptor descriptor) throws ServiceException {
        if (classCache.containsKey(descriptor.getClassName())) {
            return classCache.get(descriptor.getClassName());
        }
        Class<?> serviceClass = null;
        ClassLoader loader = this.getClass().getClassLoader();
        File file = new File(String.valueOf(descriptor.getURL()));
        if (file != null && file.canRead() && file.isFile()) {
            try {
                loader = new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
            }
            catch (MalformedURLException e) {
                throw new ServiceException(e);
            }
        }
        try {
            serviceClass = Class.forName(descriptor.getClassName(), false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException(e);
        }
        classCache.put(descriptor.getClassName(), serviceClass);
        return serviceClass;
    }

    protected Method getServiceMethod(LocalServiceDescriptor descriptor) throws ServiceException {
        String key;
        Class<?> serviceClass = this.getServiceClass(descriptor);
        Method method = null;
        if (descriptor.getMethodName() != null) {
            StringBuilder builder = new StringBuilder(serviceClass.getName());
            builder.append(descriptor.getMethodName());
            for (int i = 0; i < descriptor.getArgumentCount(); ++i) {
                builder.append(descriptor.getArgument(i).getType().getName());
            }
            key = builder.toString();
            if (methodCache.containsKey(key)) {
                return methodCache.get(key);
            }
            try {
                List<ServiceArgument<?>> arguments = descriptor.getArguments();
                Class[] types = new Class[arguments.size()];
                for (int i = 0; i < arguments.size(); ++i) {
                    types[i] = arguments.get(i).getType();
                }
                method = serviceClass.getMethod(descriptor.getMethodName(), types);
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
        } else {
            throw new ServiceException("No method name specified");
        }
        methodCache.put(key, method);
        return method;
    }
}

