/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.soap;

import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceDescriptorEditor;
import chemaxon.marvin.services.soap.SoapServiceDescriptor;
import chemaxon.marvin.services.soap.WSDLProcessor;
import chemaxon.marvin.services.ui.ArgumentEditorFactory;
import chemaxon.marvin.services.ui.ServiceArgumentEditor;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SoapServiceDescriptorEditor
implements ServiceDescriptorEditor<SoapServiceDescriptor> {
    private WSDLProcessor wsdl;
    private static final Set<Class<?>> supportedClasses = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Double.class, Integer.class, String.class)));
    private JPanel panel;
    private JTextField wsdlURIText = null;
    private JFileChooser fileChooser = null;
    private JButton browseButton = null;
    private JTree methodTree = null;
    private JComboBox portSelector = null;
    private JSplitPane splitPane = null;
    private ServiceArgumentEditor argumentEditor = null;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean valid = false;

    @Override
    public JComponent getEditor() {
        if (this.panel == null) {
            this.wsdl = new WSDLProcessor();
            CellConstraints cc = new CellConstraints();
            FormLayout layout = new FormLayout("pref, 2dlu, fill:min:grow, 4dlu, pref, 2dlu, pref", "2dlu, min, 2dlu, min, 2dlu, fill:min:grow, 2dlu");
            layout.setColumnGroups((int[][])new int[][]{{3, 5}});
            this.panel = new JPanel((LayoutManager)layout);
            this.panel.add((Component)new JLabel("WSDL URI: "), cc.xy(1, 2));
            this.panel.add((Component)this.getWsdlURIText(), cc.xyw(3, 2, 3));
            this.panel.add((Component)this.getBrowseButton(), cc.xy(7, 2));
            this.panel.add((Component)new JLabel("Port:"), cc.xy(1, 4));
            this.panel.add((Component)this.getSplitPane(), cc.xyw(1, 6, 7));
            this.panel.add((Component)this.getPortSelector(), cc.xyw(3, 4, 5));
        }
        return this.panel;
    }

    private JTextField getWsdlURIText() {
        if (this.wsdlURIText == null) {
            this.wsdlURIText = new JTextField();
            this.wsdlURIText.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.getOppositeComponent() != null) {
                        if (!SoapServiceDescriptorEditor.this.validateWSDL()) {
                            JOptionPane.showMessageDialog(SoapServiceDescriptorEditor.this.getEditor(), "Can not load web service descriptor", "Descriptor error", 0);
                        } else {
                            SoapServiceDescriptorEditor.this.updateMethodTree();
                        }
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.wsdlURIText.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (!SoapServiceDescriptorEditor.this.validateWSDL()) {
                        JOptionPane.showMessageDialog(SoapServiceDescriptorEditor.this.getEditor(), "Can not load web service descriptor", "Descriptor error", 0);
                    } else {
                        SoapServiceDescriptorEditor.this.updateMethodTree();
                    }
                }
            });
        }
        return this.wsdlURIText;
    }

    private JButton getBrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton("Browse");
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SoapServiceDescriptorEditor.this.getFileChooser().showOpenDialog(SoapServiceDescriptorEditor.this.getEditor()) == 0) {
                        SoapServiceDescriptorEditor.this.getWsdlURIText().setText("file://localhost/" + SoapServiceDescriptorEditor.this.getFileChooser().getSelectedFile().getAbsolutePath());
                    }
                    SoapServiceDescriptorEditor.this.validateWSDL();
                }
            });
        }
        return this.browseButton;
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            try {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getAbsolutePath().toLowerCase().endsWith(".wsdl");
                    }

                    @Override
                    public String getDescription() {
                        return "Web Service Descriptor (*.wsdl)";
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileChooser;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane(0, true, new JScrollPane(this.getMethodTree()), new JScrollPane(this.getArgumentEditor().getEditor()));
            this.splitPane.setResizeWeight(1.0);
            this.getArgumentEditor().getEditor().getParent().setBackground(this.getArgumentEditor().getEditor().getBackground());
        }
        return this.splitPane;
    }

    private JTree getMethodTree() {
        if (this.methodTree == null) {
            this.methodTree = new JTree(new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.methodTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.methodTree.setRootVisible(true);
            this.methodTree.getSelectionModel().setSelectionMode(1);
            this.methodTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    SoapServiceDescriptorEditor.this.validate();
                    if (SoapServiceDescriptorEditor.this.valid) {
                        SoapServiceDescriptorEditor.this.updateArgumentTable();
                        SoapServiceDescriptorEditor.this.updatePortSelector();
                        TreePath path = SoapServiceDescriptorEditor.this.getMethodTree().getSelectionPath();
                        String operationName = path.getLastPathComponent().toString();
                        SoapServiceDescriptorEditor.this.getPropertyChangeSupport().firePropertyChange("PreferredName", "", operationName);
                        SoapServiceDescriptorEditor.this.updateDescription();
                    }
                }
            });
        }
        return this.methodTree;
    }

    private ServiceArgumentEditor getArgumentEditor() {
        if (this.argumentEditor == null) {
            this.argumentEditor = ArgumentEditorFactory.createServiceArgumentEditor(false, supportedClasses);
            Component editor = this.argumentEditor.getEditor();
            if (editor instanceof JTable) {
                ((JTable)editor).getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                    }
                });
            }
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                }
            };
            this.argumentEditor.getEditor().addPropertyChangeListener("serviceArgument", listener);
        }
        return this.argumentEditor;
    }

    private JComboBox getPortSelector() {
        if (this.portSelector == null) {
            this.portSelector = new JComboBox();
        }
        return this.portSelector;
    }

    @Override
    public SoapServiceDescriptor getDescriptor() {
        if (this.isValid()) {
            SoapServiceDescriptor descriptor = new SoapServiceDescriptor();
            descriptor.setWsdlURI(this.getWsdlURIText().getText());
            descriptor.setNameSpace(this.methodTree.getSelectionPath().getPath()[0].toString());
            descriptor.setWebServiceName(this.methodTree.getSelectionPath().getPath()[1].toString());
            descriptor.setMethodName(this.methodTree.getSelectionPath().getPath()[2].toString());
            descriptor.setURL(this.wsdl.getPortURL(this.portSelector.getSelectedItem().toString()));
            descriptor.setPortName(this.portSelector.getSelectedItem().toString());
            for (ServiceArgument<?> argument : this.getArgumentEditor().getServiceArguments()) {
                descriptor.addArgument(argument);
            }
            return descriptor;
        }
        return null;
    }

    @Override
    public void setDescriptor(SoapServiceDescriptor descriptor) {
        if (descriptor == null) {
            this.getWsdlURIText().setText("");
            this.validateWSDL();
            this.updateMethodTree();
            this.updateArgumentTable();
            this.updatePortSelector();
        } else {
            this.getWsdlURIText().setText(descriptor.getWsdlURI());
            this.validateWSDL();
            this.updateMethodTree();
            final String methodName = descriptor.getMethodName();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeModel model = SoapServiceDescriptorEditor.this.getMethodTree().getModel();
                    TreeNode root = (TreeNode)model.getRoot();
                    for (int i = 0; i < root.getChildCount(); ++i) {
                        TreeNode service = root.getChildAt(i);
                        for (int j = 0; j < service.getChildCount(); ++j) {
                            TreeNode operation = service.getChildAt(j);
                            if (!operation.toString().equals(methodName)) continue;
                            SoapServiceDescriptorEditor.this.getMethodTree().setSelectionPath(new TreePath(new Object[]{root, service, operation}));
                        }
                    }
                    SoapServiceDescriptorEditor.this.updatePortSelector();
                    SoapServiceDescriptorEditor.this.updateArgumentTable();
                }
            });
            final String portname = descriptor.getPortName();
            final List<ServiceArgument<?>> args = descriptor.getArguments();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SoapServiceDescriptorEditor.this.getArgumentEditor().setServiceArguments(args);
                    SoapServiceDescriptorEditor.this.getPortSelector().setSelectedItem(portname);
                }
            });
        }
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private boolean validateWSDL() {
        try {
            this.wsdl.setURI(this.getWsdlURIText().getText());
            if (this.wsdl.isValid()) {
                this.getMethodTree().setEnabled(true);
                this.updateMethodTree();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.valid = false;
        return false;
    }

    protected void validate() {
        boolean oldValue = this.valid;
        this.valid = this.wsdl.isValid() && this.methodTree.getSelectionPath() != null && this.methodTree.getSelectionPath().getPath().length >= 3;
        this.getEditor().firePropertyChange("EditorValid", oldValue, this.valid);
    }

    private void updateMethodTree() {
        if (!this.wsdl.isValid()) {
            DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
            this.getMethodTree().setModel(model);
            return;
        }
        ((DefaultTreeModel)this.methodTree.getModel()).setRoot(this.wsdl.getOperations());
        this.methodTree.expandRow(0);
    }

    private void updateArgumentTable() {
        if (this.valid) {
            Object[] selection = this.getMethodTree().getSelectionPath().getPath();
            List<String[]> parameters = this.wsdl.getInputParameters(selection[0].toString(), selection[1].toString(), selection[2].toString());
            if (parameters == null) {
                JOptionPane.showMessageDialog(this.getEditor(), "The parameter-set of the operation " + selection[2].toString() + " is not supported yet!", "Operation error", 0);
                this.getMethodTree().setSelectionPath(this.getMethodTree().getSelectionPath().getParentPath());
                this.updateArgumentTable();
                return;
            }
            LinkedList arguments = new LinkedList();
            for (String[] parameter : parameters) {
                ServiceArgument<Object> argument = ServiceArgument.createArgumentAs(null, WSDLProcessor.typeMap.get(parameter[1]));
                argument.setName(parameter[0]);
                arguments.add(argument);
            }
            ServiceArgumentEditor editor = this.getArgumentEditor();
            editor.setServiceArguments(arguments);
        } else {
            Component editor = this.getArgumentEditor().getEditor();
            if (editor instanceof JTable) {
                ((DefaultTableModel)((JTable)editor).getModel()).setRowCount(0);
            }
        }
        this.updateSplitPosition();
    }

    private void updateSplitPosition() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component editor = SoapServiceDescriptorEditor.this.getArgumentEditor().getEditor();
                if (editor instanceof JTable) {
                    if (((JTable)editor).getRowCount() > 0) {
                        int prefLoc = SoapServiceDescriptorEditor.this.getSplitPane().getHeight() - ((JTable)editor).getTableHeader().getHeight();
                        for (int i = 0; i < ((JTable)editor).getRowCount(); ++i) {
                            prefLoc -= ((JTable)editor).getRowHeight(i) + ((JTable)editor).getRowMargin();
                        }
                        SoapServiceDescriptorEditor.this.getSplitPane().setDividerLocation(prefLoc -= ((JTable)editor).getRowHeight());
                    } else if (((JTable)editor).isDisplayable()) {
                        SoapServiceDescriptorEditor.this.getSplitPane().setDividerLocation(1.0);
                    }
                }
            }
        });
    }

    private void updatePortSelector() {
        this.portSelector.removeAllItems();
        if (!this.isValid()) {
            this.portSelector.setEnabled(false);
            return;
        }
        this.portSelector.setEnabled(true);
        Object[] selection = this.methodTree.getSelectionPath().getPath();
        LinkedList<String> portList = this.wsdl.getPorts(selection[2].toString());
        for (String portName : portList) {
            this.portSelector.addItem(portName);
        }
        this.setPreferredPort();
    }

    private void setPreferredPort() {
        Matcher matcher;
        String element;
        int i;
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getPortSelector().getModel();
        String soapRegexp = ".*soap\\s*_*v*[12|1.2]+.*";
        Pattern pattern = Pattern.compile(soapRegexp, 2);
        for (i = 0; i < model.getSize(); ++i) {
            element = model.getElementAt(i).toString();
            matcher = pattern.matcher(element);
            if (!matcher.find()) continue;
            this.getPortSelector().setSelectedIndex(i);
        }
        soapRegexp = ".*soap.*";
        pattern = Pattern.compile(soapRegexp, 2);
        for (i = 0; i < model.getSize(); ++i) {
            element = model.getElementAt(i).toString();
            matcher = pattern.matcher(element);
            if (!matcher.find()) continue;
            this.getPortSelector().setSelectedIndex(i);
        }
    }

    private void updateDescription() {
        Object[] selection = this.methodTree.getSelectionPath().getPath();
        if (selection != null && selection.length == 3) {
            String description = this.wsdl.getDescription(selection[0].toString(), selection[1].toString(), selection[2].toString());
            this.getPropertyChangeSupport().firePropertyChange("PreferredDescription", "", description == null ? "" : description);
        }
    }
}

