/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.soap;

import chemaxon.marvin.services.ServiceException;
import com.ibm.wsdl.extensions.schema.SchemaImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.Text;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class WSDLProcessor {
    private String URI = "";
    private Definition definition;
    private boolean valid = false;
    private String nameSpaceAbbr = "xs";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private Map<String, LinkedList<String>> portsOfOperation;
    private Map<String, String> urlOfport = new HashMap<String, String>();
    public static HashMap<String, Class<?>> typeMap = new HashMap();

    public WSDLProcessor() {
        typeMap.put("{http://www.w3.org/2001/XMLSchema}string", String.class);
        typeMap.put("{http://www.w3.org/2001/XMLSchema}int", Integer.class);
        typeMap.put("{http://www.w3.org/2001/XMLSchema}double", Double.class);
        typeMap.put("{http://www.w3.org/2001/XMLSchema}float", Float.class);
        typeMap.put("{http://www.w3.org/2001/XMLSchema}boolean", Boolean.class);
        typeMap.put("{http://www.w3.org/2001/XMLSchema}anytype", Object.class);
    }

    public WSDLProcessor(String URI2) {
        this();
        try {
            this.setURI(URI2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void setURI(String URI2) throws ServiceException {
        if (URI2 == null || URI2.isEmpty()) {
            this.valid = false;
            return;
        }
        if (this.URI.equals(URI2)) {
            return;
        }
        this.URI = URI2;
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            this.definition = reader.readWSDL(URI2);
            Map namespaces = this.definition.getNamespaces();
            for (String key : namespaces.keySet()) {
                if (!XML_SCHEMA.equals(namespaces.get(key))) continue;
                this.nameSpaceAbbr = key;
                typeMap.put(key + ":string", String.class);
                typeMap.put(key + ":int", Integer.class);
                typeMap.put(key + ":double", Double.class);
                typeMap.put(key + ":float", Float.class);
                typeMap.put(key + ":boolean", Boolean.class);
                typeMap.put(key + ":anytype", Object.class);
            }
            this.valid = true;
        }
        catch (WSDLException e) {
            this.valid = false;
            throw new ServiceException("WSDL definition is not valid! Please note, that the supported versions are WSDL 1.0 and 1.1!");
        }
    }

    public String getURI() {
        return this.URI;
    }

    public MutableTreeNode getOperations() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setUserObject(this.definition.getTargetNamespace());
        this.portsOfOperation = new HashMap<String, LinkedList<String>>();
        Map services = this.definition.getServices();
        for (Object servicekey : services.keySet()) {
            QName serviceName = ((Service)services.get(servicekey)).getQName();
            DefaultMutableTreeNode serviceNode = new DefaultMutableTreeNode(serviceName.getLocalPart());
            root.insert(serviceNode, root.getChildCount());
            Service service = this.definition.getService(serviceName);
            for (Object portkey : service.getPorts().keySet()) {
                Port port = (Port)service.getPorts().get(portkey);
                String portName = this.getPortURL(port);
                if (portName != null) {
                    this.urlOfport.put(port.getName(), portName);
                }
                Binding binding = port.getBinding();
                PortType portType = binding.getPortType();
                List operations = portType.getOperations();
                for (Object operation : operations) {
                    String operationName = ((Operation)operation).getName();
                    if (this.portsOfOperation.containsKey(operationName)) {
                        this.portsOfOperation.get(operationName).add(port.getName());
                        continue;
                    }
                    DefaultMutableTreeNode operationNode = new DefaultMutableTreeNode(operationName);
                    serviceNode.insert(operationNode, serviceNode.getChildCount());
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(port.getName());
                    this.portsOfOperation.put(operationName, list);
                }
            }
        }
        return root;
    }

    public List<String[]> getInputParameters(String nameSpace, String serviceName, String operationName) throws IllegalArgumentException {
        Operation operation = this.getOperation(nameSpace, serviceName, operationName);
        Input input = operation.getInput();
        Message message = input.getMessage();
        return this.getParametersOfMessage(message);
    }

    public Class<?>[] getOutputParameters(String nameSpace, String serviceName, String operationName) {
        Operation operation = this.getOperation(nameSpace, serviceName, operationName);
        Output output = operation.getOutput();
        Message message = output.getMessage();
        List<String[]> parameters = this.getParametersOfMessage(message);
        if (parameters == null) {
            // empty if block
        }
        Class[] types = new Class[parameters.size()];
        int i = 0;
        for (String[] parameter : parameters) {
            types[i] = typeMap.get(parameter[1]);
            ++i;
        }
        return types;
    }

    public LinkedList<String> getPorts(String operationName) {
        return this.portsOfOperation.get(operationName);
    }

    private Operation getOperation(String namespace, String serviceName, String operationName) {
        QName serviceQName = new QName(namespace, serviceName);
        Service service = this.definition.getService(serviceQName);
        Binding currentBinding = null;
        for (Object portkey : service.getPorts().keySet()) {
            currentBinding = ((Port)service.getPorts().get(portkey)).getBinding();
            PortType portType = currentBinding.getPortType();
            List operations = portType.getOperations();
            for (Object operation : operations) {
                if (!((Operation)operation).getName().equals(operationName)) continue;
                return (Operation)operation;
            }
        }
        return null;
    }

    public boolean isValid() {
        return this.valid;
    }

    private List<String[]> getParametersOfMessage(Message message) throws IllegalArgumentException {
        LinkedList<String[]> result = new LinkedList<String[]>();
        Part parameters = message.getPart("parameters");
        if (parameters == null) {
            Map parts = message.getParts();
            for (Object partKey : parts.keySet()) {
                Part part = (Part)parts.get(partKey);
                if (!typeMap.containsKey(part.getTypeName().toString())) {
                    return null;
                }
                result.add(new String[]{part.getName(), part.getTypeName().toString()});
            }
            return result;
        }
        QName parameterTypeName = parameters.getElementName();
        Types allTypes = this.definition.getTypes();
        List elements = allTypes.getExtensibilityElements();
        for (Object element : elements) {
            SchemaImpl schema = (SchemaImpl)element;
            Element elem = schema.getElement();
            NodeList nodes = elem.getElementsByTagName(this.nameSpaceAbbr + ":element");
            for (int j = 0; j < nodes.getLength(); ++j) {
                if (!nodes.item(j).getAttributes().getNamedItem("name").getNodeValue().equals(parameterTypeName.getLocalPart())) continue;
                Element typeNode = (Element)nodes.item(j);
                NodeList types = typeNode.getElementsByTagName(this.nameSpaceAbbr + ":element");
                for (int k = 0; k < types.getLength(); ++k) {
                    String name = types.item(k).getAttributes().getNamedItem("name").getNodeValue();
                    String type = types.item(k).getAttributes().getNamedItem("type").getNodeValue();
                    if (!typeMap.containsKey(type)) {
                        return null;
                    }
                    result.add(new String[]{name, type});
                }
                return result;
            }
        }
        return null;
    }

    public String getDescription(String namespace, String serviceName, String operationName) {
        Operation operation = this.getOperation(namespace, serviceName, operationName);
        Element element = operation.getDocumentationElement();
        if (element == null) {
            return null;
        }
        return element.getTextContent();
    }

    private String getPortURL(Port port) {
        ExtensibilityElement element = WSDLProcessor.findExtensibilityElement((ElementExtensible)port, "address");
        if (element instanceof SOAPAddress) {
            return ((SOAPAddress)element).getLocationURI();
        }
        if (element instanceof SOAP12Address) {
            return ((SOAP12Address)element).getLocationURI();
        }
        if (element instanceof HTTPAddress) {
            return ((HTTPAddress)element).getLocationURI();
        }
        return null;
    }

    private static ExtensibilityElement findExtensibilityElement(ElementExtensible extensibleElement, String elementType) {
        List extensibilityElements = extensibleElement.getExtensibilityElements();
        if (extensibilityElements != null) {
            for (Object o : extensibilityElements) {
                ExtensibilityElement element = (ExtensibilityElement)o;
                if (!element.getElementType().getLocalPart().equalsIgnoreCase(elementType)) continue;
                return element;
            }
        }
        return null;
    }

    public String getPortURL(String portName) {
        return this.urlOfport.get(portName);
    }

    private List<String[]> parameterSearch(Operation operation, Message in) {
        List paramOrdering = operation.getParameterOrdering();
        List inParts = in.getOrderedParts(paramOrdering);
        LinkedList<String[]> result = new LinkedList<String[]>();
        for (Object p : inParts) {
            String type;
            String name;
            Part part = (Part)p;
            if (part.getElementName() == null) {
                name = part.getName();
                type = part.getTypeName().toString();
                result.add(new String[]{name, type});
            }
            name = part.getName();
            type = part.getTypeName() == null ? "unknown" : part.getTypeName().toString();
            result.add(new String[]{name, type});
        }
        return result;
    }

    private Element getElementForTypeName(QName parameterTypeName) {
        Types allTypes = this.definition.getTypes();
        List elements = allTypes.getExtensibilityElements();
        Iterator i$ = elements.iterator();
        if (i$.hasNext()) {
            Object element = i$.next();
            SchemaImpl schema = (SchemaImpl)element;
            Element elem = schema.getElement();
            return elem;
        }
        return null;
    }

    public Object[] getValueOf(SOAPMessage message) throws Exception {
        SOAPBody body = message.getSOAPBody();
        LinkedList<Object> result = new LinkedList<Object>();
        Iterator it = body.getChildElements();
        while (it.hasNext()) {
            result.add(this.processWSDLObject((SOAPElement)((SOAPBodyElement)it.next())));
        }
        return result.toArray();
    }

    private Object processWSDLObject(SOAPElement element) {
        if (element.hasChildNodes()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator it = element.getChildElements();
            SOAPElement child = null;
            while (it.hasNext()) {
                Object entry = it.next();
                if (entry instanceof Text) {
                    return ((Text)entry).getNodeValue();
                }
                child = (SOAPElement)entry;
                map.put(child.getLocalName(), this.processWSDLObject(child));
            }
            if (map.size() == 1) {
                return this.processWSDLObject(child);
            }
            return map;
        }
        return element.getValue();
    }
}

