/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.ui;

import chemaxon.marvin.services.AsyncCallback;
import chemaxon.marvin.services.DynamicArgument;
import chemaxon.marvin.services.ServiceArgument;
import chemaxon.marvin.services.ServiceDescriptor;
import chemaxon.marvin.services.ServiceException;
import chemaxon.marvin.services.ui.ArgumentEditorFactory;
import chemaxon.marvin.services.ui.FlexibleScrollPane;
import chemaxon.marvin.services.ui.ServiceArgumentEditor;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class AbstractServiceDialogPanel
extends JPanel {
    private static final long serialVersionUID = -3347049461138350297L;
    private static final Icon expandIcon;
    private static final Icon collapseIcon;
    private JLabel structureLabel = null;
    private JLabel argumentsLabel = null;
    private JLabel resultsLabel = null;
    private ServiceArgumentEditor argumentEditor = null;
    private JPanel inputPanel = null;
    private JPanel contentPanel = null;
    private JPanel tablePanel = null;
    private JCheckBox autoCallCheck = null;
    private JButton calculateButton = null;
    private JButton updateButton = null;
    protected final ServiceDescriptor descriptor;
    protected final List<ServiceArgument<?>> arguments;
    protected final Object[] evaluated;
    protected FlexibleScrollPane resultsScrollPane = null;
    private static final int VERTICAL_SCROLLBAR_UNIT_INCREMENT = 30;
    protected final Action callService = new AbstractAction("Calculate"){
        private static final long serialVersionUID = 7175477168238984294L;

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            try {
                AbstractServiceDialogPanel.this.descriptor.getServiceHandler().callService(AbstractServiceDialogPanel.this.descriptor, new AsyncCallback<Object>(){

                    @Override
                    public void onSuccess(Object result) {
                        AbstractServiceDialogPanel.this.callSucceed(result);
                    }

                    @Override
                    public void onFailure(ServiceException caught) {
                        AbstractServiceDialogPanel.this.callFailed(caught);
                    }
                }, AbstractServiceDialogPanel.this.evaluated);
            }
            catch (Throwable t) {
                AbstractServiceDialogPanel.this.callFailed(new ServiceException("Service call failed.", t));
            }
        }
    };
    protected final Action updateAction = new AbstractAction("Update"){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractServiceDialogPanel.this.updateInput();
            AbstractServiceDialogPanel.this.updateManualArguments();
            AbstractServiceDialogPanel.this.callService.setEnabled(AbstractServiceDialogPanel.this.canCallService());
        }
    };

    protected FlexibleScrollPane getResultsScrollPane() {
        if (this.resultsScrollPane == null) {
            this.resultsScrollPane = new FlexibleScrollPane(1, this.getResultsView());
            this.resultsScrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.resultsScrollPane.setWheelScrollingEnabled(false);
        }
        return this.resultsScrollPane;
    }

    protected AbstractServiceDialogPanel(ServiceDescriptor descriptor) {
        this.descriptor = descriptor;
        this.arguments = descriptor.getArguments();
        this.evaluated = new Object[this.arguments.size()];
    }

    protected void initUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane scroll = new JScrollPane(this.getContentPanel(), 20, 31);
        scroll.getVerticalScrollBar().setUnitIncrement(30);
        scroll.setBorder(BorderFactory.createEmptyBorder());
        this.add(scroll);
        this.add(this.getAutoCallCheck());
        this.add(this.getCalculateButton());
    }

    protected void callSucceed(Object result) {
        this.updateResults(result);
        this.setEnabled(true);
    }

    protected void callFailed(ServiceException exception) {
        this.updateResults(null);
        this.setEnabled(true);
    }

    protected JPanel getContentPanel() {
        if (this.contentPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.contentPanel = new JPanel((LayoutManager)new FormLayout("fill:min:grow", "min, 2dlu, fill:min, 4dlu, min, 2dlu, fill:min, 4dlu, min, 2dlu, fill:pref:grow"));
            this.contentPanel.add((Component)this.getStructureLabel(), cc.xy(1, 1));
            this.contentPanel.add((Component)this.getInputPanel(), cc.xy(1, 3));
            this.contentPanel.add((Component)this.getArgumentsLabel(), cc.xy(1, 5));
            this.contentPanel.add((Component)this.getTablePanel(), cc.xy(1, 7));
            this.contentPanel.add((Component)this.getResultsLabel(), cc.xy(1, 9));
            this.contentPanel.add((Component)this.getResultsScrollPane(), cc.xy(1, 11));
            this.contentPanel.setAlignmentX(0.5f);
        }
        return this.contentPanel;
    }

    protected JPanel getTablePanel() {
        if (this.tablePanel == null) {
            this.tablePanel = new JPanel(new BorderLayout());
            this.tablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.tablePanel.add(this.getArgumentEditor().getEditor(), "Center");
            this.tablePanel.setBackground(Color.WHITE);
            this.tablePanel.setAlignmentX(0.5f);
        }
        return this.tablePanel;
    }

    protected JButton getCalculateButton() {
        if (this.calculateButton == null) {
            this.calculateButton = new JButton(this.callService);
            this.calculateButton.setAlignmentX(0.5f);
        }
        return this.calculateButton;
    }

    protected JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton(this.updateAction);
        }
        return this.updateButton;
    }

    protected JLabel getStructureLabel() {
        if (this.structureLabel == null) {
            this.structureLabel = new JLabel("Structure", collapseIcon, 2);
            this.structureLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AbstractServiceDialogPanel.this.getInputPanel().setVisible(!AbstractServiceDialogPanel.this.getInputPanel().isVisible());
                    AbstractServiceDialogPanel.this.structureLabel.setIcon(AbstractServiceDialogPanel.this.getInputPanel().isVisible() ? collapseIcon : expandIcon);
                    AbstractServiceDialogPanel.this.getContentPanel().validate();
                }
            });
            this.structureLabel.setOpaque(false);
            this.structureLabel.setAlignmentX(0.0f);
        }
        return this.structureLabel;
    }

    protected JLabel getArgumentsLabel() {
        if (this.argumentsLabel == null) {
            this.argumentsLabel = new JLabel("Arguments", collapseIcon, 2);
            this.argumentsLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AbstractServiceDialogPanel.this.getTablePanel().setVisible(!AbstractServiceDialogPanel.this.getTablePanel().isVisible());
                    AbstractServiceDialogPanel.this.argumentsLabel.setIcon(AbstractServiceDialogPanel.this.getTablePanel().isVisible() ? collapseIcon : expandIcon);
                }
            });
            this.argumentsLabel.setOpaque(false);
            this.argumentsLabel.setAlignmentX(0.0f);
        }
        return this.argumentsLabel;
    }

    protected JCheckBox getAutoCallCheck() {
        if (this.autoCallCheck == null) {
            this.autoCallCheck = new JCheckBox(new AbstractAction("Calculate automatically"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractServiceDialogPanel.this.updateAction.setEnabled(!AbstractServiceDialogPanel.this.autoCallCheck.isSelected());
                    if (AbstractServiceDialogPanel.this.autoCallCheck.isSelected()) {
                        AbstractServiceDialogPanel.this.updateAction.actionPerformed(null);
                        if (AbstractServiceDialogPanel.this.callService.isEnabled()) {
                            AbstractServiceDialogPanel.this.callService.actionPerformed(null);
                        }
                    }
                }
            });
            this.autoCallCheck.setAlignmentX(0.5f);
            this.autoCallCheck.setToolTipText("Calculate automatically on structure change");
            this.autoCallCheck.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        return this.autoCallCheck;
    }

    protected JLabel getResultsLabel() {
        if (this.resultsLabel == null) {
            this.resultsLabel = new JLabel("Results", collapseIcon, 2);
            this.resultsLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    AbstractServiceDialogPanel.this.getResultsScrollPane().setVisible(!AbstractServiceDialogPanel.this.getResultsScrollPane().isVisible());
                    AbstractServiceDialogPanel.this.resultsLabel.setIcon(AbstractServiceDialogPanel.this.getResultsScrollPane().isVisible() ? collapseIcon : expandIcon);
                }
            });
            this.resultsLabel.setOpaque(false);
            this.resultsLabel.setAlignmentX(0.0f);
        }
        return this.resultsLabel;
    }

    protected JPanel getInputPanel() {
        if (this.inputPanel == null) {
            CellConstraints cc = new CellConstraints();
            this.inputPanel = new JPanel((LayoutManager)new FormLayout("fill:pref:grow, min, fill:pref:grow", "fill:pref:grow, 2dlu, min"));
            this.inputPanel.add(this.getInputView(), cc.xyw(1, 1, 3));
            this.inputPanel.add((Component)this.getUpdateButton(), cc.xy(2, 3));
            this.inputPanel.setOpaque(true);
            this.inputPanel.setBackground(this.getInputView().getBackground());
            this.inputPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.inputPanel.setAlignmentX(0.5f);
        }
        return this.inputPanel;
    }

    protected ServiceArgumentEditor getArgumentEditor() {
        if (this.argumentEditor == null) {
            this.argumentEditor = ArgumentEditorFactory.createFillArgumentTable(this.descriptor.getArguments());
            Component editor = this.argumentEditor.getEditor();
            if (editor instanceof JTable) {
                ((JTable)editor).getModel().addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        if (AbstractServiceDialogPanel.this.getAutoCallCheck().isSelected()) {
                            AbstractServiceDialogPanel.this.updateAction.actionPerformed(null);
                            if (AbstractServiceDialogPanel.this.callService.isEnabled()) {
                                AbstractServiceDialogPanel.this.callService.actionPerformed(null);
                            }
                        } else {
                            AbstractServiceDialogPanel.this.updateManualArguments();
                            AbstractServiceDialogPanel.this.callService.setEnabled(AbstractServiceDialogPanel.this.canCallService());
                        }
                    }
                });
                ((JTable)editor).setBorder(null);
            }
        }
        return this.argumentEditor;
    }

    protected void updateManualArguments() {
        Component editor = this.getArgumentEditor().getEditor();
        if (editor instanceof JTable) {
            for (int i = 0; i < this.evaluated.length; ++i) {
                if (this.arguments.get(i) instanceof DynamicArgument) continue;
                ServiceArgument argument = (ServiceArgument)((JTable)editor).getValueAt(i, ((JTable)editor).getColumnCount() - 1);
                this.evaluated[i] = argument == null ? null : argument.getValue();
            }
        }
    }

    protected boolean canCallService() {
        for (Object value : this.evaluated) {
            if (value != null) continue;
            return false;
        }
        return true;
    }

    protected abstract Component getResultsView();

    protected abstract Component getInputView();

    protected abstract void updateInput();

    protected abstract void updateResults(Object var1);

    protected void createHTMLRepresentationOf(StringBuffer target, Object source, int depth) {
        for (int i = 0; i < depth; ++i) {
            target.append("\t");
        }
        if (source.getClass().isArray()) {
            try {
                Object[] array = (Object[])source;
                target.append("<table border=\"1\"><tr>");
                for (int i = 0; i < array.length; ++i) {
                    target.append("<tr>");
                    this.createHTMLRepresentationOf(target, array[i], depth + 1);
                    target.append("</tr>");
                }
                target.append("</table>");
            }
            catch (Exception e) {}
        } else if (source instanceof Map) {
            Map map = (Map)source;
            target.append("<table border=\"1\"><tr>");
            for (Object object : map.keySet()) {
                target.append("<tr>");
                this.createHTMLRepresentationOf(target, object, depth + 1);
                target.append("<td>");
                this.createHTMLRepresentationOf(target, map.get(object), depth + 1);
                target.append("</tr>");
            }
            target.append("</table>");
        } else if (source instanceof Iterable) {
            Iterable list = (Iterable)source;
            target.append("<table border=\"1\"><tr>");
            for (Object object : list) {
                target.append("<tr>");
                this.createHTMLRepresentationOf(target, object, depth + 1);
                target.append("</tr>");
            }
            target.append("</table>");
        } else if (source instanceof String) {
            target.append((String)source);
        } else {
            target.append(String.valueOf(source));
        }
    }

    static {
        URL expandURL = AbstractServiceDialogPanel.class.getResource("/chemaxon/icons/marvin/services/expand.png");
        URL collapseURL = AbstractServiceDialogPanel.class.getResource("/chemaxon/icons/marvin/services/collapse.png");
        expandIcon = expandURL == null ? null : new ImageIcon(expandURL);
        collapseIcon = collapseURL == null ? null : new ImageIcon(collapseURL);
    }
}

