/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class FlexibleScrollPane
extends JScrollPane {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SCROLLBAR_SIZE = 16;
    private int flexibility;
    private Component viewPortView;

    public FlexibleScrollPane(int flexibility, Component viewPort) {
        super(flexibility == 1 ? 21 : 22, flexibility == 0 ? 31 : 32);
        if (flexibility != 0 && flexibility != 1 || this.viewport == null) {
            throw new IllegalArgumentException();
        }
        this.flexibility = flexibility;
        this.setViewportView(viewPort);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                FlexibleScrollPane.this.getParent().dispatchEvent(SwingUtilities.convertMouseEvent(FlexibleScrollPane.this, e, FlexibleScrollPane.this.getParent()));
            }
        });
    }

    @Override
    public void setViewportView(Component view) {
        if (view == null) {
            throw new IllegalArgumentException();
        }
        this.viewPortView = view;
        super.setViewportView(view);
        this.resize();
    }

    private Component getViewPortView() {
        return this.viewPortView;
    }

    public void resize() {
        if (this.getViewPortView() == null || this.getViewPortView().getPreferredSize() == null) {
            return;
        }
        Dimension current = this.getViewPortView().getPreferredSize();
        int height = (this.flexibility == 0 ? 0 : current.height) + 16;
        int width = (this.flexibility == 1 ? 0 : current.width) + 16;
        Dimension dim = new Dimension(width, height);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.repaint();
        this.validate();
    }
}

