/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.services.ui;

import chemaxon.marvin.services.ServiceDescriptor;
import chemaxon.marvin.services.ServiceDescriptorEditor;
import chemaxon.marvin.services.ServiceDescriptorEditorProvider;
import chemaxon.marvin.services.ServiceDescriptorTools;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLBasedServiceDescriptorEditorProvider
implements ServiceDescriptorEditorProvider {
    public static final String USER_DEFINED_SERVICE_DESCRIPTOR_EDITOR_MAPPING_CONFIGURATION_FILENAME = "servicedescriptoreditormapping.xml";
    public static final String DEFAULT_SERVICE_DESCRIPTOR_EDITOR_MAPPING_CONFIGURATION_FILENAME = "/chemaxon/marvin/services/config/resources/defaultmapping.xml";
    public static final String DEFAULT_CONFIGURATION_SCHEMA = "/chemaxon/marvin/services/config/resources/descriptoreditormapping.xsd";
    private final Map<Class<ServiceDescriptor>, ServiceDescriptorEditor<ServiceDescriptor>> cacheMap = new HashMap<Class<ServiceDescriptor>, ServiceDescriptorEditor<ServiceDescriptor>>();

    public XMLBasedServiceDescriptorEditorProvider() {
        InputStream stream = XMLBasedServiceDescriptorEditorProvider.getServiceDescriptorEditorMappingConfigurationAsStream();
        if (stream != null) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            URL schemaURL = this.getClass().getResource(DEFAULT_CONFIGURATION_SCHEMA);
            try {
                if (schemaURL != null) {
                    Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaURL);
                    try {
                        factory.setSchema(schema);
                    }
                    catch (UnsupportedOperationException e) {}
                } else {
                    throw new SAXException("Could not find XSD Schema at location: /chemaxon/marvin/services/config/resources/descriptoreditormapping.xsd");
                }
                SAXParser parser = factory.newSAXParser();
                parser.parse(stream, new DefaultHandler(){

                    @Override
                    public void error(SAXParseException e) throws SAXException {
                        throw new SAXException(e);
                    }

                    @Override
                    public void fatalError(SAXParseException e) throws SAXException {
                        throw new SAXException(e);
                    }

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("Descriptor".equals(qName)) {
                            try {
                                Class<?> descriptorClass = Class.forName(attributes.getValue("class"));
                                Class<?> editorClass = Class.forName(attributes.getValue("editor"));
                                ServiceDescriptorEditor editor = (ServiceDescriptorEditor)editorClass.newInstance();
                                if (descriptorClass != null && editor != null) {
                                    XMLBasedServiceDescriptorEditorProvider.this.cacheMap.put(descriptorClass, editor);
                                }
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public <T extends ServiceDescriptor> ServiceDescriptorEditor<T> getEditor(Class<T> descriptorClass) {
        return this.cacheMap.get(descriptorClass);
    }

    @Override
    public Set<Class<ServiceDescriptor>> getSupportedDescriptors() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }

    private static InputStream getServiceDescriptorEditorMappingConfigurationAsStream() {
        File file = DotfileUtil.getDotFile(USER_DEFINED_SERVICE_DESCRIPTOR_EDITOR_MAPPING_CONFIGURATION_FILENAME);
        if (file.canRead()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return ServiceDescriptorTools.class.getResourceAsStream(DEFAULT_SERVICE_DESCRIPTOR_EDITOR_MAPPING_CONFIGURATION_FILENAME);
    }
}

