/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.MolJoin;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MAtomSetPoint;
import java.awt.Graphics2D;

public class AtomPO
implements PointedObject {
    private transient MolAtom atom;

    public AtomPO(MolAtom a) {
        this.atom = a;
    }

    @Override
    public MolJoin highlightMe(Graphics2D g, SketchMode sm, MolJoin j, MoleculeGraph piece, MolEditor med) {
        Sgroup hsg;
        if (piece != null && !piece.isBond() && sm.isFloatingObjectPainted()) {
            MolBond[] c;
            if (j == null || !piece.isAtom()) {
                return j;
            }
            if (!sm.willBranchAtButtonPress() && (c = j.getCorrupt()) != null && c.length != 0) {
                return j;
            }
        }
        if ((hsg = med.getExtraSgroup(this.atom)) != null) {
            med.getPainter().hilitSgroup(med.getMol(), hsg, g);
        }
        double sr = med.getStickdst() * 1.54;
        med.getPainter().hilitAtom(med.getMol(), this.atom, sr, g);
        return null;
    }

    public MolAtom getAtom() {
        return this.atom;
    }

    @Override
    public Object getContainedObject() {
        return this.atom;
    }

    @Override
    public MPoint getContainedObjectMPointerPos() {
        MolAtom[] a = new MolAtom[]{this.atom};
        return new MAtomSetPoint(a);
    }
}

