/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.StereoConstants;

public class BoldModeSM
extends SketchMode
implements StereoConstants {
    private boolean incType = false;
    private boolean changeUp = false;

    public BoldModeSM(MolEditor e) {
        super(e);
    }

    protected BoldModeSM(BoldModeSM sm) {
        super(sm);
        this.incType = sm.incType;
        this.changeUp = sm.changeUp;
    }

    @Override
    public boolean containedObjectEquals(SketchMode o) {
        return o != null && o instanceof BoldModeSM;
    }

    @Override
    public Object clone() {
        return new BoldModeSM(this);
    }

    @Override
    public boolean canPointToBond() {
        return true;
    }

    @Override
    public boolean canPointToSgroup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonDown(boolean dblClick, int mod) {
        int ret = 0;
        MolEditor med = this.getEditor();
        if (med.isMoveModePersistent()) {
            return 0;
        }
        Molecule mol = med.getMol();
        med.setMoveMode(0, false);
        boolean changed = false;
        if (med.getCurfrag().isEmpty()) {
            Object object = mol.getLock();
            synchronized (object) {
                MolBond pbond;
                med.edit(14);
                PointedObject po = med.getPointedObject();
                MolBond molBond = pbond = po != null && po instanceof BondPO ? ((BondPO)po).getBond() : null;
                if (pbond != null) {
                    int pflags = pbond.getFlags();
                    int pt = pflags & 0xF;
                    int pstereo = pflags & 0x3F0;
                    int ptopo = pflags & 0xC00;
                    boolean changedTS = false;
                    if (pflags == 1 || pflags == 2) {
                        pbond.setFlags(0x40000000 | pflags);
                    } else if (pbond.isBold() && (pt == 1 || pt == 2)) {
                        pbond.setFlags(pt);
                    } else if (pflags == 4) {
                        pbond.setFlags(0x40000004);
                        this.incType = true;
                    } else if (pbond.isBold() && pt == 4 && pstereo == 0) {
                        if (this.incType) {
                            pbond.setFlags(20);
                            changedTS = true;
                        } else {
                            pbond.setFlags(4);
                        }
                    } else if (pt == 4 && pstereo == 16 && ptopo == 0) {
                        if (!this.incType) {
                            pbond.setFlags(0x40000004);
                        } else if (!this.changeUp) {
                            pbond.swap();
                            this.changeUp = true;
                        } else {
                            pbond.swap();
                            pbond.setFlags(4);
                            this.changeUp = false;
                        }
                        changedTS = true;
                    } else {
                        pbond.setFlags(0x40000001);
                        changedTS = true;
                    }
                    if (changedTS) {
                        this.getEditor().ungroupSgroupOf(pbond);
                        MolAtom a1 = pbond.getAtom1();
                        MolAtom a2 = pbond.getAtom2();
                        a1.valenceCheck();
                        a2.valenceCheck();
                    }
                    changed = true;
                    ret = 2;
                }
            }
        }
        if (changed) {
            med.historize();
        }
        return ret;
    }

    @Override
    public int buttonUp(int mod, boolean doHist) {
        int ret = 0;
        return ret;
    }

    @Override
    public boolean pointerMove(int mod) {
        boolean ret = false;
        this.incType = false;
        this.changeUp = false;
        return ret;
    }

    @Override
    public boolean pointerDrag(int mod) {
        boolean ret = false;
        return ret;
    }

    @Override
    public boolean pointerCopyDrag(int mod) {
        boolean ret = false;
        return ret;
    }
}

