/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import java.io.Serializable;

class BondMerger
implements Serializable {
    private static final long serialVersionUID = 5825332934415879783L;
    private double adjustmentPhi = 0.0;
    private double adjustmentAlpha = 0.0;
    private double adjustmentAlphaEx = 0.0;
    private double adjustmentAlphaEy = 1.0;
    private MolAtom atom10;
    private MolAtom atom20;
    private CTransform3D trot;

    public BondMerger(MolAtom a1, MolAtom a2, CTransform3D trot) {
        this.atom10 = a1;
        this.atom20 = a2;
        this.trot = trot;
    }

    public BondMerger(MolAtom[] a1, MolAtom[] a2, CTransform3D trot) {
        this(a1[0], a2[0], trot);
        this.init(a1, a2, trot);
    }

    public BondMerger(MolBond b1, MolBond b2, CTransform3D trot) {
        this(b1.getAtom1(), b2.getAtom1(), trot);
        MolAtom[] a1 = new MolAtom[]{b1.getAtom1(), b1.getAtom2()};
        MolAtom[] a2 = new MolAtom[]{b2.getAtom1(), b2.getAtom2()};
        this.init(a1, a2, trot);
    }

    private void init(MolAtom[] a1, MolAtom[] a2, CTransform3D trot) {
        MolAtom j1 = a1[0];
        MolAtom j1m = a2[0];
        MolAtom j2 = a1[1];
        MolAtom j2m = a2[1];
        DPoint3 pj1 = j1.getLocation();
        DPoint3 pj2 = j2.getLocation();
        DPoint3 pj1m = j1m.getLocation();
        DPoint3 pj2m = j2m.getLocation();
        trot.transform(pj1);
        trot.transform(pj2);
        trot.transform(pj1m);
        trot.transform(pj2m);
        double Dx = pj1.x - pj2.x;
        double Dy = pj1.y - pj2.y;
        double Drsqxy = Dx * Dx + Dy * Dy;
        double Drxy = Math.sqrt(Drsqxy);
        double Dxm = pj1m.x - pj2m.x;
        double Dym = pj1m.y - pj2m.y;
        double Drsqxym = Dxm * Dxm + Dym * Dym;
        double Drxym = Math.sqrt(Drsqxym);
        double cf = (Dx * Dxm + Dy * Dym) / (Drxy * Drxym);
        if (cf < 0.0) {
            MolAtom t = j2m;
            j2m = j1m;
            j1m = t;
            Dxm = -Dxm;
            Dym = -Dym;
            cf = -cf;
        }
        this.adjustmentPhi = cf >= 1.0 ? 0.0 : (cf <= -1.0 ? Math.PI : Math.acos(cf));
        if (Dxm * Dy < Dym * Dx) {
            this.adjustmentPhi = -this.adjustmentPhi;
        }
        double alpha = Math.atan2(pj1.z - pj2.z, Drxy);
        double alpham = Math.atan2(pj1m.z - pj2m.z, Drxym);
        this.adjustmentAlpha = alpham - alpha;
        this.adjustmentAlphaEx = -Dy / Drxy;
        this.adjustmentAlphaEy = Dx / Drxy;
    }

    public static boolean areInOppositeDirection(MolAtom[] a1, MolAtom[] a2, CTransform3D trot) {
        DPoint3 pj1 = a1[0].getLocation();
        DPoint3 pj2 = a1[1].getLocation();
        DPoint3 pj1m = a2[0].getLocation();
        DPoint3 pj2m = a2[1].getLocation();
        trot.transform(pj1);
        trot.transform(pj2);
        trot.transform(pj1m);
        trot.transform(pj2m);
        double Dx = pj1.x - pj2.x;
        double Dy = pj1.y - pj2.y;
        double Dxm = pj1m.x - pj2m.x;
        double Dym = pj1m.y - pj2m.y;
        return Dx * Dxm + Dy * Dym < 0.0;
    }

    public static boolean areInOppositeDirection(MolBond b1, MolBond b2, CTransform3D trot) {
        MolAtom[] a1 = new MolAtom[]{b1.getAtom1(), b1.getAtom2()};
        MolAtom[] a2 = new MolAtom[]{b2.getAtom1(), b2.getAtom2()};
        return BondMerger.areInOppositeDirection(a1, a2, trot);
    }

    public CTransform3D getTransform() {
        CTransform3D t = new CTransform3D();
        t.setTranslation(this.atom10.getX(), this.atom10.getY(), this.atom10.getZ());
        DPoint3 origin = new DPoint3(0.0, 0.0, 0.0);
        CTransform3D t1 = new CTransform3D(this.trot);
        t1.invert();
        t.mul(t1);
        CTransform3D t2 = new CTransform3D();
        this.trot.transform(origin);
        t2.setRotation(this.adjustmentAlphaEx, this.adjustmentAlphaEy, 0.0, this.adjustmentAlpha);
        CTransform3D t3 = new CTransform3D();
        t3.setRotation(0.0, 0.0, 1.0, this.adjustmentPhi);
        t2.mul(t3);
        t2.setRotationCenter(origin);
        t.mul(t2);
        t.mul(this.trot);
        t1.setIdentity();
        t1.setTranslation(-this.atom20.getX(), -this.atom20.getY(), -this.atom20.getZ());
        t.mul(t1);
        return t;
    }
}

