/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.MolJoin;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MAtomSetPoint;
import java.awt.Graphics2D;

public class BondPO
implements PointedObject {
    private transient MolBond bond;

    public BondPO(MolBond b) {
        this.bond = b;
    }

    public MolBond getBond() {
        return this.bond;
    }

    @Override
    public MolJoin highlightMe(Graphics2D g, SketchMode so, MolJoin j, MoleculeGraph piece, MolEditor med) {
        if (so.canPointToBond()) {
            double sr = med.getStickdst() * 1.54;
            med.getPainter().hilitBond(med.getMol(), this.bond, sr, g);
            if (this.bond != null) {
                Sgroup hsg = med.getExtraSgroup(this.bond.getAtom1());
                if (hsg != null) {
                    med.getPainter().hilitSgroup(med.getMol(), hsg, g);
                }
                if ((hsg = med.getExtraSgroup(this.bond.getAtom2())) != null) {
                    med.getPainter().hilitSgroup(med.getMol(), hsg, g);
                }
            }
        }
        return j;
    }

    @Override
    public Object getContainedObject() {
        return this.bond;
    }

    @Override
    public MPoint getContainedObjectMPointerPos() {
        MolAtom[] a = new MolAtom[]{this.bond.getAtom1(), this.bond.getAtom2()};
        return new MAtomSetPoint(a);
    }
}

