/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.core.calculations.Parity;
import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.MolJoin;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.QueryBond;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.util.NetUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BondSM
extends SketchMode
implements StereoConstants {
    private static final long serialVersionUID = 6282033706405196916L;
    private transient MolBond bond;
    protected transient DPoint3 origin = new DPoint3(0.0, 0.0, 0.0);
    private boolean incType = false;
    private boolean wasDoubleBeforeClick = false;

    public BondSM(MolEditor e, int flags) {
        super(e);
        this.bond = new MolBond(null, null, flags);
    }

    public BondSM(MolEditor e, MolBond b) {
        super(e);
        this.bond = b;
    }

    protected BondSM(BondSM sm) {
        super(sm);
        this.bond = (MolBond)sm.bond.clone();
        this.origin = (DPoint3)sm.origin.clone();
        this.incType = sm.incType;
        this.wasDoubleBeforeClick = sm.wasDoubleBeforeClick;
    }

    public int getType() {
        return this.bond.getType();
    }

    public void setType(int type) {
        this.bond.setType(type);
    }

    @Override
    public boolean containedObjectEquals(SketchMode o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return BondSM.equals(this.bond, ((BondSM)o).bond);
    }

    @Override
    public Object clone() {
        return new BondSM(this);
    }

    @Override
    public Molecule getMol() {
        Molecule m = null;
        m = this.bond instanceof QueryBond ? BondSM.createQueryBondMol(this.bond.getQuerystr()) : BondSM.createBondMol(this.bond.getFlags());
        m.moveTo(this.origin);
        return m;
    }

    @Override
    public void moveTo(DPoint3 o) {
        this.origin = (DPoint3)o.clone();
    }

    public static Molecule createMolFromBond(MolBond pb, MolAtom a1, MolAtom a2) {
        Molecule bondMol = null;
        bondMol = pb instanceof QueryBond ? BondSM.createQueryBondMol(pb.getQuerystr(), a1, a2) : BondSM.createBondMol(pb.getFlags(), a1, a2);
        return bondMol;
    }

    public static Molecule createQueryBondMol(String qs) {
        MolAtom a1 = new MolAtom(0, -0.77, 0.0, 0.0);
        MolAtom a2 = new MolAtom(0, 0.77, 0.0, 0.0);
        return BondSM.createQueryBondMol(qs, a1, a2);
    }

    public static Molecule createQueryBondMol(String qs, MolAtom a1, MolAtom a2) {
        QueryBond b = new QueryBond(a1, a2, qs);
        Molecule m = new Molecule(null, b);
        m.add(a1);
        m.add(a2);
        return m;
    }

    public static Molecule createBondMol(int f) {
        MolAtom a1 = new MolAtom(0, -0.77, 0.0, 0.0);
        MolAtom a2 = new MolAtom(0, 0.77, 0.0, 0.0);
        return BondSM.createBondMol(f, a1, a2);
    }

    public static Molecule createBondMol(int f, MolAtom a1, MolAtom a2) {
        MolBond b = new MolBond(a1, a2, f);
        Molecule m = new Molecule(null, b);
        m.add(a1);
        m.add(a2);
        return m;
    }

    @Override
    public boolean canPointToAtom() {
        return true;
    }

    @Override
    public boolean canPointToBond() {
        return true;
    }

    @Override
    public boolean canPointToSgroup() {
        return true;
    }

    @Override
    public boolean isFloatingObjectPainted() {
        return super.isFloatingObjectPainted() && this.getEditor().isBondDraggedAlong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonDown(boolean dblClick, int modifiers) {
        MolEditor med = this.getEditor();
        if (med.isMoveModePersistent()) {
            return 0;
        }
        Molecule mol = med.getMol();
        PointedObject po = med.getPointedObject();
        if (po instanceof SgroupPO && ((SgroupPO)po).isDataLabelPointed) {
            if (modifiers == 18 || dblClick) {
                DataSgroup dsg = (DataSgroup)((SgroupPO)po).getSgroup();
                if (dsg.getFieldType() == 4) {
                    NetUtil.openURL(dsg.getData());
                    return 1;
                }
            } else {
                return 0;
            }
        }
        int ret = 0;
        boolean changed = false;
        med.setMoveMode(0, false);
        if (med.getCurfrag().isEmpty()) {
            Object object = mol.getLock();
            synchronized (object) {
                MolBond pbond;
                med.edit(14);
                po = med.getPointedObject();
                MolBond molBond = pbond = po != null && po instanceof BondPO ? ((BondPO)po).getBond() : null;
                if (pbond != null) {
                    MoleculeGraph parent;
                    if (med.canArrangeCrossingBond(pbond, MolEditor.ARRANGE_FRONT)) {
                        med.arrangeCrossingBond(pbond, MolEditor.ARRANGE_FRONT);
                        return 2;
                    }
                    if (this.bond instanceof QueryBond && (parent = pbond.getParent()) != null) {
                        parent.removeBond(pbond);
                        parent.add(new QueryBond(pbond.getAtom1(), pbond.getAtom2(), ((QueryBond)this.bond).getQuerystr()));
                    }
                    int flags = this.bond.getFlags();
                    int t = flags & 0xF;
                    int stereo = flags & 0x3F0;
                    int topo = flags & 0xC00;
                    int stereoCare = flags & 0x200;
                    int pflags = pbond.getFlags();
                    int pt = pflags & 0xF;
                    int pstereo = pflags & 0x3F0;
                    int pstereo1 = pflags & 0x3F0;
                    int ptopo = pflags & 0xC00;
                    int pstereoCare = pflags & 0x200;
                    boolean swapped = false;
                    if (stereo != 0) {
                        if (stereoCare == 0) {
                            if (pt == t && pstereo == stereo && pstereo1 != 0) {
                                pbond.swap();
                                swapped = true;
                            } else {
                                boolean chir2;
                                MoleculeGraph parent2 = pbond.getParent();
                                MolAtom a1 = pbond.getAtom1();
                                MolAtom a2 = pbond.getAtom2();
                                boolean[] chir = Parity.chiralAtoms(parent2);
                                boolean chir1 = chir[parent2.indexOf(a1)];
                                if (chir1 != (chir2 = chir[parent2.indexOf(a2)]) && chir2) {
                                    pbond.swap();
                                    swapped = true;
                                }
                                pbond.setType(t);
                                pbond.setFlags(flags, 1073742320);
                            }
                        } else {
                            if (t != 1) {
                                pflags = flags & 0xFFFFFFF0 | t;
                            }
                            pbond.setFlags(pstereoCare != 0 ? pflags & ~stereoCare : pflags | stereoCare);
                        }
                    } else if (topo != 0) {
                        pbond.setFlags(ptopo == topo ? 0 : topo, 3072);
                        if (t != 1) {
                            pbond.setType(t);
                        }
                    } else if (this.bond.isBold()) {
                        int mask = 1073742335;
                        flags = this.bond.getFlags() & mask;
                        pflags = pbond.getFlags() & ~mask;
                        pbond.setFlags(pflags | flags);
                        pbond.setType(t);
                    } else if ((this.incType || pt == t) && pt >= 1 && pt < 3 && pstereo == 0 && !pbond.isBold()) {
                        pbond.setFlags(0, 1008);
                        if (this.wasDoubleBeforeClick && pt == 1) {
                            pt = 3;
                            this.wasDoubleBeforeClick = false;
                        } else {
                            ++pt;
                        }
                        pbond.setType(pt);
                    } else {
                        if (t == 1 && pt == 2 && !this.incType) {
                            this.wasDoubleBeforeClick = true;
                        }
                        if (t == 1 || t == 6) {
                            pstereoCare = 0;
                        }
                        if (pbond.isBold()) {
                            int mask = 1073742335;
                            flags = this.bond.getFlags() & mask;
                            pflags = pbond.getFlags() & ~mask;
                            pbond.setFlags(pflags | flags);
                        } else if (flags != pflags) {
                            pbond.setFlags(pstereoCare, 1008);
                        } else if (t == 9) {
                            pbond.swap();
                        }
                        pbond.setType(t);
                    }
                    if (t == 1) {
                        this.incType = true;
                    }
                    if (t != pt || stereo != pstereo || topo != ptopo || stereoCare != pstereoCare || swapped) {
                        med.ungroupSgroupOf(pbond);
                    }
                    if (flags != pflags || t != pt || swapped) {
                        changed = true;
                        ret = 2;
                    }
                } else {
                    MolAtom a;
                    DPoint3 p = med.getPointerPos();
                    MolAtom a1 = new MolAtom(0, p.x, p.y, p.z);
                    MolAtom a2 = new MolAtom(0, p.x, p.y, p.z);
                    MolAtom molAtom = a = po != null && po instanceof AtomPO ? ((AtomPO)po).getAtom() : null;
                    if (a == null || MolJoin.canBeBound(a)) {
                        med.beginBondDrawing(a1, a2);
                    }
                }
            }
        } else if (med.endBondOrChainDrawing()) {
            ret = 2;
        }
        if (changed) {
            med.historize();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonUp(int modifiers, boolean doHist) {
        MolEditor med = this.getEditor();
        MDocument cf = med.getCurfrag();
        if (!cf.isEmpty()) {
            double dy;
            double dx;
            Object object = med.getMol().getLock();
            synchronized (object) {
                MoleculeGraph mcf = cf.getMainMoleculeGraph();
                MolBond b = mcf.getBond(0);
                MolAtom a1 = b.getAtom1();
                DPoint3 pa1 = med.getScreenFromMolPos(a1.getLocation());
                DPoint3 p = med.getPointerPos();
                dx = p.x - pa1.x;
                dy = p.y - pa1.y;
            }
            double sr = med.getStickdst() * 1.54;
            if ((med.getPointedObject() == null || med.isDragged() && dx * dx + dy * dy > sr * sr) && med.endBondOrChainDrawing()) {
                med.dragged = false;
                return 2;
            }
            PointedObject po = med.getPointedObject();
            if (po != null && po instanceof AtomPO && !med.isDragged()) {
                MolAtom a = ((AtomPO)po).getAtom();
                if (med.getMolDim() == 3 && a.getExplicitHcount() != 0 && a.getImplicitHcount() == 0) {
                    this.replaceOutermostH(a);
                } else {
                    med.branch(a);
                }
            }
        }
        med.dragged = false;
        return 0;
    }

    private void replaceOutermostH(MolAtom a0) {
        Molecule m;
        MolEditor med = this.getEditor();
        MoleculeGraph mol = med.getDocument().getMainMoleculeGraph();
        mol = mol.getGraphUnion();
        MolAtom best_H = null;
        double best_d = -1.0;
        for (int i = 0; i < a0.getBondCount(); ++i) {
            double d;
            MolAtom a = a0.getLigand(i);
            if (a.getAtno() != 1 || !((d = CleanUtil.sumDistanceSquare(mol, a.getLocation())) > best_d)) continue;
            best_H = a;
            best_d = d;
        }
        med.atomBranchPiece = m = new Molecule(null, new MolAtom(6));
        med.atomBranchPiece.moveTo(best_H.getLocation());
        med.setPiece0(m, m);
        med.atomBranchPiece = null;
        med.putPiece();
        med.setSketchMode(this, false);
    }

    @Override
    public boolean pointerMove(int modifiers) {
        MolEditor e = this.getEditor();
        MDocument cf = e.getCurfrag();
        e.pntAB(false);
        MoleculeGraph mcf = cf.getMainMoleculeGraph();
        if (mcf.isBond()) {
            e.doBondDrawing(modifiers);
        }
        this.incType = false;
        this.wasDoubleBeforeClick = false;
        return true;
    }

    @Override
    public boolean pointerDrag(int modifiers) {
        MolEditor e = this.getEditor();
        MDocument cf = e.getCurfrag();
        MoleculeGraph mcf = cf.getMainMoleculeGraph();
        if (mcf.getAtomCount() == 2 && mcf.getBondCount() == 1) {
            return e.doBondDrawing(modifiers);
        }
        return false;
    }

    @Override
    public boolean pointerCopyDrag(int modifiers) {
        return true;
    }

    @Override
    public int modkeyChange(int mod) {
        MolEditor med = this.getEditor();
        int oldmod = med.getModifiers();
        if ((mod & 1) == 0 && (oldmod & 1) != 0 && (mod & 0x10) != 0) {
            med.rotateCurrentMoleculeTo15DegreesLine();
            return 1;
        }
        return 0;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeObject(this.bond);
        oos.writeDouble(this.origin.x);
        oos.writeDouble(this.origin.y);
        oos.writeDouble(this.origin.z);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        this.bond = (MolBond)ois.readObject();
        double x = ois.readDouble();
        double y = ois.readDouble();
        double z = ois.readDouble();
        this.origin = new DPoint3(x, y, z);
    }

    private static boolean equals(MolAtom atom1, MolAtom atom2) {
        if (atom1 == atom2) {
            return true;
        }
        if (atom1 == null || atom2 == null) {
            return false;
        }
        return atom1.getCharge() == atom2.getCharge() && atom1.getAtno() == atom2.getAtno() && atom1.getRadical() == atom2.getRadical() && atom1.getElectronProp() == atom2.getElectronProp();
    }

    private static boolean equals(MolBond bond1, MolBond bond2) {
        if (bond1 == bond2) {
            return true;
        }
        if (bond1 == null || bond2 == null) {
            return false;
        }
        return bond1.getFlags() == bond2.getFlags() && (BondSM.equals(bond1.getAtom1(), bond2.getAtom1()) && BondSM.equals(bond1.getAtom2(), bond2.getAtom2()) || BondSM.equals(bond1.getAtom2(), bond2.getAtom1()) && BondSM.equals(bond1.getAtom1(), bond2.getAtom2()));
    }
}

