/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.core.util.GeomUtil;
import chemaxon.marvin.paint.internal.util.DrawingUtil;
import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.MolJoin;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.util.NetUtil;
import java.util.ArrayList;

public class ChainSM
extends BondSM {
    private static final long serialVersionUID = 6282033706405196916L;
    private static double rotateDelta = 0.0;
    private static int direction = 1;
    private boolean curvedchainTool;

    public ChainSM(MolEditor e) {
        super(e, 1);
        this.curvedchainTool = false;
    }

    public ChainSM(MolEditor e, boolean curvedchainTool) {
        super(e, 1);
        this.curvedchainTool = curvedchainTool;
    }

    protected ChainSM(ChainSM sm) {
        super(sm);
        this.curvedchainTool = sm.curvedchainTool;
    }

    @Override
    public Molecule getMol() {
        Molecule m = this.createChainMol();
        m.moveTo(this.origin);
        return m;
    }

    public boolean getTool() {
        return this.curvedchainTool;
    }

    @Override
    public boolean containedObjectEquals(SketchMode o) {
        return o != null && o instanceof ChainSM && super.containedObjectEquals(o);
    }

    @Override
    public Object clone() {
        return new ChainSM(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonDown(boolean dblClick, int modifiers) {
        MolEditor medit = this.getEditor();
        if (medit.isMoveModePersistent()) {
            return 0;
        }
        Molecule mol = medit.getMol();
        PointedObject po = medit.getPointedObject();
        if (po instanceof SgroupPO && ((SgroupPO)po).isDataLabelPointed) {
            if (modifiers == 18 || dblClick) {
                DataSgroup dsg = (DataSgroup)((SgroupPO)po).getSgroup();
                if (dsg.getFieldType() == 4) {
                    NetUtil.openURL(dsg.getData());
                    return 1;
                }
            } else {
                return 0;
            }
        }
        int ret = 0;
        boolean changed = false;
        medit.setMoveMode(0, false);
        if (medit.getCurfrag().isEmpty()) {
            Object object = mol.getLock();
            synchronized (object) {
                MolBond pbond;
                medit.edit(14);
                po = medit.getPointedObject();
                MolBond molBond = pbond = po != null && po instanceof BondPO ? ((BondPO)po).getBond() : null;
                if (pbond != null) {
                    super.buttonDown(dblClick, modifiers);
                } else {
                    MolAtom a;
                    DPoint3 p = medit.getPointerPos();
                    MolAtom a1 = new MolAtom(0, p.x, p.y, p.z);
                    MolAtom molAtom = a = po != null && po instanceof AtomPO ? ((AtomPO)po).getAtom() : null;
                    if (a == null || MolJoin.canBeBound(a)) {
                        medit.beginChainDrawing(a1);
                    }
                }
            }
        } else {
            medit.endBondOrChainDrawing();
        }
        if (changed) {
            medit.historize();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonUp(int modifiers, boolean doHist) {
        MolEditor medit = this.getEditor();
        MDocument cf = medit.getCurfrag();
        int ret = 0;
        if (!cf.isEmpty()) {
            double dy;
            double dx;
            Object object = medit.getMol().getLock();
            synchronized (object) {
                MoleculeGraph mcf = cf.getMainMoleculeGraph();
                MolBond b = mcf.getBond(0);
                MolAtom a1 = b.getAtom1();
                DPoint3 pa1 = medit.getScreenFromMolPos(a1.getLocation());
                DPoint3 p = medit.getPointerPos();
                dx = p.x - pa1.x;
                dy = p.y - pa1.y;
            }
            double sr = medit.getStickdst() * 1.54;
            if ((medit.getPointedObject() == null || medit.isDragged() && dx * dx + dy * dy > sr * sr) && medit.endBondOrChainDrawing()) {
                medit.dragged = false;
                return 2;
            }
            PointedObject po = medit.getPointedObject();
            if (po != null && po instanceof AtomPO && !medit.isDragged()) {
                ret = medit.branch(((AtomPO)po).getAtom());
            }
        }
        medit.dragged = false;
        return ret;
    }

    @Override
    public boolean pointerDrag(int modifiers) {
        MolEditor e = this.getEditor();
        MDocument cf = e.getCurfrag();
        MoleculeGraph mcf = cf.getMainMoleculeGraph();
        if (mcf.getAtomCount() >= 2 && mcf.getBondCount() == mcf.getAtomCount() - 1) {
            return e.doChainDrawing(this.curvedchainTool);
        }
        return false;
    }

    private Molecule createChainMol() {
        MolAtom a1 = new MolAtom(0);
        MolAtom a2 = new MolAtom(0);
        MolAtom a3 = new MolAtom(0);
        MolAtom a4 = new MolAtom(0);
        Molecule m = new Molecule();
        m.add(a1);
        m.add(a2);
        m.add(a3);
        m.add(a4);
        m.add(new MolBond(a1, a2, 1));
        m.add(new MolBond(a2, a3, 1));
        m.add(new MolBond(a3, a4, 1));
        this.regularizeChainInHand(m, 0.0);
        return m;
    }

    void regularizeChainInHand(MoleculeGraph m, double phi) {
        CTransform3D t = new CTransform3D();
        double c = 0.5;
        double dx = c * 1.54 * Math.sqrt(3.0) / 2.0;
        double dy = c * 1.54 / 2.0;
        MolAtom a1 = m.getAtom(0);
        MolAtom a2 = m.getAtom(1);
        MolAtom a3 = m.getAtom(2);
        MolAtom a4 = m.getAtom(3);
        DPoint3 o = a4.getLocation();
        t.setRotation(0.0, 0.0, 1.0, phi);
        t.setRotationCenter(o);
        a1.setXYZ(o.x - 3.0 * dx, o.y - dy, o.z);
        a2.setXYZ(o.x - 2.0 * dx, o.y, o.z);
        a3.setXYZ(o.x - dx, o.y - dy, o.z);
        a4.setXYZ(o.x, o.y, o.z);
        m.transform(t);
    }

    static void regenerateChain(Molecule chainMol, DPoint3 pointer, DPoint3 prevpointer, CTransform3D trot, CTransform3D tinvrot) {
        int i;
        MolAtom a0 = chainMol.getAtom(0);
        DPoint3 p0 = a0.getLocation();
        trot.transform(p0);
        trot.transform(pointer);
        trot.transform(prevpointer);
        double dlon = 1.54 * Math.sqrt(3.0) / 2.0;
        double dtra = 0.77;
        int n = Math.max(2, (int)Math.round(p0.distance(pointer) / dlon) + 1);
        if (n > chainMol.getAtomCount()) {
            for (i = chainMol.getAtomCount(); i < n; ++i) {
                MolAtom aprev = chainMol.getAtom(i - 1);
                MolAtom ai = new MolAtom(0);
                chainMol.add(ai);
                chainMol.add(new MolBond(aprev, ai, 1));
            }
        } else {
            for (i = chainMol.getAtomCount() - 1; i >= n; --i) {
                chainMol.removeAtom(i);
            }
        }
        double r = p0.distance(pointer);
        double ex = (pointer.x - p0.x) / r;
        double ey = (pointer.y - p0.y) / r;
        double ez = (pointer.z - p0.z) / r;
        double lxy = Math.sqrt(ex * ex + ey * ey);
        double df = 0.2617993877991494;
        double phi = (double)Math.round(Math.atan2(ey, ex) / df) * df;
        ex = lxy * Math.cos(phi);
        ey = lxy * Math.sin(phi);
        phi = Math.atan2(pointer.y - p0.y, pointer.x - p0.x);
        double pszi = Math.atan2(prevpointer.y - p0.y, prevpointer.x - p0.x);
        double alpha = pszi - phi;
        if ((rotateDelta += alpha) > df / 2.0) {
            direction = 1;
            rotateDelta = 0.0;
        } else if (rotateDelta < -df / 2.0) {
            direction = -1;
            rotateDelta = 0.0;
        }
        double nx = (double)(-direction) * ey / lxy;
        double ny = (double)direction * ex / lxy;
        double nz = 0.0;
        DPoint3 pi = new DPoint3();
        for (int i2 = 1; i2 < n; ++i2) {
            pi.x = p0.x + (double)i2 * dlon * ex;
            pi.y = p0.y + (double)i2 * dlon * ey;
            pi.z = p0.z + (double)i2 * dlon * ez;
            if ((i2 & 1) == 1) {
                pi.x += dtra * nx;
                pi.y += dtra * ny;
                pi.z += dtra * nz;
            }
            tinvrot.transform(pi);
            MolAtom ai = chainMol.getAtom(i2);
            ai.setLocation(pi);
        }
    }

    static void regenerateChain(MoleculeGraph mol, Molecule chainMol, DPoint3 pointer, DPoint3 prevpointer, CTransform3D trot, CTransform3D tinvrot) {
        int cn = chainMol.getAtomCount();
        MolAtom a0 = chainMol.getAtom(0);
        DPoint3 p0 = a0.getLocation();
        trot.transform(p0);
        trot.transform(pointer);
        trot.transform(prevpointer);
        double dlon = 1.54 * Math.sqrt(3.0) / 2.0;
        int m = Math.max(2, (int)Math.round(p0.distance(pointer) / dlon) + 1);
        MolAtom an2 = chainMol.getAtom(cn - 2);
        DPoint3 pn2 = an2.getLocation();
        trot.transform(pn2);
        double dpn2 = pn2.distance(pointer);
        if (cn == 2 && m == cn) {
            MolAtom a = ChainSM.findAtomInMol(mol, a0);
            if (a != null) {
                double beta = 0.0;
                int bn = a.getBondCount();
                if (bn > 1) {
                    double[] largest0 = GeomUtil.getLargestBondAngle2D(a);
                    beta = largest0[0] + largest0[1] / 2.0;
                } else if (bn == 1) {
                    DPoint3 p1 = a.getBond(0).getOtherAtom(a).getLocation();
                    trot.transform(p1);
                    double phi = Math.atan2(pointer.y - p0.y, pointer.x - p0.x);
                    phi = phi < 1.5707963267948966 ? phi + Math.PI * 2 : phi;
                    double alpha = Math.atan2(p0.y - p1.y, p0.x - p1.x);
                    alpha = alpha < 1.5707963267948966 ? alpha + Math.PI * 2 : alpha;
                    beta = phi >= alpha ? 1.0471975511965976 + alpha : -1.0471975511965976 + alpha;
                }
                DPoint3 p = new DPoint3();
                p.x = p0.x + Math.cos(beta) * dlon;
                p.y = p0.y + Math.sin(beta) * dlon;
                tinvrot.transform(p);
                MolAtom achain = chainMol.getAtom(1);
                achain.setLocation(p);
                return;
            }
            double phi = Math.atan2(pointer.y - p0.y, pointer.x - p0.x);
            double beta = (double)Math.round(phi / 0.5235987755982988) * 0.5235987755982988;
            DPoint3 p = new DPoint3();
            p.x = p0.x + Math.cos(beta) * dlon;
            p.y = p0.y + Math.sin(beta) * dlon;
            tinvrot.transform(p);
            MolAtom achain = chainMol.getAtom(1);
            achain.setLocation(p);
        }
        if (dpn2 > dlon * 1.5) {
            MolAtom aprev = chainMol.getAtom(cn - 1);
            MolAtom a = new MolAtom(0);
            chainMol.add(a);
            chainMol.add(new MolBond(aprev, a, 1));
            DPoint3 pprev = aprev.getLocation();
            trot.transform(pprev);
            double alpha = pn2.angle2D(pprev.x, pprev.y);
            int d = 1;
            if (pprev.y < pn2.y || Math.abs(pprev.y - pn2.y) == 0.0 && pprev.x < pn2.x) {
                DPoint3 tp = pn2;
                pn2 = pprev;
                pprev = tp;
                d = -1;
            }
            int side = d * DrawingUtil.getBondSideToPoint(pn2, pprev, pointer);
            double beta = 0.0;
            beta = side < 0 ? 1.0471975511965976 + alpha : -1.0471975511965976 + alpha;
            DPoint3 p = new DPoint3();
            if (d == -1) {
                p.x = pn2.x + Math.cos(beta) * dlon;
                p.y = pn2.y + Math.sin(beta) * dlon;
            } else {
                p.x = pprev.x + Math.cos(beta) * dlon;
                p.y = pprev.y + Math.sin(beta) * dlon;
            }
            tinvrot.transform(p);
            a.setLocation(p);
        } else if (cn > 2 && dpn2 > 0.0 && dpn2 < dlon * 0.5) {
            chainMol.removeAtom(cn - 1);
        }
    }

    static boolean isChainInHand(MoleculeGraph m) {
        return ChainSM.isChain(m) && m.getAtomCount() == 4;
    }

    static boolean isChain(MoleculeGraph m) {
        int n = m.getAtomCount();
        if (n < 2 || m.getBondCount() != n - 1) {
            return false;
        }
        if (m.getAtom(0).getBondCount() != 1) {
            return false;
        }
        if (m.getAtom(n - 1).getBondCount() != 1) {
            return false;
        }
        for (int i = 1; i < n - 1; ++i) {
            if (m.getAtom(i).getBondCount() == 2) continue;
            return false;
        }
        if (m instanceof Molecule) {
            Molecule mol = (Molecule)m;
            if (mol.getSgroupCount() != 0) {
                return false;
            }
            if (mol.getInputFormat() != null) {
                return false;
            }
        }
        return true;
    }

    public static MolAtom findAtomInMol(MoleculeGraph mol, MolAtom a) {
        MolAtom aa;
        int i;
        DPoint3 pa = a.getLocation();
        DPoint3 paa = new DPoint3(0.0, 0.0, 0.0);
        ArrayList<MolAtom> v = new ArrayList<MolAtom>();
        MoleculeGraph umol = mol.getGraphUnion();
        for (i = 0; i < umol.getAtomCount(); ++i) {
            aa = umol.getAtom(i);
            if (aa == a) {
                return a;
            }
            aa.getLocation(paa);
            if (!paa.equals(pa)) continue;
            v.add(aa);
        }
        if (v.size() == 1) {
            return (MolAtom)v.get(0);
        }
        for (i = v.size() - 1; i >= 0; --i) {
            aa = (MolAtom)v.get(i);
            if (aa.haveSimilarBonds(a)) continue;
            v.remove(i);
        }
        if (v.size() == 1) {
            return (MolAtom)v.get(0);
        }
        return null;
    }
}

