/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.StereoConstants;

public class HashedModeSM
extends SketchMode
implements StereoConstants {
    private static final long serialVersionUID = 2600395801827365930L;

    public HashedModeSM(MolEditor e) {
        super(e);
    }

    public HashedModeSM(SketchMode so) {
        super(so);
    }

    @Override
    public boolean containedObjectEquals(SketchMode o) {
        return o != null && o instanceof HashedModeSM;
    }

    @Override
    public Object clone() {
        return new HashedModeSM(this);
    }

    @Override
    public boolean canPointToBond() {
        return true;
    }

    @Override
    public boolean canPointToSgroup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonDown(boolean dblClick, int mod) {
        int ret = 0;
        MolEditor med = this.getEditor();
        if (med.isMoveModePersistent()) {
            return 0;
        }
        Molecule mol = med.getMol();
        med.setMoveMode(0, false);
        boolean changed = false;
        if (med.getCurfrag().isEmpty()) {
            Object object = mol.getLock();
            synchronized (object) {
                MolBond pbond;
                med.edit(14);
                PointedObject po = med.getPointedObject();
                MolBond molBond = pbond = po != null && po instanceof BondPO ? ((BondPO)po).getBond() : null;
                if (pbond != null) {
                    int pt = pbond.getFlags() & 0xF;
                    if (!pbond.isHashed()) {
                        pbond.setFlags(-2147483647);
                    } else {
                        pbond.setFlags(pt);
                    }
                    changed = true;
                    ret = 2;
                }
            }
        }
        if (changed) {
            med.historize();
        }
        return ret;
    }

    @Override
    public int buttonUp(int mod, boolean doHist) {
        return 0;
    }

    @Override
    public boolean pointerMove(int mod) {
        return false;
    }

    @Override
    public boolean pointerDrag(int mod) {
        return false;
    }

    @Override
    public boolean pointerCopyDrag(int mod) {
        return false;
    }
}

