/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.RubberSM;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.util.AbbrevGroupCollection;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.graphics.MTextBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Timer;

public class KeyboardInput {
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final String[] STGRP_NAMES = new String[]{"abs", "or", "&", "and"};
    private static final int DEFAULT_CLEAR_DELAY = 5000;
    private StringBuffer keysSbuf = new StringBuffer();
    private String keysString;
    private String[] possibleCompletions;
    private String completion;
    private SketchMode sketchObject;
    private int templateNumber;
    private boolean isAbbrevGroup;
    private AbbrevGroupCollection abbrevGroups = null;
    private MolEditor molEditor;
    private Molecule[] myTemplates = null;
    private String[] myTemplateNamesLC = null;
    private String[] myTemplateNames = null;
    private String[] groupAndTemplateNamesLC = null;
    private String[] groupAndTemplateNames = null;
    private String temporaryTextClipboard = null;
    private Timer timer;
    private CallbackIface observer;

    public KeyboardInput(MolEditor medit, CallbackIface observer) {
        this.molEditor = medit;
        this.timer = new Timer(5000, this.createClearAction());
        this.clear();
        this.observer = observer;
    }

    public void clear() {
        this.stopTimer();
        this.keysSbuf.setLength(0);
        this.clear0();
        if (this.observer != null) {
            this.observer.callback("keyBufferCleared", null);
        }
    }

    public void setAbbrevGroups(AbbrevGroupCollection groups) {
        this.abbrevGroups = groups;
        this.setGroupAndTemplateNames();
    }

    public void setMyTemplates(Molecule[] mols) {
        if (mols == null) {
            this.myTemplateNamesLC = null;
            this.myTemplateNames = null;
        } else {
            String s;
            int i;
            Vector<Object> vmols = new Vector<Object>();
            int n = 0;
            for (i = 0; i < mols.length; ++i) {
                s = mols[i].getProperty("abbreviation");
                if (s == null || s.length() == 0) {
                    s = mols[i].getName();
                }
                if (s == null || s.length() == 0) continue;
                vmols.addElement(mols[i]);
                vmols.addElement(s);
                ++n;
            }
            this.myTemplates = new Molecule[n];
            this.myTemplateNamesLC = new String[n];
            this.myTemplateNames = new String[n];
            for (i = 0; i < n; ++i) {
                this.myTemplates[i] = (Molecule)vmols.elementAt(2 * i);
                s = (String)vmols.elementAt(2 * i + 1);
                this.myTemplateNamesLC[i] = s.toLowerCase();
                this.myTemplateNames[i] = s;
            }
        }
        this.setGroupAndTemplateNames();
    }

    private void setGroupAndTemplateNames() {
        int n1 = this.abbrevGroups != null ? this.abbrevGroups.getSize() : 0;
        int n2 = this.myTemplateNames != null ? this.myTemplateNames.length : 0;
        this.groupAndTemplateNames = new String[n1 + n2];
        this.groupAndTemplateNamesLC = new String[n1 + n2];
        if (n1 != 0) {
            System.arraycopy(this.abbrevGroups.getAbbrevNames(), 0, this.groupAndTemplateNames, 0, n1);
            System.arraycopy(this.abbrevGroups.getAbbrevNamesLC(), 0, this.groupAndTemplateNamesLC, 0, n1);
        }
        if (n2 != 0) {
            System.arraycopy(this.myTemplateNames, 0, this.groupAndTemplateNames, n1, n2);
            System.arraycopy(this.myTemplateNamesLC, 0, this.groupAndTemplateNamesLC, n1, n2);
        }
    }

    public void add(char keychar, CallbackIface hourglass) {
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null) {
            this.clear();
            if (keychar == '\b') {
                t.deleteCharBackward();
            } else if (keychar != '\uffff') {
                t.addChar(keychar);
            }
            this.setSelection(t);
        } else {
            this.restartTimer();
            if (keychar == '\uffff') {
                return;
            }
            if (keychar == '\t') {
                this.complete();
                return;
            }
            if (keychar == '\b') {
                if (this.keysSbuf.length() == 0) {
                    return;
                }
                this.keysSbuf.deleteCharAt(this.keysSbuf.length() - 1);
            } else {
                this.keysSbuf.append(keychar);
            }
            String s = this.keysSbuf.toString();
            if (!(KeyboardInput.canBeBond(s) || KeyboardInput.canBeEraser(s) || KeyboardInput.canBeTemplate(s) || KeyboardInput.canBeCharge(s) || KeyboardInput.canBeAnyAtom(s) || KeyboardInput.canBeEnhancedStereo(s) || KeyboardInput.canBeRgroupOrMap(s) || KeyboardInput.canBeQueryProp(s) || KeyboardInput.canBeValenceProp(s, true) || this.canBeAbbrevGroup(s) || KeyboardInput.canBeElement(s) || KeyboardInput.canBeAtomList(s) || this.canBeMyTemplate(s) || s.equals("lp"))) {
                this.keysSbuf.setLength(0);
                this.keysSbuf.append(keychar);
            }
            this.clear0();
            this.keysString = this.keysSbuf.toString();
            this.findCompletions();
            if (this.tryBond()) {
                return;
            }
            if (this.tryEraser(hourglass)) {
                return;
            }
            if (this.tryTemplate()) {
                return;
            }
            if (this.tryLP()) {
                return;
            }
            if (this.tryCharge()) {
                return;
            }
            if (this.tryAnyAtom()) {
                return;
            }
            if (this.tryEnhancedStereo()) {
                return;
            }
            if (this.tryRgroupAndMap()) {
                return;
            }
            if (this.tryQueryProp()) {
                return;
            }
            if (this.tryValenceProp()) {
                return;
            }
            if (this.tryAbbrevGroup()) {
                return;
            }
            if (this.tryElement()) {
                return;
            }
            if (this.tryAtomList()) {
                return;
            }
            if (this.tryMyTemplate()) {
                return;
            }
        }
    }

    public void cursorLeft(boolean shift) {
        int i;
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null && (i = t.getCursorPos()) > 0) {
            t.setCursorPos(i - 1, shift);
            this.setSelection(t);
        }
    }

    public void cursorRight(boolean shift) {
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null) {
            int i = t.getCursorPos();
            if (i < t.getText().length()) {
                t.setCursorPos(i + 1, shift);
                this.setSelection(t);
            } else {
                t.setCursorPos(i, shift);
                this.setSelection(t);
            }
        }
    }

    public boolean cursorHome(boolean shift) {
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null) {
            t.setCursorPos(0, shift);
            this.setSelection(t);
            return true;
        }
        return false;
    }

    public boolean cursorToRowStart(boolean shift) {
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null) {
            t.cursorToRowStart(shift);
            this.setSelection(t);
            return true;
        }
        return false;
    }

    public boolean cursorToRowEnd(boolean shift) {
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null) {
            t.cursorToRowEnd(shift);
            this.setSelection(t);
            return true;
        }
        return false;
    }

    public boolean cursorEnd(boolean shift) {
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null) {
            t.setCursorPos(t.getText().length(), shift);
            this.setSelection(t);
            return true;
        }
        return false;
    }

    public boolean cursorUp(boolean shift) {
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null) {
            t.cursorUp(shift);
            this.setSelection(t);
            return true;
        }
        return false;
    }

    public boolean cursorDown(boolean shift) {
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null) {
            t.cursorDown(shift);
            this.setSelection(t);
            return true;
        }
        return false;
    }

    public boolean enter() {
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null) {
            t.addChar('\n');
            this.setSelection(t);
            return true;
        }
        return false;
    }

    public boolean deleteChar(boolean shift) {
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null) {
            if (shift) {
                this.temporaryTextClipboard = t.getSelectedString();
            }
            t.deleteChar();
            this.setSelection(t);
            this.molEditor.historize();
            return true;
        }
        return false;
    }

    public boolean insertChar(boolean ctrl) {
        MTextBox t = this.molEditor.getFocusedMTextBox();
        if (t != null) {
            if (ctrl) {
                this.temporaryTextClipboard = t.getSelectedString();
            }
            return true;
        }
        return false;
    }

    public String getTemporaryTextClipboardContents() {
        String s = this.temporaryTextClipboard;
        this.temporaryTextClipboard = null;
        return s;
    }

    public void setSelection(MTextBox t) {
        if (t.hasSelection()) {
            this.molEditor.edit(15);
        } else {
            t = null;
        }
        this.molEditor.getDocument().setObjectContainingSelection(t);
        this.molEditor.getSelectionDocument().setObjectContainingSelection(t);
    }

    public String getString() {
        return this.keysString;
    }

    public String[] getPossibleCompletions() {
        return this.possibleCompletions;
    }

    public String getCompletion() {
        return this.completion;
    }

    public boolean isUnfinishedButCompletionPossible() {
        int l = this.keysString.length();
        return l != 0 && l != this.completion.length();
    }

    public SketchMode getSketchMode() {
        SketchMode sm = this.sketchObject;
        if (this.isAbbrevGroup) {
            Molecule m = sm.getMol();
            this.prepareAbbrevGroup(m);
            return this.molEditor.createSM(m);
        }
        return sm != null ? (SketchMode)sm.clone() : null;
    }

    public void prepareAbbrevGroup(Molecule m) {
        m.expandSgroups();
        int dim = this.molEditor.getMolDim();
        if (m.getDim() != dim) {
            m.clean(dim, null);
        }
        DPoint3 p = m.calcCenter();
        m.moveTo(p);
        m.setLocation(new DPoint3(0.0, 0.0, 0.0));
        m.contractSgroups();
        m.getAtom(0).setXYZ(0.0, 0.0, 0.0);
    }

    public int getTemplateNumber() {
        return this.templateNumber;
    }

    public void complete() {
        if (this.keysString != this.completion) {
            this.keysString = this.completion;
            this.keysSbuf.setLength(0);
            this.keysSbuf.append(this.keysString);
            this.tryAbbrevGroup();
        }
    }

    private void findCompletions() {
        Vector<String> v = new Vector<String>();
        int n = Integer.MAX_VALUE;
        this.findQPropCompletions(this.keysString, v);
        String keys = this.keysString.toLowerCase();
        if (this.groupAndTemplateNamesLC != null) {
            for (int i = 0; i < this.groupAndTemplateNamesLC.length; ++i) {
                String s = this.groupAndTemplateNamesLC[i];
                if (!s.startsWith(keys)) continue;
                if (v.size() == 0) {
                    n = s.length();
                } else {
                    for (int j = 0; j < v.size(); ++j) {
                        String ss = (String)v.elementAt(j);
                        int l = ss.length() < s.length() ? ss.length() : s.length();
                        for (int k = 0; k < l; ++k) {
                            if (ss.charAt(k) == s.charAt(k) || k >= n) continue;
                            n = k;
                        }
                    }
                }
                v.addElement(this.groupAndTemplateNames[i]);
            }
        }
        this.completion = v.size() != 0 && n != Integer.MAX_VALUE ? ((String)v.elementAt(0)).substring(0, n) : keys;
        this.possibleCompletions = new String[v.size()];
        v.copyInto(this.possibleCompletions);
    }

    private void clear0() {
        this.keysString = "";
        this.completion = "";
        this.possibleCompletions = EMPTY_ARRAY;
        this.sketchObject = null;
        this.templateNumber = 0;
        this.isAbbrevGroup = false;
    }

    private void setSketchMode(SketchMode so) {
        this.sketchObject = so;
    }

    private void setAtomSM(MolAtom a) {
        this.setSketchMode(new AtomSM(this.molEditor, a));
    }

    private static boolean canBeBond(String s) {
        if (s.length() == 1) {
            char c = s.charAt(0);
            return c >= '0' && c <= '7';
        }
        return s.equals("12") || s.equals("14") || s.equals("24");
    }

    private boolean tryBond() {
        String s = this.keysString;
        if (!KeyboardInput.canBeBond(s)) {
            return false;
        }
        int t = -1;
        if (s.equals("12")) {
            t = 5;
        } else if (s.equals("14")) {
            t = 6;
        } else if (s.equals("24")) {
            t = 7;
        } else if (s.equals("5")) {
            t = 17;
        } else if (s.equals("6")) {
            t = 33;
        } else if (s.equals("7")) {
            t = 49;
        } else if (s.length() == 1) {
            char c = s.charAt(0);
            t = c - 48;
        }
        if (t >= 0) {
            BondSM bondSM = new BondSM(this.molEditor, t);
            this.setSketchMode(bondSM);
            return true;
        }
        return false;
    }

    private static boolean canBeEraser(String s) {
        return s.equals("\u007f");
    }

    public boolean tryEraser(CallbackIface hourglass) {
        if (KeyboardInput.canBeEraser(this.keysString)) {
            this.setSketchMode(new RubberSM(this.molEditor));
            return true;
        }
        return false;
    }

    private static boolean canBeTemplate(String s) {
        int l = s.length();
        if (l != 1 && l != 2) {
            return false;
        }
        char c = s.charAt(0);
        if (c < '1' || c > '9') {
            return false;
        }
        return l == 1 || l == 2 && s.charAt(1) == c;
    }

    private boolean tryTemplate() {
        String s = this.keysString;
        if (KeyboardInput.canBeTemplate(s) && s.length() == 2) {
            this.templateNumber = s.charAt(0) - 48;
            return true;
        }
        return false;
    }

    private static boolean canBeCharge(String s) {
        return s.equals("-") || s.equals("+");
    }

    private boolean tryCharge() {
        if (KeyboardInput.canBeCharge(this.keysString)) {
            char c = this.keysString.charAt(0);
            MolAtom a = new MolAtom(0);
            a.setCharge(c == '-' ? -1 : 1);
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeAnyAtom(String s) {
        return s.equals("*") || s.toUpperCase().equals("Q");
    }

    private boolean tryAnyAtom() {
        if (KeyboardInput.canBeAnyAtom(this.keysString)) {
            char c = this.keysString.charAt(0);
            int atno = c == '*' ? 131 : 132;
            this.setAtomSM(new MolAtom(atno));
            return true;
        }
        return false;
    }

    private boolean tryLP() {
        if (this.keysString.toUpperCase().equals("LP")) {
            this.setAtomSM(new MolAtom(130));
            return true;
        }
        return false;
    }

    private static boolean canBeRgroupOrMap(String s) {
        if (s.length() >= 1) {
            char c = Character.toUpperCase(s.charAt(0));
            if (c != 'R' && c != 'M') {
                return false;
            }
            if ((s = s.substring(1)).length() == 0) {
                return true;
            }
            if (c == 'M' && (s.equals("=") || s.equals("+"))) {
                return true;
            }
            int n = KeyboardInput.getNonnegativeInteger(s);
            return c == 'R' && n >= 1 && n <= Short.MAX_VALUE || c == 'M' && n >= 0 && n <= 1023;
        }
        return false;
    }

    private boolean tryRgroupAndMap() {
        String s = this.keysString;
        if (!KeyboardInput.canBeRgroupOrMap(s)) {
            return false;
        }
        if (s.length() < 2 && !s.equalsIgnoreCase("R")) {
            return false;
        }
        try {
            char c = Character.toUpperCase(s.charAt(0));
            MolAtom a = null;
            if (c == 'R') {
                a = new MolAtom(134);
                int k = s.equalsIgnoreCase("R") ? 0 : Integer.parseInt(s.substring(1));
                a.setRgroup(k);
            } else if (c == 'M') {
                char d = s.charAt(1);
                if (d == '+' || d == '=') {
                    a = new MolAtom(210);
                    int k = this.molEditor.findFreeAtomMap();
                    a.setAtomMap(k);
                } else {
                    a = new MolAtom(209);
                    int k = Integer.parseInt(s.substring(1));
                    a.setAtomMap(k);
                }
            } else {
                return false;
            }
            this.setAtomSM(a);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private void findQPropCompletions(String keys, Vector v) {
        int l = keys.length();
        if (l < 3) {
            if (KeyboardInput.canBeQProp_a(keys, true)) {
                v.addElement(".a - aromatic");
            }
            if (KeyboardInput.canBeQProp_A(keys, true)) {
                v.addElement(".A - aliphatic");
            }
            if (KeyboardInput.canBeMDLUnsat(keys, true)) {
                v.addElement(".u - unsaturated");
            }
            if (KeyboardInput.canBeQProp_H(keys, true)) {
                v.addElement(".H# - number of hydrogens");
            }
            if (KeyboardInput.canBeQProp_h(keys, true)) {
                v.addElement(".h# - implicit hydrogens");
            }
            if (KeyboardInput.canBeQProp_X(keys, true)) {
                v.addElement(".X# - connectivity");
            }
            if (KeyboardInput.canBeQProp_D(keys, true)) {
                v.addElement(".D# - degree ");
            }
            if (KeyboardInput.canBeQProp_R(keys, true)) {
                v.addElement(".R# - number of rings");
            }
            if (KeyboardInput.canBeQProp_r(keys, true)) {
                v.addElement(".r# - smallest ring size");
            }
            if (KeyboardInput.canBeMDLSubstCount(keys, true)) {
                v.addElement(".s# - substitution count");
            }
            if (KeyboardInput.canBeValenceProp(keys, true)) {
                v.addElement(".v# - valence");
            }
        }
        if (l < 4 && KeyboardInput.canBeMDLRBCount(keys, true)) {
            v.addElement(".rb# - ring bond count");
        }
    }

    private static boolean canBeQProp_X(String s, boolean incomplete) {
        s = s.toUpperCase();
        if (incomplete && ".X".startsWith(s)) {
            return true;
        }
        int off = 0;
        if (!s.startsWith(".X") || s.length() < 3) {
            return false;
        }
        off = 2;
        return KeyboardInput.getNonnegativeInteger(s.substring(off)) >= 0;
    }

    private boolean tryQProp_X() {
        String s = this.keysString;
        if (KeyboardInput.canBeQProp_X(s, false)) {
            int off = s.startsWith(".") ? 2 : 1;
            int k = KeyboardInput.getNonnegativeInteger(s.substring(off));
            MolAtom a = new MolAtom(0);
            a.setQProp("X", k);
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeQProp_D(String s, boolean incomplete) {
        s = s.toUpperCase();
        if (incomplete && ".D".startsWith(s)) {
            return true;
        }
        int off = 0;
        if (!s.startsWith(".D") || s.length() < 3) {
            return false;
        }
        off = 2;
        return KeyboardInput.getNonnegativeInteger(s.substring(off)) >= 0;
    }

    private boolean tryQProp_D() {
        String s = this.keysString;
        if (KeyboardInput.canBeQProp_D(s, false)) {
            int off = s.startsWith(".") ? 2 : 1;
            int k = KeyboardInput.getNonnegativeInteger(s.substring(off));
            MolAtom a = new MolAtom(0);
            a.setQProp("D", k);
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeQProp_H(String s, boolean incomplete) {
        if (incomplete && ".H".startsWith(s)) {
            return true;
        }
        int off = 0;
        if (!s.startsWith(".H") || s.length() < 3) {
            return false;
        }
        off = 2;
        return KeyboardInput.getNonnegativeInteger(s.substring(off)) >= 0;
    }

    private boolean tryQProp_H() {
        String s = this.keysString;
        if (KeyboardInput.canBeQProp_H(s, false)) {
            int off = s.startsWith(".") ? 2 : 1;
            int k = KeyboardInput.getNonnegativeInteger(s.substring(off));
            MolAtom a = new MolAtom(0);
            a.setQProp("H", k);
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeQProp_h(String s, boolean incomplete) {
        if (incomplete && ".h".startsWith(s)) {
            return true;
        }
        int off = 0;
        if (!s.startsWith(".h") || s.length() < 3) {
            return false;
        }
        off = 2;
        return KeyboardInput.getNonnegativeInteger(s.substring(off)) >= 0;
    }

    private boolean tryQProp_h() {
        String s = this.keysString;
        if (KeyboardInput.canBeQProp_h(s, false)) {
            int off = s.startsWith(".") ? 2 : 1;
            int k = KeyboardInput.getNonnegativeInteger(s.substring(off));
            MolAtom a = new MolAtom(0);
            a.setQProp("h", k);
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeQProp_R(String s, boolean incomplete) {
        if (incomplete && ".R".startsWith(s)) {
            return true;
        }
        int off = 0;
        if (!s.startsWith(".R") || s.length() < 3) {
            return false;
        }
        off = 2;
        return KeyboardInput.getNonnegativeInteger(s.substring(off)) >= 0;
    }

    private boolean tryQProp_R() {
        String s = this.keysString;
        if (KeyboardInput.canBeQProp_R(s, false)) {
            int off = s.startsWith(".") ? 2 : 1;
            int k = KeyboardInput.getNonnegativeInteger(s.substring(off));
            MolAtom a = new MolAtom(0);
            a.setQProp("R", k);
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeQProp_r(String s, boolean incomplete) {
        if (incomplete && ".r".startsWith(s)) {
            return true;
        }
        int off = 0;
        if (!s.startsWith(".r") || s.length() < 3) {
            return false;
        }
        off = 2;
        return KeyboardInput.getNonnegativeInteger(s.substring(off)) >= 0;
    }

    private boolean tryQProp_r() {
        String s = this.keysString;
        if (KeyboardInput.canBeQProp_r(s, false)) {
            int off = s.startsWith(".") ? 2 : 1;
            int k = KeyboardInput.getNonnegativeInteger(s.substring(off));
            MolAtom a = new MolAtom(0);
            a.setQProp("r", k);
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeQProp_a(String s, boolean incomplete) {
        if (incomplete && ".a".startsWith(s)) {
            return true;
        }
        return s.equals(".a");
    }

    private boolean tryQProp_a() {
        String s = this.keysString;
        if (KeyboardInput.canBeQProp_a(s, false)) {
            MolAtom a = new MolAtom(0);
            a.setQueryAromaticity(1);
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeQProp_A(String s, boolean incomplete) {
        if (incomplete && ".A".startsWith(s)) {
            return true;
        }
        return s.equals(".A");
    }

    private boolean tryQProp_A() {
        String s = this.keysString;
        if (KeyboardInput.canBeQProp_A(s, false)) {
            MolAtom a = new MolAtom(0);
            a.setQueryAromaticity(2);
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeMDLSubstCount(String s, boolean incomplete) {
        if (incomplete && ".s".startsWith(s)) {
            return true;
        }
        if (s.equals(".s*")) {
            return true;
        }
        int off = 0;
        if (!s.startsWith(".s") || s.length() < 3) {
            return false;
        }
        off = 2;
        return KeyboardInput.getNonnegativeInteger(s.substring(off)) >= 0;
    }

    private boolean tryMDLSubstCount() {
        String s = this.keysString;
        if (KeyboardInput.canBeMDLSubstCount(s, false)) {
            MolAtom a = null;
            if (s.equalsIgnoreCase(".s*") || s.equalsIgnoreCase("s*")) {
                a = new MolAtom(0);
                a.setQProp("s", -2);
            } else {
                int off = s.startsWith(".") ? 2 : 1;
                int k = KeyboardInput.getNonnegativeInteger(s.substring(off));
                a = new MolAtom(0);
                a.setQProp("s", k);
            }
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeMDLRBCount(String s, boolean incomplete) {
        if (incomplete && ".rb".startsWith(s)) {
            return true;
        }
        if (s.equals(".rb*")) {
            return true;
        }
        int off = 0;
        if (!s.startsWith(".rb") || s.length() < 4) {
            return false;
        }
        off = 3;
        return KeyboardInput.getNonnegativeInteger(s.substring(off)) >= 0;
    }

    private boolean tryMDLRBCount() {
        String s = this.keysString;
        if (KeyboardInput.canBeMDLRBCount(s, false)) {
            MolAtom a = null;
            if (s.equalsIgnoreCase(".rb*") || s.equalsIgnoreCase("rb*")) {
                a = new MolAtom(0);
                a.setQProp("rb", -2);
            } else {
                int off = s.startsWith(".") ? 3 : 2;
                int k = KeyboardInput.getNonnegativeInteger(s.substring(off));
                a = new MolAtom(0);
                a.setQProp("rb", k);
            }
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeMDLUnsat(String s, boolean incomplete) {
        if (incomplete && ".u".startsWith(s)) {
            return true;
        }
        return s.equals(".u");
    }

    private boolean tryMDLUnsat() {
        String s = this.keysString;
        if (KeyboardInput.canBeMDLUnsat(s, false)) {
            MolAtom a = new MolAtom(0);
            a.setQProp("u", 1);
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeQueryProp(String s) {
        return KeyboardInput.canBeQProp_X(s, true) || KeyboardInput.canBeQProp_D(s, true) || KeyboardInput.canBeQProp_H(s, true) || KeyboardInput.canBeQProp_h(s, true) || KeyboardInput.canBeQProp_R(s, true) || KeyboardInput.canBeQProp_r(s, true) || KeyboardInput.canBeQProp_a(s, true) || KeyboardInput.canBeQProp_A(s, true) || KeyboardInput.canBeMDLSubstCount(s, true) || KeyboardInput.canBeMDLRBCount(s, true) || KeyboardInput.canBeMDLUnsat(s, true);
    }

    private boolean tryQueryProp() {
        if (this.tryQProp_X()) {
            return true;
        }
        if (this.tryQProp_D()) {
            return true;
        }
        if (this.tryQProp_H()) {
            return true;
        }
        if (this.tryQProp_h()) {
            return true;
        }
        if (this.tryQProp_R()) {
            return true;
        }
        if (this.tryQProp_r()) {
            return true;
        }
        if (this.tryQProp_a()) {
            return true;
        }
        if (this.tryQProp_A()) {
            return true;
        }
        if (this.tryMDLSubstCount()) {
            return true;
        }
        if (this.tryMDLRBCount()) {
            return true;
        }
        return this.tryMDLUnsat();
    }

    private static boolean canBeValenceProp(String s, boolean incomplete) {
        if (incomplete && ".v".startsWith(s)) {
            return true;
        }
        int off = 0;
        if (!s.startsWith(".v") || s.length() < 3) {
            return false;
        }
        off = 2;
        return KeyboardInput.getNonnegativeInteger(s.substring(off)) >= 0;
    }

    private boolean tryValenceProp() {
        String s = this.keysString;
        if (KeyboardInput.canBeValenceProp(s, false)) {
            MolAtom a = null;
            int off = s.startsWith(".") ? 2 : 1;
            int k = KeyboardInput.getNonnegativeInteger(s.substring(off));
            a = new MolAtom(0);
            a.setValenceProp(k);
            this.setAtomSM(a);
            return true;
        }
        return false;
    }

    private static boolean canBeEnhancedStereo(String s) {
        if (s.length() < 2) {
            return false;
        }
        s = s.toLowerCase();
        for (int i = 0; i < STGRP_NAMES.length; ++i) {
            if (!STGRP_NAMES[i].startsWith(s)) continue;
            return true;
        }
        return s.startsWith("or") && KeyboardInput.getNonnegativeInteger(s.substring(2)) > 0 || s.startsWith("and") && KeyboardInput.getNonnegativeInteger(s.substring(3)) > 0 || s.startsWith("&") && KeyboardInput.getNonnegativeInteger(s.substring(1)) > 0;
    }

    private boolean tryEnhancedStereo() {
        String s = this.keysString;
        if (s.length() < 2) {
            return false;
        }
        s = s.toLowerCase();
        int t = 0;
        int k = 0;
        if (s.equals("abs")) {
            t = 1;
        } else if (s.startsWith("or")) {
            t = 2;
            k = KeyboardInput.getNonnegativeInteger(s.substring(2));
        } else if (s.startsWith("and")) {
            t = 3;
            k = KeyboardInput.getNonnegativeInteger(s.substring(3));
        } else if (s.startsWith("&")) {
            t = 3;
            k = KeyboardInput.getNonnegativeInteger(s.substring(1));
        }
        if (k < 0) {
            return false;
        }
        if (t == 0 || (t == 2 || t == 3) && k < 1) {
            return false;
        }
        MolAtom a = new MolAtom(0);
        a.setStereoGroupType(t);
        if (k > 0) {
            a.setStereoGroupNumber(k);
        }
        this.setAtomSM(a);
        return true;
    }

    private static boolean canBeElement(String s) {
        int l = s.length();
        if (l == 1) {
            char c = Character.toUpperCase(s.charAt(0));
            return c >= 'A' && c <= 'Z';
        }
        if (l == 2) {
            return MolAtom.numOf(KeyboardInput.capitalize(s)) > 0;
        }
        return false;
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private static boolean canBeAtomList(String s) {
        if (s.isEmpty()) {
            return false;
        }
        String[] elements = KeyboardInput.getElementsList(s);
        assert (elements.length > 0);
        return KeyboardInput.canConvertToAtomicNumber(Arrays.copyOf(elements, elements.length - 1)) && (elements[elements.length - 1].isEmpty() || KeyboardInput.canBeElement(elements[elements.length - 1]));
    }

    private static String[] getElementsList(String s) {
        if (s.isEmpty()) {
            return EMPTY_ARRAY;
        }
        String elements = s;
        if (s.charAt(0) == '!') {
            elements = s.substring(1);
        }
        String[] result = elements.split(",", -1);
        for (int i = 0; i < result.length; ++i) {
            result[i] = KeyboardInput.capitalize(result[i]);
        }
        return result;
    }

    private static int[] convertToAtomicNumber(String[] elements) {
        int[] result = new int[elements.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = PeriodicSystem.getAtomicNumber(elements[i]);
        }
        return result;
    }

    private static boolean canConvertToAtomicNumber(String[] elements) {
        for (String element : elements) {
            if (KeyboardInput.canConvertToAtomicNumber(element)) continue;
            return false;
        }
        return true;
    }

    private static boolean canConvertToAtomicNumber(String elements) {
        return !elements.isEmpty() && PeriodicSystem.getAtomicNumber(elements) != -1;
    }

    private boolean tryElement() {
        String s = this.keysString;
        if (!KeyboardInput.canBeElement(s)) {
            return false;
        }
        int l = s.length();
        int atno = 0;
        int iso = 0;
        boolean specIsoSymPref = false;
        if (l == 1) {
            char c = Character.toUpperCase(s.charAt(0));
            atno = MolAtom.numOf(String.valueOf(c));
            if (c == 'D') {
                atno = 1;
                iso = 2;
                specIsoSymPref = true;
            } else if (c == 'T') {
                atno = 1;
                iso = 3;
                specIsoSymPref = true;
            }
        } else if (l == 2) {
            char[] name = new char[]{Character.toUpperCase(s.charAt(0)), s.charAt(1)};
            atno = MolAtom.numOf(new String(name));
        }
        if (atno < 1 || atno > 109) {
            return false;
        }
        MolAtom a = new MolAtom(atno);
        a.setSpecIsotopeSymbolPreferred(specIsoSymPref);
        if (iso != 0) {
            a.setMassno(iso);
        }
        this.setAtomSM(a);
        return true;
    }

    private boolean tryAtomList() {
        if (this.keysString.isEmpty()) {
            return false;
        }
        String[] elements = KeyboardInput.getElementsList(this.keysString);
        if (!KeyboardInput.canConvertToAtomicNumber(elements)) {
            return false;
        }
        MolAtom a = new MolAtom(this.keysString.charAt(0) == '!' ? 129 : 128);
        a.setList(KeyboardInput.convertToAtomicNumber(elements));
        a.setXYZ(0.0, 0.0, 0.0);
        this.setAtomSM(a);
        return true;
    }

    private boolean canBeAbbrevGroup(String s) {
        boolean cs = KeyboardInput.isCaseSensitiveInput(s);
        String sLC = s.toLowerCase();
        if (this.abbrevGroups != null) {
            for (int i = 0; i < this.abbrevGroups.getSize(); ++i) {
                String name = this.abbrevGroups.getAbbrevName(i);
                if ((!cs || !name.startsWith(s)) && (cs || !name.toLowerCase().startsWith(sLC))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canBeMyTemplate(String s) {
        boolean cs = KeyboardInput.isCaseSensitiveInput(s);
        String sLC = s.toLowerCase();
        if (this.myTemplateNamesLC != null) {
            for (int i = 0; i < this.myTemplateNames.length; ++i) {
                String name = this.myTemplateNames[i];
                if ((!cs || !name.startsWith(s)) && (cs || !this.myTemplateNamesLC[i].startsWith(sLC))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryAbbrevGroup() {
        String s = this.keysString;
        if (s.length() < 1) {
            return false;
        }
        boolean cs = KeyboardInput.isCaseSensitiveInput(s);
        if (this.abbrevGroups != null) {
            for (int i = 0; i < this.abbrevGroups.getSize(); ++i) {
                Molecule m;
                String name = this.abbrevGroups.getAbbrevName(i);
                if ((!cs || !name.equals(s)) && (cs || !name.toLowerCase().equals(s))) continue;
                this.isAbbrevGroup = true;
                try {
                    m = this.abbrevGroups.getMolecule(i);
                }
                catch (MRecordParseException ex) {
                    ex.printStackTrace();
                    return true;
                }
                catch (MolFormatException ex) {
                    ex.printStackTrace();
                    return true;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    return true;
                }
                SketchMode sm = this.molEditor.createSM(m);
                this.setSketchMode(sm);
                return true;
            }
        }
        return false;
    }

    private boolean tryMyTemplate() {
        String s = this.keysString;
        if (s.length() < 1) {
            return false;
        }
        boolean cs = KeyboardInput.isCaseSensitiveInput(s);
        if (this.myTemplateNamesLC != null) {
            for (int i = 0; i < this.myTemplateNames.length; ++i) {
                String name = this.myTemplateNames[i];
                if ((!cs || !name.equals(s)) && (cs || !this.myTemplateNamesLC[i].equals(s))) continue;
                SketchMode sm = this.molEditor.createSM(this.myTemplates[i]);
                this.setSketchMode(sm);
                return true;
            }
        }
        return false;
    }

    private ActionListener createClearAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardInput.this.clear();
            }
        };
    }

    private void stopTimer() {
        this.timer.stop();
    }

    private void restartTimer() {
        this.timer.restart();
    }

    private static boolean isCaseSensitiveInput(String s) {
        boolean cs = false;
        for (int i = 0; i < s.length() && !cs; ++i) {
            char c = s.charAt(i);
            if (c < 'A' || c > 'Z') continue;
            cs = true;
        }
        return cs;
    }

    private static int getNonnegativeInteger(String s) {
        if (s.length() == 0) {
            return 0;
        }
        char c = s.charAt(0);
        if (s.equals("0")) {
            return 0;
        }
        if (c < '1' || c > '9') {
            return -1;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (c >= '0' && c <= '9') continue;
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

