/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MObjectSM
extends SketchMode {
    private static final long serialVersionUID = 8408081115999010988L;
    private transient MObject object;

    protected MObjectSM() {
    }

    public MObjectSM(MolEditor e, MObject o) {
        super(e);
        if (o == null) {
            throw new NullPointerException("MObjectSM cannot be constructed with a null MObject");
        }
        this.object = o;
    }

    protected MObjectSM(MolEditor e) {
        super(e);
    }

    protected MObjectSM(MObjectSM so) {
        super(so);
        this.object = (MObject)so.object.clone();
    }

    public void initMObject(MObject o) {
        if (o == null) {
            throw new NullPointerException("MObjectSM cannot be constructed with a null MObject");
        }
        this.object = o;
    }

    @Override
    public Molecule getMol() {
        Molecule m = new Molecule();
        MDocument doc = new MDocument(m);
        doc.addObject((MObject)this.object.clone());
        return m;
    }

    @Override
    public boolean canPointToMObject() {
        return true;
    }

    @Override
    public boolean canPointToAtom() {
        return true;
    }

    @Override
    public boolean canPointToBond() {
        return true;
    }

    @Override
    public boolean canPointToSgroup() {
        return true;
    }

    @Override
    public boolean containedObjectEquals(SketchMode o) {
        if (o != null && o instanceof MObjectSM) {
            MObjectSM mso = (MObjectSM)o;
            return mso.object == this.object;
        }
        return false;
    }

    @Override
    public Object clone() {
        return new MObjectSM(this);
    }

    public MObject getMObject() {
        return this.object;
    }

    @Override
    public int buttonDown(boolean dblClick, int modifiers) {
        return 0;
    }

    @Override
    public int buttonUp(int modifiers, boolean doHist) {
        return 0;
    }

    @Override
    public boolean pointerMove(int modifiers) {
        return false;
    }

    @Override
    public boolean pointerDrag(int modifiers) {
        return false;
    }

    @Override
    public boolean pointerCopyDrag(int modifiers) {
        return true;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeObject(this.object);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        this.object = (MObject)ois.readObject();
    }
}

