/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.core.util.BondTable;
import chemaxon.core.util.GeomUtil;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.BondMerger;
import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.MolJoin;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MoleculeSM
extends SketchMode {
    private static final long serialVersionUID = 879978814934682047L;
    protected transient Molecule molecule;
    private SketchMode parentSketchMode = null;

    public MoleculeSM(MolEditor e, Molecule m) {
        super(e);
        this.molecule = m;
    }

    MoleculeSM(SketchMode parent, Molecule m) {
        this(parent.getEditor(), m);
        this.parentSketchMode = parent;
    }

    public MoleculeSM(MoleculeSM so) {
        super(so);
        this.molecule = MoleculeSM.cloneMol(so.molecule);
    }

    protected MoleculeSM(MolEditor e) {
        super(e);
    }

    @Override
    public boolean containedObjectEquals(SketchMode o) {
        return o != null && o instanceof MoleculeSM && ((MoleculeSM)o).molecule == this.molecule;
    }

    @Override
    public Object clone() {
        return new MoleculeSM(this);
    }

    @Override
    public Molecule getMol() {
        Molecule mdef = this.molecule;
        MolEditor ed = this.getEditor();
        int dim = ed.getMolDim();
        MPropertyContainer mprops = mdef.properties();
        Molecule m = (Molecule)mprops.getObject(dim == 3 ? "mol3d" : "mol2d");
        if (m != null) {
            return m;
        }
        String cmd = mprops.getString(dim == 3 ? "mol3dcmd" : "mol2dcmd");
        if (cmd != null) {
            cmd = cmd.trim();
            m = mdef.cloneMolecule();
            if (dim == 3) {
                if (cmd.equals("clean")) {
                    m.clean(3, null);
                }
                mprops.setObject("mol3d", m);
            } else {
                if (cmd.equals("z=0")) {
                    for (int i = 0; i < m.getAtomCount(); ++i) {
                        m.getAtom(i).setZ(0.0);
                    }
                    m.setDim(2);
                } else if (cmd.equals("clean")) {
                    m.clean(2, null);
                }
                mprops.setObject("mol2d", m);
            }
        }
        if (m == null) {
            m = mdef;
        }
        return m;
    }

    @Override
    public void setMol(Molecule m) {
        this.molecule = m;
    }

    @Override
    public void moveTo(DPoint3 o) {
        MoleculeSM.moveTo(o, this.molecule);
    }

    public static Molecule cloneMol(Molecule m) {
        MDocument d = m.getDocument();
        if (d != null) {
            return (Molecule)((MDocument)d.clone()).getMainMoleculeGraph();
        }
        return (Molecule)m.clone();
    }

    public static void moveTo(DPoint3 o, Molecule m) {
        MDocument d = m.getDocument();
        CTransform3D t = new CTransform3D();
        DPoint3 o0 = m.getLocation();
        t.setTranslation(o.x - o0.x, o.y - o0.y, o.z - o0.z);
        if (d == null) {
            m.transform(t);
        } else {
            d.transform(t);
        }
        for (int i = 0; i < m.getAtomCount(); ++i) {
            m.getAtom(i).moveCorners(o.x - o0.x, o.y - o0.y);
        }
    }

    @Override
    public boolean isFloatingObjectPainted() {
        SuperatomSgroup sg;
        MolAtom[] attach;
        Sgroup s;
        boolean is3D;
        MolBond bond;
        MolBond molBond = bond = this.molecule.isBond() ? this.molecule.getBond(0) : null;
        if (!super.isFloatingObjectPainted() || bond != null && !this.getEditor().isBondDraggedAlong()) {
            return false;
        }
        boolean bl = is3D = this.getEditor().getMol().getDim() == 3 || this.getEditor().getPainter().getRTransform().is3d();
        if (is3D) {
            return true;
        }
        if (this.molecule.isSgroup() ? (s = this.molecule.getSgroup(0)) instanceof SuperatomSgroup && (attach = (sg = (SuperatomSgroup)this.molecule.getSgroup(0)).getFreeLegalAttachAtoms()).length != 1 : !this.molecule.isRing() || !this.molecule.isSymmetric()) {
            return true;
        }
        return !this.isAtomOrBondPointed();
    }

    @Override
    public boolean canPointToAtom() {
        return !this.isFloatingObjectPainted();
    }

    @Override
    public boolean canPointToBond() {
        return !this.isFloatingObjectPainted();
    }

    @Override
    public boolean canPointToSgroup() {
        return true;
    }

    @Override
    public void hilitJoins(MolJoin j, MolPainter p, double sr, Graphics2D g) {
        if (this.isFloatingObjectPainted()) {
            super.hilitJoins(j, p, sr, g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonDown(boolean dblClick, int modifiers) {
        boolean is3D;
        MolEditor med = this.getEditor();
        med.edit(14);
        boolean bl = is3D = med.getMol().getDim() == 3 || med.getPainter().getRTransform().is3d();
        if (this.isFloatingObjectPainted()) {
            med.putPiece();
        } else if (!is3D) {
            med.pntAB(false);
            Molecule piece = med.getPiece().cloneMolecule();
            PointedObject po = med.getPointedObject();
            if (po != null && po instanceof AtomPO && this.molecule.isRing() && this.molecule.isSymmetric() && piece.isRing()) {
                MolAtom pnta = ((AtomPO)po).getAtom();
                if (pnta != null && !(pnta instanceof SgroupAtom)) {
                    boolean show = med.isBranchable(pnta);
                    Object object = med.getMol().getLock();
                    synchronized (object) {
                        if ((modifiers & 1) != 0 || pnta.getBondCount() == 1) {
                            this.prepareSpiroDrawingOfSymmetricRing(piece, pnta, show);
                        } else {
                            Molecule m = this.createBondmolFromAtoms(pnta, null);
                            CTransform3D trot = med.getPainter().getRTransformRef();
                            this.mergeRingWithAtom(m, piece, m.getAtom(1), trot);
                            med.showPossibleMolecule(m, show);
                        }
                        med.setPaintOnlyShowMolecule(false);
                    }
                }
            } else if (po instanceof BondPO && this.molecule.isRing() && this.molecule.isSymmetric()) {
                med.setPaintOnlyShowMolecule(false);
            } else if (po != null && po instanceof AtomPO && this.molecule.isSgroup()) {
                Molecule m;
                MolAtom pnta = ((AtomPO)po).getAtom();
                if (pnta.getBondCount() > 1 && !med.isBranchable(pnta) && (m = this.prepareSproutDrawingOfSgroup(pnta)) != null) {
                    med.showPossibleMolecule(m, false);
                }
                med.setPaintOnlyShowMolecule(false);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buttonUp(int modifiers, boolean doHist) {
        MolEditor med = this.getEditor();
        boolean histEnabled = med.setHistorizeEnabled(false);
        if (med.isMoveModePersistent()) {
            return 0;
        }
        Object molLock = med.getMol().getLock();
        int ret = 0;
        Object object = molLock;
        synchronized (object) {
            PointedObject po = med.getPointedObject();
            if (po != null && po instanceof BondPO && this.molecule.isRing() && this.molecule.isSymmetric()) {
                Molecule mol = med.getMol();
                Molecule ring = this.molecule.cloneMolecule();
                CTransform3D trot = new CTransform3D();
                trot.setIdentity();
                MolBond b = ((BondPO)po).getBond();
                this.mergeRingWithBond(mol, ring, b, trot);
                if (med.atomBranchPiece != null) {
                    med.atomBranchPiece.moveTo(med.getPointerPos());
                    med.setPiece0(med.atomBranchPiece, null);
                    med.atomBranchPiece = null;
                }
                med.clearShowMolecule();
            } else if (med.atomBranchPiece != null && (po = med.getPointedObject()) != null && po instanceof AtomPO) {
                med.endShowMoleculeDrawing();
                this.pointerMove(modifiers);
            } else if (med.isDragged() && !med.getCurfrag().isEmpty()) {
                med.join(med.getCurfragJoin(), med.getCurfrag(), 1);
                med.restoreNonReactionIfPossible();
            }
            med.clearCurfrag();
            med.setMoveMode(0, false);
            med.jointAtom = null;
            ret = 2;
        }
        if ((modifiers & 1) == 0 && this.parentSketchMode != null) {
            this.parentSketchMode.moveTo(this.molecule.getLocation());
            med.setSketchMode(this.parentSketchMode, false, true);
            med.command(1, modifiers);
        }
        med.setHistorizeEnabled(histEnabled);
        if (doHist) {
            med.historize();
        }
        return ret;
    }

    @Override
    public boolean pointerMove(int modifiers) {
        boolean is3D;
        MolEditor med = this.getEditor();
        med.pntAB(false);
        boolean bl = is3D = med.getMol().getDim() == 3 || med.getPainter().getRTransform().is3d();
        if (this.isFloatingObjectPainted()) {
            med.setPointedObject(null);
            if (med.atomBranchPiece != null) {
                med.atomBranchPiece.moveTo(med.getPointerPos());
                med.setPiece0(med.atomBranchPiece, null);
                med.atomBranchPiece = null;
                med.clearShowMolecule();
            }
            med.setSketchMode(this, false);
        } else if (!is3D) {
            PointedObject po = med.getPointedObject();
            Molecule piece = med.getPiece().cloneMolecule();
            if (po != null && po instanceof AtomPO) {
                Molecule mol;
                Sgroup s;
                MolAtom pnta = ((AtomPO)po).getAtom();
                if (this.molecule.isRing() && this.molecule.isSymmetric() && piece.isRing()) {
                    if (med.isBranchable(pnta) && !(pnta instanceof SgroupAtom)) {
                        if ((modifiers & 1) != 0 || pnta.getBondCount() == 1) {
                            this.prepareSpiroDrawingOfSymmetricRing(piece, pnta, true);
                        } else {
                            Molecule m = this.createBondmolFromAtoms(pnta, null);
                            CTransform3D trot = med.getPainter().getRTransformRef();
                            this.mergeRingWithAtom(m, piece, m.getAtom(1), trot);
                            med.showPossibleMolecule(m, true);
                        }
                    } else {
                        med.clearShowMolecule();
                    }
                } else if (this.molecule.isSgroup() && med.isBranchable(pnta) && (s = (mol = this.molecule.cloneMolecule()).getSgroup(0)) instanceof SuperatomSgroup) {
                    SuperatomSgroup sg = (SuperatomSgroup)s;
                    MolAtom[] attach = sg.getFreeLegalAttachAtoms();
                    if (attach.length != 1) {
                        return true;
                    }
                    if (pnta.getBondCount() > 1) {
                        Molecule m = this.prepareSproutDrawingOfSgroup(pnta);
                        if (m == null) {
                            return true;
                        }
                    } else if (pnta.getBondCount() == 1) {
                        this.prepareSpiroDrawingOfSgroup(pnta);
                    }
                }
            } else if (po != null && po instanceof BondPO && this.molecule.isRing() && this.molecule.isSymmetric()) {
                MolBond b = ((BondPO)po).getBond();
                CTransform3D trot = new CTransform3D();
                trot.setIdentity();
                piece = this.molecule.cloneMolecule();
                MolAtom[] ratoms = MoleculeSM.sortRingAtoms(piece);
                MolBond[] rbonds = MoleculeSM.sortRingBonds(piece, ratoms);
                MolBond rb = rbonds[0];
                if (BondMerger.areInOppositeDirection(b, rb, trot)) {
                    rb = new MolBond(rb.getAtom2(), rb.getAtom1(), rb.getFlags());
                }
                BondMerger bm = new BondMerger(b, rb, trot);
                CTransform3D t = bm.getTransform();
                piece.transform(t);
                Molecule mol = med.getMol();
                double[] badness = new double[]{CleanUtil.calcBadness(mol, piece, null, null)};
                double[] savedCoords = CleanUtil.createSavedCoordsArray(piece);
                CleanUtil.saveCoords(piece, savedCoords);
                MoleculeSM.tryMirror(badness, mol, piece, b, savedCoords);
                med.showPossibleMolecule(piece, true);
            } else if (po != null && po instanceof BondPO) {
                med.clearShowMolecule();
            }
        }
        return true;
    }

    @Override
    public boolean pointerDrag(int modifiers) {
        boolean is3D;
        MolEditor med = this.getEditor();
        PointedObject po = med.getPointedObject();
        boolean bl = is3D = med.getMol().getDim() == 3 || med.getPainter().getRTransform().is3d();
        if (po instanceof AtomPO && !is3D) {
            return med.beginPossibleMoleculeDrawing(modifiers);
        }
        return med.moveOrRotateCurfrag(modifiers, false);
    }

    @Override
    public boolean pointerCopyDrag(int modifiers) {
        return true;
    }

    @Override
    public int modkeyChange(int mod) {
        MolEditor med = this.getEditor();
        int oldmod = med.getModifiers();
        if ((mod & 1) == 0 && (oldmod & 1) != 0) {
            if ((mod & 0x10) == 0) {
                if (this.parentSketchMode != null) {
                    this.parentSketchMode.moveTo(this.molecule.getLocation());
                    med.setSketchMode(this.parentSketchMode, false, true);
                    med.command(1, mod);
                    return 1;
                }
                this.pointerMove(mod);
                return 1;
            }
            med.rotateCurrentMoleculeTo15DegreesLine();
            return 1;
        }
        if ((mod & 1) != 0 && (oldmod & 1) == 0) {
            med.clearIndexesToRot();
            if (this.molecule.getSgroupCount() > 0) {
                if ((mod & 0x10) != 0) {
                    return 0;
                }
                Molecule m = this.molecule.cloneMolecule();
                if (m.contractSgroups()) {
                    m.setProperty("sgroupstate", "contract");
                } else {
                    m.expandSgroups();
                    m.setProperty("sgroupstate", "expand");
                }
                DPoint3 center = new DPoint3();
                m.calcCenter(center);
                m.setLocation(center);
                m.moveTo(this.molecule.getLocation());
                MoleculeSM sm = new MoleculeSM(this, m);
                med.setSketchMode(sm, false, true);
                return 1;
            }
            if ((mod & 0x10) == 0) {
                this.pointerMove(mod);
                return 1;
            }
        }
        return 0;
    }

    private void prepareSpiroDrawingOfSymmetricRing(Molecule piece, MolAtom pnta, boolean show) {
        MolEditor med = this.getEditor();
        DPoint3 ppnta = pnta.getLocation();
        CTransform3D t = new CTransform3D();
        MolAtom a = piece.getAtom(0);
        a.setAtno(0);
        DPoint3 pa = a.getLocation();
        double dx = ppnta.x - pa.x;
        double dy = ppnta.y - pa.y;
        double dz = ppnta.z - pa.z;
        t.setTranslation(dx, dy, dz);
        piece.transform(t);
        med.showPossibleMolecule(piece, show);
    }

    private Molecule createBondmolFromAtoms(MolAtom pnta, MolAtom other) {
        MolAtom a1 = (MolAtom)pnta.clone();
        a1.setAtno(0);
        if (other == null) {
            other = new MolAtom(0, 0.0, 0.0, 0.0);
        }
        Molecule m = BondSM.createBondMol(1, a1, other);
        double desired = this.molecule.getDesiredLength(this.molecule.getBond(0));
        other.setXYZ(a1.getX() + desired, a1.getY(), a1.getZ());
        return m;
    }

    private Molecule prepareSproutDrawingOfSgroup(MolAtom pnta) {
        MolEditor med = this.getEditor();
        Molecule mol = this.molecule.cloneMolecule();
        Sgroup s = mol.getSgroup(0);
        if (s instanceof SuperatomSgroup) {
            SuperatomSgroup sg = (SuperatomSgroup)s;
            sg.contract(0);
            SgroupAtom a = sg.getSuperAtom();
            Molecule bondm = this.createBondmolFromAtoms(pnta, a);
            med.showPossibleMolecule(bondm, true);
            Molecule cmg = med.getMol().cloneMolecule();
            Molecule cbondm = bondm.cloneMolecule();
            SuperatomSgroup csg = (SuperatomSgroup)cbondm.getSgroup(0);
            CTransform3D trot = med.getPainter().getRTransformRef();
            MolJoin j = new MolJoin(cmg, cbondm, med.getStickdst(), med.getMergedst(), null, trot);
            int options = 4;
            j.join(cbondm, options);
            if (csg.getAttachAtoms().length != 1) {
                bondm.expandSgroups();
            } else {
                csg.expandOther(0, bondm);
            }
            return bondm;
        }
        return null;
    }

    private void prepareSpiroDrawingOfSgroup(MolAtom pnta) {
        MolEditor med = this.getEditor();
        Molecule mol = this.molecule.cloneMolecule();
        Sgroup s = mol.getSgroup(0);
        if (s instanceof SuperatomSgroup) {
            SuperatomSgroup sg = (SuperatomSgroup)s;
            sg.contract(0);
            SgroupAtom a = sg.getSuperAtom();
            a.setLocation(pnta.getLocation());
            med.showPossibleMolecule(mol, true, true);
            Molecule cmg = med.getMol().cloneMolecule();
            Molecule cmol = mol.cloneMolecule();
            SuperatomSgroup csg = (SuperatomSgroup)cmol.getSgroup(0);
            CTransform3D trot = med.getPainter().getRTransformRef();
            MolJoin j = new MolJoin(cmg, cmol, med.getStickdst(), med.getMergedst(), null, trot);
            int options = 4;
            j.join(cmol, options);
            csg.expandOther(0, mol);
        }
    }

    private boolean isAtomOrBondPointed() {
        MolEditor med = this.getEditor();
        Molecule mol = med.getMol();
        double sr = med.getStickdst() * 1.54;
        MolAtom[] pa = mol.getAtomArray();
        CTransform3D trot = med.getPainter().getRTransformRef();
        DPoint3 p = med.getScreenPointerPos();
        double ptrX = p.x;
        double ptrY = p.y;
        if (MolJoin.findNearAtom(pa, ptrX, ptrY, sr, true, trot) != null) {
            return true;
        }
        if (MolJoin.findNearAtom(pa, ptrX, ptrY, sr, false, trot) != null) {
            return true;
        }
        MolBond[] pb = mol.getBondArray();
        return MolJoin.findNearBond(pb, ptrX, ptrY, sr, trot) != null;
    }

    private void mergeRingWithAtom(Molecule mol, MoleculeGraph ring, MolAtom a, CTransform3D trot) {
        MolAtom ra = ring.getAtom(0);
        DPoint3 pra = ra.getLocation();
        DPoint3 pa = a.getLocation();
        CTransform3D t = new CTransform3D();
        CTransform3D t1 = new CTransform3D();
        double dx = pa.x - pra.x;
        double dy = pa.y - pra.y;
        double dz = pa.z - pra.z;
        t.setTranslation(dx, dy, dz);
        double phi = MoleculeSM.getInitialRotationAngle(a, ra);
        t1.setRotation(0.0, 0.0, 1.0, phi);
        t1.setRotationCenter(pa);
        t1.mul(t);
        ring.transform(t1);
        MolEditor med = this.getEditor();
        MolJoin j = new MolJoin(mol, ring, med.getStickdst(), med.getMergedst(), null, trot);
        int options = 5;
        j.join(ring, options);
    }

    private static double getInitialRotationAngle(MolAtom a0, MolAtom a1) {
        double[] largest0 = GeomUtil.getLargestBondAngle2D(a0);
        double beta0 = largest0[0] + largest0[1] / 2.0;
        double[] largest1 = GeomUtil.getLargestBondAngle2D(a1);
        double beta1 = largest1[0] + largest1[1] / 2.0;
        return Math.PI + beta0 - beta1;
    }

    private void mergeRingWithBond(Molecule mol, MoleculeGraph ring, MolBond b, CTransform3D trot) {
        MolAtom[] ratoms = MoleculeSM.sortRingAtoms(ring);
        MolBond[] rbonds = MoleculeSM.sortRingBonds(ring, ratoms);
        MolBond rb = rbonds[0];
        if (BondMerger.areInOppositeDirection(b, rb, trot)) {
            rb = new MolBond(rb.getAtom2(), rb.getAtom1(), rb.getFlags());
        }
        BondMerger bm = new BondMerger(b, rb, trot);
        CTransform3D t = bm.getTransform();
        ring.transform(t);
        double[] badness = new double[]{CleanUtil.calcBadness(mol, ring, null, null)};
        double[] savedCoords = CleanUtil.createSavedCoordsArray(ring);
        CleanUtil.saveCoords(ring, savedCoords);
        MoleculeSM.tryMirror(badness, mol, ring, b, savedCoords);
        MolEditor med = this.getEditor();
        MolJoin j = new MolJoin(mol, ring, med.getStickdst(), med.getMergedst(), null, trot);
        int options = 5;
        j.join(ring, options);
    }

    private static boolean tryMirror(double[] badness, MoleculeGraph mol, MoleculeGraph ring, MolBond b, double[] savedCoords) {
        CTransform3D t1 = CleanUtil.createRotationAboutBond(b, Math.PI);
        ring.transform(t1);
        double badness2 = CleanUtil.calcBadness(mol, ring, null, null);
        if (badness2 < badness[0]) {
            badness[0] = badness2;
            return true;
        }
        CleanUtil.restoreCoords(ring, savedCoords);
        return false;
    }

    private static MolAtom[] sortRingAtoms(MoleculeGraph ring) {
        int n_all = ring.getAtomCount();
        int n_without_H = 0;
        MolAtom a0 = null;
        int i0 = -1;
        for (int i = n_all - 1; i >= 0; --i) {
            MolAtom aa = ring.getAtom(i);
            if (aa.getAtno() == 1) continue;
            ++n_without_H;
            a0 = aa;
            i0 = i;
        }
        boolean[] visited = new boolean[n_all];
        int k = 0;
        int[][] ctab = ring.getCtab();
        MolAtom[] sorted = new MolAtom[n_without_H];
        int l = 0;
        sorted[l++] = a0;
        visited[i0] = true;
        block1: for (int i = i0 + 1; i < n_all; ++i) {
            for (int j = 0; j < ctab[i].length; ++j) {
                MolAtom a;
                int k2 = ctab[k][j];
                if (visited[k2] || (a = ring.getAtom(k2)).getAtno() == 1) continue;
                k = k2;
                visited[k] = true;
                sorted[l++] = a;
                continue block1;
            }
        }
        if (l != n_without_H) {
            throw new RuntimeException("sortRingAtoms called for non-ring");
        }
        return sorted;
    }

    private static MolBond[] sortRingBonds(MoleculeGraph ring, MolAtom[] sortedatoms) {
        int n = sortedatoms.length;
        MolBond[] sortedbonds = new MolBond[n];
        BondTable btab = ring.getBondTable();
        for (int i = 0; i < n; ++i) {
            int i2;
            int i1 = ring.indexOf(sortedatoms[i]);
            int k = btab.getBondIndex(i1, i2 = ring.indexOf(sortedatoms[(i + 1) % n]));
            if (k < 0) {
                System.err.println("sortedRingBonds: i1=" + i1 + " i2=" + i2 + " k=" + k);
            }
            sortedbonds[i] = ring.getBond(k);
        }
        return sortedbonds;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeObject(this.molecule);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        this.molecule = (Molecule)ois.readObject();
    }
}

