/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.SelectUtil;
import chemaxon.marvin.sketch.SketchMode;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RubberSM
extends SketchMode {
    private static final long serialVersionUID = -7010050364100540729L;
    private SelectUtil selectUtil;

    public RubberSM(MolEditor e) {
        super(e);
        this.selectUtil = new SelectUtil(e);
    }

    public RubberSM(RubberSM so) {
        super(so);
        this.selectUtil = (SelectUtil)so.selectUtil.clone();
    }

    @Override
    public void initSketchMode(MolEditor e) {
        super.initSketchMode(e);
        this.selectUtil = e != null ? new SelectUtil(e) : null;
    }

    @Override
    public boolean isRubber() {
        return true;
    }

    @Override
    public boolean containedObjectEquals(SketchMode o) {
        return o != null && o instanceof RubberSM;
    }

    @Override
    public Object clone() {
        return new RubberSM(this);
    }

    @Override
    public boolean canPointToAtom() {
        return true;
    }

    @Override
    public boolean canPointToBond() {
        return true;
    }

    @Override
    public boolean canPointToSgroup() {
        return true;
    }

    @Override
    public boolean canPointToMObject() {
        return true;
    }

    @Override
    public int buttonDown(boolean dblClick, int modifiers) {
        MolEditor medit = this.getEditor();
        Object[] args = new Object[]{this.selectUtil, dblClick, new Integer(modifiers)};
        return medit.callInteger("RubberUtil.buttonDown", args);
    }

    @Override
    public int buttonUp(int modifiers, boolean doHist) {
        MolEditor medit = this.getEditor();
        if (this.selectUtil.selPoly != null || this.selectUtil.selRect != null) {
            this.selectUtil.endS();
            medit.edit(20);
        }
        medit.setDragged(false);
        return 0;
    }

    @Override
    public boolean pointerMove(int modifiers) {
        MolEditor medit = this.getEditor();
        boolean dirty = false;
        if (this.selectUtil.selPoly != null) {
            if (!medit.getSelectionMolecule().isEmpty()) {
                medit.edit(14);
                dirty = true;
            }
            dirty |= this.selectUtil.doS();
        }
        return dirty;
    }

    @Override
    public boolean pointerDrag(int modifiers) {
        MolEditor medit = this.getEditor();
        boolean dirty = false;
        if (medit.getCurfrag().isEmpty() && this.selectUtil.selRect != null) {
            if (!medit.getSelectionMolecule().isEmpty()) {
                medit.edit(14);
                dirty = true;
            }
            dirty |= this.selectUtil.doS();
        }
        return dirty;
    }

    @Override
    public boolean pointerCopyDrag(int modifiers) {
        return true;
    }

    @Override
    public void reset() {
        this.selectUtil.reset();
    }

    @Override
    public void paintTemps1(Graphics2D g) {
        this.selectUtil.paintTemps1(g);
    }

    @Override
    public void prepareMolPaint() {
        this.selectUtil.prepareMolPaint();
    }

    @Override
    public SelectUtil getSelectUtil() {
        return this.selectUtil;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeObject(this.selectUtil);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        this.selectUtil = (SelectUtil)ois.readObject();
    }
}

