/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMoleculeGraphIface;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.graphics.MChemicalStruct;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;

public class SelectUtil
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4143211204478415057L;
    private transient MolEditor medit;
    transient MDocument tmpSel;
    public transient Polygon selPoly = null;
    public transient Rectangle selRect = null;
    transient Point selFirst = null;
    private int groupType = -1;
    private CallbackIface groupCreationDialogHandler = null;

    public SelectUtil(MolEditor e) {
        this.medit = e;
        this.tmpSel = MolEditor.createSelectionDoc(this.medit.getDocument());
    }

    public Object clone() {
        SelectUtil su = new SelectUtil(this.medit);
        su.tmpSel = this.tmpSel;
        if (this.selPoly != null) {
            su.selPoly = new Polygon(this.selPoly.xpoints, this.selPoly.ypoints, this.selPoly.npoints);
        }
        if (this.selRect != null) {
            su.selRect = new Rectangle(this.selRect.x, this.selRect.y, this.selRect.width, this.selRect.height);
        }
        if (this.selFirst != null) {
            su.selFirst = new Point(this.selFirst.x, this.selFirst.y);
        }
        return su;
    }

    public void begPS(int modifiers) {
        this.selRect = null;
        if ((modifiers & 1) != 0 || this.medit.getSelectionDocument().isEmpty()) {
            this.beginPolygonSelection();
        } else {
            this.medit.edit(14);
        }
    }

    public void beginPolygonSelection() {
        this.selRect = null;
        DPoint3 ptr = this.medit.getScreenPointerPos();
        int x = (int)Math.round(1000.0 * ptr.x);
        int y = (int)Math.round(1000.0 * ptr.y);
        this.selPoly = new Polygon();
        this.selPoly.addPoint(x, y);
    }

    public void begRS() {
        if (this.selPoly == null) {
            this.beginRectangleSelection();
        }
    }

    public void beginRectangleSelection() {
        Point p;
        this.selPoly = null;
        DPoint3 ptr = this.medit.getScreenPointerPos();
        int x = (int)Math.round(1000.0 * ptr.x);
        int y = (int)Math.round(1000.0 * ptr.y);
        this.selFirst = p = new Point(x, y);
        this.selRect = new Rectangle(p.x, p.y, 0, 0);
    }

    public boolean doS() {
        DPoint3 ptr = this.medit.getScreenPointerPos();
        boolean dirty = false;
        int x = (int)Math.round(1000.0 * ptr.x);
        int y = (int)Math.round(1000.0 * ptr.y);
        MDocument doc = this.medit.getDocument();
        MoleculeGraph tmpg = this.tmpSel.getMainMoleculeGraph();
        if (this.selPoly != null) {
            int rx = this.selPoly.xpoints[this.selPoly.npoints - 1] - x;
            int ry = this.selPoly.ypoints[this.selPoly.npoints - 1] - y;
            if (rx * rx + ry * ry > 100) {
                this.tmpSel.clear();
                this.selPoly.addPoint(x, y);
                this.selPoly = new Polygon(this.selPoly.xpoints, this.selPoly.ypoints, this.selPoly.npoints);
                if (this.selPoly.npoints > 2) {
                    CTransform3D trot = this.medit.getPainter().getRTransformRef();
                    DPoint3 p = new DPoint3();
                    for (int i = 0; i < doc.getConnectedObjectCount(); ++i) {
                        MObject o = doc.getConnectedObject(i);
                        o.setSelected(false);
                        if (o instanceof MChemicalStruct) {
                            MChemicalStruct mm = (MChemicalStruct)o;
                            MoleculeGraph m = mm.getMoleculeGraph();
                            MoleculeGraph u = !this.medit.getPainter().getCommon().isRgDefinitionVisible() && m instanceof RgMoleculeGraphIface ? ((RgMoleculeGraphIface)((Object)m)).getRootG() : m.getGraphUnion();
                            for (int j = 0; j < u.getAtomCount(); ++j) {
                                MolAtom a = u.getAtom(j);
                                a.getLocation(p);
                                trot.transform(p);
                                int ax = (int)Math.round(1000.0 * p.x);
                                int ay = (int)Math.round(1000.0 * p.y);
                                if (!this.selPoly.contains(ax, ay)) continue;
                                tmpg.add(a);
                            }
                            continue;
                        }
                        if (!this.insidePolygon(o, this.selPoly)) continue;
                        this.tmpSel.addObject(o);
                    }
                }
                dirty = true;
            }
        } else if (this.selRect != null) {
            Rectangle r;
            int sx = this.selFirst.x;
            int sy = this.selFirst.y;
            int sw = x - sx;
            int sh = y - sy;
            if (sw < 0) {
                sx += sw;
                sw = -sw;
            }
            if (sh < 0) {
                sy += sh;
                sh = -sh;
            }
            if (!(r = new Rectangle(sx, sy, sw, sh)).equals(this.selRect)) {
                this.tmpSel.clear();
                this.tmpSel.clear();
                this.selRect = r;
                CTransform3D trot = this.medit.getPainter().getRTransformRef();
                DPoint3 p = new DPoint3();
                List<MObject> list = doc.getAllObjects();
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    MObject o = list.get(i);
                    o.setSelected(false);
                    if (o instanceof MChemicalStruct) {
                        MChemicalStruct mm = (MChemicalStruct)o;
                        MoleculeGraph m = mm.getMoleculeGraph();
                        MoleculeGraph u = !this.medit.getPainter().getCommon().isRgDefinitionVisible() && m instanceof RgMoleculeGraphIface ? ((RgMoleculeGraphIface)((Object)m)).getRootG() : m.getGraphUnion();
                        for (int j = 0; j < u.getAtomCount(); ++j) {
                            MolAtom a = u.getAtom(j);
                            a.getLocation(p);
                            trot.transform(p);
                            int ax = (int)Math.round(1000.0 * p.x);
                            int ay = (int)Math.round(1000.0 * p.y);
                            if (!this.selRect.contains(ax, ay)) continue;
                            tmpg.add(a);
                        }
                        continue;
                    }
                    if (!this.insideRectangle(o, r)) continue;
                    this.tmpSel.addObject(o);
                }
                dirty = true;
            }
        }
        tmpg.regenBonds();
        if (doc.getObjectContainingSelection() != null) {
            doc.setObjectContainingSelection(null);
            this.medit.getSelectionDocument().setObjectContainingSelection(null);
            dirty = true;
        }
        return dirty;
    }

    public void endS() {
        this.doS();
        MSelectionDocument seldoc = this.medit.getSelectionDocument();
        MoleculeGraph selmol = seldoc.getMainMoleculeGraph();
        for (int i = 0; i < this.tmpSel.getObjectCount(); ++i) {
            MObject o = this.tmpSel.getObject(i);
            if (o instanceof MChemicalStruct) {
                MoleculeGraph g = ((MChemicalStruct)o).getMoleculeGraph();
                int na = g.getAtomCount();
                for (int j = 0; j < na; ++j) {
                    MolEditor.selectAtom(g.getAtom(j), selmol);
                }
                continue;
            }
            if (seldoc.contains(o)) continue;
            ((MDocument)seldoc).addObject(o);
        }
        if (this.groupType > 0 && !selmol.isEmpty()) {
            CallbackIface f = this.groupCreationDialogHandler;
            if (f == null) {
                f = (CallbackIface)MarvinModule.load("sketch.swing.GroupCreationDialog", null);
                f.callback("setSketchPanel", this.medit.getCanvas().callback("getPanel", null));
                this.groupCreationDialogHandler = f;
            }
            f.callback("groupType", this.groupType);
            f.callback("mode", "selection");
            f.callback("show", this.medit.getMol());
        }
        this.medit.rationalizeSelection();
        this.tmpSel.clear();
        this.selPoly = null;
        this.selRect = null;
    }

    public void reset() {
        this.tmpSel.clear();
        this.selPoly = null;
        this.selRect = null;
    }

    public void paintTemps1(Graphics2D g) {
        if (this.selPoly != null || this.selRect != null) {
            MolPainter painter = this.medit.getPainter();
            MolPainterCommon common = painter.getCommon();
            common.setAntialiasing(g, true);
            g.setColor(painter.getColors().getAtomHighlightColor());
            if (this.selPoly != null) {
                SelectUtil.drawSel(g, this.selPoly, painter);
            }
            if (this.selRect != null) {
                SelectUtil.drawSel(g, this.selRect, painter, this.groupType > 0);
            }
            common.setAntialiasing(g, false);
        }
    }

    public void prepareMolPaint() {
        this.medit.getDocument().selectAllObjects(false);
        MSelectionDocument seldoc = this.medit.getSelectionDocument();
        MoleculeGraph selmol = seldoc.getMainMoleculeGraph();
        MoleculeGraph tmpg = this.tmpSel.getMainMoleculeGraph();
        if (!seldoc.isEmpty() || !this.tmpSel.isEmpty()) {
            SelectionMolecule s = new SelectionMolecule();
            selmol.clonelesscopy(s);
            if (this.medit.mouseInside || this.medit.isDragged()) {
                s.fuse(tmpg);
            }
            seldoc.selectAllObjects(true);
            this.tmpSel.selectAllObjects(true);
        }
    }

    private boolean insidePolygon(MObject o, Polygon pg) {
        int n = o.getPointCount();
        CTransform3D trot = this.medit.getPainter().getRTransformRef();
        for (int i = 0; i < n; ++i) {
            MPoint p = o.getPoint(i);
            DPoint3 pp = p.getLocation();
            trot.transform(pp);
            int x = (int)Math.round(1000.0 * pp.x);
            int y = (int)Math.round(1000.0 * pp.y);
            if (pg.contains(x, y)) continue;
            return false;
        }
        return true;
    }

    private boolean insideRectangle(MObject o, Rectangle r) {
        int n = o.getPointCount();
        CTransform3D trot = this.medit.getPainter().getRTransformRef();
        for (int i = 0; i < n; ++i) {
            MPoint p = o.getPoint(i);
            DPoint3 pp = p.getLocation();
            trot.transform(pp);
            int x = (int)Math.round(1000.0 * pp.x);
            int y = (int)Math.round(1000.0 * pp.y);
            if (r.contains(x, y)) continue;
            return false;
        }
        return true;
    }

    public boolean isSelecting() {
        return this.selRect != null || this.selPoly != null;
    }

    public double[] getMolSelRect() {
        if (this.selRect != null) {
            double[] bounds = new double[]{(double)this.selRect.x * 0.001, (double)this.selRect.y * 0.001, (double)this.selRect.width * 0.001, (double)this.selRect.height * 0.001};
            return bounds;
        }
        return null;
    }

    private static void drawSel(Graphics2D g, Rectangle r, MolPainter painter, boolean createGroup) {
        DPoint3 p1 = new DPoint3(0.001 * (double)r.x, 0.001 * (double)r.y, 0.0);
        DPoint3 p2 = new DPoint3(0.001 * (double)(r.x + r.width), 0.001 * (double)(r.y + r.height), 0.0);
        CTransform3D t = painter.getInvRTransformRef();
        t.transform(p1);
        t.transform(p2);
        painter.calcGP(p1);
        painter.calcGP(p2);
        if (createGroup) {
            DPoint3 p3 = new DPoint3(p2.x, p1.y, 0.0);
            DPoint3 p4 = new DPoint3(p1.x, p2.y, 0.0);
            DPoint3 p5 = CleanUtil.calcDividingPoint(p1, p3, 0.1);
            DPoint3 p6 = CleanUtil.calcDividingPoint(p3, p1, 0.1);
            DPoint3 p7 = CleanUtil.calcDividingPoint(p2, p4, 0.1);
            DPoint3 p8 = CleanUtil.calcDividingPoint(p4, p2, 0.1);
            g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y), (int)Math.ceil(p1.x), (int)Math.ceil(p2.y));
            g.drawLine((int)Math.ceil(p2.x), (int)Math.ceil(p2.y), (int)Math.ceil(p2.x), (int)Math.ceil(p1.y));
            g.drawLine((int)Math.ceil(p1.x), (int)Math.ceil(p1.y), (int)Math.ceil(p5.x), (int)Math.ceil(p5.y));
            g.drawLine((int)Math.ceil(p3.x), (int)Math.ceil(p3.y), (int)Math.ceil(p6.x), (int)Math.ceil(p6.y));
            g.drawLine((int)Math.ceil(p2.x), (int)Math.ceil(p2.y), (int)Math.ceil(p7.x), (int)Math.ceil(p7.y));
            g.drawLine((int)Math.ceil(p4.x), (int)Math.ceil(p4.y), (int)Math.ceil(p8.x), (int)Math.ceil(p8.y));
        } else {
            SelectUtil.drawLine(g, p1.x, p1.y, p2.x, p1.y);
            SelectUtil.drawLine(g, p2.x, p1.y, p2.x, p2.y);
            SelectUtil.drawLine(g, p2.x, p2.y, p1.x, p2.y);
            SelectUtil.drawLine(g, p1.x, p2.y, p1.x, p1.y);
        }
    }

    private static void drawSel(Graphics2D g, Polygon pg, MolPainter painter) {
        double prevx = 0.0;
        double prevy = 0.0;
        DPoint3 p = new DPoint3();
        CTransform3D t = painter.getInvRTransformRef();
        for (int i = 0; i <= pg.npoints; ++i) {
            int j = i % pg.npoints;
            p.x = 0.001 * (double)pg.xpoints[j];
            p.y = 0.001 * (double)pg.ypoints[j];
            p.z = 0.0;
            t.transform(p);
            painter.calcGP(p);
            if (i != 0) {
                if (i == pg.npoints) {
                    g.setColor(painter.getColors().getHighlightColor());
                }
                SelectUtil.drawLine(g, prevx, prevy, p.x, p.y);
            }
            prevx = p.x;
            prevy = p.y;
        }
    }

    private static void drawLine(Graphics2D g, double x1, double y1, double x2, double y2) {
        int u1 = (int)Math.round(x1);
        int v1 = (int)Math.round(y1);
        int u2 = (int)Math.round(x2);
        int v2 = (int)Math.round(y2);
        try {
            g.drawLine(u1, v1, u2, v2);
        }
        catch (Throwable ex) {
            System.err.println("Graphics.drawLine bug " + x1 + " " + y1 + " " + x2 + " " + y2 + " " + ex.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeObject(this.medit);
        if (this.selPoly != null) {
            oos.writeInt(this.selPoly.npoints);
            for (int i = 0; i < this.selPoly.npoints; ++i) {
                oos.writeInt(this.selPoly.xpoints[i]);
                oos.writeInt(this.selPoly.ypoints[i]);
            }
        } else {
            oos.writeInt(0);
        }
        int f = 0;
        if (this.selRect != null) {
            f |= 1;
        }
        if (this.selFirst != null) {
            f |= 2;
        }
        oos.writeInt(f);
        if ((f & 1) != 0) {
            oos.writeInt(this.selRect.x);
            oos.writeInt(this.selRect.y);
            oos.writeInt(this.selRect.width);
            oos.writeInt(this.selRect.height);
        }
        if ((f & 2) != 0) {
            oos.writeInt(this.selFirst.x);
            oos.writeInt(this.selFirst.y);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int y;
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        this.medit = (MolEditor)ois.readObject();
        this.tmpSel = MolEditor.createSelectionDoc(this.medit.getDocument());
        int n = ois.readInt();
        if (n == 0) {
            this.selPoly = null;
        } else {
            int[] x = new int[n];
            int[] y2 = new int[n];
            for (int i = 0; i < n; ++i) {
                x[i] = ois.readInt();
                y2[i] = ois.readInt();
            }
            this.selPoly = new Polygon(x, y2, n);
        }
        int f = ois.readInt();
        if ((f & 1) != 0) {
            int x = ois.readInt();
            y = ois.readInt();
            int w = ois.readInt();
            int h = ois.readInt();
            this.selRect = new Rectangle(x, y, w, h);
        }
        if ((f & 2) != 0) {
            int x = ois.readInt();
            y = ois.readInt();
            this.selFirst = new Point(x, y);
        }
    }

    public void beginGroupSelection(int type) {
        this.groupType = type;
        this.beginRectangleSelection();
    }
}

