/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.graphics.MAssignerPainter;
import chemaxon.marvin.paint.internal.graphics.MPolylinePainter;
import chemaxon.marvin.paint.internal.graphics.MRArrowPainter;
import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.MObjectPO;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.modules.LineSM;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.graphics.MAssigner;
import chemaxon.struc.graphics.MMidPoint;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRArrow;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public abstract class ArrowSM
extends LineSM {
    private static final long serialVersionUID = 8529842567778601689L;

    public ArrowSM() {
        this(0);
    }

    public ArrowSM(String opt) {
        super(opt);
    }

    public ArrowSM(int f) {
        super(f);
    }

    public ArrowSM(ArrowSM sm) {
        super(sm);
    }

    public abstract ArrowSM cloneArrowSM();

    @Override
    public final Object clone() {
        return this.cloneArrowSM();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
    }

    public static class ManualMap
    extends Reaction {
        public ManualMap() {
            this.init();
        }

        public ManualMap(int f) {
            super(f);
            this.init();
        }

        public ManualMap(MolEditor editor) {
            super(editor);
            this.init();
        }

        public ManualMap(Reaction sm) {
            super(sm);
        }

        public ManualMap(String opt) {
            super(opt);
            this.init();
        }

        private void init() {
            if (this.polyline instanceof MRArrow) {
                ((MRArrow)this.polyline).setType(0);
            }
        }

        @Override
        public ArrowSM cloneArrowSM() {
            return new ManualMap(this);
        }

        @Override
        public void paintTemporaryObject(Graphics2D g) {
            MolPainter painter = this.getEditor().getPainter();
            DPoint3 p1 = this.startPoint == null ? this.itsStart : this.startPoint.getLocation();
            DPoint3 p2 = this.getEndPoint().getLocation();
            CTransform3D t = painter.getTransformMatrix();
            if (this.beginMap != null) {
                MRArrow l = new MRArrow(new MPoint(p1), new MPoint(p2));
                MRArrowPainter ap = new MRArrowPainter();
                ap.paint(l, g, t, 0, painter.getColors().getForeground(), null, null);
            }
        }

        @Override
        public int buttonUp(int modifiers, boolean doHist) {
            MolEditor med = this.getEditor();
            boolean histEnabled = med.setHistorizeEnabled(false);
            int ret = 0;
            PointedObject po = med.getPointedObject();
            if (po instanceof AtomPO) {
                int aaMap = this.beginMap.getAtomMap();
                if (aaMap == 0) {
                    aaMap = med.findFreeAtomMap();
                }
                this.beginMap.setAtomMap(aaMap);
                MolAtom ea = (MolAtom)po.getContainedObject();
                ea.setAtomMap(aaMap);
                ret = 2;
            }
            med.setHistorizeEnabled(histEnabled);
            if (ret > 0) {
                med.historize();
            }
            this.beginMap = null;
            this.setStartPoint(null);
            return ret;
        }
    }

    public static class TwoHeadedDoubleReaction
    extends Reaction {
        public TwoHeadedDoubleReaction() {
            this.init();
        }

        public TwoHeadedDoubleReaction(int f) {
            super(f);
            this.init();
        }

        public TwoHeadedDoubleReaction(MolEditor editor) {
            super(editor);
            this.init();
        }

        public TwoHeadedDoubleReaction(Reaction sm) {
            super(sm);
        }

        public TwoHeadedDoubleReaction(String opt) {
            super(opt);
            this.init();
        }

        private void init() {
            this.setType(3);
            if (this.polyline instanceof MRArrow) {
                ((MRArrow)this.polyline).setType(3);
            }
        }

        @Override
        public ArrowSM cloneArrowSM() {
            return new TwoHeadedDoubleReaction(this);
        }
    }

    public static class DoubleReaction
    extends Reaction {
        public DoubleReaction() {
            this.init();
        }

        public DoubleReaction(int f) {
            super(f);
            this.init();
        }

        public DoubleReaction(MolEditor editor) {
            super(editor);
            this.init();
        }

        public DoubleReaction(Reaction sm) {
            super(sm);
        }

        public DoubleReaction(String opt) {
            super(opt);
            this.init();
        }

        private void init() {
            this.setType(2);
            if (this.polyline instanceof MRArrow) {
                ((MRArrow)this.polyline).setType(2);
            }
        }

        @Override
        public ArrowSM cloneArrowSM() {
            return new DoubleReaction(this);
        }
    }

    public static class TwoHeadedReaction
    extends Reaction {
        public TwoHeadedReaction() {
            this.init();
        }

        public TwoHeadedReaction(int f) {
            super(f);
            this.init();
        }

        public TwoHeadedReaction(MolEditor editor) {
            super(editor);
            this.init();
        }

        public TwoHeadedReaction(Reaction sm) {
            super(sm);
        }

        public TwoHeadedReaction(String opt) {
            super(opt);
            this.init();
        }

        private void init() {
            this.setType(1);
            if (this.polyline instanceof MRArrow) {
                ((MRArrow)this.polyline).setType(1);
            }
        }

        @Override
        public ArrowSM cloneArrowSM() {
            return new TwoHeadedReaction(this);
        }
    }

    public static class RegularReaction
    extends Reaction {
        public RegularReaction() {
            this.init();
        }

        public RegularReaction(int f) {
            super(f);
            this.init();
        }

        public RegularReaction(MolEditor editor) {
            super(editor);
            this.init();
        }

        public RegularReaction(Reaction sm) {
            super(sm);
        }

        public RegularReaction(String opt) {
            super(opt);
            this.init();
        }

        private void init() {
            this.setType(0);
            if (this.polyline instanceof MRArrow) {
                ((MRArrow)this.polyline).setType(0);
            }
        }

        @Override
        public ArrowSM cloneArrowSM() {
            return new RegularReaction(this);
        }
    }

    public static class Reaction
    extends ArrowSM {
        protected transient DPoint3 itsStart = null;
        protected transient MolAtom beginMap = null;
        private transient int arrowType = 0;

        @Override
        protected boolean isValidEndPoint(MPoint p) {
            MolEditor med = this.getEditor();
            PointedObject po = med.getPointedObject();
            return po == null || this.beginMap != null;
        }

        @Override
        protected boolean isValidStartPoint(MPoint p) {
            boolean isValid;
            MolEditor med = this.getEditor();
            PointedObject po = med.getPointedObject();
            boolean bl = isValid = po == null;
            if (!isValid && po != null) {
                isValid = po.getContainedObject() instanceof MolAtom && this.beginMap == null;
            }
            return isValid;
        }

        @Override
        public boolean isTemporaryObjectPaintingNeeded() {
            return this.startPoint != null;
        }

        @Override
        public void paintTemporaryObject(Graphics2D g) {
            MolEditor medit = this.getEditor();
            MolPainter painter = medit.getPainter();
            DPoint3 p1 = this.startPoint == null ? this.itsStart : this.startPoint.getLocation();
            DPoint3 p2 = this.getEndPoint().getLocation();
            CTransform3D t = painter.getTransformMatrix();
            PointedObject po = medit.getPointedObject();
            if (!this.shiftPressed && this.beginMap == null && po == null) {
                double dx = p1.x - p2.x;
                double dy = p1.y - p2.y;
                double f = dx != 0.0 || dy != 0.0 ? Math.atan2(dy, dx) : 0.0;
                double df = 0.2617993877991494;
                double phi = (double)Math.round(f / df) * df;
                CTransform3D tr = new CTransform3D();
                tr.setRotation(0.0, 0.0, 1.0, phi - f);
                tr.setRotationCenter(p1);
                CTransform3D t2 = this.getEditor().getPainter().getInvRTransform();
                t2.mul(tr);
                t2.mul(this.getEditor().getPainter().getRTransformRef());
                t2.setRotationCenter(p1);
                t2.transform(p2);
            }
            if (this.polyline instanceof MRArrow) {
                MRArrow l = new MRArrow(new MPoint(p1), new MPoint(p2));
                ((MRArrow)this.polyline).copyProperties(l);
                MRArrowPainter ap = new MRArrowPainter();
                ap.paint(l, g, t, 0, painter.getColors().getForeground(), null, null);
            } else {
                MPolyline l = new MPolyline(new MPoint(p1), new MPoint(p2));
                this.polyline.copyProperties(l);
                MPolylinePainter mpp = new MPolylinePainter();
                mpp.paint(l, g, t, 0, painter.getColors().getForeground(), null, null);
            }
        }

        public Reaction(MolEditor editor) {
            this.initSketchMode(editor);
            this.init();
        }

        private void init() {
            MPolyline l = this.getPolyline();
            l.setArrowWidth(MPolyline.HEAD, 0.3);
            l.setArrowLength(MPolyline.HEAD, 0.5);
            if (l instanceof MRArrow) {
                ((MRArrow)l).setType(0);
            }
        }

        public Reaction() {
            this(0);
            this.polyline = new MRArrow();
        }

        public Reaction(int f) {
            super(f);
            this.polyline = new MRArrow();
            this.init();
        }

        public Reaction(String opt) {
            super(opt);
            this.polyline = new MRArrow();
            this.init();
        }

        public Reaction(Reaction sm) {
            super(sm);
            this.polyline = new MRArrow();
            this.setType(sm.getType());
        }

        @Override
        public ArrowSM cloneArrowSM() {
            return new Reaction(this);
        }

        @Override
        protected MPolyline createLine(MPoint p1, MPoint p2) {
            MRArrow l = null;
            if (this.beginMap == null) {
                MolEditor me = this.getEditor();
                MPoint sp = this.getStartPoint();
                Molecule molg = me.getMol();
                if (molg instanceof RgMolecule) {
                    molg = ((RgMolecule)molg).getRoot();
                }
                if (molg instanceof RxnMolecule) {
                    l = ((RxnMolecule)molg).getItsArrow();
                    if (sp != null) {
                        this.itsStart = sp.getLocation();
                    }
                    if (l != null) {
                        me.endArrowDrawing(l, this.itsStart, me.getScreenPointerPos());
                        l = null;
                    } else {
                        me.endArrowDrawing(null, this.itsStart, me.getScreenPointerPos());
                    }
                } else {
                    l = new MRArrow(p1, p2);
                    l.setType(this.getType());
                    this.initLine(l);
                    if (sp != null) {
                        this.itsStart = sp.getLocation();
                    }
                    me.endArrowDrawing(l, this.itsStart, me.getScreenPointerPos());
                }
            }
            return l;
        }

        @Override
        public int buttonUp(int modifiers, boolean doHist) {
            MolEditor med = this.getEditor();
            boolean histEnabled = med.setHistorizeEnabled(false);
            int retval = super.buttonUp(modifiers, doHist);
            PointedObject po = med.getPointedObject();
            if (retval > 0) {
                if (this.beginMap == null) {
                    Molecule molg = med.getMol();
                    if (molg instanceof RgMolecule) {
                        molg = ((RgMolecule)molg).getRoot();
                    }
                    if (molg instanceof RxnMolecule) {
                        RxnMolecule rxmol = (RxnMolecule)molg;
                        if (rxmol.isSingleStepReaction()) {
                            rxmol.setReactionArrowType(this.arrowType);
                        } else {
                            Map<MRArrow, RxnMolecule> msl = rxmol.getMSLogic();
                            MPolyline keyArrow = null;
                            Iterator<MRArrow> rxn_arrows = msl.keySet().iterator();
                            while (rxn_arrows.hasNext() && keyArrow == null) {
                                MPolyline arrow = rxn_arrows.next();
                                MPoint[] aPoints = arrow.getPoints();
                                if (!aPoints[0].getLocation().equals(this.itsStart) || !aPoints[1].equals(this.getEndPoint())) continue;
                                keyArrow = arrow;
                            }
                            if (keyArrow != null) {
                                rxmol = msl.get(keyArrow);
                                rxmol.setReactionArrowType(this.arrowType);
                            }
                        }
                    }
                    retval = 2;
                } else if (po instanceof AtomPO) {
                    int aaMap = this.beginMap.getAtomMap();
                    if (aaMap == 0) {
                        aaMap = med.findFreeAtomMap();
                    }
                    this.beginMap.setAtomMap(aaMap);
                    MolAtom ea = (MolAtom)po.getContainedObject();
                    ea.setAtomMap(aaMap);
                } else {
                    retval = 0;
                }
            }
            med.setHistorizeEnabled(histEnabled);
            if (retval > 0) {
                med.historize();
            }
            this.beginMap = null;
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int buttonDown(boolean dblClick, int modifiers) {
            int ret = super.buttonDown(dblClick, modifiers);
            MolEditor medit = this.getEditor();
            if (medit.isMoveModePersistent()) {
                return 0;
            }
            Molecule mol = medit.getMol();
            medit.setMoveMode(0, false);
            if (medit.getCurfrag().isEmpty()) {
                Object object = mol.getLock();
                synchronized (object) {
                    medit.edit(14);
                    this.shiftPressed = (modifiers & 1) != 0;
                    PointedObject po = medit.getPointedObject();
                    if (po != null && po instanceof AtomPO) {
                        this.beginMap = ((AtomPO)po).getAtom();
                    } else {
                        RxnMolecule rmol = RxnMolecule.getReaction(mol);
                        if (rmol != null && rmol.getReactionArrow(false) != null) {
                            MRArrow arrow = rmol.getReactionArrow(false);
                            this.polyline = arrow;
                            if (po != null && arrow == po.getContainedObject()) {
                                boolean changed = rmol.getReactionArrowType() != this.getType();
                                rmol.setReactionArrowType(this.getType());
                                if (changed) {
                                    medit.historize();
                                }
                            }
                        }
                    }
                }
            }
            return ret;
        }

        public void setType(int arrowIndex) {
            this.arrowType = arrowIndex;
        }

        public int getType() {
            return this.arrowType;
        }

        @Override
        public boolean pointerDrag(int modifiers) {
            this.cursorMoved = true;
            boolean bl = this.shiftPressed = (modifiers & 1) != 0;
            if (this.startPoint != null) {
                return true;
            }
            MolEditor ed = this.getEditor();
            PointedObject po = ed.getPointedObject();
            if (this.draggedObject == null && po != null && po instanceof MObjectPO) {
                this.draggedObject = ((MObjectPO)po).getMObject();
            }
            if (this.draggedObject != null && !(this.draggedObject instanceof MMidPoint)) {
                DPoint3 dpos = ed.getPointerPosDiff();
                CTransform3D T = new CTransform3D();
                CTransform3D t = ed.getPainter().getRTransformRef();
                MPoint[] aps = this.polyline != null ? this.polyline.getPoints() : null;
                DPoint3 o = null;
                int i = -1;
                if (aps != null && aps.length > 1) {
                    if (this.draggedObject.equals(aps[1])) {
                        o = aps[0].getLocation(t);
                        i = 1;
                    } else if (this.draggedObject.equals(aps[0])) {
                        o = aps[1].getLocation(t);
                        i = 0;
                    }
                    if (!this.shiftPressed && i != -1) {
                        DPoint3 pa = ed.getPointerPos();
                        double dx = o.x - pa.x;
                        double dy = o.y - pa.y;
                        double f = dx != 0.0 || dy != 0.0 ? Math.atan2(dy, dx) : 0.0;
                        double df = 0.2617993877991494;
                        double phi = (double)Math.round(f / df) * df;
                        CTransform3D tr = new CTransform3D();
                        tr.setRotation(0.0, 0.0, 1.0, phi - f);
                        tr.setRotationCenter(o);
                        CTransform3D t2 = this.getEditor().getPainter().getInvRTransform();
                        t2.mul(tr);
                        t2.mul(ed.getPainter().getRTransformRef());
                        t2.setRotationCenter(o);
                        t2.transform(pa);
                        aps[i].setLocation(pa, t);
                        ((MPoint)this.draggedObject).setLocation(pa, t);
                    } else {
                        T.setTranslation(dpos);
                        this.draggedObject.transform(T, 1, t);
                        if (i > -1) {
                            aps[i].setLocation(((MPoint)this.draggedObject).getLocation(), t);
                        } else if (this.draggedObject instanceof MRArrow) {
                            DPoint3 p0 = this.draggedObject.getPoint(0).getLocation();
                            DPoint3 p1 = this.draggedObject.getPoint(1).getLocation();
                            aps[0].setLocation(p0, t);
                            aps[1].setLocation(p1, t);
                        }
                    }
                    this.polyline.setPoints(aps);
                    return true;
                }
            }
            return false;
        }
    }

    public static class TwoHeaded
    extends ArrowSM {
        public TwoHeaded() {
            this(0);
        }

        public TwoHeaded(String opt) {
            super(opt);
            this.init();
        }

        public TwoHeaded(int f) {
            super(f);
            this.init();
        }

        public TwoHeaded(TwoHeaded sm) {
            super(sm);
        }

        @Override
        public ArrowSM cloneArrowSM() {
            return new TwoHeaded(this);
        }

        private void init() {
            MPolyline l = this.getPolyline();
            l.setArrowWidth(MPolyline.HEAD, 0.5);
            l.setArrowLength(MPolyline.HEAD, 0.8);
            l.setArrowWidth(MPolyline.TAIL, 0.5);
            l.setArrowLength(MPolyline.TAIL, 0.8);
            l.setArrowFlags(MPolyline.TAIL, MPolyline.ARROW_BACK_FLAG);
        }
    }

    public static class AtomAssigner
    extends ArrowSM {
        public AtomAssigner(MolEditor editor) {
            this.initSketchMode(editor);
            this.polyline = new MAssigner();
            this.init();
        }

        public AtomAssigner(AtomAssigner sm) {
            super(sm);
            this.polyline = new MAssigner();
        }

        @Override
        public int buttonDown(boolean dblClick, int modifiers) {
            PointedObject po = this.getEditor().getPointedObject();
            if (po instanceof AtomPO) {
                return super.buttonDown(dblClick, modifiers);
            }
            return 0;
        }

        @Override
        public ArrowSM cloneArrowSM() {
            return new AtomAssigner(this);
        }

        @Override
        public void paintTemporaryObject(Graphics2D g) {
            MolEditor medit = this.getEditor();
            MolPainter painter = medit.getPainter();
            DPoint3 p1 = this.startPoint.getLocation();
            DPoint3 p2 = this.getEndPoint().getLocation();
            CTransform3D t = painter.getTransformMatrix();
            MAssigner l = new MAssigner(new MPoint(p1), new MPoint(p2));
            l.setOrder(-1);
            if (this.polyline != null) {
                this.polyline.copyProperties(l);
            }
            MAssignerPainter mpp = new MAssignerPainter();
            mpp.paint(l, g, t, 0, painter.getColors().getForeground(), null, null);
        }

        private void init() {
            MAssigner l = new MAssigner();
            l.setArrowWidth(MPolyline.HEAD, 0.3);
            l.setArrowLength(MPolyline.HEAD, 0.5);
            this.polyline = l;
        }

        @Override
        protected MPolyline createLine(MPoint p1, MPoint p2) {
            MAssigner l = new MAssigner(p1, p2);
            this.initLine(l);
            return l;
        }

        @Override
        protected boolean addObject(MPolyline l) {
            MolEditor medit = this.getEditor();
            MDocument doc = medit.getDocument();
            if (l instanceof MAssigner) {
                MAssigner assigner = (MAssigner)l;
                MolAtom[] atoms = assigner.getAssignedAtoms();
                int assigners = this.getAssignerNumber(doc);
                if (atoms != null && atoms.length == 2 && assigners < 3 && this.isAllowedAssigner(assigners, atoms)) {
                    assigner.setOrder(++assigners);
                    doc.addObject(assigner);
                    return false;
                }
            }
            return true;
        }

        private boolean isAllowedAssigner(int assigners, MolAtom[] assignerAtoms) {
            if (assigners > 2) {
                return false;
            }
            if (assigners > 0) {
                SelectionMolecule fromMol = new SelectionMolecule();
                SelectionMolecule toMol = new SelectionMolecule();
                Vector<MolAtom[]> atomList = this.getEditor().getAssignments(fromMol, toMol, false);
                for (int i = 0; i < atomList.size(); ++i) {
                    if (atomList.get(i)[0] != assignerAtoms[1] && atomList.get(i)[1] != assignerAtoms[0] && atomList.get(i)[1] != assignerAtoms[1] && atomList.get(i)[0] != assignerAtoms[0]) continue;
                    return false;
                }
                return fromMol.contains(assignerAtoms[1]) && toMol.contains(assignerAtoms[0]);
            }
            if (assigners == 0) {
                SelectionMolecule fromMol = new SelectionMolecule();
                SelectionMolecule toMol = new SelectionMolecule();
                MoleculeGraph molecule0 = assignerAtoms[0].getParent();
                MoleculeGraph molecule1 = assignerAtoms[1].getParent();
                molecule0.findFrag(molecule0.indexOf(assignerAtoms[0]), 1, fromMol);
                molecule1.findFrag(molecule1.indexOf(assignerAtoms[1]), 1, toMol);
                return molecule0 == molecule1 && !toMol.contains(assignerAtoms[0]) && !fromMol.contains(assignerAtoms[1]);
            }
            return assigners >= 0 && assigners < 3;
        }

        private int getAssignerNumber(MDocument doc) {
            int n = 0;
            for (MObject object : doc.getAllObjects()) {
                if (!(object instanceof MAssigner)) continue;
                ++n;
            }
            return n;
        }
    }

    public static class Regular
    extends ArrowSM {
        public Regular() {
            this(0);
        }

        public Regular(String opt) {
            super(opt);
            this.init();
        }

        public Regular(int f) {
            super(f);
            this.init();
        }

        public Regular(Regular sm) {
            super(sm);
        }

        @Override
        public ArrowSM cloneArrowSM() {
            return new Regular(this);
        }

        private void init() {
            MPolyline l = this.getPolyline();
            l.setArrowWidth(MPolyline.HEAD, 0.5);
            l.setArrowLength(MPolyline.HEAD, 0.8);
        }
    }
}

