/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.core.calculations.AtomBranchCoords;
import chemaxon.core.util.GeomUtil;
import chemaxon.marvin.paint.internal.util.DrawingUtil;
import chemaxon.marvin.sketch.GroupUtil;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.MolJoin;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.math.discrete.CombinationIterator;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;

public class AtomActions
implements CallbackIface {
    private MolEditor medit = null;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("init")) {
            this.medit = (MolEditor)arg;
        } else {
            if (method.equals("remove")) {
                this.removeAtom((MolAtom)arg);
                return Boolean.TRUE;
            }
            if (method.equals("branch")) {
                return new Integer(this.branch((MolAtom)arg));
            }
            if (method.equals("rAttachmentBranch")) {
                AtomActions.addRgroupAttachment((MolAtom)arg);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAtom(MolAtom a) {
        MDocument doc = this.medit.getDocument();
        Molecule mol = this.medit.getMol();
        Object object = mol.getLock();
        synchronized (object) {
            long id;
            RxnMolecule rxn = RxnMolecule.getReaction(mol);
            Molecule rxncomp = null;
            long rxnid = -1L;
            if (rxn != null && (rxnid = rxn.getComponentID(a)) != -1L) {
                rxncomp = rxn.getComponent(rxnid);
            }
            MSelectionDocument seldoc = this.medit.getSelectionDocument();
            MoleculeGraph sel = seldoc.getMainMoleculeGraph();
            sel.removeAtom(a);
            doc.removeAtom(a);
            if (rxncomp != null && (id = rxn.getComponentID(rxncomp)) != -1L) {
                rxn.splitDisconnectedComponent(id);
            }
            this.medit.restoreNonReactionIfPossible();
            if (this.medit.isEmpty()) {
                this.medit.setIdentityTransform();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int branch(MolAtom a0) {
        Molecule mol = this.medit.getMol();
        Molecule piece = this.medit.getPiece();
        Object object = mol.getLock();
        synchronized (object) {
            int nb = a0.getBondCount();
            if (!this.medit.isBranchable(a0)) {
                return 0;
            }
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double epsilon = 0.0154;
            MolAtom a3 = null;
            int atno = piece != null && piece.isAtom() ? piece.getAtom(0).getAtno() : 6;
            double blen = MolBond.desiredLength(a0.getAtno(), atno, 1, this.medit.getMolDim());
            boolean done = false;
            boolean broken = false;
            if (nb == 1) {
                int type1;
                int atno0 = a0.getAtno();
                int type0 = a0.getBond(0).getType();
                int n = type1 = piece != null && piece.isBond() ? piece.getBond(0).getType() : -1;
                if (type0 == 6 || type0 == 5 || type0 == 0) {
                    type0 = 1;
                } else if (type0 == 7) {
                    type0 = 2;
                }
                if (type1 == 6 || type1 == 5 || type1 == 0) {
                    type1 = 1;
                } else if (type1 == 7) {
                    type1 = 2;
                }
                boolean bl = broken = type1 > 0 && (type0 * type1 == 1 || type0 * type1 == 2 || type0 == type1 && type1 == 2 && atno0 != 6 && atno0 != 14 && atno0 != 32 && atno0 != 50 && atno0 != 82);
            }
            if (broken) {
                a3 = this.chain(a0);
                done = true;
            } else if (nb == 0) {
                x = blen;
                done = true;
            } else if (nb == 1) {
                for (int i = 0; i < nb; ++i) {
                    MolAtom a = a0.getLigand(i);
                    x += a.getX();
                    y += a.getY();
                    z += a.getZ();
                }
                double r = Math.sqrt((x = x / (double)nb - a0.getX()) * x + (y = y / (double)nb - a0.getY()) * y + (z = z / (double)nb - a0.getZ()) * z);
                if (r >= epsilon) {
                    double q = -blen / r;
                    x *= q;
                    y *= q;
                    z *= q;
                    done = true;
                }
            }
            if (!done) {
                a3 = piece != null && piece.isAtom() ? (MolAtom)piece.getAtom(0).clone() : new MolAtom(6);
                a3.setXYZ(a0.getX() + x, a0.getY() + y, a0.getZ() + z);
                boolean coords3d = false;
                MolBond b3 = this.medit.getLastBond(a0, a3);
                if (mol.getDim() == 3 || this.medit.isTransform3D()) {
                    coords3d = AtomActions.branch3D(mol, a0, a3, blen);
                }
                mol.add(a3);
                mol.add(b3);
                if (b3.getType() != 0) {
                    mol.setProperty("anyBondsFromCoords", null);
                }
                a3.valenceCheck();
                a0.valenceCheck();
                if (!coords3d) {
                    this.detAngles(a0);
                }
                this.medit.clearCurfrag();
                this.medit.setCurfragJoin(null);
                this.medit.bondrawMode = false;
                if (this.medit.isTransform3D()) {
                    mol.setDim(3);
                }
                this.medit.historize();
                return 1;
            }
            a0 = new MolAtom(0, a0.getX(), a0.getY(), a0.getZ());
            if (a3 == null && piece != null && piece.isAtom()) {
                a3 = (MolAtom)piece.getAtom(0).clone();
                a3.setXYZ(a0.getX() + x, a0.getY() + y, a0.getZ() + z);
            }
            if (a3 == null) {
                a3 = new MolAtom(0, a0.getX() + x, a0.getY() + y, a0.getZ() + z);
            }
            MolBond bond = this.medit.getLastBond(a0, a3);
            MolBond coveredBond = AtomActions.findNearestBond(this.medit.getMol().getBondArray(), bond);
            Molecule mcf = new Molecule(null, bond);
            mcf.add(a0);
            mcf.add(a3);
            if (coveredBond != null) {
                float[] next = GroupUtil.getNextDirection(a0.getLocation(), a3.getLocation(), 1, 1, 2.0943951023931953);
                a3.setX(next[0]);
                a3.setY(next[1]);
            }
            this.medit.flyingBondMol = (MoleculeGraph)mcf.clone();
            this.medit.setCurfrag(new MDocument(mcf));
            this.medit.setPointerPos0(a3.getLocation());
        }
        if (this.medit.endBondOrChainDrawing()) {
            return 1;
        }
        return 0;
    }

    private static MolBond findNearestBond(MolBond[] bondArray, MolBond bond) {
        DPoint3 dap1 = bond.getAtom1().getLocation();
        DPoint3 dap2 = bond.getAtom2().getLocation();
        for (int i = 0; i < bondArray.length; ++i) {
            if (dap1.distance(bondArray[i].getAtom1().getLocation()) < 0.01 && dap2.distance(bondArray[i].getAtom2().getLocation()) < 0.01) {
                return bondArray[i];
            }
            if (!(dap1.distance(bondArray[i].getAtom2().getLocation()) < 0.01) || !(dap2.distance(bondArray[i].getAtom1().getLocation()) < 0.01)) continue;
            return bondArray[i];
        }
        return null;
    }

    private static boolean branch3D(Molecule mol, MolAtom a0, MolAtom a3, double blen) {
        int i;
        int i2;
        int nImplH = a0.getImplicitHcount();
        int nBranches = 0;
        for (int i3 = 0; i3 < a0.getBondCount(); ++i3) {
            if (a0.getLigand(i3).getBondCount() != 1) continue;
            ++nBranches;
        }
        int[] bondflags = new int[nBranches];
        MolAtom[] atoms = new MolAtom[nBranches];
        double[] lengths = new double[nBranches];
        int j = 0;
        for (i2 = 0; i2 < a0.getBondCount(); ++i2) {
            MolBond b = a0.getBond(i2);
            MolAtom a = b.getOtherAtom(a0);
            if (a.getBondCount() != 1) continue;
            bondflags[j] = b.getFlags();
            atoms[j] = a;
            lengths[j] = b.getLength();
            ++j;
        }
        for (i2 = 0; i2 < atoms.length; ++i2) {
            mol.removeAtom(atoms[i2]);
        }
        int nNew = nImplH > 0 ? nImplH : 1;
        DPoint3[] coords = AtomBranchCoords.branchCoords3d(a0, atoms.length + nNew, 1.0);
        boolean failed = false;
        DPoint3 p0 = a0.getLocation();
        for (i = 0; i < coords.length && !failed; ++i) {
            if (!coords[i].equals(p0)) continue;
            failed = true;
        }
        coords = AtomActions.chooseBestCombination(mol, coords, atoms.length + 1);
        for (i = 0; i < atoms.length; ++i) {
            if (!failed) {
                DPoint3 p = coords[i];
                double l = lengths[i];
                double ex = p.x - p0.x;
                double ey = p.y - p0.y;
                double ez = p.z - p0.z;
                atoms[i].setXYZ(p0.x + ex * l, p0.y + ey * l, p0.z + ez * l);
            }
            mol.add(atoms[i]);
            mol.add(new MolBond(a0, atoms[i], bondflags[i]));
        }
        if (failed) {
            return false;
        }
        DPoint3 p = coords[atoms.length];
        double ex = p.x - p0.x;
        double ey = p.y - p0.y;
        double ez = p.z - p0.z;
        a3.setXYZ(p0.x + ex * blen, p0.y + ey * blen, p0.z + ez * blen);
        return true;
    }

    private static DPoint3[] chooseBestCombination(Molecule mol, DPoint3[] orig, int k) {
        int n = orig.length;
        DPoint3[] coords = new DPoint3[k];
        DPoint3[] best = new DPoint3[k];
        for (int i = 0; i < k; ++i) {
            best[i] = orig[i];
        }
        double max = -1.0;
        CombinationIterator it = new CombinationIterator(n, k);
        int i = 0;
        while (it.hasNext()) {
            int[] comb = it.next();
            for (int j = 0; j < coords.length; ++j) {
                coords[j] = orig[comb[j]];
            }
            double w = AtomActions.sumDistanceSquare(mol, coords);
            if (w > max) {
                System.arraycopy(coords, 0, best, 0, k);
                max = w;
            }
            ++i;
        }
        return best;
    }

    private static double sumDistanceSquare(Molecule mol, DPoint3[] points) {
        MoleculeGraph umol = mol.getGraphUnion();
        double sum = 0.0;
        for (int i = 0; i < points.length; ++i) {
            sum += CleanUtil.sumDistanceSquare(umol, points[i]);
        }
        return sum;
    }

    private MolAtom chain(MolAtom a0) {
        MolAtom a3;
        double z;
        double y;
        double x;
        Molecule piece = this.medit.getPiece();
        double epsilon = 0.0154;
        MolBond b1 = a0.getBond(0);
        MolAtom a1 = b1.getOtherAtom(a0);
        MolBond b2 = a1.getBond(0);
        int nb1 = a1.getBondCount();
        double x01 = a0.getX() - a1.getX();
        double y01 = a0.getY() - a1.getY();
        double z01 = a0.getZ() - a1.getZ();
        double r01 = Math.sqrt(x01 * x01 + y01 * y01 + z01 * z01);
        int atno = piece != null && piece.isAtom() ? piece.getAtom(0).getAtno() : 6;
        double blen = MolBond.desiredLength(a0.getAtno(), atno, 1, this.medit.getMolDim());
        if (nb1 > 1) {
            double c;
            double r;
            if (b2 == b1) {
                b2 = a1.getBond(1);
            }
            MolAtom a2 = b2.getOtherAtom(a1);
            x = a1.getX() - a2.getX() - x01;
            y = a1.getY() - a2.getY() - y01;
            z = a1.getZ() - a2.getZ() - z01;
            if ((r = Math.sqrt((x -= (x01 /= r01) * (c = x01 * x + (y01 /= r01) * y + (z01 /= r01) * z)) * x + (y -= y01 * c) * y + (z -= z01 * c) * z)) < epsilon) {
                x = -y01;
                y = x01;
                z = 0.0;
            } else {
                x /= r;
                y /= r;
                z /= r;
            }
            double q = Math.sqrt(0.75) * blen;
            double q01 = 0.5 * blen;
            x = q01 * x01 + x * q;
            y = q01 * y01 + y * q;
            z = q01 * z01 + z * q;
        } else {
            double a = 0.5 * blen;
            double b = Math.sqrt(0.75) * blen;
            x = a * (x01 /= r01) + b * (y01 /= r01);
            y = -b * x01 + a * y01;
            z = blen * (z01 /= r01);
        }
        if (piece != null && piece.isAtom()) {
            a3 = (MolAtom)piece.getAtom(0).clone();
            a3.setXYZ(a0.getX() + x, a0.getY() + y, a0.getZ() + z);
        } else {
            a3 = new MolAtom(0, a0.getX() + x, a0.getY() + y, a0.getZ() + z);
        }
        return a3;
    }

    private void detAngles(MolAtom a0) {
        int[][] bi = DrawingUtil.bondIndices1(a0);
        double[] angles = GeomUtil.bondAngles(a0, bi[1]);
        double[] diffs = GeomUtil.calcAngleDiffs(angles, bi[1], bi[0].length > 0 ? bi[0] : null);
        DrawingUtil.sortDiffs(diffs, angles, bi[1], bi[0].length > 0 ? bi[0] : null);
        int desBondIndex = bi[1].length - 1;
        if (bi[1].length == 3 && DrawingUtil.regular(diffs)) {
            desBondIndex = bi[0].length > 0 ? DrawingUtil.detDesBondIndex(angles, bi[0]) : 0;
        }
        double phi = diffs[desBondIndex] / 2.0 + angles[desBondIndex];
        MolAtom a = a0.getLigand(bi[1].length);
        double l = MolBond.desiredLength(a0.getAtno(), a.getAtno(), 1, this.medit.getMolDim());
        a.setXYZ(a0.getX() + l * Math.cos(phi), a0.getY() + l * Math.sin(phi), a0.getZ());
        SelectionMolecule m = new SelectionMolecule();
        m.add(a0);
        for (int k = 0; k < bi[1].length; ++k) {
            MolBond b = a0.getBond(bi[1][k]);
            MolAtom a1 = b.getOtherAtom(a0);
            if (a1.getAtno() == 137) continue;
            m.add(a1);
            m.add(b);
        }
        m.add(a);
        m.add(a0.getBond(bi[1].length));
        Molecule mol = this.medit.getMol();
        MolJoin mj = new MolJoin(mol, m, this.medit.getStickdst() * 1.54, this.medit.getMergedst() * 1.54, a0, this.medit.getPainter().getRTransform());
        this.medit.join(mj, new MSelectionDocument(m), 4);
    }

    private static void addRgroupAttachment(MolAtom atom) {
        if (MolJoin.canBeBound(atom)) {
            MoleculeGraph parent = atom.getParent();
            int order = parent.getMaxRgroupAttachmentPointOrder();
            MolAtom attachmentAtom = atom.addRgroupAttachmentPoint(order + 1, 1);
            parent.valenceCheck();
            CleanUtil.setBestLigandPosition(atom, attachmentAtom);
        }
    }
}

