/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.graphics.MBracketPainter;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.modules.RectangleSM;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MRectangle;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BracketSM
extends RectangleSM {
    private static final long serialVersionUID = -9218518807593387331L;
    private MBracket bracket;

    public BracketSM(String type) {
        this(new MBracket());
        this.bracket = (MBracket)this.getMObject();
        this.bracket.setAttribute("type", type);
    }

    public BracketSM(BracketSM sm) {
        super(sm);
        this.bracket = (MBracket)this.getMObject();
    }

    protected BracketSM(MBracket r) {
        super(r);
        this.bracket = r;
    }

    @Override
    public void initMObject(MObject o) {
        super.initMObject(o);
        this.bracket = (MBracket)o;
    }

    public MBracket getBracket() {
        return this.bracket;
    }

    @Override
    public Object clone() {
        return new BracketSM(this);
    }

    @Override
    protected MRectangle newRectangle() {
        MBracket r = (MBracket)this.bracket.clone();
        if ((r.getTOption() & 1) != 0) {
            r.transformTo2D();
        }
        return r;
    }

    @Override
    public void paintTemporaryObject(Graphics2D g) {
        MolEditor medit = this.getEditor();
        MolPainter painter = medit.getPainter();
        DPoint3 p1 = this.startPoint.getLocation();
        DPoint3 p2 = this.getEndPoint().getLocation();
        if (p2.x < p1.x) {
            double x = p1.x;
            p1.x = p2.x;
            p2.x = x;
        }
        if (p2.y > p1.y) {
            double y = p1.y;
            p1.y = p2.y;
            p2.y = y;
        }
        CTransform3D t = painter.getTransformMatrix();
        MBracket mb = new MBracket(new MPoint(p1), new MPoint(p2));
        if (this.bracket != null) {
            this.bracket.copyProperties(mb);
        }
        MBracketPainter mbp = new MBracketPainter();
        mbp.paint(mb, g, t, 0, painter.getColors().getForeground(), null, null);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        this.bracket = (MBracket)this.getMObject();
    }
}

