/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.SelectionMolecule;
import java.util.ArrayList;
import java.util.List;

public class ChangeSelection
implements CallbackIface {
    private MolEditor medit = null;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("init")) {
            this.medit = (MolEditor)arg;
        } else if (method.equals("changeSelection")) {
            Molecule m = (Molecule)arg;
            boolean changed = this.changeSelection(m);
            return new Boolean(changed);
        }
        return null;
    }

    private boolean changeSelection(Molecule m) {
        boolean changed = false;
        if (m.isAtom() && !m.isSgroup()) {
            MolAtom aa = m.getAtom(0);
            changed = this.changeSelection(aa);
            if (aa.getAtno() == 210) {
                this.medit.setFreePieceMap();
            }
        } else if (m.isBond()) {
            changed = this.changeBondSelection(m);
        }
        return changed;
    }

    private boolean changeBondSelection(Molecule m) {
        MolBond b0 = m.getBond(0);
        MSelectionDocument seldoc = this.medit.getSelectionDocument();
        MoleculeGraph sel = seldoc.getMainMoleculeGraph();
        if (!sel.isEmpty()) {
            ArrayList<MolAtom> toCheck = new ArrayList<MolAtom>();
            boolean changed = false;
            int mask = 1073742335;
            int flags = b0.getFlags() & mask;
            for (int j = sel.getBondCount() - 1; j >= 0; --j) {
                MolBond b = sel.getBond(j);
                if ((b.getFlags() & mask) == flags) continue;
                this.medit.ungroupSgroupOf(b);
                int otherflags = b.getFlags() & ~mask;
                b = this.medit.setBondFlags(b, otherflags | flags);
                MolAtom node1 = b.getAtom1();
                MolAtom node2 = b.getAtom2();
                if (!toCheck.contains(node1)) {
                    toCheck.add(node1);
                }
                if (!toCheck.contains(node2)) {
                    toCheck.add(node2);
                }
                changed = true;
            }
            ChangeSelection.doValenceCheck(toCheck);
            return changed;
        }
        return false;
    }

    private static void doValenceCheck(List l) {
        int n = l.size();
        for (int j = 0; j < n; ++j) {
            MolAtom a = (MolAtom)l.get(j);
            for (int k = 0; k < a.getBondCount(); ++k) {
                MolAtom aa = a.getLigand(k);
                if (l.contains(aa)) continue;
                l.add(aa);
            }
        }
        for (MolAtom a : l) {
            a.valenceCheck();
        }
    }

    private boolean changeSelection(MolAtom atom) {
        boolean changed = false;
        int[] list = atom.getList();
        int atno = atom.getAtno();
        String aliasstr = atom.getAliasstr();
        int rgroup = atom.getRgroup();
        boolean island = true;
        RgMolecule rgmol = null;
        Molecule mol = this.medit.getMol();
        if (mol instanceof RgMolecule) {
            rgmol = (RgMolecule)mol;
        }
        SelectionMolecule sel = (SelectionMolecule)this.medit.getSelectionDocument().getMainMoleculeGraph();
        for (int i = sel.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = sel.getAtom(i);
            for (int j = a.getBondCount() - 1; j >= 0; --j) {
                if (sel.contains(a.getLigand(j))) continue;
                island = false;
            }
        }
        if (rgmol != null) {
            if (rgmol.getRoot().contains(sel)) {
                sel.setAbsStereo(rgmol.isAbsStereo());
            } else {
                int n = rgmol.getRgroupCount();
                for (int i = 0; i < n; ++i) {
                    int k = rgmol.getRgroupMemberCount(i);
                    for (int j = 0; j < k; ++j) {
                        if (!rgmol.getRgroupMember(i, j).contains(sel)) continue;
                        sel.setAbsStereo(rgmol.getRgroupMember(i, j).isAbsStereo());
                    }
                }
            }
        }
        if (island && atno == 134) {
            if (rgmol == null) {
                rgmol = new RgMolecule();
                rgmol.setRoot(mol);
                this.medit.getDocument().setMainMoleculeGraph(rgmol);
                mol = rgmol;
            }
            rgmol.replaceAtomsWithNewRgroup(sel, rgroup);
            changed = true;
        } else if (atno == 210) {
            if (this.medit.hasSelection()) {
                this.medit.edit(25);
                this.medit.edit(14);
            }
        } else if (atom.getValenceProp() != -1 && atno == 0) {
            ChangeSelection.changeValenceProp(atom.getValenceProp(), sel);
            changed = true;
        } else if (atom.getQueryAromaticity() != 0 && atno == 0) {
            ChangeSelection.changeQAromProp(atom.getQueryAromaticity(), sel);
            changed = true;
        } else if (atom.isQProp()) {
            String[] names = atom.getQPropNames();
            if (names.length != 0) {
                ChangeSelection.changeQProps(atom, names, sel);
                changed = true;
            }
        } else {
            ArrayList<MolAtom> toCheck = new ArrayList<MolAtom>();
            for (int i = sel.getAtomCount() - 1; i >= 0; --i) {
                MolAtom aa = sel.getAtom(i);
                if (atno != 0) {
                    int[] aalist;
                    int massno = atom.getMassno();
                    if (atno == 209) {
                        aa.setAtomMap(atom.getAtomMap());
                        changed = true;
                    } else if (atno == 136) {
                        aa.clearQProps();
                        aa.setAtno(atno);
                        aa.setAliasstr(aliasstr);
                        this.medit.ungroupSgroupOf(aa, true);
                        changed = true;
                    } else if (aa.getAtno() != atno) {
                        aa.setValenceProp(-1);
                        aa.clearQProps();
                        aa.setAtno(atno);
                        aa.setMassno(massno);
                        this.medit.ungroupSgroupOf(aa, true);
                        changed = true;
                    } else if (massno > 0 && massno != aa.getMassno()) {
                        aa.setValenceProp(-1);
                        aa.clearQProps();
                        aa.setMassno(massno);
                        this.medit.ungroupSgroupOf(aa, true);
                        changed = true;
                    }
                    if (aa.getRgroup() != rgroup) {
                        aa.setRgroup(rgroup);
                        this.medit.ungroupSgroupOf(aa, true);
                        changed = true;
                    }
                    if ((aalist = aa.getList()) != null) {
                        if (list != null) {
                            if (aalist.length != list.length) {
                                aa.setList(list);
                                this.medit.ungroupSgroupOf(aa, true);
                                changed = true;
                            } else {
                                for (int j = 0; j < list.length; ++j) {
                                    if (aalist[j] == list[j]) continue;
                                    aa.setList(list);
                                    this.medit.ungroupSgroupOf(aa, true);
                                    changed = true;
                                    break;
                                }
                            }
                        } else if (atno > 0 && atno <= 139) {
                            aa.setList(list);
                            this.medit.ungroupSgroupOf(aa, true);
                            changed = true;
                        }
                    } else if (list != null) {
                        aa.setList(list);
                        this.medit.ungroupSgroupOf(aa, true);
                        changed = true;
                    }
                } else if (aliasstr != null) {
                    aa.setAliasstr(aliasstr);
                    changed = true;
                }
                toCheck.add(aa);
            }
            ChangeSelection.doValenceCheck(toCheck);
            if (atno == 209) {
                this.medit.edit(14);
            }
        }
        return changed;
    }

    private static void changeValenceProp(int vprop, MoleculeGraph sel) {
        ArrayList<MolAtom> toCheck = new ArrayList<MolAtom>();
        for (int i = sel.getAtomCount() - 1; i >= 0; --i) {
            MolAtom aa = sel.getAtom(i);
            ChangeSelection.changeValenceProp(aa, vprop);
            toCheck.add(aa);
        }
        ChangeSelection.doValenceCheck(toCheck);
    }

    private static void changeValenceProp(MolAtom a, int val) {
        if (val == 255) {
            a.decValenceProp();
        } else if (val == 257) {
            a.incValenceProp();
        } else {
            a.setValenceProp(val);
        }
    }

    private static void changeQProps(MolAtom atom, String[] names, MoleculeGraph sel) {
        boolean[] alltrue = new boolean[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            alltrue[i] = name.equals("u") ? ChangeSelection.isQPropSetAndEqualInSelectedAtoms(sel, name) : false;
        }
        ArrayList<MolAtom> toCheck = new ArrayList<MolAtom>();
        for (int i = sel.getAtomCount() - 1; i >= 0; --i) {
            MolAtom aa = sel.getAtom(i);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                int val = atom.getQPropAsInt(name);
                if (alltrue[j]) {
                    aa.setQProp(name, null);
                    continue;
                }
                ChangeSelection.changeQProp(aa, name, val);
            }
            toCheck.add(aa);
        }
        ChangeSelection.doValenceCheck(toCheck);
    }

    private static void changeQProp(MolAtom a, String key, int val) {
        if (val == 255) {
            a.decQProp(key);
        } else if (val == 257) {
            a.incQProp(key);
        } else {
            a.setQProp(key, val);
        }
    }

    private static boolean isQPropSetAndEqualInSelectedAtoms(MoleculeGraph molg, String name) {
        int x = -1;
        for (int i = molg.getAtomCount() - 1; i >= 0; --i) {
            int val = molg.getAtom(i).getQPropAsInt(name);
            if (val == -1) {
                return false;
            }
            if (x == -1) {
                x = val;
                continue;
            }
            if (x == val) continue;
            return false;
        }
        return true;
    }

    private static void changeQAromProp(int qprop, MoleculeGraph sel) {
        boolean alltrue = ChangeSelection.isQPropSetAndEqualInSelectedAtoms(sel, "a");
        ArrayList<MolAtom> toCheck = new ArrayList<MolAtom>();
        for (int i = sel.getAtomCount() - 1; i >= 0; --i) {
            MolAtom aa = sel.getAtom(i);
            if (alltrue && qprop == 1) {
                aa.incQueryAromaticity();
            } else {
                aa.setQueryAromaticity(qprop);
            }
            toCheck.add(aa);
        }
        ChangeSelection.doValenceCheck(toCheck);
    }
}

