/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.sketch.modules.LineSM;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MEFlow;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class EFlowSM
extends LineSM {
    private static final long serialVersionUID = 7628926124658632381L;
    private transient MEFlow eflow = (MEFlow)this.getMObject();
    private transient List<DPoint3> positions = null;

    public EFlowSM() {
        this(2);
    }

    public EFlowSM(EFlowSM sm) {
        super(sm);
        if (sm.positions != null) {
            this.positions = new ArrayList<DPoint3>();
            for (int i = 0; i < sm.positions.size(); ++i) {
                DPoint3 p = sm.positions.get(i);
                this.positions.add((DPoint3)p.clone());
            }
        }
    }

    protected EFlowSM(int ne) {
        super(new MEFlow(ne), 0);
        this.eflow.setArrowWidth(MPolyline.HEAD, 0.4);
        this.eflow.setArrowLength(MPolyline.HEAD, 0.5);
    }

    @Override
    public void initMObject(MObject o) {
        super.initMObject(o);
        this.eflow = (MEFlow)o;
    }

    public MEFlow getEFlow() {
        return this.eflow;
    }

    @Override
    public Object clone() {
        return new EFlowSM(this);
    }

    @Override
    protected void setStartPoint(MPoint p) {
        super.setStartPoint(p);
        if (p != null) {
            this.positions = new ArrayList<DPoint3>();
            this.positions.add(p.getLocation());
            double angle = this.getPolyline().getArcAngle();
            this.getPolyline().setArcAngle(angle >= 0.0 ? 120.0 : -120.0);
        } else {
            this.positions = null;
        }
    }

    @Override
    public boolean pointerMove(int modifiers) {
        if (this.positions != null) {
            this.updatePosition();
        }
        return super.pointerMove(modifiers);
    }

    @Override
    public boolean pointerDrag(int modifiers) {
        if (this.positions != null) {
            this.updatePosition();
        }
        return super.pointerDrag(modifiers);
    }

    @Override
    public boolean pointerCopyDrag(int modifiers) {
        return true;
    }

    private void updatePosition() {
        this.positions.add(this.getEditor().getPointerPos());
        int n = this.positions.size();
        if (n < 3) {
            return;
        }
        DPoint3 p1 = this.positions.get(0);
        DPoint3 p2 = this.positions.get(n - 1);
        double x3 = (p1.x + p2.x) / 2.0;
        double y3 = (p1.y + p2.y) / 2.0;
        double z3 = (p1.z + p2.z) / 2.0;
        double r12 = p1.distance(p2);
        if (r12 < 1.0E-9) {
            return;
        }
        double e12x = (p2.x - p1.x) / r12;
        double e12y = (p2.y - p1.y) / r12;
        double e12z = (p2.z - p1.z) / r12;
        DPoint3 closest = null;
        double closestD = Double.MAX_VALUE;
        for (int i = 1; i < n - 1; ++i) {
            DPoint3 p = this.positions.get(i);
            double dx3 = (p.x - x3) * e12x;
            double dy3 = (p.y - y3) * e12y;
            double dz3 = (p.z - z3) * e12z;
            double d = Math.sqrt(dx3 * dx3 + dy3 * dy3 + dz3 * dz3);
            if (closest != null && !(d < closestD)) continue;
            closest = p;
            closestD = d;
        }
        double angle = this.calcCentralAngle(p1, closest, p2);
        if (angle != 0.0) {
            this.getPolyline().setArcAngle(angle > 0.0 ? 150.0 : -150.0);
        }
    }

    private double calcCentralAngle(DPoint3 p1, DPoint3 p2, DPoint3 p3) {
        double angle31;
        double r1sq = p1.x * p1.x + p1.y * p1.y;
        double r2sq = p2.x * p2.x + p2.y * p2.y;
        double r3sq = p3.x * p3.x + p3.y * p3.y;
        double a = (r3sq - r1sq) * (p2.y - p1.y) - (r2sq - r1sq) * (p3.y - p1.y);
        double b = 2.0 * ((p3.x - p1.x) * (p2.y - p1.y) - (p3.y - p1.y) * (p2.x - p1.x));
        if (Math.abs(b) < 1.0E-9) {
            return 0.0;
        }
        double x = a / b;
        double y12 = p2.y - p1.y;
        double y13 = p3.y - p1.y;
        double y = Math.abs(y12) > Math.abs(y13) ? (r2sq - r1sq - 2.0 * (p2.x - p1.x) * x) / (2.0 * y12) : (r3sq - r1sq - 2.0 * (p3.x - p1.x) * x) / (2.0 * y13);
        double phi1 = Math.atan2(p1.y - y, p1.x - x);
        double phi2 = Math.atan2(p2.y - y, p2.x - x);
        double phi3 = Math.atan2(p3.y - y, p3.x - x);
        double angle21 = phi1 - phi2;
        if (angle21 < 0.0) {
            angle21 += Math.PI * 2;
        }
        if ((angle31 = phi1 - phi3) < 0.0) {
            angle31 += Math.PI * 2;
        }
        return angle21 < angle31 ? angle31 : angle31 - Math.PI * 2;
    }

    @Override
    public MolAtom[] getPointableAtoms(Molecule m) {
        MolAtom[] src = this.getSourceAtoms();
        if (src == null) {
            return MEFlow.getValidSourceAtomsForMolecule(m);
        }
        if (src.length == 2) {
            return MEFlow.getValidSinkAtomsForMolecule(m, src[0].getBondTo(src[1]));
        }
        return MEFlow.getValidSinkAtomsForMolecule(m, src[0]);
    }

    @Override
    public boolean canPointToBond() {
        return super.canPointToBond();
    }

    @Override
    public MolBond[] getPointableBonds(Molecule m) {
        MolAtom[] src = this.getSourceAtoms();
        if (src == null) {
            return MEFlow.getValidSourceBondsForMolecule(m);
        }
        if (src.length == 2) {
            return MEFlow.getValidSinkBondsForMolecule(m, src[0].getBondTo(src[1]));
        }
        return MEFlow.getValidSinkBondsForMolecule(m, src[0]);
    }

    @Override
    public boolean canPointToAtomPair() {
        return this.getStartPoint() != null;
    }

    @Override
    public double getPointedAtomPairMinDstRatio2() {
        return 0.3;
    }

    @Override
    public double[] getAtomPairLocationWeights() {
        return new double[]{0.25, 0.75};
    }

    @Override
    public MolAtom[][] getPointableAtomPairs(Molecule m) {
        MolAtom[] src = this.getSourceAtoms();
        if (src == null) {
            return MEFlow.getValidSourceAtomPairsForMolecule(m);
        }
        if (src.length == 2) {
            return MEFlow.getValidSinkAtomPairsForMolecule(m, src[0].getBondTo(src[1]));
        }
        return MEFlow.getValidSinkAtomPairsForMolecule(m, src[0]);
    }

    private MolAtom[] getSourceAtoms() {
        MAtomSetPoint p = (MAtomSetPoint)this.getStartPoint();
        return p != null ? p.getAtoms() : null;
    }

    private static int countOrFillAtomPairs(MoleculeGraph m, MolAtom[] src, MolAtom[][] pairs) {
        int count = 0;
        block0: for (int i = 0; i < m.getAtomCount(); ++i) {
            int j;
            SgroupAtom sga;
            SuperatomSgroup supsg;
            MolAtom[] attach;
            MolAtom a = m.getAtom(i);
            if (a.getAtno() == 135 && (attach = (supsg = (sga = (SgroupAtom)a).getSgroup()).getFreeLegalAttachAtoms()).length != 1) continue;
            for (j = 0; j < src.length; ++j) {
                if (src[j] == a) continue block0;
            }
            for (j = 0; j < src.length; ++j) {
                if (src[j].isBoundTo(a) || !EFlowSM.isAcceptableAtomPair(src[j], a)) continue;
                MolAtom[] pair = new MolAtom[]{src[j], a};
                if (pairs != null) {
                    pairs[count] = pair;
                }
                ++count;
            }
        }
        return count;
    }

    @Override
    protected MPolyline createLine(MPoint p1, MPoint p2) {
        MEFlow proto = this.getEFlow();
        MEFlow l = new MEFlow(p1, p2, proto.getNumElectrons());
        this.initLine(l);
        return l;
    }

    @Override
    protected void initLine(MPolyline pl) {
        super.initLine(pl);
        CTransform3D trot = this.getEditor().getPainter().getRTransformRef();
        double angle = pl.getArcAngle();
        double sgn = angle > 0.0 ? 1.0 : -1.0;
        double l = pl.getArcRadius(trot) * Math.abs(angle * Math.PI / 180.0);
        while (l < 2.0) {
            angle = 360.0 - (360.0 - angle) * 0.9;
            pl.setArcAngle(sgn * angle);
            l = pl.getArcRadius(trot) * Math.abs(angle * Math.PI / 180.0);
        }
        double askip = 0.25;
        double bskip = 0.3;
        for (int i = 0; i < 2; ++i) {
            MPoint p = pl.getPointRef(i, null);
            if (!(p instanceof MAtomSetPoint)) continue;
            MolAtom[] atoms = ((MAtomSetPoint)p).getAtoms();
            pl.setSkip(i, atoms.length == 1 ? askip : bskip);
        }
    }

    @Override
    protected boolean isValidStartPoint(MPoint p) {
        if (!super.isValidStartPoint(p)) {
            return false;
        }
        if (!(p instanceof MAtomSetPoint)) {
            return false;
        }
        MAtomSetPoint pp = (MAtomSetPoint)p;
        MolAtom[] atoms = pp.getAtoms();
        if (atoms.length == 2) {
            if (atoms[0].isBoundTo(atoms[1])) {
                return EFlowSM.isAcceptableAtomPair(atoms[0], atoms[1]);
            }
            return false;
        }
        return atoms.length == 1;
    }

    @Override
    protected boolean isValidEndPoint(MPoint p) {
        if (!super.isValidEndPoint(p)) {
            return false;
        }
        if (!(p instanceof MAtomSetPoint)) {
            return false;
        }
        MAtomSetPoint pp = (MAtomSetPoint)p;
        MolAtom[] atoms = pp.getAtoms();
        if (atoms.length == 2) {
            return EFlowSM.isAcceptableAtomPair(atoms[0], atoms[1]);
        }
        return atoms.length == 1;
    }

    private static boolean isAcceptableAtomPair(MolAtom a1, MolAtom a2) {
        MolAtom aa;
        SuperatomSgroup ssg;
        Sgroup sg2;
        Sgroup sg1 = EFlowSM.getSgroupContaining(a1);
        if (sg1 == (sg2 = EFlowSM.getSgroupContaining(a2))) {
            return true;
        }
        if (sg1 != null) {
            if (sg1 instanceof SuperatomSgroup) {
                ssg = (SuperatomSgroup)sg1;
                aa = ssg.findAttachAtom();
                if (aa != a1) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (sg2 != null) {
            if (sg2 instanceof SuperatomSgroup) {
                ssg = (SuperatomSgroup)sg2;
                aa = ssg.findAttachAtom();
                if (aa != a2) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static Sgroup getSgroupContaining(MolAtom a) {
        MoleculeGraph mg = a.getParent();
        if (mg instanceof Molecule) {
            Molecule m = (Molecule)mg;
            Sgroup sg = m.findSgroupContaining(a);
            return sg;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
    }
}

