/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;

public class ObjectOverwriter
implements CallbackIface {
    private MolEditor medit;
    private PointedObject lastPointedObject = null;
    private MoleculeGraph lastMoleculeGraph;
    private long lastGrinvCC;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("init")) {
            this.medit = (MolEditor)arg;
        } else {
            if (method.equals("overwriteAtom")) {
                Object[] args = (Object[])arg;
                return this.overwriteAtom((AtomPO)args[0], (MolAtom)args[1]);
            }
            if (method.equals("overwriteBond")) {
                Object[] args = (Object[])arg;
                return this.overwriteBond((BondPO)args[0], (MolBond)args[1]);
            }
        }
        return null;
    }

    private boolean overwriteAtom(AtomPO pnto, MolAtom source) {
        MoleculeGraph mol0 = this.medit.getDocument().getMainMoleculeGraph();
        long grinvcc0 = mol0.getGrinvCC();
        MolAtom target = pnto.getAtom();
        int itarget = this.medit.indexOf(target);
        if (itarget < 0) {
            return false;
        }
        boolean changed = false;
        MoleculeGraph mol = this.medit.getDocument().getMainMoleculeGraph();
        int tatno = target.getAtno();
        int atno = source.getAtno();
        int chg = source.getCharge();
        boolean unhistneeded = false;
        if (source.getValenceProp() != -1 && atno == 0) {
            boolean histenabled = this.medit.setHistorizeEnabled(false);
            int vprop = source.getValenceProp();
            this.medit.abEdit(31, itarget, vprop);
            changed = true;
            this.medit.setHistorizeEnabled(histenabled);
        } else if (source.isQProp()) {
            boolean histenabled = this.medit.setHistorizeEnabled(false);
            String[] names = new String[]{"X", "D", "H", "h", "R", "r", "a", "s", "rb", "u"};
            int[] cmds = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41};
            int qprop = -1;
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                qprop = source.getQPropAsInt(name);
                if (qprop == -1) continue;
                this.medit.abEdit(cmds[i], itarget, qprop);
                changed = true;
                break;
            }
            this.medit.setHistorizeEnabled(histenabled);
        } else {
            boolean histenabled = this.medit.setHistorizeEnabled(false);
            if (atno == 0 && (chg == -1 || chg == 1)) {
                this.medit.abEdit(22, itarget, target.getCharge() + chg);
                changed = true;
            } else if (atno == 209 || atno == 210) {
                if (tatno != 135) {
                    this.medit.abEdit(26, itarget, source.getAtomMap());
                    changed = true;
                }
            } else if (atno == 135 || tatno == 135) {
                boolean[] r = this.replaceAtom(mol, source, target);
                changed = r[0];
                unhistneeded = r[1];
            } else if (atno == 134) {
                this.medit.abEdit(24, itarget, source.getRgroup());
                changed = true;
            } else if (atno != 0) {
                this.medit.abEdit(20, itarget, source.getAtno());
                if (source.getAtno() == 128 || source.getAtno() == 129) {
                    target.setList(source.getList());
                    unhistneeded = true;
                }
                if (source.getMassno() != 0) {
                    int massNo = source.getMassno();
                    if (source.isSpecIsotopeSymbolPreferred()) {
                        massNo |= 0x1000;
                    }
                    this.medit.abEdit(21, itarget, massNo);
                }
                if (atno == 136) {
                    target.setAliasstr(source.getSymbol());
                }
                changed = true;
            }
            this.medit.setHistorizeEnabled(histenabled);
        }
        if (changed) {
            this.unhistorizeIfNeeded(mol0, grinvcc0, unhistneeded);
        }
        return changed;
    }

    private boolean overwriteBond(BondPO pnto, MolBond source) {
        int i;
        MoleculeGraph mol0 = this.medit.getDocument().getMainMoleculeGraph();
        long grinvcc0 = mol0.getGrinvCC();
        boolean changed = false;
        MolBond target = pnto.getBond();
        int f = source.getFlags();
        if (target.getFlags() != f && (i = this.medit.indexOf(target)) >= 0) {
            boolean histenabled = this.medit.setHistorizeEnabled(false);
            this.medit.abEdit(42, i, f);
            this.medit.setHistorizeEnabled(histenabled);
            changed = true;
        }
        if (changed) {
            this.unhistorizeIfNeeded(mol0, grinvcc0, false);
        }
        return changed;
    }

    private boolean[] replaceAtom(MoleculeGraph mol, MolAtom source, MolAtom target) {
        int n = Integer.MAX_VALUE;
        if (source instanceof SgroupAtom) {
            SgroupAtom sa = (SgroupAtom)source;
            SuperatomSgroup sg = sa.getSgroup();
            MolAtom[] attach = sg.getFreeLegalAttachAtoms();
            n = attach.length;
        }
        if (target.getBondCount() <= n) {
            source.setLocation(target.getLocation());
            mol.mergeAtoms(source, target);
            source.valenceCheck();
            target = source;
            this.medit.setPointedObject(new AtomPO(target));
            return new boolean[]{true, true};
        }
        return new boolean[]{false, false};
    }

    private void unhistorizeIfNeeded(MoleculeGraph mol0, long grinvcc0, boolean unhistneeded) {
        if (unhistneeded || this.isLastState(mol0, grinvcc0)) {
            this.medit.unhistorize();
        }
        this.setLastState();
    }

    private boolean isLastState(MoleculeGraph mol0, long grinvcc0) {
        PointedObject po = this.medit.getPointedObject();
        return this.lastPointedObject == po && this.lastMoleculeGraph == mol0 && this.lastGrinvCC == grinvcc0;
    }

    private void setLastState() {
        PointedObject po = this.medit.getPointedObject();
        MoleculeGraph m = this.medit.getDocument().getMainMoleculeGraph();
        this.lastPointedObject = po;
        this.lastMoleculeGraph = m;
        this.lastGrinvCC = m.getGrinvCC();
    }
}

