/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.MObjectPO;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.SelectUtil;
import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class RubberUtil
implements CallbackIface {
    private MolEditor medit;
    private SelectUtil selectUtil;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("init")) {
            this.medit = (MolEditor)arg;
        } else if (method.equals("buttonDown")) {
            Object[] args = (Object[])arg;
            this.selectUtil = (SelectUtil)args[0];
            boolean dblClick = (Boolean)args[1];
            int mod = (Integer)args[2];
            int r = this.buttonDown(dblClick, mod);
            return new Integer(r);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int buttonDown(boolean dblClick, int modifiers) {
        long id;
        if (this.medit.isMoveModePersistent()) {
            return 0;
        }
        Molecule mol = this.medit.getMol();
        SelectionMolecule selection = this.medit.getSelectionMolecule();
        int ret = 0;
        boolean changed = false;
        this.medit.setMoveMode(0, false);
        boolean historize = this.medit.setHistorizeEnabled(false);
        RxnMolecule rxn = RxnMolecule.getReaction(mol);
        Molecule rxncomp = null;
        Object object = mol.getLock();
        synchronized (object) {
            PointedObject po = this.medit.getPointedObject();
            if (po == null) {
                this.selectUtil.begRS();
            } else if (po instanceof BondPO) {
                MolBond b = ((BondPO)po).getBond();
                MolAtom a1 = b.getAtom1();
                MolAtom a2 = b.getAtom2();
                if (rxn != null) {
                    long id2 = -1L;
                    id2 = rxn.getComponentID(b);
                    if (id2 != -1L) {
                        rxncomp = rxn.getComponent(id2);
                    }
                }
                selection.removeBond(b);
                this.medit.ungroupSgroupOf(b);
                mol.removeBond(b);
                this.medit.updateMolecule();
                this.medit.setPntbond(null);
                ArrayList<MolAtom> atoms = new ArrayList<MolAtom>(2);
                atoms.add(a1);
                atoms.add(a2);
                this.handleAtoms(modifiers, atoms);
                changed = true;
                ret = 2;
            } else if (po instanceof AtomPO) {
                MDocument doc = this.medit.getDocument();
                MolAtom a = ((AtomPO)po).getAtom();
                if (rxn != null) {
                    long id3 = -1L;
                    id3 = rxn.getComponentID(a);
                    if (id3 != -1L) {
                        rxncomp = rxn.getComponent(id3);
                    }
                }
                Vector<MolAtom> v = new Vector<MolAtom>();
                this.medit.ungroupSgroupOf(a, true);
                for (int i = 0; i < a.getBondCount(); ++i) {
                    MolAtom lig = a.getLigand(i);
                    if (lig == null) continue;
                    v.addElement(lig);
                }
                selection.removeAtom(a);
                this.medit.removeBrokenSgroup(a);
                this.medit.updateAttachmentPointOrder(a);
                this.medit.removeAtom(doc, a);
                this.medit.setPointedObject(null);
                this.handleAtoms(modifiers, v);
                changed = true;
                ret = 2;
            } else if (po instanceof SgroupPO) {
                MDocument doc = this.medit.getDocument();
                Sgroup sg = ((SgroupPO)po).getSgroup();
                Molecule sgparent = sg.getParentMolecule();
                if (rxn != null) {
                    long id4 = -1L;
                    id4 = rxn.getComponentID(sgparent);
                    if (id4 != -1L) {
                        rxncomp = rxn.getComponent(id4);
                    }
                }
                Vector<MolAtom> v = new Vector<MolAtom>();
                DataSgroup sgroup = this.medit.getPointedDataSgroup();
                if (sgroup != null) {
                    sgroup.getParentMolecule().ungroupSgroup(sgroup);
                } else {
                    while (sg.getAtomCount() > 0) {
                        MolAtom sgnode = sg.getAtom(0);
                        for (int j = 0; j < sgnode.getBondCount(); ++j) {
                            MolAtom node = sgnode.getLigand(j);
                            if (node == null || v.contains(node)) continue;
                            v.addElement(node);
                        }
                        selection.removeAtom(sgnode);
                        this.medit.removeAtom(doc, sgnode);
                    }
                }
                this.medit.setPointedObject(null);
                this.medit.pntSgroups = new Sgroup[0];
                this.handleAtoms(modifiers, v);
                changed = true;
                ret = 2;
            } else if (po instanceof MObjectPO) {
                MObject mo = ((MObjectPO)po).getMObject();
                this.medit.edit(1, mo, 0);
                changed = true;
                ret = 2;
            }
        }
        if (rxncomp != null && (id = rxn.getComponentID(rxncomp)) != -1L) {
            rxn.splitDisconnectedComponent(id);
        }
        this.medit.setHistorizeEnabled(historize);
        if (changed) {
            if (this.medit.isEmpty()) {
                this.medit.setIdentityTransform();
            }
            this.medit.historize();
        }
        return ret;
    }

    private void handleAtoms(int modifiers, Collection<MolAtom> v) {
        if ((modifiers & 8) != 0 ^ this.medit.isDeleteRemovesTerminalAtoms()) {
            v = this.removeLonelyAtoms(v);
        }
        this.valanceCheckAtoms(v);
    }

    private Collection<MolAtom> removeLonelyAtoms(Collection<MolAtom> v) {
        MDocument doc = this.medit.getDocument();
        MoleculeGraph sel = this.medit.getSelectionDocument().getMainMoleculeGraph();
        Iterator<MolAtom> it = v.iterator();
        while (it.hasNext()) {
            MolAtom a = it.next();
            if (a.getBondCount() != 0 || a.getAtno() == 137) continue;
            sel.removeAtom(a);
            this.medit.removeBrokenSgroup(a);
            this.medit.removeAtom(doc, a);
            it.remove();
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void valanceCheckAtoms(Collection<MolAtom> atoms) {
        for (MolAtom a : atoms) {
            int c;
            Molecule mol;
            a.valenceCheck();
            if (a.getStereoGroupType() == 0 || !(mol = this.medit.getMol()).contains(a)) continue;
            try {
                mol.setGUIContracted(false);
                int i = mol.indexOf(a);
                c = i >= 0 ? mol.getChirality(i) : 0;
            }
            finally {
                mol.setGUIContracted(true);
            }
            if (c != 0) continue;
            a.setStereoGroupType(0);
            a.setStereoGroupNumber(1);
        }
        this.medit.restoreNonReactionIfPossible();
    }
}

