/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SgroupUtil
implements CallbackIface {
    private MolEditor medit = null;

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("init")) {
            this.medit = (MolEditor)arg;
        } else {
            if (method.equals("contractAll")) {
                return new Boolean(this.contractAll());
            }
            if (method.equals("expandOrUngroupAll")) {
                try {
                    int cmd = (Integer)arg;
                    return new Boolean(this.expandOrUngroupAll(cmd));
                }
                catch (Throwable ex) {
                    this.medit.internalError(ex);
                }
            } else if (method.equals("editSgroup")) {
                int[] args = (int[])arg;
                return new Boolean(this.editSgroup(args[0], args[1]));
            }
        }
        return null;
    }

    private boolean contractAll() {
        Molecule mol = this.medit.getMol();
        boolean changed = false;
        DPoint3 center_before = mol.calcCenter();
        try {
            if (this.medit.hasSelection()) {
                Expandable[] x = this.getSelectedNonContractedSgroups();
                for (int i = 0; i < x.length; ++i) {
                    changed = x[i].contract(0) || changed;
                }
                if (changed) {
                    this.medit.unselect();
                }
            } else {
                changed = this.contractSgroups(mol);
            }
        }
        catch (Throwable ex) {
            this.medit.internalError(ex);
            return false;
        }
        DPoint3 center_after = mol.calcCenter();
        CTransform3D t = new CTransform3D();
        t.setTranslation(center_before.x - center_after.x, center_before.y - center_after.y, center_before.z - center_after.z);
        mol.transform(t);
        return changed;
    }

    private boolean contractSgroups(Molecule mol) {
        boolean success;
        block7: {
            block8: {
                block6: {
                    int i;
                    success = true;
                    if (!(mol instanceof RxnMolecule)) break block6;
                    RxnMolecule rxn = (RxnMolecule)mol;
                    for (i = 0; i < rxn.getComponentCount(0); ++i) {
                        success &= this.contractSgroups(rxn.getComponent(0, i));
                    }
                    for (i = 0; i < rxn.getComponentCount(1); ++i) {
                        success &= this.contractSgroups(rxn.getComponent(1, i));
                    }
                    for (i = 0; i < rxn.getComponentCount(2); ++i) {
                        success &= this.contractSgroups(rxn.getComponent(2, i));
                    }
                    break block7;
                }
                if (!(mol instanceof RgMolecule)) break block8;
                RgMolecule rgmol = (RgMolecule)mol;
                success &= this.contractSgroups(rgmol.getRoot());
                for (int i = 0; i < rgmol.getRgroupCount(); ++i) {
                    for (int j = 0; j < rgmol.getRgroupMemberCount(i); ++j) {
                        success &= this.contractSgroups(rgmol.getRgroupMember(i, j));
                    }
                }
                break block7;
            }
            if (!(mol instanceof Molecule)) break block7;
            for (int i = 0; i < mol.getSgroupCount(); ++i) {
                if (!(mol.getSgroup(i) instanceof Expandable)) continue;
                success &= this.contractSgroup(mol.getSgroup(i), mol);
            }
        }
        return success;
    }

    private Expandable[] getSelectedNonContractedSgroups() {
        MoleculeGraph sel = this.medit.getSelectionDocument().getMainMoleculeGraph();
        Molecule mol = this.medit.getMol();
        Vector<Sgroup> v = new Vector<Sgroup>();
        for (int i = 0; i < sel.getAtomCount(); ++i) {
            MolAtom a = sel.getAtom(i);
            Sgroup sg = mol.findSgroupContaining(a);
            if (sg == null || !(sg instanceof Expandable) || !((Expandable)((Object)sg)).isExpanded() || v.contains(sg)) continue;
            v.addElement(sg);
        }
        Object[] arr = new Expandable[v.size()];
        v.copyInto(arr);
        return arr;
    }

    private boolean preexpand(SgroupAtom a, HashSet atomSet) {
        SuperatomSgroup sg = a.getSgroup();
        Expandable x = sg;
        boolean changed = x.expand(0);
        if (atomSet != null) {
            MolAtom[] arr = sg.getAtomArray();
            for (int j = 0; j < arr.length; ++j) {
                if (arr[j] instanceof SgroupAtom) {
                    this.preexpand((SgroupAtom)arr[j], atomSet);
                    continue;
                }
                atomSet.add(arr[j]);
            }
        }
        return changed;
    }

    private boolean expandOrUngroupAll(int cmd) {
        MolAtom a;
        boolean changed = false;
        Molecule mol = this.medit.getMol();
        Object[] ungrouped = null;
        DPoint3 center_before = mol.calcCenter();
        Set<MolAtom> selatoms = this.medit.getSetOfAllOrSelectedAtoms();
        if (cmd == 24 && mol instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)mol;
            changed |= rgmol.unRgroupAtoms(selatoms) != 0;
        }
        if (this.medit.hasSelection() || changed) {
            Vector<Sgroup> ungroupedV = new Vector<Sgroup>();
            Iterator<MolAtom> it = selatoms.iterator();
            HashSet<MolAtom> atomSet = new HashSet<MolAtom>();
            while (it.hasNext()) {
                MolAtom a2 = it.next();
                if (a2 instanceof SgroupAtom) {
                    changed |= this.preexpand((SgroupAtom)a2, atomSet);
                    continue;
                }
                atomSet.add(a2);
            }
            for (MolAtom a2 : atomSet) {
                Sgroup sg = mol.findSgroupContaining(a2);
                if (sg == null || sg.getType() == 14 || sg.getType() == 10) continue;
                if (cmd == 24 && !ungroupedV.contains(sg)) {
                    ungroupedV.addElement(sg);
                    this.addChildSgroups(sg, ungroupedV, a2);
                }
                if (!(sg instanceof Expandable) || ((Expandable)((Object)sg)).isExpanded()) continue;
                ((Expandable)((Object)sg)).expand(0);
                changed = true;
            }
            ungrouped = new Sgroup[ungroupedV.size()];
            ungroupedV.copyInto(ungrouped);
            if (changed) {
                this.medit.unselect();
            }
        } else {
            changed |= mol.expandSgroups();
            if (cmd == 24) {
                ArrayList<Sgroup> mc_list = new ArrayList<Sgroup>();
                for (int i = 0; i < mol.getAtomCount(); ++i) {
                    a = mol.getAtom(i);
                    if (!(a instanceof SgroupAtom)) continue;
                    changed |= this.preexpand((SgroupAtom)a, null);
                }
                for (int s = 0; s < mol.getSgroupCount(); ++s) {
                    Sgroup sg = mol.getSgroup(s);
                    if (sg.getType() == 14 || sg.getType() == 10) continue;
                    mc_list.add(sg);
                }
                ungrouped = new Sgroup[mc_list.size()];
                mc_list.toArray(ungrouped);
            }
        }
        if (ungrouped != null) {
            MoleculeGraph umol = mol.getGraphUnion();
            for (int j = 0; j < umol.getAtomCount(); ++j) {
                a = umol.getAtom(j);
                Sgroup g = mol.findSmallestSgroupContaining(a);
                while (g != null) {
                    Sgroup psg = null;
                    for (int i = 0; i < ungrouped.length; ++i) {
                        Object sg = ungrouped[i];
                        if (g == sg) {
                            psg = g.getParentSgroup();
                            SgroupUtil.ungroupAtom(mol, (Sgroup)sg, a);
                            changed = true;
                        } else if (psg == null) {
                            psg = g.getParentSgroup();
                        }
                        SgroupUtil.updateChildAfterUngroup((Sgroup)sg);
                    }
                    g = psg;
                }
            }
            RxnMolecule rxn = RxnMolecule.getReaction(mol);
            if (rxn != null) {
                rxn.splitAllDisconnectedComponents();
            }
        }
        DPoint3 center_after = mol.calcCenter();
        CTransform3D t = new CTransform3D();
        t.setTranslation(center_before.x - center_after.x, center_before.y - center_after.y, center_before.z - center_after.z);
        mol.transform(t);
        return changed;
    }

    private void addChildSgroups(Sgroup sg, Vector ungroupedV, MolAtom a) {
        for (int i = sg.getChildSgroupCount() - 1; i >= 0; --i) {
            Sgroup csg = sg.getChildSgroup(i);
            if (!ungroupedV.contains(csg) && csg.indexOf(a) > -1) {
                ungroupedV.addElement(csg);
            }
            this.addChildSgroups(csg, ungroupedV, a);
        }
    }

    private boolean editSgroup(int cmd, int arg) {
        Molecule mol = this.medit.getMol();
        switch (cmd) {
            case 17: {
                return this.contractSgroup(mol.getSgroup(arg), mol);
            }
            case 18: {
                return this.expandSgroup(mol.getSgroup(arg), mol);
            }
            case 19: {
                this.ungroupSgroup(mol.getSgroup(arg), mol);
                break;
            }
            case 20: {
                this.removeSgroup(mol.getSgroup(arg), mol);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean expandSgroup(Sgroup sg, Molecule mol) {
        this.ungroupParentIfNeeded(sg, mol);
        Expandable x = (Expandable)((Object)sg);
        if (!x.expand(4)) {
            return false;
        }
        this.medit.pntSgroups = new Sgroup[0];
        this.medit.unselect();
        return true;
    }

    private boolean contractSgroup(Sgroup sg, Molecule mol) {
        this.ungroupParentIfNeeded(sg, mol);
        if (sg.getType() == 0 && !sg.isVisible()) {
            return false;
        }
        Expandable x = (Expandable)((Object)sg);
        if (!x.contract(4)) {
            return false;
        }
        this.medit.pntSgroups = new Sgroup[0];
        this.medit.unselect();
        return true;
    }

    private void ungroupSgroup(Sgroup sg, Molecule mol) {
        Expandable x;
        this.ungroupParentIfNeeded(sg, mol);
        RxnMolecule rxn = RxnMolecule.getReaction(mol);
        long componentID = -1L;
        if (rxn != null) {
            componentID = rxn.getComponentID(sg.getAtom(0));
        }
        if (sg instanceof Expandable && !(x = (Expandable)((Object)sg)).isExpanded()) {
            x.expand(0);
        }
        if (sg instanceof DataSgroup) {
            this.medit.setDataSgroupObject(null);
        }
        if (sg instanceof RepeatingUnitSgroup) {
            ((RepeatingUnitSgroup)sg).removeStarAtoms();
        }
        MolAtom[] arr = sg.getAtomArray();
        for (int j = 0; j < arr.length; ++j) {
            SgroupUtil.ungroupAtom(mol, sg, arr[j]);
        }
        SgroupUtil.updateChildAfterUngroup(sg);
        mol.ungroupSgroup(sg, 0);
        if (componentID != -1L) {
            rxn.splitDisconnectedComponent(componentID);
        }
        this.medit.pntSgroups = new Sgroup[0];
        this.medit.unselect();
    }

    private void ungroupParentIfNeeded(Sgroup sg, Molecule mol) {
        Sgroup psg = sg.getParentSgroup();
        if (psg != null && psg instanceof MultipleSgroup && ((MultipleSgroup)psg).isExpanded()) {
            this.ungroupSgroup(psg, mol);
        }
    }

    private static void updateChildAfterUngroup(Sgroup sg) {
        if (sg.isEmpty()) {
            for (int i = sg.getChildSgroupCount() - 1; i >= 0; --i) {
                Sgroup csg = sg.getChildSgroup(i);
                sg.removeChildSgroup(csg);
            }
        }
    }

    private void removeSgroup(Sgroup sg, Molecule mol) {
        MSelectionDocument seldoc = this.medit.getSelectionDocument();
        MoleculeGraph sel = seldoc.getMainMoleculeGraph();
        MolAtom[] arr = sg.getAtomArray();
        for (int j = 0; j < arr.length; ++j) {
            sel.removeAtom(arr[j]);
            mol.removeAtom(arr[j]);
        }
        if (sg instanceof SuperatomSgroup) {
            SgroupAtom sa = ((SuperatomSgroup)sg).getSuperAtom();
            sel.removeAtom(sa);
            mol.removeAtom(sa);
        }
        this.medit.pntSgroups = new Sgroup[0];
        this.medit.unselect();
    }

    private static void ungroupAtom(Molecule mol, Sgroup sg, MolAtom a) {
        mol.setSgroupParent(a, sg, false);
        if (mol.findSgroupContaining(a) != sg) {
            int apo = a.getAttach();
            a.setAttach(0);
            if (apo != 0) {
                a.valenceCheck();
            }
        }
        if (sg.isEmpty()) {
            mol.ungroupSgroup(sg, 0);
        }
    }
}

