/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.modules.SgroupUpdate;
import chemaxon.struc.MSelectionDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import java.util.ArrayList;

public class SgroupValidate {
    private static final boolean[][] directEmbeddingAllowed = new boolean[][]{{false, false, true, true, true, true, true, true, false, false, true, true, true, true, true, true}, {true, false, true, true, true, true, true, true, false, false, true, true, true, true, true, true}, {true, false, false, true, true, true, false, false, false, false, true, true, true, true, true, false}, {true, false, false, false, false, true, false, false, false, false, true, true, true, true, true, false}, {true, false, false, false, false, true, false, false, false, false, true, true, true, true, true, false}, {true, false, false, false, false, false, false, false, false, false, true, false, true, true, true, false}, {true, false, false, false, false, true, false, false, false, false, true, true, true, true, true, false}, {true, false, false, false, false, true, false, false, false, false, true, true, true, true, true, false}, {true, false, false, false, false, false, false, false, false, false, true, false, true, false, true, false}, {true, false, false, false, false, false, false, false, false, false, true, false, true, false, true, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, false, false, true, true, true, false, false, false, false, true, true, true, true, true, false}, {true, true, true, true, true, true, true, true, false, false, true, true, true, true, true, true}, {false, false, false, false, false, false, false, false, true, true, true, false, false, false, true, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, false, false, false, false, true, false, false, false, false, true, true, true, true, true, false}};
    private static boolean[][] indirectEmbeddingAllowed = new boolean[][]{{false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, false, false, true, true, true, false, false, true, true, true, true, true, true, true, false}, {true, false, false, false, false, true, false, false, true, true, true, true, true, true, true, false}, {true, false, false, false, false, true, false, false, true, true, true, true, true, true, true, false}, {true, false, false, false, false, false, false, false, true, true, true, false, true, true, true, false}, {true, false, false, false, false, true, false, false, true, true, true, true, true, true, true, false}, {true, false, false, false, false, true, false, false, false, false, true, true, true, true, true, false}, {true, false, false, false, false, false, false, false, false, false, true, false, true, false, true, false}, {true, false, false, false, false, false, false, false, false, false, true, false, true, false, true, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, false, false, true, true, true, false, false, true, true, true, true, true, true, true, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, false, false, false, false, false, false, false, true, true, true, false, true, false, true, false}, {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {true, false, false, false, false, true, false, false, true, true, true, true, true, true, true, false}};

    private SgroupValidate() {
    }

    public static boolean isStructureChanging(int type) {
        return type != 0 && type != 10 && type != 12;
    }

    public static boolean canHaveSubScript(int type) {
        return type == 0 || type == 1 || type == 13 || type == 2;
    }

    public static boolean isSRUPolymerType(int type) {
        return type == 11 || type == 2 || type == 5 || type == 6 || type == 15 || type == 7;
    }

    public static boolean canHavePolymerSuperScript(SelectionMolecule selection, int type) {
        if (SgroupValidate.isSRUPolymerType(type)) {
            Sgroup sg = new Sgroup(null, type);
            sg.setSgroupGraph(selection);
            if (sg.findCrossingBonds().length != 1) {
                return true;
            }
        }
        return false;
    }

    public static boolean isCorrectGroupSelection(MolEditor molEdit) {
        RxnMolecule rxnMol = RxnMolecule.getReaction(molEdit.getMol());
        if (rxnMol != null) {
            return rxnMol.getType(molEdit.getSelectionMolecule()) != -1;
        }
        return true;
    }

    private static boolean isAllowedDirectEmbedding(int childType, int parentType) {
        return directEmbeddingAllowed[childType][parentType];
    }

    private static boolean isAllowedAncestors(int type, Sgroup parent) {
        for (Sgroup ancestor = parent; ancestor != null; ancestor = ancestor.getParentSgroup()) {
            if (indirectEmbeddingAllowed[type][ancestor.getType()]) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllowedDescendants(int type, Sgroup child) {
        if (!indirectEmbeddingAllowed[child.getType()][type]) {
            return false;
        }
        for (int i = 0; i < child.getChildSgroupCount(); ++i) {
            if (SgroupValidate.isAllowedDescendants(type, child.getChildSgroup(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPossibleEmbedding(int type, MoleculeGraph molSelection, Molecule molecule) {
        Sgroup sg;
        int i;
        int nSgroups = molecule.getSgroupCount();
        Sgroup parent = null;
        for (i = 0; i < nSgroups; ++i) {
            sg = molecule.getSgroup(i);
            if (!sg.isPartSelected(molSelection) || parent != null && !sg.isDescendantOf(parent)) continue;
            parent = sg;
        }
        if (parent != null) {
            if (!parent.getSgroupGraph().contains(molSelection)) {
                return false;
            }
            if (!SgroupValidate.isAllowedDirectEmbedding(type, parent.getType()) || !SgroupValidate.isAllowedAncestors(type, parent)) {
                return false;
            }
            for (i = 0; i < parent.getChildSgroupCount(); ++i) {
                Sgroup child = parent.getChildSgroup(i);
                if (!child.isTotalSelected(molSelection) || SgroupValidate.isAllowedDirectEmbedding(child.getType(), type) && SgroupValidate.isAllowedDescendants(type, child)) continue;
                return false;
            }
        } else {
            for (i = 0; i < nSgroups; ++i) {
                Sgroup sgParent;
                sg = molecule.getSgroup(i);
                if (!sg.isTotalSelected(molSelection) || (sgParent = sg.getParentSgroup()) != null && sgParent.isTotalSelected(molSelection) || SgroupValidate.isAllowedDirectEmbedding(sg.getType(), type) && SgroupValidate.isAllowedDescendants(type, sg)) continue;
                return false;
            }
        }
        return true;
    }

    private static int findSgroupAncestorCount(Sgroup sgroup, int type, MoleculeGraph molGraph, Molecule molecule) {
        int nAncestors = 0;
        if (sgroup == null) {
            int nSgroups = molecule.getSgroupCount();
            for (int i = 0; i < nSgroups; ++i) {
                Sgroup sg = molecule.getSgroup(i);
                if (sg.getType() != type || !sg.isPartSelected(molGraph)) continue;
                ++nAncestors;
            }
        } else {
            for (Sgroup ancestor = sgroup.getParentSgroup(); ancestor != null; ancestor = ancestor.getParentSgroup()) {
                if (ancestor.getType() != type) continue;
                ++nAncestors;
            }
        }
        return nAncestors;
    }

    private static int findSgroupContractedMultipleAncestorCount(Sgroup sgroup, MoleculeGraph molGraph, Molecule molecule) {
        int nAncestors = 0;
        if (sgroup == null) {
            int nSgroups = molecule.getSgroupCount();
            for (int i = 0; i < nSgroups; ++i) {
                Sgroup sg = molecule.getSgroup(i);
                if (sg.getType() != 1 || !((MultipleSgroup)sg).isContracted() || !sg.isPartSelected(molGraph)) continue;
                ++nAncestors;
            }
        } else {
            for (Sgroup ancestor = sgroup.getParentSgroup(); ancestor != null; ancestor = ancestor.getParentSgroup()) {
                if (ancestor.getType() != 1 || !((MultipleSgroup)ancestor).isContracted()) continue;
                ++nAncestors;
            }
        }
        return nAncestors;
    }

    private static int getNumberOfDescendants(Sgroup sgroup, int type) {
        int nDescendants = 0;
        for (int i = sgroup.getChildSgroupCount() - 1; i >= 0; --i) {
            Sgroup descendant = sgroup.getChildSgroup(i);
            if (descendant.getType() == type) {
                ++nDescendants;
            }
            nDescendants += SgroupValidate.getNumberOfDescendants(descendant, type);
        }
        return nDescendants;
    }

    private static int findSgroupDescendantCount(Sgroup sgroup, int type, MoleculeGraph molGraph, Molecule molecule) {
        int nDescendants = 0;
        if (sgroup == null) {
            int nSgroups = molecule.getSgroupCount();
            for (int i = 0; i < nSgroups; ++i) {
                Sgroup sg = molecule.getSgroup(i);
                if (sg.getType() != type || !sg.isTotalSelected(molGraph)) continue;
                ++nDescendants;
            }
        } else {
            nDescendants = SgroupValidate.getNumberOfDescendants(sgroup, type);
        }
        return nDescendants;
    }

    private static boolean isSgroupSpecificConstraintsOK(Sgroup sgroup, int creationType, MoleculeGraph molGraph, Molecule molecule) {
        int type = MolEditor.getSgroupType(creationType);
        if (creationType == 19) {
            if (!RepeatingUnitSgroup.isAcceptableRSRUGraph(molGraph)) {
                return false;
            }
        } else {
            int nDependants;
            if (SgroupValidate.isSRUPolymerType(type) && !RepeatingUnitSgroup.isAcceptablePolymerGraph(molGraph)) {
                return false;
            }
            if (type == 1) {
                if (!MultipleSgroup.isAcceptableGraph(molGraph)) {
                    return false;
                }
                int nDependants2 = SgroupValidate.findSgroupContractedMultipleAncestorCount(sgroup, molGraph, molecule) + SgroupValidate.findSgroupDescendantCount(sgroup, 1, molGraph, molecule) + SgroupValidate.findSgroupDescendantCount(sgroup, 0, molGraph, molecule);
                if (nDependants2 > 1) {
                    return false;
                }
            } else if (type == 0 && (nDependants = SgroupValidate.findSgroupAncestorCount(sgroup, 1, molGraph, molecule) + SgroupValidate.findSgroupAncestorCount(sgroup, 0, molGraph, molecule) + SgroupValidate.findSgroupDescendantCount(sgroup, 1, molGraph, molecule) + SgroupValidate.findSgroupDescendantCount(sgroup, 0, molGraph, molecule)) > 1) {
                return false;
            }
        }
        return true;
    }

    private static void contractSgroupSelection(MSelectionDocument selectionDoc, ArrayList<Sgroup> addedSgroups) {
        if (addedSgroups == null) {
            return;
        }
        int nAddedSgroups = addedSgroups.size();
        for (int i = nAddedSgroups - 1; i >= 0; --i) {
            Sgroup sg = addedSgroups.remove(i);
            if (sg.getBracketCount() == 0) continue;
            ArrayList<MBracket> brackets = sg.getBrackets();
            for (int k = 0; k < brackets.size(); ++k) {
                selectionDoc.removeObject(brackets.get(k));
                brackets.get(k).setSelected(false);
            }
        }
    }

    public static boolean isAllowedSgroupTypeToCreate(MolEditor molEdit, int creationType) {
        MSelectionDocument selDoc = molEdit.getSelectionDocument();
        MoleculeGraph molSelection = selDoc.getMainMoleculeGraph();
        Molecule molecule = molEdit.getMol();
        int type = MolEditor.getSgroupType(creationType);
        if (SgroupUpdate.isSgroupToExtendToWholeFragments(type) || SgroupUpdate.isSgroupToExtendToSubgraph(type)) {
            SelectionMolecule extendedSelection = new SelectionMolecule();
            for (int i = 0; i < molSelection.getAtomCount(); ++i) {
                extendedSelection.add(molSelection.getAtom(i));
            }
            ArrayList<Sgroup> addedSgroups = SgroupUpdate.isSgroupToExtendToWholeFragments(type) ? SgroupUpdate.extendSgroupSelectionToWholeFragments(extendedSelection, selDoc, molecule) : SgroupUpdate.extendSgroupSelectionToSubgraph(extendedSelection, selDoc, molecule);
            boolean toReturn = SgroupValidate.isSgroupSpecificConstraintsOK(null, creationType, extendedSelection, molecule) && SgroupValidate.isPossibleEmbedding(type, extendedSelection, molecule);
            SgroupValidate.contractSgroupSelection(selDoc, addedSgroups);
            return toReturn;
        }
        return SgroupValidate.isSgroupSpecificConstraintsOK(null, creationType, molSelection, molecule) && SgroupValidate.isPossibleEmbedding(type, molSelection, molecule);
    }

    public static boolean isAllowedSgroupTypeToChangeTo(MolEditor molEdit, int creationType, Sgroup sgroup) {
        Molecule molecule;
        SelectionMolecule sgroupGraph = sgroup.getSgroupGraph();
        if (!SgroupValidate.isSgroupSpecificConstraintsOK(sgroup, creationType, sgroupGraph, molecule = molEdit.getMol())) {
            return false;
        }
        int type = MolEditor.getSgroupType(creationType);
        if (SgroupUpdate.isSgroupToExtendToWholeFragments(type) && !SgroupUpdate.isSgroupToExtendToWholeFragments(sgroup.getType()) && sgroup.findCrossingBonds().length != 0) {
            return false;
        }
        Sgroup parent = sgroup.getParentSgroup();
        boolean isAllowed = parent == null || SgroupValidate.isAllowedDirectEmbedding(type, parent.getType()) && SgroupValidate.isAllowedAncestors(type, parent);
        for (int i = 0; isAllowed && i < sgroup.getChildSgroupCount(); ++i) {
            Sgroup child = sgroup.getChildSgroup(i);
            isAllowed = SgroupValidate.isAllowedDirectEmbedding(child.getType(), type) && SgroupValidate.isAllowedDescendants(type, child);
        }
        return isAllowed;
    }
}

