/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.modules;

import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.modules.RectangleSM;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MTextBox;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TextBoxSM
extends RectangleSM {
    private static final long serialVersionUID = 7100978795783445200L;
    private transient MTextBox textBox = (MTextBox)this.getMObject();
    private boolean selectingText;

    public TextBoxSM() {
        super(new MTextBox());
        this.textBox.setTOption(1);
    }

    public TextBoxSM(TextBoxSM so) {
        super(so);
    }

    @Override
    public void initMObject(MObject o) {
        super.initMObject(o);
        this.textBox = (MTextBox)o;
    }

    public MTextBox getTextBox() {
        return this.textBox;
    }

    @Override
    public Object clone() {
        return new TextBoxSM(this);
    }

    @Override
    public int buttonDown(boolean dblClick, int modifiers) {
        DPoint3 ptr;
        int i;
        MolEditor med = this.getEditor();
        MTextBox t = med.getFocusedMTextBox();
        if (t != null && (i = t.determinePosition(ptr = med.getPointerPos(), false)) >= 0) {
            t.setCursorPos(i, false);
            this.selectingText = true;
            return 1;
        }
        DPoint3 scrptrpos = med.getScreenPointerPos();
        MObject mo = med.findObjectAt(scrptrpos.x, scrptrpos.y, new double[1]);
        if (t != mo && mo != null && mo instanceof MTextBox) {
            t = (MTextBox)mo;
            med.setFocus(t);
            DPoint3 ptr2 = med.getPointerPos();
            int i2 = t.determinePosition(ptr2, false);
            if (i2 >= 0) {
                t.setCursorPos(i2, false);
                this.selectingText = true;
                return 1;
            }
        }
        return super.buttonDown(dblClick, modifiers);
    }

    @Override
    public int buttonUp(int modifiers, boolean doHist) {
        DPoint3 ptr;
        int i;
        MolEditor med = this.getEditor();
        MTextBox t = med.getFocusedMTextBox();
        if (t != null && this.selectingText && (i = t.determinePosition(ptr = med.getPointerPos(), false)) >= 0) {
            t.setCursorPos(i, true);
            this.selectingText = false;
            return 1;
        }
        int ret = super.buttonUp(modifiers, doHist);
        if (ret == 0) {
            MPoint p = med.getMPointerPos(false);
            if (this.startPoint != null && this.clickPoint != null && p.equals(this.clickPoint)) {
                this.startPoint = null;
                this.clickPoint = null;
                this.setCorners(p, p);
                t = (MTextBox)this.newRectangle();
                t.setAutoSize(true);
                this.addObject(t);
                return 2;
            }
        }
        return ret;
    }

    @Override
    public boolean pointerMove(int modifiers) {
        return true;
    }

    @Override
    public boolean pointerDrag(int modifiers) {
        DPoint3 ptr;
        int i;
        MolEditor med = this.getEditor();
        MTextBox t = med.getFocusedMTextBox();
        if (t != null && this.selectingText && (i = t.determinePosition(ptr = med.getPointerPos(), true)) >= 0) {
            t.setCursorPos(i, true);
            return true;
        }
        return super.pointerDrag(modifiers);
    }

    @Override
    public boolean pointerCopyDrag(int modifiers) {
        return true;
    }

    @Override
    protected void addObject(MObject o) {
        super.addObject(o);
        MolEditor med = this.getEditor();
        med.setFocus(o);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize sketcher object with future version (" + version + ")");
        }
        this.textBox = (MTextBox)this.getMObject();
    }
}

