/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import chemaxon.marvin.sketch.swing.Scheduler;
import chemaxon.marvin.sketch.swing.SketchModuleLoaderTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScheduledLoader
extends Thread {
    private static final long DEFAULT_DELAY = 5L;
    private final long delay;
    private Scheduler scheduler = null;
    private static Vector<String> cachedModules = new Vector();

    public ScheduledLoader() {
        this(5L);
    }

    public ScheduledLoader(long delay) {
        this(delay, 5);
    }

    public ScheduledLoader(long delay, int priority) {
        super("ScheduledLoader");
        this.delay = delay;
        this.setPriority(priority);
        this.setDaemon(true);
    }

    public void setScheduler(Scheduler s) {
        this.scheduler = s;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException ignored) {
            return;
        }
        String modname = null;
        while ((modname = this.scheduler.pollFromHighest()) != null) {
            Runnable task;
            if (cachedModules.contains(modname) || (task = SketchModuleLoaderTask.getTask(modname)) == null) continue;
            cachedModules.add(modname);
            try {
                task.run();
                Thread.yield();
            }
            catch (Throwable t) {
                Logger.getLogger(ScheduledLoader.class.getName()).log(Level.WARNING, "Failed to run task: " + task, t);
            }
            if (!Thread.interrupted()) continue;
            return;
        }
    }
}

