/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import java.util.LinkedList;

public class Scheduler {
    private final LinkedList<String> highqueue;
    private final LinkedList<String> lowqueue = new LinkedList();

    public Scheduler() {
        this(false);
    }

    public Scheduler(boolean priority) {
        this.highqueue = priority ? new LinkedList() : null;
    }

    public boolean isPriority() {
        return this.highqueue != null;
    }

    public synchronized void putHigher(String elem) {
        if (!this.highqueue.contains(elem)) {
            this.highqueue.add(elem);
            this.lowqueue.remove(elem);
        }
    }

    public synchronized void put(String elem) {
        if (!(this.highqueue != null && this.highqueue.contains(elem) || this.lowqueue.contains(elem))) {
            this.lowqueue.add(elem);
        }
    }

    public synchronized String pollFromHighest() {
        if (this.highqueue != null && !this.highqueue.isEmpty()) {
            return this.highqueue.poll();
        }
        return this.lowqueue.poll();
    }
}

