/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.formats.MolExporter;
import chemaxon.license.LicenseException;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.MolCanvas;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.SketchChangeEvent;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.ZoomModel;
import chemaxon.marvin.swing.ExportGraphics;
import chemaxon.marvin.swing.MDialogProgressMonitor;
import chemaxon.marvin.swing.SaveImageTool;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.StereoConstants;
import chemaxon.util.ImageExportUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Properties;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public final class SketchCanvas
extends MolCanvas
implements MouseListener,
MouseMotionListener,
PropertyChangeListener,
StereoConstants,
MouseWheelListener,
CallbackIface {
    private static final long serialVersionUID = -6133440285863686988L;
    private static final int MAX_COMPLETIONS = 16;
    private final MolEditor medit;
    private SketchPanel sketchPanel;
    private transient JPopupMenu currentPopup = null;
    private boolean popdown = false;
    private boolean ctrlKeyPress = false;
    private boolean notCopy = false;
    private boolean isViewRotated = false;
    private Dimension prefsize = new Dimension(430, 350);
    private Rectangle keyboardInputRect = new Rectangle(0, 0, 0, 0);

    SketchCanvas(SketchPanel mpan) {
        this.sketchPanel = mpan;
        MolPainter painter = new MolPainter(mpan.painterCommon, 0.0, 0.0, 0.0, 0.0);
        painter.setScale(mpan.getScale());
        this.medit = new MolEditor(painter, this);
        mpan.addPropertyChangeListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    void stop() {
        this.currentPopup = null;
    }

    void setMol(Molecule m) {
        this.medit.setMol(m);
        MDocument doc = m.getDocument();
        Object scale = null;
        if (doc != null) {
            this.medit.getPainter().setRTransformFromDocument(doc);
            scale = doc.properties().getObject("scale");
        }
        if (this.sketchPanel != null) {
            UserSettings settings = this.sketchPanel.getUserSettings();
            if (scale != null && settings != null && settings.getSaveLoadZoomFactorToMRV()) {
                this.sketchPanel.setScale((Double)scale);
            }
            this.sketchPanel.setScrollbars(true);
        }
        this.repaint();
    }

    public MolEditor getEditor() {
        return this.medit;
    }

    double getAtomSize() {
        return this.medit.getAtomSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAtomAndBondSizes(double l, double w) {
        Object object = this.sketchPanel.getMolPanelLock();
        synchronized (object) {
            MolPainterCommon c = this.sketchPanel.painterCommon;
            c.setBondSpacing(w);
            MolPainter painter = new MolPainter(c, 0.0, 0.0, 0.0, 0.0);
            painter.setBackground(this.sketchPanel.getBackground());
            painter.setScale(this.sketchPanel.getScale());
            painter.setAtomSize(l);
            this.medit.setPainter(painter);
            this.medit.edit(10, l);
            this.medit.edit(11, w);
            this.repaint();
        }
    }

    Molecule getMol() {
        return this.medit.getMol();
    }

    @Override
    public MolPainter getPainter() {
        return this.medit.getPainter();
    }

    void selectAll() {
        this.medit.edit(13);
        this.repaint();
    }

    void mapAtoms(int method) {
        this.medit.edit(method);
        this.medit.edit(25);
        this.repaint();
    }

    void unmapAtoms() {
        this.medit.edit(26);
        this.repaint();
    }

    void setCorner(int x, int y, boolean addToHist) {
        this.medit.setCorner(new Point(x, y), addToHist);
        this.repaint();
    }

    Point getCorner() {
        return this.medit.getCorner();
    }

    void reset() {
        this.medit.edit(12);
        this.sketchPanel.clearKeyin();
        this.repaint();
        if (this.sketchPanel != null) {
            this.sketchPanel.setScrollbars(true);
        }
    }

    void delSel() {
        if (this.medit.hasSelection()) {
            this.medit.edit(20);
            this.reset();
            this.sketchPanel.updateControls();
        }
    }

    boolean isUndoEnabled() {
        return this.medit.isUndoEnabled();
    }

    boolean isRedoEnabled() {
        return this.medit.isRedoEnabled();
    }

    public void undo() {
        if (this.medit.undo()) {
            this.isViewRotated = false;
            double newScale = this.medit.getPainter().getScale();
            this.sketchPanel.setScale(newScale);
            Point corner = this.medit.getCorner();
            int cleanDim = this.medit.getMolDim();
            this.sketchPanel.setCleanDim(cleanDim);
            this.sketchPanel.setScrollbarsAfterUndo(corner, this.medit.getScrollBarVals());
        }
        this.sketchPanel.updateControls();
    }

    void redo() {
        if (this.medit.redo()) {
            double newScale = this.medit.getPainter().getScale();
            this.sketchPanel.setScale(newScale);
            Point corner = this.medit.getCorner();
            int cleanDim = this.medit.getMolDim();
            this.sketchPanel.setCleanDim(cleanDim);
            this.sketchPanel.setScrollbarsAfterUndo(corner, this.medit.getScrollBarVals());
        }
        this.sketchPanel.updateControls();
    }

    Molecule getPiece() {
        return this.medit.getPiece();
    }

    void setSketchMode(SketchMode so, boolean changeSel) {
        SketchMode prev = this.medit.getSketchMode();
        boolean changed = this.medit.edit(changeSel ? 1 : 0, so);
        this.sketchPanel.backToSketching(false);
        if (this.medit.getSketchMode() != prev) {
            this.medit.edit(10);
        }
        this.repaint();
        if (changed) {
            this.medit.invokeSelectionChangedEvent();
            this.sketchPanel.updateControls();
        }
        if (this.sketchPanel != null) {
            this.sketchPanel.updateControls();
            this.sketchPanel.setScrollbars();
            this.sketchPanel.fireChangeEvent(new SketchChangeEvent(this.sketchPanel, 5));
        }
    }

    @Override
    public void paint(Graphics g) {
        this.paintGraphics((Graphics2D)g, this.getSize(), false, 1.0);
    }

    @Override
    public void update(Graphics g) {
        this.paintGraphics((Graphics2D)g, this.getSize(), false, 1.0);
    }

    public void paintGraphics(Graphics2D g, Dimension d, boolean saveImage, double relScale) {
        boolean v = this.popupVisible();
        MolPainter painter = this.medit.getPainter();
        try {
            this.medit.paint(g, d, painter.getCommon().getDispopts(), v, saveImage, relScale);
        }
        catch (SecurityException sex) {
            this.sketchPanel.getErrorDisplay().firewallError(sex, null);
        }
        catch (LicenseException lex) {
            this.sketchPanel.getErrorDisplay().error(lex.getMessage(), lex);
        }
        String keys = this.sketchPanel.getKeyinString();
        if (keys != null && keys.length() != 0) {
            Font f = this.getFont();
            FontMetrics fm = this.getFontMetrics(f);
            g.setFont(this.getFont());
            String[] completions = this.sketchPanel.getKeyinPossibleCompletions();
            int n = completions.length;
            if (n != 0) {
                keys = completions[0].substring(0, keys.length());
            }
            Color fg = painter.getColors().getForeground();
            this.keyboardInputRect.width = 0;
            this.keyboardInputRect.height = 0;
            boolean more = false;
            if (n > 16) {
                n = 15;
                more = true;
            }
            boolean updaterect = true;
            if (n > 0) {
                Color bg = painter.getBackground();
                Color c = new Color((bg.getRed() + fg.getRed()) / 2, (bg.getGreen() + fg.getGreen()) / 2, (bg.getBlue() + fg.getBlue()) / 2);
                g.setColor(c);
                for (int i = 0; i < n; ++i) {
                    String s = completions[i];
                    if (i == 0) {
                        s = keys.concat(s.substring(keys.length()));
                    }
                    this.displayKeyin(s, i, g, fm, updaterect);
                }
                if (more) {
                    this.displayKeyin("...", n, g, fm, updaterect);
                }
                updaterect = false;
            }
            g.setColor(fg);
            this.displayKeyin(keys, 0, g, fm, updaterect);
        }
        if (!this.isEnabled()) {
            Color c = painter.getBackground();
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 180);
            g.setColor(c);
            g.fillRect(0, 0, d.width, d.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(double scale) {
        Object object = this.sketchPanel.getMolPanelLock();
        synchronized (object) {
            double relscale = scale / this.medit.getPainter().getScale();
            Point oldcorner = this.medit.getCorner();
            this.medit.setCorner(new Point(0, 0), false);
            Rectangle rect = this.medit.calcMolBoundingRectangle();
            double w = (double)rect.width * relscale;
            double h = (double)rect.height * relscale;
            Dimension imgsize = new Dimension((int)Math.round(w), (int)Math.round(h));
            Color bgcolor = this.sketchPanel.getMolbg();
            int rgba = bgcolor.getRGB();
            Image[] imgs = SaveImageTool.createBackgroundImages(this, imgsize, rgba, 1);
            Image img = imgs[0];
            if (img != null) {
                Graphics2D g = (Graphics2D)img.getGraphics();
                if (g.getClip() == null) {
                    g.setClip(0, 0, imgsize.width, imgsize.height);
                }
                g.translate((int)Math.round(-relscale * (double)rect.x), (int)Math.round(-relscale * (double)rect.y));
                this.paintGraphics(g, imgsize, true, relscale);
            }
            this.medit.setCorner(oldcorner, true);
            return img;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(Dimension imgsize) {
        Object object = this.sketchPanel.getMolPanelLock();
        synchronized (object) {
            double relscale;
            Point oldcorner = this.medit.getCorner();
            this.medit.setCorner(new Point(0, 0), false);
            Rectangle rect = this.medit.calcMolBoundingRectangle();
            double mx = (double)imgsize.width / (double)rect.width;
            double my = (double)imgsize.height / (double)rect.height;
            if (mx < my) {
                relscale = mx;
                int h = (int)Math.round(mx * (double)rect.height);
                rect.y -= (int)Math.round((double)(imgsize.height - h) / (2.0 * relscale));
            } else {
                relscale = my;
                int w = (int)Math.round(my * (double)rect.width);
                rect.x -= (int)Math.round((double)(imgsize.width - w) / (2.0 * relscale));
            }
            Color bgcolor = this.sketchPanel.getMolbg();
            int rgba = bgcolor.getRGB();
            Image[] imgs = SaveImageTool.createBackgroundImages(this, imgsize, rgba, 1);
            Image img = imgs[0];
            if (img != null) {
                Graphics2D g = (Graphics2D)img.getGraphics();
                g.translate((int)Math.round(-relscale * (double)rect.x), (int)Math.round(-relscale * (double)rect.y));
                this.paintGraphics(g, imgsize, true, relscale);
            }
            this.medit.setCorner(oldcorner, true);
            return img;
        }
    }

    public double[] getBoundRectSize() {
        double[] borders = this.medit.calcMolBoundsInMolCoords();
        DPoint3 point1 = new DPoint3(borders[0], borders[1], borders[2]);
        DPoint3 point2 = new DPoint3(borders[3], borders[4], borders[5]);
        MolPainter painter = this.medit.getPainter();
        painter.calcGP(point1);
        painter.calcGP(point2);
        double scale = painter.getScale();
        double[] size = new double[]{(point2.x - point1.x) / scale, (point2.y - point1.y) / scale};
        return size;
    }

    private void displayKeyin(String keys, int i, Graphics g, FontMetrics fm, boolean updaterect) {
        int y = fm.getAscent() + i * fm.getHeight();
        g.drawString(keys, 0, y);
        if (updaterect) {
            int w = fm.stringWidth(keys);
            int h = y + fm.getDescent();
            if (this.keyboardInputRect.width < w) {
                this.keyboardInputRect.width = w;
            }
            if (this.keyboardInputRect.height < h) {
                this.keyboardInputRect.height = h;
            }
        }
    }

    void repaintKeyinString() {
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        String[] completions = this.sketchPanel.getKeyinPossibleCompletions();
        String keys = this.sketchPanel.getKeyinString();
        if (completions.length != 0) {
            keys = completions[0].substring(0, keys.length());
        }
        int w = fm.stringWidth(keys);
        for (int i = 0; i < completions.length; ++i) {
            int ww;
            String s = completions[i];
            if (i == 0) {
                s = keys.concat(s.substring(keys.length()));
            }
            if ((ww = fm.stringWidth(s)) <= w) continue;
            w = ww;
        }
        int h = fm.getHeight();
        if (completions.length != 0) {
            h *= completions.length > 16 ? completions.length : 16;
        }
        if (w < this.keyboardInputRect.width) {
            w = this.keyboardInputRect.width;
        }
        if (h < this.keyboardInputRect.height) {
            h = this.keyboardInputRect.height;
        }
        this.repaint(0, 0, w, h);
    }

    void click(long when) {
        DPoint3 ptrPos = this.getPointerPos();
        Point p = this.medit.getPainter().calcGP(ptrPos.x, ptrPos.y, ptrPos.z);
        this.processEvent(new MouseEvent(this, 501, when, 16, p.x, p.y, 0, false));
        this.processEvent(new MouseEvent(this, 502, when, 16, p.x, p.y, 0, false));
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        int mod = ev.getModifiers();
        if (this.getNavMode() != 0 && (mod & 0x10) != 0 && (mod & 3) == 0 && !ev.isPopupTrigger()) {
            this.sketchPanel.backToSketching(true);
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        this.popdown = false;
        this.ctrlKeyPress = false;
        this.notCopy = false;
        this.requestFocusInWindow();
        this.setScreenPointerPos(ev.getX(), ev.getY());
        if (this.popupVisible()) {
            this.currentPopup.setVisible(false);
            this.popdown = true;
            return;
        }
        if (ev.isPopupTrigger() && this.sketchPanel.arePopupMenusEnabled()) {
            this.showPopup(ev);
            return;
        }
        if (ev.getButton() != 1) {
            return;
        }
        if (this.getNavMode() == 0) {
            int ret = this.medit.command(ev.getClickCount() > 1 ? 6 : 5, ev.getModifiers());
            if (ret > 0) {
                this.sketchPanel.setScrollbars();
            }
            this.repaint();
        }
        this.initDrag(ev);
    }

    private void showPopup(MouseEvent ev) {
        JPopupMenu popup = this.sketchPanel.showPopup(ev);
        if (popup != null) {
            this.currentPopup = popup;
        }
    }

    boolean popupVisible() {
        return this.currentPopup != null && this.currentPopup.isVisible();
    }

    public DPoint3 getPointerPos() {
        return this.medit.getPointerPos();
    }

    public boolean setScreenPointerPos(int x, int y) {
        DPoint3 p = this.medit.getPainter().calcMolP(x, y);
        return this.medit.setPointerPos(p);
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        this.setScreenPointerPos(ev.getX(), ev.getY());
        if (this.getNavMode() != 24) {
            this.isViewRotated = false;
        }
        if (this.popdown || this.popupVisible()) {
            return;
        }
        if (ev.isPopupTrigger() && this.sketchPanel.arePopupMenusEnabled()) {
            this.showPopup(ev);
            return;
        }
        if (ev.getButton() != 1) {
            return;
        }
        if (this.getNavMode() == 0) {
            this.medit.command(7, ev.getModifiers());
            this.sketchPanel.setScrollbars(true);
            this.repaint();
            this.sketchPanel.updateControls();
            this.sketchPanel.repaint();
        } else {
            if (this.getNavMode() == 24) {
                this.getEditor().setActualRotate3dPhiX_Y(false);
                if (!this.isViewRotated) {
                    this.getEditor().historize();
                    this.isViewRotated = true;
                } else {
                    this.getEditor().backInHistory();
                    this.getEditor().historize();
                }
            }
            this.sketchPanel.setScrollbars(true);
            this.sketchPanel.setScale(this.getPainter().getScale());
        }
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        this.setScreenPointerPos(ev.getX(), ev.getY());
        this.medit.command(3, ev.getModifiers());
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        this.setScreenPointerPos(ev.getX(), ev.getY());
        this.medit.command(4, ev.getModifiers());
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        Object pntObjNew;
        if (!this.isEnabled()) {
            return;
        }
        if (this.popupVisible()) {
            return;
        }
        Object pntObjOld = this.medit.getObjectAtPointer();
        boolean dirty = this.setScreenPointerPos(ev.getX(), ev.getY());
        if (dirty |= this.medit.command(1, ev.getModifiers()) > 0) {
            this.repaint();
        }
        if (pntObjOld != (pntObjNew = this.medit.getObjectAtPointer())) {
            this.sketchPanel.changeListeners.firePropertyChange("objectAtPointer", pntObjOld, pntObjNew);
            this.sketchPanel.clearKeyin();
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.popupVisible()) {
            return;
        }
        int x = ev.getX();
        int y = ev.getY();
        int nav = this.getNavMode();
        if (nav != 0) {
            MolPainter p = this.getPainter();
            DPoint3 roto = this.calcTransformCenter(nav);
            CTransform3D u = new CTransform3D();
            u.setIdentity();
            if (nav == 32) {
                this.zoomRotate(ev, u, true);
                u.setRotationCenter(roto);
                p.transform(u, true);
            } else if (nav == 8) {
                this.zoomRotate(ev, u, false);
                u.setRotationCenter(roto);
                p.transform(u, true);
            } else if (nav == 16) {
                this.rotZ(ev, u);
                u.setRotationCenter(roto);
                p.transform(u, false);
            } else if (nav == 24) {
                this.rot3D(ev, u);
                u.setRotationCenter(roto);
                p.transform(u, false);
            }
            this.medit.setPointedObject(null);
            this.medit.setSketchMode(this.medit.getSketchMode(), false);
            this.draggedPointerX = x;
            this.draggedPointerY = y;
            this.repaint();
        } else {
            this.doDragging(x, y);
            boolean dirty1 = this.setScreenPointerPos(x, y);
            MolEditor med = this.getEditor();
            if ((med.isCopyDrag(ev.getModifiers()) || this.ctrlKeyPress) && !this.notCopy) {
                this.ctrlOptDrag(x, y);
            }
            if (!this.ctrlKeyPress) {
                this.notCopy = true;
            }
            boolean dirty2 = this.medit.command(2, ev.getModifiers()) > 0;
            this.sketchPanel.setCleanDim(this.medit.getMolDim());
            if (dirty2) {
                this.sketchPanel.setScrollbars();
            }
            if (dirty1 || dirty2) {
                this.repaint();
            }
        }
    }

    private void ctrlOptDrag(int x, int y) {
        MolEditor med = this.getEditor();
        try {
            SketchMode sm = med.ctrlOptDrag(x, y);
            if (sm == null) {
                return;
            }
            this.ctrlKeyPress = true;
            med.setPointedObject(null);
            this.setSketchMode(sm, true);
            this.sketchPanel.pressButton(sm, false);
        }
        catch (SecurityException sex) {
            sex.printStackTrace();
            this.sketchPanel.getErrorDisplay().firewallError(sex, null);
        }
    }

    @Override
    public DPoint3 calcTransformCenter() {
        CTransform3D t = this.getPainter().getRTransformRef();
        DPoint3 q = this.medit.getDocument().calcCenter(t);
        return q;
    }

    public void doDragging(int x, int y) {
        boolean bottom;
        boolean right;
        Dimension size = this.getSize();
        double c = 0.03125;
        int xscroll1 = (int)(c * (double)size.width + 0.5);
        int xscroll2 = (int)((1.0 - c) * (double)size.width + 0.5);
        int yscroll1 = (int)(c * (double)size.height + 0.5);
        int yscroll2 = (int)((1.0 - c) * (double)size.height + 0.5);
        int xp = this.draggedPointerX;
        int scrolldx = 0;
        boolean left = x >= 0 && x < xscroll1 || xp >= 0 && xp < xscroll1;
        boolean bl = right = x >= xscroll2 && x < size.width || xp >= xscroll2 && xp < size.width;
        if (left || right) {
            scrolldx = 5 * (x - xp);
            if (left && scrolldx > 0 || right && scrolldx < 0) {
                scrolldx = 0;
            }
        }
        int yp = this.draggedPointerY;
        int scrolldy = 0;
        boolean top = y >= 0 && y < yscroll1 || yp >= 0 && yp < yscroll1;
        boolean bl2 = bottom = y >= yscroll2 && y < size.height || yp >= yscroll2 && yp < size.height;
        if (top || bottom) {
            scrolldy = 5 * (y - yp);
            if (top && scrolldy > 0 || bottom && scrolldy < 0) {
                scrolldy = 0;
            }
        }
        if (scrolldx != 0 || scrolldy != 0) {
            this.sketchPanel.scroll(scrolldx, scrolldy);
        }
        this.draggedPointerX = x;
        this.draggedPointerY = y;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String name = ev.getPropertyName();
        Object val = ev.getNewValue();
        if (name.equals("scale")) {
            double mag = (Double)val;
            MolPainter painter = this.medit.getPainter();
            if (painter != null) {
                painter.setScale(mag);
                this.repaint();
            }
        }
    }

    void setPrefsize(Dimension d) {
        this.prefsize = d;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefsize;
    }

    void aromatize(int opt) {
        try {
            this.medit.edit(21, opt);
            this.sketchPanel.repaintMols();
            this.sketchPanel.updateControls();
        }
        catch (SecurityException sex) {
            this.sketchPanel.getErrorDisplay().firewallError(sex, null);
        }
    }

    void dearomatize() {
        try {
            this.medit.edit(22, -1);
            this.sketchPanel.repaintMols();
            this.sketchPanel.updateControls();
        }
        catch (SecurityException sex) {
            this.sketchPanel.getErrorDisplay().firewallError(sex, null);
        }
    }

    void hydrogenize(int cmd, boolean add) {
        try {
            this.medit.edit(cmd, add);
            this.sketchPanel.repaintMols();
            this.sketchPanel.updateControls();
        }
        catch (SecurityException sex) {
            this.sketchPanel.getErrorDisplay().firewallError(sex, null);
        }
    }

    void clean(int dim) {
        try {
            final Molecule m = (Molecule)this.medit.getDocument().cloneDocument().getMainMoleculeGraph();
            MDialogProgressMonitor pm = new MDialogProgressMonitor(this.sketchPanel, "Cleaning...");
            String cleanOpts = this.sketchPanel.getCleanOpts(dim);
            if (dim == 2) {
                this.clean2DImpl(m, pm, cleanOpts);
            } else {
                Cleaner.clean(m, dim, cleanOpts, pm);
            }
            SketchCanvas.runInEDT(new Runnable(){

                @Override
                public void run() {
                    SketchCanvas.this.medit.setMol(m);
                    SketchCanvas.this.medit.setDocumentEdited();
                    SketchCanvas.this.sketchPanel.updateControls();
                }
            });
        }
        catch (SecurityException sex) {
            this.sketchPanel.getErrorDisplay().firewallError(sex, null);
        }
        catch (Throwable ex) {
            this.sketchPanel.getErrorDisplay().error("Error in module Clean" + dim + "D", ex);
        }
    }

    private void clean2DImpl(Molecule m, MProgressMonitor pm, String cleanOpts) {
        String options;
        String string = options = this.sketchPanel.getCleanHOption() ? cleanOpts + "H" : cleanOpts;
        if (!this.medit.hasSelection() || this.medit.isAllSelected()) {
            this.medit.getPainter().setIdentityTransform();
        }
        if (!this.partial2DClean(m, options)) {
            Cleaner.clean(m, 2, options, pm);
        }
    }

    private boolean partial2DClean(Molecule m, String cleanOpts) {
        if (this.medit.hasSelection() && !this.isAllAtomSelected()) {
            MoleculeGraph om = this.medit.getDocument().getMainMoleculeGraph().getGraphUnion();
            MoleculeGraph sm = this.medit.getSelectionDocument().getMainMoleculeGraph();
            int[] fixed = new int[om.getAtomCount() - sm.getAtomCount()];
            int j = 0;
            for (int i = 0; i < om.getAtomCount(); ++i) {
                if (sm.indexOf(om.getAtom(i)) != -1) continue;
                fixed[j++] = i;
            }
            return Cleaner.partialClean((MoleculeGraph)m, 2, fixed, cleanOpts);
        }
        Molecule[] clean2DTemplates = this.sketchPanel.getTemplateHandler().getClean2DTemplates();
        if (clean2DTemplates != null && clean2DTemplates.length > 0) {
            return Cleaner.partialClean(m, clean2DTemplates, cleanOpts);
        }
        return false;
    }

    private static void runInEDT(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private boolean isAllAtomSelected() {
        return this.medit.getSelectionMolecule().getAtomCount() == this.medit.getDocument().getMainMoleculeGraph().getGraphUnion().getAtomCount();
    }

    void saveImage() {
        try {
            Dimension d = this.getSize();
            SaveImageTool sit = this.sketchPanel.getSaveImageTool();
            Object[] imgs = sit.createInitialImages(d, this.sketchPanel.getMolbg(), this.medit.getPainter().getScale(), 1);
            Molecule m = this.getMol();
            String mrvSource = "";
            try {
                mrvSource = MolExporter.exportToFormat(m, "mrv");
            }
            catch (IOException e) {
                // empty catch block
            }
            sit.setMolSourceOnImageExport(mrvSource);
            if (sit.getFormat() != null && sit.getFormat().equals("emf") && Environment.MSWINDOWS) {
                boolean success = false;
                boolean tmp = this.sketchPanel.getSaveGlobalGUIProperties();
                this.sketchPanel.setSaveGlobalGUIProperties(true);
                Properties props = ImageExportUtil.mergeProperties(this.sketchPanel.getUserSettings(), this.sketchPanel.getGlobalGUIProperties(), new Rectangle(sit.getImageSize()));
                props.setProperty("transbg", Boolean.toString(sit.isTransparent()));
                this.sketchPanel.setSaveGlobalGUIProperties(tmp);
                String params = ImageExportUtil.createImageExporterParameter(props, "emf", m.getDocument());
                success = ImageExportUtil.generateEMFToFile(mrvSource, params, sit.getImageFile().getAbsolutePath());
                if (success) {
                    this.sketchPanel.setSaveCwdToUserSettings(sit.getImageFile());
                    return;
                }
            }
            if (imgs != null) {
                Graphics2D g;
                double relmag = sit.getMagnification();
                if (imgs[0] instanceof Graphics2D) {
                    g = (Graphics2D)imgs[0];
                } else if (imgs[0] instanceof ExportGraphics) {
                    Object mm = sit.getExportModule();
                    g = ((ExportGraphics)imgs[0]).getGraphics2D((CallbackIface)mm);
                } else {
                    g = (Graphics2D)((Image)imgs[0]).getGraphics();
                }
                boolean oldTransparency = this.medit.getPainter().isTransparent();
                this.medit.getPainter().setTransparent(sit.isTransparent());
                this.paintGraphics(g, d, true, relmag);
                this.medit.getPainter().setTransparent(oldTransparency);
                sit.exportImage(imgs);
                this.sketchPanel.setSaveCwdToUserSettings(sit.getImageFile());
            }
        }
        catch (OutOfMemoryError er) {
            this.sketchPanel.getErrorDisplay().error("Image size error.\nReduce the scale parameter's value.", er);
        }
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("canbeDnDdrag")) {
            if (this.medit.maybeDnDDrag() && !this.popupVisible()) {
                return Boolean.TRUE;
            }
        } else {
            if (method.equals("canbeDnDcopy")) {
                if (this.ctrlKeyPress) {
                    return Boolean.TRUE;
                }
                return null;
            }
            if (method.equals("fireMolPropertyChange")) {
                Molecule[] mols = (Molecule[])arg;
                PropertyChangeSupport p = this.sketchPanel.changeListeners;
                if (p != null) {
                    p.firePropertyChange("mol", mols[0], mols[1]);
                }
            } else if (method.equals("fireSelectionPropertyChange")) {
                PropertyChangeSupport p = this.sketchPanel.changeListeners;
                if (p != null) {
                    p.firePropertyChange("selectionChanged", null, arg.toString());
                    p.firePropertyChange("hasSelection", null, (Object)this.getEditor().hasSelection());
                    p.firePropertyChange("selectionEmpty", null, (Object)(!this.getEditor().hasSelection() ? 1 : 0));
                }
            } else if (method.equals("internalError")) {
                this.sketchPanel.getErrorDisplay().error("Internal error.", (Throwable)arg);
            } else {
                if (method.equals("createMsm")) {
                    Molecule m = (Molecule)arg;
                    return this.sketchPanel.createSM(m);
                }
                if (method.equals("getPanel")) {
                    return this.sketchPanel;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Object lock;
        SketchPanel p = this.sketchPanel;
        Object object = lock = p != null ? p.getMolPanelLock() : new Object();
        synchronized (object) {
            if (this.sketchPanel != null) {
                this.currentPopup = null;
                this.sketchPanel.removePropertyChangeListener(this);
            }
            out.defaultWriteObject();
            if (this.sketchPanel != null) {
                this.sketchPanel.addPropertyChangeListener(this);
            }
        }
    }

    public void setBondFlags(MolBond bond, int flags) {
        int bondIndex = this.medit.indexOf(bond);
        boolean changed = this.medit.abEdit(42, bondIndex, flags);
        if (changed) {
            this.repaint();
        }
        this.sketchPanel.updateControls();
        this.sketchPanel.requestFocus();
    }

    public void alignToBond(MolBond bond, int alignment) {
        int mcmd;
        int bondIndex = this.medit.indexOf(bond);
        if (bondIndex < 0) {
            return;
        }
        if (alignment == 0) {
            mcmd = 13;
        } else if (alignment == 1) {
            mcmd = 14;
        } else {
            throw new IllegalArgumentException("Unknown alignment!");
        }
        this.medit.edit(mcmd, bondIndex);
        this.repaint();
        this.sketchPanel.setScrollbars();
        this.sketchPanel.updateControls();
        this.sketchPanel.requestFocus();
    }

    public void setCharge(MolAtom atom, int c) {
        if (c != atom.getCharge()) {
            int atomIndex = this.medit.indexOf(atom);
            this.medit.abEdit(22, atomIndex, c);
            this.afterAtomAction();
        }
    }

    public void setStereo(MolAtom atom, int c) {
        int atomIndex = this.medit.indexOf(atom);
        this.medit.abEdit(25, atomIndex, c);
        this.afterAtomAction();
    }

    public void setValence(MolAtom atom, int valence) {
        this.medit.abEdit(31, this.medit.indexOf(atom), valence);
        this.afterAtomAction();
    }

    public void setAtomMap(MolAtom atom, int w) {
        int atomIndex = this.medit.indexOf(atom);
        this.medit.abEdit(26, atomIndex, w);
        this.afterAtomAction();
    }

    public void setEnhancedStereo(MolAtom atom, int f) {
        int atomIndex = this.medit.indexOf(atom);
        this.medit.abEdit(30, atomIndex, f);
        this.afterAtomAction();
    }

    public void toggleAtomAttachmentPoint(MolAtom atom) {
        int atomIndex = this.medit.indexOf(atom);
        this.medit.edit(12, atomIndex);
        this.resetControls();
    }

    public void setRGroup(MolAtom atom, int r) {
        int atomIndex = this.medit.indexOf(atom);
        this.medit.abEdit(24, atomIndex, r);
        this.afterAtomAction();
    }

    public void setLigandOrder(MolAtom atom, MolBond bond, int value) {
        this.medit.changeLigandOrder(atom, bond, value);
        this.afterAtomAction();
    }

    public void setReactionStereo(MolAtom atom, int value) {
        int atomIndex = this.medit.indexOf(atom);
        this.medit.abEdit(29, atomIndex, value);
        this.afterAtomAction();
    }

    public void setRadical(MolAtom atom, int r) {
        if (r != atom.getRadical()) {
            int atomIndex = this.medit.indexOf(atom);
            this.medit.abEdit(23, atomIndex, r);
            this.afterAtomAction();
        }
    }

    public void setIsotope(MolAtom atom, int isotope) {
        int atomIndex = this.medit.indexOf(atom);
        try {
            this.medit.abEdit(21, atomIndex, isotope);
        }
        catch (IllegalArgumentException e) {
            this.sketchPanel.getErrorDisplay().error(e.getMessage(), e);
        }
        this.sketchPanel.mbuttonfit();
        this.resetControls();
    }

    public void doBranchAtom(MolAtom atom) {
        int i = this.medit.indexOf(atom);
        if (i >= 0) {
            this.medit.edit(16, i);
            this.sketchPanel.mbuttonfit();
        }
        this.resetControls();
    }

    public void doAddRgroupAttachmentPoint(MolAtom atom) {
        int i = this.medit.indexOf(atom);
        if (i >= 0) {
            this.medit.addRgroupAttachment(atom);
            this.sketchPanel.mbuttonfit();
        }
        this.resetControls();
    }

    public void setLinkNodeMaxRepetition(MolAtom atom, int linkCount) {
        try {
            if (atom != null) {
                int atomIndex = this.medit.indexOf(atom);
                this.medit.abEdit(28, atomIndex, linkCount);
            } else {
                this.medit.createLinkNode(28, -1, linkCount);
            }
        }
        catch (IllegalArgumentException e) {
            this.sketchPanel.getErrorDisplay().error(e.getMessage(), e);
        }
        this.sketchPanel.mbuttonfit();
        this.resetControls();
    }

    private MObject extractObject(MObject object) {
        MObject result = object;
        if (result.isInternalSelectable()) {
            result = this.medit.getContainerMObject(result);
        }
        return result;
    }

    public void showObjectPropertiesDialog(MObject object) {
        this.showObjectPropertiesDialog(new MObject[]{this.extractObject(object)});
    }

    public void showObjectPropertiesDialog(MObject[] objects) {
        CallbackIface c = (CallbackIface)MarvinModule.load("sketch.swing.MObjectPropertiesDialog", this.sketchPanel);
        if (c == null) {
            return;
        }
        c.callback("setSketchPanel", this.sketchPanel);
        c.callback("setMObjects", objects);
        c.callback("show", null);
        this.repaint();
    }

    public void moveObjectToFront(MObject object) {
        this.medit.edit(0, this.extractObject(object), this.medit.getDocument().getObjectCount() - 1);
        this.repaint();
    }

    public void moveObjectToBack(MObject object) {
        this.medit.edit(0, this.extractObject(object), 0);
        this.repaint();
    }

    public void removeObject(MObject object) {
        this.medit.edit(1, object, 0);
        this.sketchPanel.updateControls();
    }

    public void removeBond(MolBond bond) {
        this.medit.edit(11);
        int i = this.medit.indexOf(bond);
        if (i >= 0) {
            this.medit.edit(11, i);
            this.repaint();
        }
        this.sketchPanel.updateControls();
        this.sketchPanel.requestFocus();
    }

    public void doRemoveAtoms(MolAtom[] atoms) {
        this.medit.edit(11);
        for (int i = 0; i < atoms.length; ++i) {
            this.removeAtomImpl(atoms[i]);
        }
        this.sketchPanel.mbuttonfit();
        this.resetControls();
    }

    public void doRemoveAtom(MolAtom atom) {
        this.medit.edit(11);
        this.removeAtomImpl(atom);
        this.sketchPanel.mbuttonfit();
        this.resetControls();
    }

    private void removeAtomImpl(MolAtom atom) {
        int i = this.medit.indexOf(atom);
        this.medit.edit(10, i);
    }

    private void resetControls() {
        this.repaint();
        this.reset();
        this.sketchPanel.updateControls();
        this.sketchPanel.requestFocus();
    }

    private void afterAtomAction() {
        this.repaint();
        this.sketchPanel.mbuttonfit();
        this.sketchPanel.updateControls();
        this.sketchPanel.requestFocus();
    }

    public void setRgroupAttachmentPointOrder(MolAtom atom, int order) {
        this.medit.setRgroupAttachmentPointOrder(atom, order);
        this.afterAtomAction();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if ((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
            ZoomModel model = new ZoomModel(this.sketchPanel);
            if (e.getWheelRotation() < 0) {
                model.zoomIn(e.getX(), e.getY());
            } else {
                model.zoomOut(e.getX(), e.getY());
            }
        } else if (e.isShiftDown()) {
            this.sketchPanel.scrollCanvas(this.sketchPanel.getHScrollBarPos() + e.getWheelRotation() * 20, this.sketchPanel.getVScrollBarPos(), false, false);
        } else {
            this.sketchPanel.scrollCanvas(this.sketchPanel.getHScrollBarPos(), this.sketchPanel.getVScrollBarPos() + e.getWheelRotation() * 20, false, false);
        }
        e.consume();
        this.repaint();
    }
}

