/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import cb.aloe.swing.tools.DockPane;
import chemaxon.calculations.clean.Cleaner;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.license.LicenseManagerGUI;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.DnD;
import chemaxon.marvin.common.swing.MenuBarChangeListener;
import chemaxon.marvin.common.swing.MolButton;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.MoleculeProvider;
import chemaxon.marvin.common.swing.PagesActions;
import chemaxon.marvin.common.swing.spi.PreferencesDialogProvider;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.sketch.AtomPO;
import chemaxon.marvin.sketch.AtomSM;
import chemaxon.marvin.sketch.BondPO;
import chemaxon.marvin.sketch.BondSM;
import chemaxon.marvin.sketch.History;
import chemaxon.marvin.sketch.KeyboardInput;
import chemaxon.marvin.sketch.MObjectPO;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.PointedObject;
import chemaxon.marvin.sketch.RectangleSelectSM;
import chemaxon.marvin.sketch.SgroupPO;
import chemaxon.marvin.sketch.SketchMode;
import chemaxon.marvin.sketch.swing.AbbrevGroupsDialog;
import chemaxon.marvin.sketch.swing.AttachDataDialog;
import chemaxon.marvin.sketch.swing.DialogFactory;
import chemaxon.marvin.sketch.swing.MObjectEditor;
import chemaxon.marvin.sketch.swing.PeriodicSystemDialog;
import chemaxon.marvin.sketch.swing.ScheduledLoader;
import chemaxon.marvin.sketch.swing.Scheduler;
import chemaxon.marvin.sketch.swing.SketchCanvas;
import chemaxon.marvin.sketch.swing.SketchChangeEvent;
import chemaxon.marvin.sketch.swing.SketchChangeListener;
import chemaxon.marvin.sketch.swing.SketchGUIModule;
import chemaxon.marvin.sketch.swing.SketchKeyBindings;
import chemaxon.marvin.sketch.swing.SketchModuleLoaderTask;
import chemaxon.marvin.sketch.swing.SketchStatusBar;
import chemaxon.marvin.sketch.swing.SubstituentMoleculeProvider;
import chemaxon.marvin.sketch.swing.TextEditor;
import chemaxon.marvin.sketch.swing.modules.DockDropTarget;
import chemaxon.marvin.sketch.swing.modules.PubChemDialog;
import chemaxon.marvin.sketch.swing.modules.RadioChooserDialog;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerStatusbarComponent;
import chemaxon.marvin.sketch.swing.templates.TemplateHandler;
import chemaxon.marvin.sketch.swing.templates.TemplatePresentationModel;
import chemaxon.marvin.sketch.templates.Template;
import chemaxon.marvin.uif.aloe.AloeDockHandler;
import chemaxon.marvin.uif.module.ConfigurationException;
import chemaxon.marvin.uif.module.GUIModule;
import chemaxon.marvin.uif.util.swing.AbstractDialog;
import chemaxon.marvin.util.AbbrevGroupCollection;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.ColorSetUtil;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.ErrorDisplay;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.MolLoader;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PageSettings;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RgMoleculeGraphIface;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MNameTextBox;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.util.NetUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;

public class SketchPanel
extends MolPanel
implements MouseListener,
AdjustmentListener,
PreferencesDialogProvider.ServiceContainer,
PreferencesDialogProvider.CheckerContainer,
ComponentListener,
WindowListener,
ChangeListener {
    private static final long serialVersionUID = 4141149488082011428L;
    public static final int TRANSFORMSEL_NONE = -1;
    public static final int TRANSFORMSEL_TRANSLATE = 0;
    public static final int TRANSFORMSEL_ROTZ = 1;
    public static final int TRANSFORMSEL_ROT3D = 2;
    public static final int TRANSFORMSEL_ROT3D_NONE = -1;
    public static final int TRANSFORMSEL_ROT3D_AXIS_ARBRITRARY = 0;
    public static final int TRANSFORMSEL_ROT3D_AXIS_X = 1;
    public static final int TRANSFORMSEL_ROT3D_AXIS_Y = 2;
    public static final int TRANSFORMSEL_ROT3D_AXIS_Z = 3;
    public static final int TRANSFROMSEL_ROT3D_AXIS_FREE = 4;
    public static final int TRANSFROMSEL_ROT3D_AXIS_GROUP = 5;
    public static final double DEFAULT_SCALE = 28.0;
    private static final int EDITOR_MOL = 0;
    private static final int EDITOR_TEXTBOX = 1;
    public static final ResourceBundle RESOURCES;
    private static long total;
    private static long live;
    private SketchCanvas sketchCanvas = null;
    public JPanel mainPanel = null;
    private DockPane dockPane = null;
    private SketchStatusBar theStatusBar = null;
    private transient Object abbrevGroupLock = new Object();
    private transient KeyboardInput keyboardInput;
    private SketchKeyBindings sketchKeyBindings;
    private boolean hasmenubar = true;
    private boolean hasbuttonmenubar = true;
    private boolean hasStatusBar = false;
    private boolean undetachByX = true;
    private JFrame mframe = null;
    private MolButton mbutton = null;
    private MolPainter mpainter = null;
    private boolean periodicSystemEnabled = true;
    private TemplateHandler templateHandler;
    private AbbrevGroupCollection abbrevGroups = null;
    private String abbrevGroupsFile = null;
    private AbbrevGroupCollection[] usrAbbrevGroups = new AbbrevGroupCollection[128];
    private AbbrevGroupCollection allAbbrevGroups = null;
    private boolean abbrevGroupsAllowed = true;
    private JMenuBar currentSketcherMenuBar = null;
    private JMenuBar viewButtonMenuBar = null;
    private MObjectEditor objectEditor = null;
    private MObjectEditor textBoxEditor = null;
    private PeriodicSystemDialog periodicSystemDialog;
    private JScrollBar hscrollbar;
    private JScrollBar vscrollbar;
    private boolean scrlpos;
    private double sketchScale = 0.0;
    private double maxScale = 0.0;
    private double buttonMaxScale = 0.0;
    private int mvindex;
    private JRootPane rootPane;
    private transient DnD sketchDnD = null;
    private CallbackIface rlogicDialog = null;
    private CallbackIface groupCreationDialogHandler = null;
    private List<String> disabledGroupTypes = null;
    private String molLoaderFinishedJs = null;
    private transient long lastExitDialogTime = -1000L;
    private transient int lastExitDialogAnswer = 2;
    private boolean confirmExit = true;
    private static int COPY_DEFAULT;
    private static int COPY_AS_SMILES;
    private SketchGUIModule guiModule;
    private EventListenerList listenerList;
    private SketchChangeEvent changeEvent;
    private boolean toolbarVisible = true;
    private SketchMode lastSelectSM;
    private boolean personalizationEnabled = true;
    private AloeDockHandler dockHandler;
    private String configurationURL = null;
    private String shortcutURL = null;
    private boolean closeEnabled = true;
    private boolean detached;
    private String customizationDirectory;
    private MoleculeProvider moleculeProvider;
    private boolean showTransferDialog;
    private boolean transferButtonVisible;
    private boolean toolbarFloatable = true;
    private static Scheduler bgscheduler;
    private static ScheduledLoader bgloader;
    private static Scheduler preschedule;
    private static ScheduledLoader preloader;
    private Timer configurationSaveTimer;
    private boolean menuChanged;
    private String serializedConfigurationURL = null;
    private boolean isValenceCheckEnabledParameter = true;
    private boolean transferSelection = true;
    private boolean useComponentActions = false;
    private Object saveLock = new Object();

    public SketchPanel(Component parent, int dim, int mvindex, JRootPane rootPane, UserSettings settings) {
        super(parent, settings);
        this.userSettings.setProperty("isSketcher", "true", false);
        ++total;
        ++live;
        this.painterCommon.setDispopts(this.painterCommon.getDispopts() & 0xFFFFFFC7 | 0);
        this.configurationSaveTimer = new Timer(15000, this);
        this.configurationSaveTimer.setRepeats(false);
        this.listenerList = new EventListenerList();
        this.painterCommon.setErrorVisible(true);
        this.sketchCanvas = new SketchCanvas(this);
        this.templateHandler = new TemplateHandler(this);
        this.setCleanDim(dim);
        this.setToolbarVisible(true);
        this.initTransient();
        this.mvindex = mvindex;
        this.rootPane = rootPane;
        this.keyboardInput = new KeyboardInput(this.getEditor(), this);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.mainPanel = new JPanel();
        gbl.setConstraints(this.add(this.mainPanel), gbc);
        this.mainPanel.setLayout(new BorderLayout());
        this.dockPane = new DockPane(1, 0, 0, 0);
        this.sketchCanvas.setFocusable(true);
        this.vscrollbar = new JScrollBar(1);
        this.vscrollbar.addAdjustmentListener(this);
        this.vscrollbar.setFocusable(false);
        this.hscrollbar = new JScrollBar(0);
        this.hscrollbar.addAdjustmentListener(this);
        this.hscrollbar.setFocusable(false);
        JPanel canvpan = new JPanel();
        GridBagLayout cgbl = new GridBagLayout();
        this.initDnD(this.dockPane, canvpan);
        canvpan.setLayout(cgbl);
        GridBagConstraints cgbc = SwingUtil.createTopLeftConstraints();
        cgbc.fill = 1;
        cgbc.gridwidth = 1;
        cgbc.gridheight = 1;
        cgbc.weightx = 1.0;
        cgbc.weighty = 1.0;
        canvpan.add(this.sketchCanvas);
        cgbl.setConstraints(this.sketchCanvas, cgbc);
        cgbc.fill = 3;
        cgbc.gridx = 1;
        cgbc.weightx = 0.0;
        canvpan.add(this.vscrollbar);
        cgbl.setConstraints(this.vscrollbar, cgbc);
        cgbc.fill = 2;
        cgbc.gridheight = 0;
        cgbc.gridx = 0;
        cgbc.gridy = 1;
        cgbc.weightx = 1.0;
        cgbc.weighty = 0.0;
        canvpan.add(this.hscrollbar);
        cgbl.setConstraints(this.hscrollbar, cgbc);
        this.dockPane.setContent((Component)canvpan);
        this.mainPanel.add((Component)this.dockPane, "Center");
        this.mainPanel.add((Component)new JLabel(), "West");
        this.mainPanel.add((Component)new JLabel(), "East");
        this.initBondSM();
        this.addPropertyChangeListener(this);
        this.sketchDnD = null;
        this.getDnD();
        this.sketchCanvas.addMouseListener(this);
        this.sketchCanvas.addComponentListener(this);
        this.setPersonalizationEnbaled(this.shortcutURL == null && this.configurationURL == null);
        this.addMouseListener(this);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SketchPanel.this.changeFocus2Canvas();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        MouseAdapter mlistener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SketchPanel.this.changeFocus2Canvas();
            }
        };
        this.hscrollbar.addMouseListener(mlistener);
        this.vscrollbar.addMouseListener(mlistener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDnD(DockPane pane, JPanel canvpan) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        this.beginHourglass();
        try {
            DockDropTarget f = new DockDropTarget();
            f.callback("init", new Object[]{this, pane, canvpan});
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    private void initBondSM() {
        BondSM sm = new BondSM(this.getEditor(), 1);
        this.setSketchMode(sm, false, false, false, false);
    }

    @Override
    @Deprecated
    public JMenu addToolsMenu(Container parentMenu, Object target) {
        JMenu result = super.addToolsMenu(parentMenu, target);
        if (result != null) {
            this.addServicesMenu(result);
        }
        return result;
    }

    @Override
    public void updateServices() {
        super.updateServices();
    }

    private void setSketchMode(String s) {
        Mode mode = Mode.forName(s);
        if (mode == null) {
            return;
        }
        if (mode != Mode.ATOM && mode != Mode.BOND) {
            Action action = this.getGUIModule().getActions().getAction(mode.getActionID());
            if (action != null) {
                action.actionPerformed(null);
            }
            return;
        }
        int flag = Mode.getFlag(s);
        if (flag == -1) {
            return;
        }
        SketchMode sm = null;
        if (mode == Mode.ATOM) {
            if (flag < 1 || flag > PeriodicSystem.getElementCount()) {
                return;
            }
            sm = new AtomSM(this.getEditor(), new MolAtom(flag));
        } else if (mode == Mode.BOND) {
            sm = new BondSM(this.getEditor(), flag);
        } else {
            return;
        }
        this.setSketchMode(sm, false, false, false, true);
    }

    @Override
    protected final void showPreferencesDialog(PreferencesDialogProvider provider) {
        provider.show(this, this, this);
    }

    private SketchStatusBar getStatusBar() {
        if (this.theStatusBar == null) {
            this.theStatusBar = new SketchStatusBar(this, (SketchGUIModule)this.getGUIModule());
        }
        return this.theStatusBar;
    }

    public MoleculeProvider getMoleculeProvider() {
        return this.moleculeProvider;
    }

    public void setMoleculeProvider(MoleculeProvider provider) {
        MoleculeProvider oldValue = this.moleculeProvider;
        this.moleculeProvider = provider;
        this.firePropertyChange("moleculeProvider", oldValue, provider);
        if (provider != null) {
            this.molLoaded(new Molecule[]{provider.getMolecule(this.mvindex)}, 0L);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.guiModule != null) {
            this.guiModule.updateUI();
        }
    }

    public synchronized void addSketchChangeListener(SketchChangeListener listener) {
        this.listenerList.add(SketchChangeListener.class, listener);
    }

    public synchronized void removeSketchChangeListener(SketchChangeListener listener) {
        this.listenerList.remove(SketchChangeListener.class, listener);
    }

    protected void fireChangeEvent(SketchChangeEvent e) {
        SketchChangeListener[] listeners = (SketchChangeListener[])this.listenerList.getListeners(SketchChangeListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stateChanged(e);
        }
    }

    protected void fireChangeEvent() {
        if (this.changeEvent == null) {
            this.changeEvent = new SketchChangeEvent(this);
        }
        this.fireChangeEvent(this.changeEvent);
    }

    public void doSetStatusBarVisible(boolean val) {
        this.setStatusBarVisible(val);
    }

    public boolean isStatusBarVisible() {
        return this.hasStatusBar;
    }

    public void setStatusBarVisible(boolean val) {
        boolean old = this.hasStatusBar;
        if (val) {
            GridBagLayout gbl = (GridBagLayout)this.getLayout();
            Component c = this.getComponent(this.getComponentCount() - 1);
            GridBagConstraints gbc = gbl.getConstraints(c);
            ++gbc.gridy;
            gbc.fill = 2;
            gbc.weighty = 0.0;
            gbl.setConstraints(this.add(this.getStatusBar()), gbc);
            this.getStatusBar().update();
            this.getStatusBar().setEnabled(this.isEnabled());
            this.getStatusBar().updateUI();
        } else if (this.theStatusBar != null) {
            this.remove(this.getStatusBar());
        }
        this.revalidate();
        this.hasStatusBar = val;
        this.changeListeners.firePropertyChange("statusBarVisible", old, val);
    }

    public void nextSelectionTransformMode() {
        int i;
        if (!this.isSelectionTransformModeEnabled(0)) {
            return;
        }
        int[] modes = new int[]{-1, 0, 1, 2};
        int currentMode = this.getSelectionTransformMode();
        boolean afterCurrent = false;
        for (i = 0; !(i >= modes.length || afterCurrent && this.isSelectionTransformModeEnabled(modes[i])); ++i) {
            afterCurrent = afterCurrent || modes[i] == currentMode;
        }
        this.doSetSelectionMove(modes[i < modes.length ? i : 0]);
    }

    public void doAddNewSubstituent() {
        JDialog dialog = null;
        if (this.getParentDialog() != null) {
            dialog = new JDialog(this.getParentDialog(), false);
        } else if (this.getParentFrame() != null) {
            dialog = new JDialog(this.getParentFrame(), false);
        }
        if (dialog != null) {
            SketchPanel panel = new SketchPanel(this, 2, -1, dialog.getRootPane(), this.getUserSettings());
            panel.setTransferButtonVisible(true);
            panel.init();
            panel.init();
            panel.startstop(false);
            panel.setScrollbars();
            panel.setMoleculeProvider(new SubstituentMoleculeProvider(this, panel, dialog));
            panel.setConfirmExit(false);
            dialog.add(panel);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle(RESOURCES.getString("newSubstituentDialog.title"));
            dialog.pack();
            dialog.setVisible(true);
        }
    }

    @Override
    protected void nextTransformMode() {
    }

    @Override
    protected void checkReadEnableActions(boolean v) {
    }

    @Override
    public String getAppletInfo() {
        return "MarvinSketch ".concat(mver).concat(", (C) 1998-2012 ChemAxon Ltd.");
    }

    @Override
    public String getProgName() {
        return "MarvinSketch";
    }

    @Override
    @Deprecated
    public String getAboutPath() {
        return "";
    }

    @Override
    public String getHelpSetLocation() {
        return "help/sketch_set.hs";
    }

    @Override
    protected String getHelpPropertyName() {
        return "sketchHelp";
    }

    @Override
    protected String getQuickHelpPropertyName() {
        return "sketchQuickHelp";
    }

    @Override
    protected void molInit() throws Throwable {
        Matcher m;
        this.sketchScale = 28.0;
        super.molInit();
        double sr = 0.3;
        double mr = 0.1;
        String s = this.getParameter("customizationEnabled");
        if (s != null) {
            this.setPersonalizationEnbaled(Boolean.parseBoolean(s));
        }
        if ((s = this.getParameter("valenceCheckEnabled")) != null) {
            this.isValenceCheckEnabledParameter = Boolean.parseBoolean(s);
        }
        if ((s = this.getParameter("confirmTransfer")) != null) {
            this.showTransferDialog = Boolean.parseBoolean(s);
        }
        if ((s = this.getParameter("transferButtonVisible")) != null) {
            this.setTransferButtonVisible(Boolean.parseBoolean(s));
        }
        if ((s = this.getParameter("shortcuts")) != null) {
            this.shortcutURL = s;
        }
        if ((s = this.getParameter("menuconfig")) != null) {
            this.configurationURL = s;
        }
        if ((s = this.getParameter("serializedMenuconfig")) != null) {
            this.serializedConfigurationURL = s;
        }
        if ((s = this.getParameter("customizationDirectory")) != null) {
            this.customizationDirectory = s;
        }
        if ((s = this.getParameter("terminalBondDeletionStyle")) != null) {
            this.getEditor().setDeleteRemovesTerminalAtoms(s.equals("withAtom"));
            this.userSettings.setTerminalBondDeletionStyle(s);
        } else {
            this.getEditor().setDeleteRemovesTerminalAtoms(this.userSettings.getTerminalBondDeletionStyle().equals("withAtom"));
        }
        s = this.getParameter("useComponentActions");
        if (s != null) {
            this.useComponentActions = SketchPanel.isTrue(s);
            this.updateModuleActionMap();
        }
        if ((s = this.getParameter("transferSelection")) != null) {
            this.transferSelection = SketchPanel.isTrue(s);
        }
        if ((s = this.getParameter("scale|mag")) != null) {
            this.sketchScale = Double.parseDouble(s);
        }
        if ((s = this.getParameter("maxscale")) != null) {
            this.maxScale = Double.parseDouble(s);
            this.userSettings.setProperty("maxScale", s, false);
        }
        if ((s = this.getParameter("menubar")) != null) {
            this.hasmenubar = SketchPanel.isTrue(s);
            if (this.dockHandler != null) {
                this.dockHandler.setHandleMenuBar(this.hasmenubar);
            }
        }
        if ((s = this.getParameter("buttonmenubar")) != null) {
            this.hasbuttonmenubar = SketchPanel.isTrue(s);
        }
        if ((s = this.getParameter("statusBar")) != null) {
            this.hasStatusBar = SketchPanel.isTrue(s);
            this.setStatusBarVisible(this.hasStatusBar);
        }
        if ((s = this.getParameter("toolbarFloatable")) != null) {
            this.toolbarFloatable = SketchPanel.isTrue(s);
            if (this.guiModule != null) {
                this.guiModule.setToolbarFloatable(this.toolbarFloatable);
            }
        }
        if ((s = this.getParameter("undetachByX")) != null) {
            this.undetachByX = SketchPanel.isTrue(s);
        }
        if ((s = this.getParameter("stickdst")) != null) {
            sr = Double.valueOf(s);
        }
        if ((s = this.getParameter("mergedst")) != null) {
            mr = Double.valueOf(s);
        }
        int undo = 50;
        s = this.getParameter("undo");
        if (s != null) {
            undo = Integer.parseInt(s);
        }
        if ((s = this.getParameter("disabledGroupTypesOnUI")) != null && (m = Pattern.compile(".*([,;:|/\\\\-]).*").matcher(s)).matches() && m.groupCount() > 0) {
            String separator = m.group(1);
            this.disabledGroupTypes = Arrays.asList(s.split(separator));
        }
        this.getEditor().initAllowedElements(this.getParameter("elements"));
        this.getEditor().initAllowedExtraBonds(this.getParameter("extraBonds"));
        this.getEditor().initAllowedQueryAtoms(this.getParameter("queryAtoms"), this.getParameter("anyatom") != null);
        this.getEditor().initAllowedAtomStrings(this.getParameter("atomStrings"));
        s = this.getParameter("reactionSupport");
        if (s != null) {
            this.getEditor().setReactionSupported(SketchPanel.isTrue(s));
        }
        this.sketchCanvas.setAtomAndBondSizes(this.getUserSettings().getAtomSize(), this.getBondSpacing());
        this.setStickdst(sr);
        this.setMergedst(mr);
        this.setUndo(undo);
        double tmp = this.sketchScale;
        this.sketchScale = 0.0;
        this.setScale(tmp);
        s = this.getParameter("moreEnabled");
        if (s != null) {
            this.setPeriodicSystemEnabled(SketchPanel.isTrue(s));
        }
        if (this.applet != null) {
            URL base = this.applet.getCodeBase();
            this.defaultHelpURL = new URL(base, "help/sketch/sketch-index.html");
            this.defaultQuickHelpURL = new URL(base, "help/sketch/sketch.html");
        }
        boolean buttononly = false;
        boolean showwindow = false;
        s = this.getParameter("detach");
        if (s != null) {
            String maxS;
            showwindow = (s = s.toLowerCase()).indexOf("show") != -1;
            this.setDetached(showwindow);
            buttononly = showwindow || s.indexOf("hide") != -1;
            int i = s.indexOf("size=");
            if (i != -1) {
                int j = s.indexOf(120, i += 5);
                int w = Integer.parseInt(s.substring(i, j));
                if ((i = s.indexOf(44, ++j)) == -1) {
                    i = s.length();
                }
                int h = Integer.parseInt(s.substring(j, i));
                this.sketchCanvas.setPrefsize(new Dimension(w, h));
            }
            if ((i = s.indexOf(maxS = "maxscale=")) != -1) {
                this.buttonMaxScale = Double.parseDouble(s.substring(i += maxS.length()));
            }
        }
        if ((s = this.getParameter("autoscale")) != null) {
            this.autoScale = SketchPanel.isTrue(s);
        }
        if ((s = this.getParameter("viewonly")) != null && !SketchPanel.isTrue(s)) {
            this.configurationURL = SketchPanel.class.getResource("viewonly_configuration.xml").toString();
        }
        if ((s = this.getParameter("sketchCarbonVisibility")) != null) {
            this.setCarbonVisibility(s);
        } else {
            this.setCarbonVisibility(this.getDefaultCarbonVisibility());
        }
        s = this.getParameter("sketchLigandOrderVisibility");
        if (s != null) {
            this.setLigandOrderVisibility(s);
        } else {
            this.setLigandOrderVisibility(this.getDefaultLigandOrderVisibility());
        }
        this.abbrevGroupsFile = "/chemaxon/marvin/templates/default.abbrevgroup";
        s = this.getParameter("abbrevgroupsAllowed");
        if (s != null) {
            this.abbrevGroupsAllowed = Boolean.valueOf(s);
        }
        if (this.abbrevGroupsAllowed && (s = this.getParameter("abbrevgroups")) != null) {
            this.abbrevGroupsFile = s;
        }
        this.loadPersonalization();
        this.templateHandler.init();
        this.templateHandler.setProperties();
        this.getGUIModule().bindComponent(this);
        if (this.isPersonalizationSaveEnabled()) {
            this.getDockHandler().addChangeListener(this);
        }
        if (this.hasmenubar) {
            this.getDockHandler().setRootPane(this.rootPane);
            this.currentSketcherMenuBar = this.getGUIModule().getMenuBar();
            if (this.currentSketcherMenuBar != null) {
                this.fireMenuBarChanged(this.currentSketcherMenuBar);
            }
        }
        if ((s = this.getParameter("defaultTool")) != null) {
            this.setSketchMode(s);
        }
        this.setButtonmode(buttononly);
        if (showwindow) {
            this.setWinmode(true);
        }
        this.sketchKeyBindings = new SketchKeyBindings(this, this.keyboardInput, this.textBoxEditor);
        this.validate();
        this.setScrollbars();
    }

    @Override
    protected boolean getDefaultRgroupVisibility() {
        return true;
    }

    public void templateWindowStatusChanged() {
        this.fireChangeEvent();
    }

    public TemplatePresentationModel getTemplatePresentationModel() {
        return this.templateHandler.getTemplatePresentationModel();
    }

    public void addToMyTemplates(Molecule m) {
        this.templateHandler.addToMyTemplates(m);
    }

    public void removeMyTemplate(Template t) {
        this.templateHandler.removeMyTemplate(t);
    }

    public boolean isTemplateWindowVisible() {
        return this.templateHandler != null && this.templateHandler.isTemplateLibraryManagerVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemplateWindowVisible(boolean b) {
        this.beginHourglass();
        try {
            this.templateHandler.setTemplateLibraryManagerVisible(b);
            if (b) {
                this.templateHandler.getTemplateLibraryManager().addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        SketchPanel.this.fireChangeEvent(new SketchChangeEvent(SketchPanel.this, 0));
                    }
                });
            }
            this.fireChangeEvent(new SketchChangeEvent(this, 0));
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    public TemplateHandler getTemplateHandler() {
        return this.templateHandler;
    }

    @Override
    public void setProperties(Properties p) {
        super.setProperties(p);
        p = this.getProperties();
        this.templateHandler.setProperties(p);
        if (this.isLoadingEnabled()) {
            this.startLoadingAbbreviations();
        }
    }

    @Override
    public String getFormat() {
        MDocument doc;
        String f;
        String fmt = super.getFormat();
        if (fmt == null) {
            fmt = "DEFAULT";
        }
        if (fmt.equals("DEFAULT") && (f = (doc = this.sketchCanvas.getEditor().getDocument()).getInputFormat()) != null) {
            return f;
        }
        return fmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.sketchCanvas.undo();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.sketchCanvas.redo();
            this.repaint();
        }
    }

    @Override
    public void molStart() {
        if (this.isLoadingEnabled()) {
            this.startLoadingAbbreviations();
            String s = this.getParameter("molLoaderFinishedEvent");
            if (s != null) {
                this.molLoaderFinishedJs = s;
            }
            if ((s = this.getParameter("mol")) != null) {
                this.startLoader(s, null, 0L, false);
            }
            if (this.getMol() != null && !this.isValenceCheckEnabledParameter) {
                this.getMol().setValenceCheckEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startstop(boolean stopped) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            super.startstop(stopped);
            if (this.sketchCanvas != null && stopped) {
                this.sketchCanvas.stop();
                this.configurationSaveTimer.stop();
                this.savePersonalisation();
                if (preloader != null && preloader.isAlive()) {
                    try {
                        preloader.interrupt();
                    }
                    catch (SecurityException e) {
                        preloader.setPriority(1);
                    }
                }
                if (bgloader != null && bgloader.isAlive()) {
                    try {
                        bgloader.interrupt();
                    }
                    catch (SecurityException e) {
                        bgloader.setPriority(1);
                    }
                }
            }
        }
        if (!stopped && Environment.APPLET) {
            PeriodicSystem.getIsotopeCount();
            String s = this.getParameter("bgloadEnabled");
            boolean bgloadEnabled = true;
            if (s != null) {
                bgloadEnabled = Boolean.getBoolean(s);
            }
            if (bgloadEnabled) {
                SketchPanel.initBgscheduler();
                s = this.getParameter("bgloadPriority");
                if (s != null) {
                    StringTokenizer stk = new StringTokenizer(s, ",");
                    while (stk.hasMoreTokens()) {
                        String nickname = stk.nextToken();
                        String mod = SketchModuleLoaderTask.getModuleByNickname(nickname);
                        bgscheduler.putHigher(mod);
                    }
                }
                SketchPanel.startBackgroundScheduledLoader(bgscheduler);
            }
        }
    }

    private static synchronized void initBgscheduler() {
        if (bgscheduler == null) {
            bgscheduler = new Scheduler(true);
            Collection<String> mods = SketchModuleLoaderTask.getDefaultModulesLoadedBackground();
            for (String m : mods) {
                bgscheduler.put(m);
            }
        }
    }

    private static synchronized void startBackgroundScheduledLoader(Scheduler schedule) {
        if (bgloader == null || !bgloader.isAlive()) {
            bgloader = new ScheduledLoader(6000L, 1);
            bgloader.setScheduler(schedule);
            bgloader.start();
        }
    }

    private static synchronized void initPreloadscheduler() {
        if (preschedule == null) {
            preschedule = new Scheduler();
        }
    }

    private static synchronized void startPreLoader() {
        if (preloader == null || !preloader.isAlive()) {
            preloader = new ScheduledLoader();
            preloader.setScheduler(preschedule);
            preloader.start();
        }
    }

    public void startPreload() {
        String s = this.getParameter("preload");
        if (s != null) {
            SketchPanel.initPreloadscheduler();
            StringTokenizer stk = new StringTokenizer(s, ",");
            while (stk.hasMoreTokens()) {
                String token = stk.nextToken();
                String nickname = SketchModuleLoaderTask.getModuleByNickname(token);
                preschedule.put(nickname);
            }
            SketchPanel.startPreLoader();
        }
    }

    @Override
    public void closeWindows() {
        this.setPeriodicSystemVisible(false);
        super.closeWindows();
    }

    private int showIsSaveDialog() {
        return JOptionPane.showConfirmDialog(this, RESOURCES.getString("exitQuestion"), RESOURCES.getString("exitQuestionTitle"), 1, 3);
    }

    private int showConfirmTransferDialog() {
        return JOptionPane.showConfirmDialog(this, RESOURCES.getString("transferQuestion"), RESOURCES.getString("transferQuestionTitle"), 0, 3);
    }

    public void setConfirmExit(boolean b) {
        this.confirmExit = b;
    }

    public boolean isConfirmExit() {
        return this.confirmExit;
    }

    @Override
    public boolean isExitCanceled() {
        if (this.applet != null || !this.isConfirmExit() || this.getParentMolPanel() != null) {
            return false;
        }
        MolEditor med = this.sketchCanvas.getEditor();
        if (med.isDocumentEdited() && !med.isEmpty()) {
            int r = 0;
            if (System.currentTimeMillis() - this.lastExitDialogTime >= 100L && this.lastExitDialogAnswer > 1) {
                r = this.showIsSaveDialog();
                this.lastExitDialogTime = System.currentTimeMillis();
                this.lastExitDialogAnswer = r;
                if (r == 1) {
                    return false;
                }
                if (r == 0) {
                    this.saveMolfile(this.getFile(), null, "save", med.getMol(), med.getPainter(), false, false);
                    if (this.isSavedBeforeExit) {
                        return false;
                    }
                    this.lastExitDialogAnswer = 2;
                    return true;
                }
                return true;
            }
            return this.lastExitDialogAnswer == 2;
        }
        return false;
    }

    @Override
    public void destroy() {
        this.removePropertyChangeListener(this.sketchCanvas);
        if (this.applet != null) {
            this.applet.removeKeyListener(this);
            this.rootPane = null;
            this.applet = null;
        }
        super.destroy();
        if (this.guiModule != null) {
            if (this.dockHandler != null) {
                this.dockHandler.dispose();
            }
            this.guiModule.dispose();
        }
    }

    @Override
    public void exit() {
        this.exit(true);
    }

    @Override
    public void exit(boolean destroy) {
        this.setEditorMode(0);
        UserSettings settings = this.getUserSettings();
        if (this.getCleanDim() == 3) {
            settings.setSketchMolbg3d(this.getMolbg());
        } else {
            settings.setSketchMolbg2d(this.getMolbg());
        }
        if (this.colorSchemeChangedFromGUI) {
            settings.setSketchColorScheme(this.getColorScheme());
        }
        settings.setSketchImplicitH(this.getImplicitH());
        this.removeMouseListener(this);
        super.exit(destroy);
    }

    @Override
    public void paint(Graphics g) {
        this.validate();
        super.paint(g);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.markMenuDirty();
        this.configurationSaveTimer.restart();
    }

    @Override
    public void windowOpened(WindowEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void windowClosing(WindowEvent ev) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            Object o = ev.getSource();
            if (o == this.mframe) {
                this.setWinmode(false);
                if (this.undetachByX && this.canDockWindowSketcher()) {
                    this.setButtonmode(false);
                }
                if (this.applet != null) {
                    this.exit(false);
                }
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent ev) {
    }

    @Override
    public void windowIconified(WindowEvent ev) {
    }

    @Override
    public void windowDeiconified(WindowEvent ev) {
    }

    @Override
    public void windowActivated(WindowEvent ev) {
    }

    @Override
    public void windowDeactivated(WindowEvent ev) {
    }

    public void closeRlogicDialog(Window w) {
        this.unregWindow(w);
        this.rlogicDialog = null;
    }

    public void closeGroupCreationDialog(Window w) {
        this.unregWindow(w);
        this.updateControls();
        this.doSetSelectionMove(-1);
        this.sketchCanvas.repaint();
    }

    public void closeAttachDataDialog(Window w) {
        this.unregWindow(w);
        this.updateControls();
        this.sketchCanvas.repaint();
    }

    public void doNew() {
        MolEditor med = this.getEditor();
        med.edit(21);
        med.edit(13, false);
        MDocument doc = med.getDocument();
        if (doc != null) {
            PageSettings ps = doc.getPageSettings();
            Molecule molecule = med.getMol();
            if (molecule != null) {
                molecule.setName("");
                for (int i = 0; i < molecule.getPropertyCount(); ++i) {
                    String key = molecule.getPropertyKey(i);
                    molecule.setProperty(key, null);
                }
            }
            if (ps.isMultiPageEnabled()) {
                ps.reset();
                if (this.hasStatusBar) {
                    this.getStatusBar().update();
                }
            }
        }
        if (this.getMol() != null && !this.isValenceCheckEnabledParameter) {
            this.getMol().setValenceCheckEnabled(false);
        }
        this.hscrollbar.setEnabled(false);
        this.vscrollbar.setEnabled(false);
        this.sketchCanvas.repaint();
        this.mbuttonfit();
        this.updateControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doOpen() {
        this.beginHourglass();
        try {
            this.openMolfile(null, null);
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    public void doOpenImage() {
        JFileChooser jfc = new JFileChooser(this.userSettings.getSketchLoadWorkingDir());
        jfc.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "PS and PDF files (*.ps, *.pdf)";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName();
                return filename.endsWith(".ps") || filename.endsWith(".pdf");
            }
        });
        jfc.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "Image files (*.bmp, *.png, *.jpg, *.gif, *.svg)";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName();
                return filename.endsWith(".bmp") || filename.endsWith(".jpg") || filename.endsWith(".jpeg") || filename.endsWith(".png") || filename.endsWith(".gif") || filename.endsWith(".svg");
            }
        });
        if (jfc.showOpenDialog(this) == 0) {
            this.userSettings.setSketchLoadWorkingDir(jfc.getSelectedFile().getAbsolutePath());
        }
        try {
            if (jfc.getSelectedFile() != null) {
                MolImporter importer = new MolImporter(new FileInputStream(jfc.getSelectedFile()));
                Molecule mol = importer.read();
                if (mol.getDim() == 0) {
                    Cleaner.clean(mol, 2, null);
                }
                this.setMol(mol, false);
                importer.close();
            }
        }
        catch (IOException e) {
            this.getErrorDisplay().error(e.getMessage(), e);
            e.printStackTrace();
        }
    }

    public void doOpenWithChemicalizeOrg() {
        if (this.getMol() == null || this.getMol().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Can not search empty molecule in Chemicalize");
            return;
        }
        AbstractDialog dialog = null;
        ArrayList<String> options = new ArrayList<String>();
        options.add("Exact search (with properties)");
        options.add("Substructure search");
        options.add("Similarity search (>50%)");
        if (this.getParentDialog() != null) {
            dialog = new RadioChooserDialog(null, options, this.getParentDialog(), "Search in chemicalize.org", true);
        } else if (this.getParentFrame() != null) {
            dialog = new RadioChooserDialog(null, options, this.getParentFrame(), "Search in chemicalize.org", true);
        }
        if (dialog != null) {
            dialog.open();
            if (!dialog.isCanceled()) {
                int result = ((RadioChooserDialog)dialog).getSelectedIndex();
                String molstr = "";
                try {
                    molstr = MolExporter.exportToFormat(this.getMol(), "smiles");
                }
                catch (IOException e) {
                    // empty catch block
                }
                String urlForChmicalize = result == 0 ? "http://www.chemicalize.org/?mol=" + molstr + "&source=marvin" : (result == 1 ? "http://www.chemicalize.org/search/#m=" + molstr + "/t=s/h=0" : "http://www.chemicalize.org/search/#m=" + molstr + "/t=t/h=0");
                try {
                    NetUtil.openURL(urlForChmicalize);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "Error during opening chemicalize.org in default browser");
                    e.printStackTrace();
                }
            }
        }
    }

    public void doOpenWithPubChem() {
        block15: {
            if (this.getMol() == null || this.getMol().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Can not search empty molecule in PubChem");
                return;
            }
            try {
                String query;
                PubChemDialog pcd = null;
                if (this.getParentDialog() != null) {
                    pcd = new PubChemDialog(this.getParentDialog(), "Search in PubChem", true);
                } else if (this.getParentFrame() != null) {
                    pcd = new PubChemDialog(this.getParentFrame(), "Search in PubChem", true);
                } else {
                    JOptionPane.showMessageDialog(this, "Error during opening PubChem in default browser");
                    return;
                }
                pcd.open();
                if (pcd.isCanceled()) break block15;
                String molstr = "";
                try {
                    molstr = MolExporter.exportToFormat(this.getMol(), "smiles");
                }
                catch (IOException e) {
                    // empty catch block
                }
                switch (pcd.getChoice()) {
                    case 0: {
                        query = "http://pubchem.ncbi.nlm.nih.gov/search/search.cgi?cmd=search&q_type=dt&q_data=" + molstr + "&simp_schtp=fs";
                        break;
                    }
                    case 1: {
                        query = "http://pubchem.ncbi.nlm.nih.gov/search/search.cgi?cmd=search&q_type=dt&q_data=" + molstr + "&simp_schtp=" + pcd.getPercentage();
                        break;
                    }
                    case 2: {
                        query = "http://pubchem.ncbi.nlm.nih.gov/search/search.cgi?cmd=search&q_type=dt&q_data=" + molstr + "&simp_schtp=subsch";
                        break;
                    }
                    case 3: {
                        query = "http://pubchem.ncbi.nlm.nih.gov/search/search.cgi?cmd=search&q_type=dt&q_data=" + molstr + "&simp_schtp=supsch";
                        break;
                    }
                    default: {
                        query = "http://pubchem.ncbi.nlm.nih.gov/search/search.cgi?cmd=search&q_type=dt&q_data=" + molstr + "&simp_schtp=fs";
                    }
                }
                NetUtil.openURL(query);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error during opening PubChem in default browser");
                e.printStackTrace();
            }
        }
    }

    public void doOpenWithChemSpider() {
        if (this.getMol() == null || this.getMol().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Can not search empty molecule in ChemSpider");
            return;
        }
        try {
            String molstr = "";
            try {
                molstr = MolExporter.exportToFormat(this.getMol(), "smiles");
            }
            catch (IOException e) {
                // empty catch block
            }
            String data = URLEncoder.encode("query", "UTF-8") + "=" + URLEncoder.encode(molstr, "UTF-8");
            data = data + "&" + URLEncoder.encode("token", "UTF-8") + "=" + URLEncoder.encode("02760f43-e501-41ee-9fa7-5efdfeaf7c9f", "UTF-8");
            String hostname = "www.chemspider.com";
            int port = 80;
            InetAddress addr = InetAddress.getByName(hostname);
            Socket socket = new Socket(addr, port);
            String path = "/Search.asmx/SimpleSearch";
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
            wr.write("POST " + path + " HTTP/1.0\r\n");
            wr.write("Content-Length: " + data.length() + "\r\n");
            wr.write("Content-Type: application/x-www-form-urlencoded\r\n");
            wr.write("\r\n");
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String line = null;
            boolean found = false;
            while (!found && (line = rd.readLine()) != null) {
                if (!line.startsWith("<ArrayOfInt")) continue;
                found = true;
            }
            if (found) {
                line = rd.readLine();
                if (line != null && line.startsWith("  <int>")) {
                    int id = Integer.parseInt(line.substring(7, line.length() - 6));
                    NetUtil.openURL("http://www.chemspider.com/Chemical-Structure." + id + ".html");
                } else {
                    JOptionPane.showMessageDialog(this, "Can not find structure in ChemSpider");
                }
            } else {
                JOptionPane.showMessageDialog(this, "Can not find structure in ChemSpider");
            }
            wr.close();
            rd.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error during opening ChemSpider in default browser");
            e.printStackTrace();
        }
    }

    public void doTransfer() {
        if (this.isCloseEnabled()) {
            this.doCloseImpl(true);
        } else {
            this.transfer(true);
        }
        this.forwardEvent("transfer");
    }

    public void doClose() {
        this.doCloseImpl(false);
        this.forwardEvent("close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCloseImpl(boolean transfer) {
        this.beginHourglass();
        try {
            if (!this.isExitCanceled()) {
                this.setWinmode(false, transfer);
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    private void forwardEvent(String command) {
        JMenuItem menu = new JMenuItem();
        menu.setName(command);
        this.fireActionEvent(new ActionEvent(menu, 1001, command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave() {
        MolEditor med = this.sketchCanvas.getEditor();
        this.beginHourglass();
        try {
            this.saveMolfile(null, null, "save", med.getMol(), med.getPainter(), false);
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSaveAs() {
        MolEditor med = this.getEditor();
        this.beginHourglass();
        try {
            this.saveMolfile(null, null, "saveAs", med.getMol(), med.getPainter(), false);
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    public void doPrint() {
        this.beginHourglass();
        Thread thread = new Thread(){

            @Override
            public void run() {
                SketchPanel.this.startPrint();
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUndo() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.sketchCanvas.undo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRedo() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.sketchCanvas.redo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCut() {
        this.beginHourglass();
        try {
            this.clipboardOp(3);
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDeleteSelection() {
        this.beginHourglass();
        try {
            Object object = this.getMolPanelLock();
            synchronized (object) {
                this.sketchCanvas.delSel();
                this.sketchCanvas.reset();
                this.mbuttonfit();
            }
        }
        catch (SecurityException sex) {
            sex.printStackTrace();
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSelectAll() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.pressButton(false);
            this.sketchCanvas.selectAll();
        }
        this.updateSketcherMenus();
    }

    public void doHflip() {
        this.doFlip(16);
    }

    public void doVflip() {
        this.doFlip(17);
    }

    public void doGroupFlip() {
        this.doFlip(30);
    }

    public void doCanvasFlip() {
        this.doFlip(31);
    }

    private void doFlip(int cmd) {
        this.getEditor().edit(cmd);
        this.sketchCanvas.repaint();
        this.mbuttonfit();
    }

    public void doMirror(int cmd) {
        this.getEditor().edit(cmd);
        this.sketchCanvas.repaint();
        this.mbuttonfit();
    }

    public void doDirected3DMerge() {
        this.backToSketching(false);
        boolean merged = this.getEditor().edit(35);
        if (merged) {
            SketchMode selsm = this.getLastSelectSM();
            this.setSketchMode(selsm, false, false, false, true);
            this.doSetSelection3DRotationMode(5);
            this.repaint();
        }
    }

    public void doPlane3D() {
        this.backToSketching(false);
        this.getEditor().edit(34);
        this.sketchCanvas.repaint();
    }

    public void doAlign(int cmd) {
        this.getEditor().edit(cmd);
        this.setScrollbars();
        this.sketchCanvas.repaint();
        this.mbuttonfit();
    }

    public void doDistribute(int cmd) {
        this.getEditor().edit(cmd);
        this.sketchCanvas.repaint();
        this.mbuttonfit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCreateGroup(int group_type) {
        MolEditor med = this.getEditor();
        this.beginHourglass();
        try {
            CallbackIface f = this.groupCreationDialogHandler;
            if (f == null) {
                f = (CallbackIface)MarvinModule.load("sketch.swing.GroupCreationDialog", this);
                f.callback("setSketchPanel", this);
                this.groupCreationDialogHandler = f;
            }
            f.callback("groupType", group_type);
            f.callback("mode", "create");
            f.callback("show", med.getMol());
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    public void doEditSgroup(Object ppo) {
        this.doSgroupAction("editSgroup", ppo);
    }

    public void doMergeBrackets() {
        MolEditor med = this.getEditor();
        med.mergeBrackets();
        this.sketchCanvas.repaint();
    }

    @Override
    public void doExpandSgroup(Object ppo) {
        this.doSgroupAction("expandSgroup", ppo);
    }

    @Override
    public void doContractSgroup(Object ppo) {
        this.doSgroupAction("contractSgroup", ppo);
    }

    public void doUngroupSgroup(Object ppo) {
        this.doSgroupAction("ungroupSgroup", ppo);
    }

    public void doRemoveSgroup(Object ppo) {
        this.doSgroupAction("removeSgroup", ppo);
    }

    private void doSgroupAction(String cmd, Object target) {
        PointedObject ppo = (PointedObject)target;
        MolEditor med = this.getEditor();
        Molecule mol = med.getMol();
        Sgroup sgroup = null;
        if (ppo != null) {
            SgroupPO spo = med.getSgroupPO();
            if (spo != null) {
                sgroup = spo.getSgroup();
            }
            if (spo == null && ppo instanceof BondPO) {
                spo = med.getSgroupPOfor((BondPO)ppo);
                sgroup = spo.getSgroup();
            }
            if (spo == null && ppo instanceof AtomPO) {
                sgroup = this.getMol().findSgroupOf(((AtomPO)ppo).getAtom());
            }
            if (ppo instanceof AtomPO) {
                MolAtom atom = ((AtomPO)ppo).getAtom();
                if (atom instanceof SgroupAtom) {
                    sgroup = ((SgroupAtom)atom).getSgroup();
                }
            } else if (ppo instanceof SgroupPO) {
                sgroup = ((SgroupPO)ppo).getSgroup();
            }
        }
        if (sgroup != null) {
            int i = mol.indexOf(sgroup);
            if (cmd.equals("contractSgroup")) {
                med.edit(17, i);
            } else if (cmd.equals("expandSgroup")) {
                med.edit(18, i);
            } else if (cmd.equals("ungroupSgroup")) {
                med.edit(19, i);
            } else if (cmd.equals("removeSgroup")) {
                med.edit(20, i);
            } else if (cmd.equals("editSgroup")) {
                this.openEditGroup(sgroup);
            }
        } else if (cmd.equals("ungroupSgroup")) {
            if (med.hasSelection()) {
                mol = med.getMolSelection();
            }
            med.edit(24);
            String inf = mol.getInputFormat();
            if (inf != null && inf.startsWith("peptide")) {
                mol.setInputFormat("mrv");
            }
        } else {
            med.edit(cmd.equals("expandSgroup") ? 23 : 22);
        }
        this.updateSketcherMenus();
        this.sketchCanvas.repaint();
        this.setScrollbars();
        this.mbuttonfit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openEditGroup(Sgroup sgroup) {
        this.beginHourglass();
        try {
            CallbackIface f = this.groupCreationDialogHandler;
            if (f == null) {
                f = (CallbackIface)MarvinModule.load("sketch.swing.GroupCreationDialog", this);
                f.callback("setSketchPanel", this);
                this.groupCreationDialogHandler = f;
            }
            if (sgroup.getType() == 10) {
                if (sgroup.getParentSgroup() != null) {
                    f.callback("edit", sgroup.getParentSgroup());
                }
            } else {
                f.callback("edit", sgroup);
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    public void doAttachData(Object object) {
        Object selObject = this.getEditor().getDataSgroupObject(object);
        int editorAction = object == this.getEditor().getSelectionDocument() && selObject == null ? 12 : 32;
        this.createAttachData(null, selObject, editorAction);
    }

    private void createAttachData(DataSgroup dataSgroup, Object selection, int action) {
        AttachDataDialog dialog = null;
        try {
            DialogFactory df = (DialogFactory)MarvinModule.load("chemaxon.marvin.sketch.swing.modules.attachdatadialog.AttachDataDialogFactoryImpl", this);
            if (df != null) {
                df.setSketchPanel(this);
                dialog = (AttachDataDialog)df.createDialog();
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        if (dialog != null) {
            dialog.setDataSgroup(dataSgroup);
            dialog.setSelection(selection);
            dialog.setEditorAction(action);
            dialog.open();
        }
    }

    public void doEditData() {
        DataSgroup currentDataSgroup = this.getEditor().getDataSgroupObject();
        this.doEditData(currentDataSgroup);
    }

    public void doEditData(DataSgroup currentDataSgroup) {
        this.createAttachData(currentDataSgroup, null, 13);
    }

    public void doDeleteData() {
        this.doDeleteData(this.getEditor().getDataSgroupObject());
    }

    public void doDeleteData(DataSgroup dsg) {
        if (dsg != null) {
            Molecule m = this.getEditor().getMol();
            int i = m.indexOf(dsg);
            this.getEditor().edit(19, i);
            this.updateSketcherMenus();
            this.sketchCanvas.repaint();
        }
    }

    public void doFormat() {
        SelectionMolecule mol;
        MObject[] objects;
        if (this.getEditor().hasSelection()) {
            objects = this.getEditor().getSelectedMObjects();
            mol = this.getEditor().getSelectionMolecule();
        } else {
            objects = this.getEditor().getMObjects();
            mol = null;
        }
        assert (objects != null);
        if (objects.length == 0) {
            this.showFormatMoleculeDialog(mol);
        } else if (mol != null && mol.isEmpty()) {
            this.getCanvas().showObjectPropertiesDialog(objects);
        } else {
            this.showFormatDialog(mol, objects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showFormatDialog(Object molForFormat, MObject[] objs) {
        this.beginHourglass();
        try {
            CallbackIface mm = (CallbackIface)MarvinModule.load("sketch.swing.FormatDialog", this);
            if (mm != null) {
                mm.callback("setSketchPanel", this);
                mm.callback("setMObjects", objs);
                mm.callback("setMolecule", molForFormat);
                mm.callback("show", null);
            }
            this.repaint();
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    public void doFormatMolecule() {
        this.showFormatMoleculeDialog(this.getEditor().hasSelection() ? this.getEditor().getSelectionMolecule() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showFormatMoleculeDialog(Object target) {
        this.beginHourglass();
        try {
            CallbackIface mm = (CallbackIface)MarvinModule.load("sketch.swing.FormatMoleculeDialog", this);
            mm.callback("setSketchPanel", this);
            mm.callback("setMolecule", target);
            mm.callback("show", null);
            this.repaint();
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    public void showAtomPropertyEditorDialog(MolAtom target) {
        try {
            CallbackIface aped = (CallbackIface)MarvinModule.load("sketch.swing.AtomPropertyEditorDialog", this);
            if (aped != null) {
                aped.callback("setSketchPanel", this);
                aped.callback("setAtom", target);
                aped.callback("show", null);
                this.repaint();
            }
        }
        catch (SecurityException e) {
            this.getErrorDisplay().firewallError(e, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMapAtoms(int method) {
        this.beginHourglass();
        try {
            this.sketchCanvas.mapAtoms(method);
            this.fireChangeEvent();
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnmapAtoms() {
        this.beginHourglass();
        try {
            this.sketchCanvas.unmapAtoms();
            this.fireChangeEvent();
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    public void doAbsc() {
        MolEditor med = this.getEditor();
        med.edit(13, true);
        this.updateControls();
    }

    public void doDelabsc() {
        MolEditor med = this.getEditor();
        med.edit(13, false);
        this.updateControls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRlogic() {
        CallbackIface f;
        MolEditor med = this.getEditor();
        this.beginHourglass();
        try {
            f = this.rlogicDialog;
            if (f == null) {
                f = (CallbackIface)MarvinModule.load("sketch.swing.RlogicDialog", this);
                f.callback("setSketchPanel", this);
                this.rlogicDialog = f;
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
            return;
        }
        finally {
            this.endHourglass();
        }
        f.callback("show", med.getMol());
    }

    public void doOpenMView() {
        this.setMarvinViewVisible(false);
    }

    public void doOpenMView3D() {
        this.setMarvinViewVisible(true);
    }

    @Override
    public void doOpenMSpace() {
        try {
            this.openMSpace();
        }
        catch (Throwable th) {
            this.getErrorDisplay().error("Error opening MarvinSpace", th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDocumentSettings() {
        MolEditor med = this.getEditor();
        this.beginHourglass();
        try {
            CallbackIface mm = (CallbackIface)MarvinModule.load("sketch.swing.DocumentSettings", this);
            if (mm != null) {
                mm.callback("setDocument", med.getDocument());
                mm.callback("setSketchPanel", this);
                mm.callback("setSketchCanvas", this.sketchCanvas);
                mm.callback("show", null);
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    public void doFitPageWidth() {
        this.fitPageWidth();
    }

    public void doFitPageHeight() {
        this.fitPageHeight();
    }

    public void doFitPage() {
        this.fitPage(this.getEditor().getDocument().getPageSettings());
    }

    public void doPreviousPage() {
        MolEditor med = this.getEditor();
        this.previousPage(med.getDocument().getPageSettings());
    }

    public void doNextPage() {
        MolEditor med = this.getEditor();
        this.nextPage(med.getDocument().getPageSettings());
    }

    public void doFirstPage() {
        MolEditor med = this.getEditor();
        this.firstPage(med.getDocument().getPageSettings());
    }

    public void doLastPage() {
        MolEditor med = this.getEditor();
        this.lastPage(med.getDocument().getPageSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGoToPageFromMenu() {
        CallbackIface mm;
        MolEditor med = this.getEditor();
        this.beginHourglass();
        try {
            mm = (CallbackIface)MarvinModule.load("common.swing.IntegerDialog", this);
            if (mm != null) {
                mm.callback("setDocument", med.getDocument());
                mm.callback("setSketchPanel", this);
                mm.callback("setSketchCanvas", this.sketchCanvas);
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
            return;
        }
        finally {
            this.endHourglass();
        }
        if (mm != null) {
            mm.callback("show", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFit() {
        CallbackIface mm;
        this.beginHourglass();
        try {
            mm = (CallbackIface)MarvinModule.load("common.swing.Fit", this);
            if (mm != null) {
                mm.callback("setSketchPanel", this);
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
            return;
        }
        finally {
            this.endHourglass();
        }
        if (mm != null) {
            mm.callback("show", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetDetachMode(boolean s) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            JMenuBar menuBar;
            this.setWinmode(s);
            this.setButtonmode(s);
            Container p = this.getParent();
            if (p != null) {
                p.validate();
            }
            if (this.applet != null && (menuBar = this.applet.getJMenuBar()) != null) {
                menuBar.repaint();
            }
            this.setDetached0(s);
        }
    }

    public void doSetToolbarVisible(boolean visible) {
        this.setToolbarVisible(visible);
    }

    public boolean isSelectionTransformModeEnabled(int mode) {
        if (!this.getEditor().hasSelection()) {
            return false;
        }
        int npts = this.getEditor().getSelectedPointCount();
        if (mode == 0) {
            this.getEditor().pntAB(true);
            return npts > 0;
        }
        if (mode == 1) {
            return npts > 1 && this.getEditor().canTransformStructure();
        }
        if (mode == 2) {
            return npts > 1 && this.getEditor().can3DRotateStructure();
        }
        return mode == -1;
    }

    public int getSelectionTransformMode() {
        if (this.getEditor().getMoveMode() == 1) {
            return 0;
        }
        if (this.getEditor().getMoveMode() == 2) {
            return 1;
        }
        if (this.getEditor().getMoveMode() == 3) {
            return 2;
        }
        return -1;
    }

    public void doSetSelectionMove(int i) {
        int moveMode;
        if (i == 0) {
            moveMode = 1;
        } else if (i == 1) {
            moveMode = 2;
        } else if (i == 2) {
            moveMode = 3;
        } else if (i == -1) {
            moveMode = 0;
        } else {
            return;
        }
        this.backToSketching(false);
        this.getEditor().setMoveMode(moveMode, moveMode != 0);
        this.sketchCanvas.repaint();
        this.fireChangeEvent(new SketchChangeEvent(this, 4));
    }

    public boolean isRotation3DTransformModeEnabled(int mode) {
        if (!this.isSelectionTransformModeEnabled(2)) {
            return false;
        }
        if (mode == 5) {
            return this.getEditor().getSelectedPointCount() > 1 && this.getEditor().can3DRotateGroup();
        }
        return true;
    }

    public int getRotation3DTransformMode() {
        if (this.getEditor().get3DRotationMode() == 0) {
            return 0;
        }
        if (this.getEditor().get3DRotationMode() == 1) {
            return 1;
        }
        if (this.getEditor().get3DRotationMode() == 2) {
            return 2;
        }
        if (this.getEditor().get3DRotationMode() == 3) {
            return 3;
        }
        if (this.getEditor().get3DRotationMode() == 4) {
            return 4;
        }
        if (this.getEditor().get3DRotationMode() == 5) {
            return 5;
        }
        return -1;
    }

    public void doSetSelection3DRotationMode(int mode) {
        int rot3DMode;
        if (!this.isRotation3DTransformModeEnabled(mode)) {
            return;
        }
        if (mode == 0) {
            rot3DMode = 0;
            this.showAxisChooserModeInformation(this.getEditor().getSelectedStructureJoinAtoms().size());
        } else if (mode == 1) {
            rot3DMode = 1;
        } else if (mode == 2) {
            rot3DMode = 2;
        } else if (mode == 3) {
            rot3DMode = 3;
        } else if (mode == 4) {
            rot3DMode = 4;
        } else if (mode == 5) {
            int nb = this.getEditor().setRotationAxisPoint();
            rot3DMode = nb == -1 ? this.showAxisChooserDialog() : 5;
        } else if (mode == -1) {
            rot3DMode = -1;
        } else {
            return;
        }
        this.backToSketching(false);
        this.getEditor().setMoveMode(rot3DMode != -1 ? 3 : 0, rot3DMode != -1);
        this.getEditor().set3DRotationMode(rot3DMode, rot3DMode != -1);
        this.sketchCanvas.repaint();
        this.fireChangeEvent(new SketchChangeEvent(this, 6));
    }

    public void invertSelection(boolean arbitary) {
        if (arbitary) {
            JOptionPane.showMessageDialog(this, "Please select the center of the inversion.");
        }
        this.getEditor().edit(14, arbitary);
        this.sketchCanvas.repaint();
        this.updateControls();
    }

    private void showAxisChooserModeInformation(int na) {
        if (na == 0) {
            JOptionPane.showMessageDialog(this, "There is no joining atom in the selected part, therefor no axis is defined for the rotation.\nPlease define axis by selecting two atoms!");
        } else if (na == 1) {
            JOptionPane.showMessageDialog(this, "There is one joining atom in the selected part, this is going to be the first point of the axis of the rotation.\nPlease define the second point of the axis by selecting an atom!");
        } else if (na == 2) {
            JOptionPane.showMessageDialog(this, "There are two joining atoms in the selected part, these are going to be the axis of the rotation.\nPlease start the rotation!");
        }
    }

    private int showAxisChooserDialog() {
        String message = RESOURCES.getString("rotate.axischooser.message");
        String title = RESOURCES.getString("rotate.axischooser.title");
        int[] rotmodes = new int[]{0, 1, 2, 3, 4};
        ArrayList<String> options = new ArrayList<String>();
        for (int i = 0; i < rotmodes.length; ++i) {
            options.add(rotmodes[i], RESOURCES.getString("rotate.axischooser.optionName." + rotmodes[i]));
        }
        AbstractDialog dialog = null;
        if (this.getParentDialog() != null) {
            dialog = new RadioChooserDialog(message, options, this.getParentDialog(), title, true);
        } else if (this.getParentFrame() != null) {
            dialog = new RadioChooserDialog(message, options, this.getParentFrame(), title, true);
        }
        if (dialog != null) {
            dialog.open();
            if (!dialog.isCanceled()) {
                return ((RadioChooserDialog)dialog).getSelectedIndex();
            }
        }
        return -1;
    }

    @Override
    public void doSource() {
        this.doSource(false);
    }

    public void doSourcename() {
        this.doSource(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSource(boolean naming) {
        MolEditor med = this.getEditor();
        this.beginHourglass();
        try {
            this.editSource(med.getDocument(), 0, med.getPainter(), naming);
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCopy() {
        this.beginHourglass();
        try {
            this.clipboardOp(COPY_DEFAULT);
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCopySMILES() {
        this.beginHourglass();
        try {
            this.clipboardOp(COPY_AS_SMILES);
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCopyAs() {
        this.beginHourglass();
        try {
            this.clipboardOp(4);
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPaste() {
        this.beginHourglass();
        try {
            boolean adjustScale = this.getEditor().getMol() == null || this.getEditor().getMol().isEmpty();
            this.clipboardOp(0);
            if (adjustScale) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (SketchPanel.this.getEditor().getMol() instanceof RgMoleculeGraphIface && ((RgMoleculeGraphIface)((Object)SketchPanel.this.getEditor().getMol())).getRgroupCount() > 0) {
                            return;
                        }
                        Rectangle bounds = SketchPanel.this.getEditor().getPainter().getBoundsFor(SketchPanel.this.getEditor().getDocument(), 28.0);
                        Dimension screen = SketchPanel.this.sketchCanvas.getSize();
                        if (bounds.width > screen.width || bounds.height > screen.height) {
                            SketchPanel.this.autoScale();
                        }
                        SketchPanel.this.getEditor().saveScaleToHistory(SketchPanel.this.getScale());
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeLater(r);
                }
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAromatize(boolean v) {
        this.beginHourglass();
        try {
            if (v) {
                this.sketchCanvas.aromatize(this.getUserSettings().getAromatizeMethod());
            } else {
                this.sketchCanvas.dearomatize();
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    @Override
    public void doRegenBonds() {
        this.regenBonds(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doHydrogenize(boolean v) {
        this.beginHourglass();
        try {
            this.sketchCanvas.hydrogenize(11, v);
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    @Override
    public void doClean(int dim) {
        this.cleanActionPerformed(dim, 0);
    }

    public void clean2D() {
        this.cleanActionPerformed(2, 0);
    }

    public void clean3D() {
        this.cleanActionPerformed(3, 0);
    }

    @Override
    public void doClean2dWedgeBonds() {
        Molecule m = this.getMol();
        this.clean2dWedgeBonds(0, m);
    }

    @Override
    protected void showConformers(int icell, Molecule m) {
        try {
            MarvinModule mm = (MarvinModule)MarvinModule.load("view.swing.ShowConformers", new Class[]{Integer.TYPE, Molecule.class, MolPanel.class, ErrorDisplay.class}, new Object[]{icell, m, this, this.errorDisplay}, this);
            mm.modfunc(null);
        }
        catch (ClassNotFoundException ex) {
            this.errorDisplay.error(ex);
        }
        catch (NoSuchMethodException ex) {
            this.errorDisplay.error(ex);
        }
        catch (InstantiationException ex) {
            this.errorDisplay.error(ex);
        }
        catch (IllegalAccessException ex) {
            this.errorDisplay.error(ex);
        }
        catch (InvocationTargetException ex) {
            this.errorDisplay.error(ex);
        }
    }

    @Override
    public void doClean3dSelConf() {
        Molecule m = this.getMol();
        this.clean3dSelConf(0, m);
    }

    @Override
    public void doResetView() {
        MolEditor med = this.sketchCanvas.getEditor();
        MDocument document = med.getDocument();
        int selectedPage = 0;
        if (med.isMultipageEnabled()) {
            selectedPage = document.getPageSettings().getSelectedPage();
        }
        MolPainter painter = med.getPainter();
        painter.resetMolPainter();
        this.sketchCanvas.reset();
        this.keyboardInput.clear();
        this.backToSketching(true);
        painter.setBoundsFor(document);
        this.autoScale();
        this.setScale(28.0);
        this.scrlpos = false;
        this.setScrollbars();
        if (med.isMultipageEnabled()) {
            this.fitPage(document.getPageSettings());
            document.getPageSettings().setSelectedPage(selectedPage);
            this.fitPage(document.getPageSettings());
        }
    }

    @Override
    public void doSaveImage() {
        if (this.showSaveImageFileChooser(3)) {
            this.sketchCanvas.saveImage();
        }
    }

    public void doInsertName() {
        MDocument doc = this.getMol().getDocument();
        int no = doc.getObjectCount();
        MNameTextBox textBox = null;
        for (int i = 0; i < no && textBox == null; ++i) {
            MObject o = doc.getObject(i);
            if (!(o instanceof MNameTextBox)) continue;
            textBox = (MNameTextBox)o;
        }
        if (textBox == null) {
            textBox = new MNameTextBox();
            textBox.setHorizontalAlignment(1);
            this.sketchCanvas.getPainter().alignNameBox(null, this.sketchCanvas.getMol(), textBox);
            doc.addObject(textBox);
        }
        this.getEditor().updateName(this.getMol(), true);
        this.updateNameBox();
        this.getEditor().historize();
        this.sketchCanvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        this.beginHourglass();
        try {
            String cmd = ev.getActionCommand();
            String string = cmd = cmd != null ? cmd : "";
            if (cmd.startsWith("plugin_")) {
                this.pluginActionPerformed(cmd, 0);
            } else if (ev.getSource() == this.configurationSaveTimer) {
                this.savePersonalisation();
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    private void openMSpace() throws Exception {
        CallbackIface msw = this.loadMSpaceViewer("chemaxon.marvin.space.gui.MSpaceFrameViewer");
        Window mspaceViewer = this.getMSpaceViewer(msw);
        msw.callback("setSketchPanel", this);
        mspaceViewer.setVisible(true);
        Molecule mol = this.sketchCanvas.getMol().cloneMolecule();
        Object o = msw.callback("addMoleculeToEmptyCell", mol);
        if (o != null && o instanceof Exception) {
            throw (Exception)o;
        }
    }

    @Override
    public void keyPressed(KeyEvent ev) {
    }

    @Override
    public void keyTyped(KeyEvent ev) {
    }

    @Override
    public void keyReleased(KeyEvent ev) {
    }

    void clearKeyin() {
        this.keyboardInput.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGenerics() {
        this.beginHourglass();
        try {
            DialogFactory df = (DialogFactory)MarvinModule.load("sketch.swing.GenericsDialogFactoryImpl", this);
            if (df != null) {
                df.setSketchPanel(this);
                df.showDialog();
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAbbrevGroups() {
        if (!this.abbrevGroupsAllowed) {
            return;
        }
        Object object = this.abbrevGroupLock;
        synchronized (object) {
            AbbrevGroupCollection vall = new AbbrevGroupCollection();
            for (int i = this.usrAbbrevGroups.length - 1; i >= 0; --i) {
                AbbrevGroupCollection c = this.usrAbbrevGroups[i];
                if (c == null) continue;
                vall.add(c);
            }
            if (this.abbrevGroups != null) {
                vall.add(this.abbrevGroups);
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/chemaxon/marvin/io/formats/vmn/vmn.abbrevgroup")));
                String line = null;
                StringBuilder b = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    b.append(line);
                    b.append("\n");
                }
                vall.add(new AbbrevGroupCollection(b.toString()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.allAbbrevGroups = vall;
            if (this.keyboardInput == null) {
                this.keyboardInput = new KeyboardInput(this.getEditor(), this);
            }
            this.keyboardInput.setAbbrevGroups(this.allAbbrevGroups);
            this.fireChangeEvent(new SketchChangeEvent(this, 3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAbbrevGroups() {
        this.beginHourglass();
        try {
            DialogFactory df = (DialogFactory)MarvinModule.load("sketch.swing.AbbrevGroupsDialogFactoryImpl", this);
            if (df != null) {
                df.setSketchPanel(this);
                AbbrevGroupsDialog agd = (AbbrevGroupsDialog)df.createDialog();
                agd.setNames(this.getAbbreviationNames());
                agd.open();
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAbbreviationNames() {
        LinkedHashSet<String> names = null;
        Object object = this.abbrevGroupLock;
        synchronized (object) {
            AbbrevGroupCollection groups = this.allAbbrevGroups;
            if (groups != null) {
                names = new LinkedHashSet<String>(Arrays.asList(groups.getAbbrevNames()));
            }
        }
        return names != null ? names.toArray(new String[names.size()]) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUserTemplates() {
        Object object = this.abbrevGroupLock;
        synchronized (object) {
            if (this.keyboardInput == null) {
                this.keyboardInput = new KeyboardInput(this.getEditor(), this);
            }
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                SketchPanel.this.importMoleculesWithAbbreviationsFinished(SketchPanel.this.templateHandler.getMoleculesWithAbbreviations());
            }
        };
        t.start();
    }

    private void importMoleculesWithAbbreviationsFinished(Molecule[] mols) {
        this.keyboardInput.setMyTemplates(mols);
    }

    public void selectAbbrevGroup(String s) {
        for (int i = 0; i < this.allAbbrevGroups.getSize(); ++i) {
            Molecule m;
            if (!this.allAbbrevGroups.getAbbrevName(i).equals(s)) continue;
            try {
                m = this.allAbbrevGroups.getMolecule(i);
            }
            catch (MRecordParseException ex) {
                this.getErrorDisplay().error("Abbreviated group cannot be imported: " + this.allAbbrevGroups.getString(i), ex);
                return;
            }
            catch (MolFormatException ex) {
                this.getErrorDisplay().error("Abbreviated group cannot be imported: " + this.allAbbrevGroups.getString(i), ex);
                return;
            }
            catch (IOException ex) {
                this.getErrorDisplay().error("Abbreviated group cannot be imported: " + this.allAbbrevGroups.getString(i), ex);
                return;
            }
            MolEditor medit = this.sketchCanvas.getEditor();
            this.keyboardInput.prepareAbbrevGroup(m);
            m.moveTo(medit.getPointerPos());
            SketchMode so = medit.createSM(m);
            this.pressButton(so, false);
            this.setPeriodicSystemVisible(false);
            return;
        }
        ColorSetUtil.copyDefaultSetColor(this.getEditor().getDocument(), this.getEditor().getPiece());
    }

    String getKeyinString() {
        return this.keyboardInput.getString();
    }

    String[] getKeyinPossibleCompletions() {
        return this.keyboardInput.getPossibleCompletions();
    }

    void pageDown() {
        Point p = this.sketchCanvas.getCorner();
        Dimension d = this.sketchCanvas.getSize();
        p.y = (int)((double)p.y + d.getHeight());
        MolEditor med = this.getEditor();
        Rectangle t = med.isMultipageEnabled() ? med.calcMultipageBoundingRectangle() : med.calcMolBoundingRectangle();
        int ymax = t.y + d.height / 2 + t.height;
        if ((double)p.y + d.getHeight() / 2.0 < (double)ymax) {
            this.scroll(0, (int)(d.getHeight() / 2.0));
        } else {
            this.scroll(0, ymax - p.y);
        }
        this.sketchCanvas.repaint();
    }

    void pageUp() {
        Point p = this.sketchCanvas.getCorner();
        Dimension d = this.sketchCanvas.getSize();
        MolEditor med = this.getEditor();
        Rectangle t = med.isMultipageEnabled() ? med.calcMultipageBoundingRectangle() : med.calcMolBoundingRectangle();
        int ymin = t.y - d.height / 2;
        if ((double)p.y - d.getHeight() / 2.0 > (double)ymin) {
            this.scroll(0, (int)(-d.getHeight() / 2.0));
        } else {
            this.scroll(0, ymin - p.y);
        }
        this.sketchCanvas.repaint();
    }

    public void centralizeMoleculeDisplay() {
        this.getEditor().getPainter().setCentralized(true);
        this.scrlpos = false;
        this.setScrollbars(false);
    }

    public int getScrollbarExt() {
        if (this.hscrollbar != null) {
            return this.hscrollbar.getHeight();
        }
        if (this.vscrollbar != null) {
            return this.vscrollbar.getWidth();
        }
        return 0;
    }

    void scrollCanvas(int x, int y, boolean magnifying, boolean addToHist) {
        int xMin = this.hscrollbar.getMinimum();
        int xMax = this.hscrollbar.getMaximum() - this.hscrollbar.getModel().getExtent() - 1;
        int yMin = this.vscrollbar.getMinimum();
        int yMax = this.vscrollbar.getMaximum() - this.vscrollbar.getModel().getExtent() - 1;
        this.setScrollbars(x < xMin ? xMin : (x > xMax ? xMax : x), y < yMin ? yMin : (y > yMax ? yMax : y), magnifying, addToHist);
    }

    public void setScrollbars() {
        this.setScrollbars(false, false);
    }

    public void setScrollbars(boolean addToHist) {
        this.setScrollbars(false, addToHist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustScrollbars(int dx, int dy, boolean magnifying, boolean addToHist) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            if (this.hscrollbar != null && this.vscrollbar != null) {
                this.setScrollbars(this.hscrollbar.getValue() + dx, this.vscrollbar.getValue() + dy, magnifying, addToHist);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScrollbars(boolean magnifying, boolean addToHist) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            if (this.hscrollbar != null && this.vscrollbar != null) {
                this.setScrollbars(this.hscrollbar.getValue(), this.vscrollbar.getValue(), magnifying, addToHist);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setScrollbars(int x, int y, boolean magnifying, boolean addToHist) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            MolEditor med;
            Dimension d = this.sketchCanvas.getSize();
            if (d.width <= 0 || d.height <= 0) {
                return;
            }
            double cx = 1.0;
            double cy = 1.0;
            if (magnifying) {
                int xmin0 = this.hscrollbar.getMinimum();
                int ymin0 = this.vscrollbar.getMinimum();
                int xmax0 = this.hscrollbar.getMaximum() - d.width;
                int ymax0 = this.vscrollbar.getMaximum() - d.height;
                int xdiff = xmax0 - xmin0;
                int ydiff = ymax0 - ymin0;
                if (xdiff != 0 && ydiff != 0) {
                    cx = (double)(x - xmin0) / (double)xdiff;
                    cy = (double)(y - ymin0) / (double)ydiff;
                } else {
                    cx = x - xmin0;
                    cy = y - ymin0;
                }
            }
            Rectangle t = (med = this.getEditor()).isMultipageEnabled() ? med.calcMultipageBoundingRectangle() : med.calcMolBoundingRectangle();
            int xmin = t.x - d.width / 2;
            int ymin = t.y - d.height / 2;
            int xmax = xmin + t.width;
            int ymax = ymin + t.height;
            if (this.scrlpos) {
                if (magnifying) {
                    x = (int)(cx * (double)(xmax - xmin) + (double)xmin + 0.5);
                    y = (int)(cy * (double)(ymax - ymin) + (double)ymin + 0.5);
                }
                if (x < xmin) {
                    xmin = x;
                } else if (x >= xmax) {
                    xmax = x + 1;
                }
                if (y < ymin) {
                    ymin = y;
                } else if (y >= ymax) {
                    ymax = y + 1;
                }
            } else {
                x = (xmax + xmin) / 2;
                y = (ymax + ymin) / 2;
                this.scrlpos = true;
            }
            this.hscrollbar.removeAdjustmentListener(this);
            this.vscrollbar.removeAdjustmentListener(this);
            this.hscrollbar.setValues(x, d.width, xmin, xmax + d.width);
            this.vscrollbar.setValues(y, d.height, ymin, ymax + d.height);
            this.hscrollbar.addAdjustmentListener(this);
            this.vscrollbar.addAdjustmentListener(this);
            this.sketchCanvas.setCorner(x, y, addToHist);
            med.setScrollBarValuesToHist(xmin, xmax, ymin, ymax);
            med.updateMultipage(this.sketchCanvas.getSize());
            if (this.hasStatusBar) {
                this.getStatusBar().update();
            }
            if (this.getEditor().isEmpty() || !this.sketchCanvas.isEnabled()) {
                this.hscrollbar.setEnabled(false);
                this.vscrollbar.setEnabled(false);
                return;
            }
            this.hscrollbar.setEnabled(true);
            this.vscrollbar.setEnabled(true);
        }
    }

    void setScrollbarsAfterUndo(Point corner, int[] sBVals) {
        Dimension d = this.sketchCanvas.getSize();
        if (d.width <= 0 || d.height <= 0) {
            return;
        }
        this.hscrollbar.removeAdjustmentListener(this);
        this.vscrollbar.removeAdjustmentListener(this);
        this.hscrollbar.setValues(corner.x, d.width, sBVals[0], sBVals[1] + d.width);
        this.vscrollbar.setValues(corner.y, d.height, sBVals[2], sBVals[3] + d.height);
        this.hscrollbar.addAdjustmentListener(this);
        this.vscrollbar.addAdjustmentListener(this);
        this.getEditor().updateMultipage(this.sketchCanvas.getSize());
        if (this.hasStatusBar) {
            this.getStatusBar().update();
        }
        if (this.getEditor().isEmpty() || !this.sketchCanvas.isEnabled()) {
            this.hscrollbar.setEnabled(false);
            this.vscrollbar.setEnabled(false);
            return;
        }
        this.hscrollbar.setEnabled(true);
        this.vscrollbar.setEnabled(true);
    }

    void scroll(int dx, int dy) {
        int x = this.hscrollbar.getValue();
        int y = this.vscrollbar.getValue();
        this.scrlpos = true;
        this.setScrollbars(x + dx, y + dy, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustmentValueChanged(AdjustmentEvent ev) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            Point corner = this.sketchCanvas.getCorner();
            Object target = ev.getSource();
            switch (ev.getAdjustmentType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (target == this.hscrollbar) {
                        this.sketchCanvas.setCorner(ev.getValue(), corner.y, true);
                    } else if (target == this.vscrollbar) {
                        this.sketchCanvas.setCorner(corner.x, ev.getValue(), true);
                    }
                    MolEditor med = this.getEditor();
                    med.updateMultipage(this.sketchCanvas.getSize());
                    if (!this.hasStatusBar) break;
                    this.getStatusBar().update();
                }
            }
        }
    }

    public boolean isDetached() {
        return this.detached;
    }

    public boolean isPeriodicSystemVisible() {
        return this.periodicSystemDialog != null && this.periodicSystemDialog.isVisible();
    }

    public boolean isPeriodicSystemEnabled() {
        return this.periodicSystemEnabled;
    }

    private void setPeriodicSystemEnabled(boolean enabled) {
        if (!enabled) {
            this.setPeriodicSystemVisible(false);
        }
        boolean oldValue = this.isPeriodicSystemEnabled();
        this.periodicSystemEnabled = enabled;
        this.firePropertyChange("moreEnabled", oldValue, this.isPeriodicSystemEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeriodicSystemVisible(boolean v) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            if (this.isPeriodicSystemVisible() == v) {
                return;
            }
            this.openPeriodicSystem(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openPeriodicSystem(boolean visible) {
        if (this.periodicSystemDialog == null && visible) {
            this.beginHourglass();
            try {
                DialogFactory factory = (DialogFactory)MarvinModule.load("sketch.swing.PeriodicSystemDialogFactoryImpl", this);
                factory.setSketchPanel(this);
                this.periodicSystemDialog = (PeriodicSystemDialog)factory.createDialog();
                this.periodicSystemDialog.open();
                this.periodicSystemDialog.setMolecule(this.getPiece());
                this.periodicSystemDialog.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if (e.getID() == 4 && !SketchPanel.this.isShowing()) {
                            SketchPanel.this.periodicSystemDialog.close();
                            SketchPanel.this.periodicSystemDialog = null;
                        }
                    }
                });
                this.periodicSystemDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        SketchPanel.this.periodicSystemDialog = null;
                    }
                });
            }
            catch (SecurityException e) {
                this.getErrorDisplay().firewallError(e, null);
            }
            finally {
                this.endHourglass();
            }
        }
        if (this.periodicSystemDialog != null) {
            if (visible) {
                this.periodicSystemDialog.open();
                this.periodicSystemDialog.setMolecule(this.getPiece());
            } else {
                this.periodicSystemDialog.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSketchMode(SketchMode so, boolean centralize, boolean resize, boolean nomore, boolean release) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            Molecule mol;
            MDocument doc;
            if (so.isSelector()) {
                this.lastSelectSM = so;
            }
            MDocument mDocument = doc = (mol = so.getMol()) != null ? mol.getDocument() : null;
            if (mol != null) {
                MolAtom a;
                double l;
                CTransform3D t = new CTransform3D();
                t.setIdentity();
                if (centralize) {
                    DPoint3 p = doc != null ? doc.calcCenter() : mol.calcCenter();
                    mol.setLocation(p);
                    t.setTranslation(-p.x, -p.y, -p.z);
                }
                if (resize && (l = mol.bondlength()) > 5.0E-5) {
                    t.setScale(1.54);
                }
                if (doc != null) {
                    doc.transform(t);
                } else {
                    mol.transform(t);
                }
                MolAtom molAtom = a = mol.isAtom() ? mol.getAtom(0) : null;
                if (a != null && !a.isQuery() && (doc == null || doc.isSimpleMolecule())) {
                    so = new AtomSM(this.getEditor(), a);
                }
            }
            if (mol != null && (mol.isBond() || mol.isAtom() && !mol.getAtom(0).isQuery() && !mol.isSgroup()) && (doc == null || doc.isSimpleMolecule())) {
                this.pressButton(so, nomore);
                if (this.lastSelectSM != null && this.getEditor().hasSelection() && this.getEditor().getSelectionMolecule().getAtomCount() > 1 && (!mol.isAtom() || mol.getAtom(0).getAtno() != 0)) {
                    this.sketchCanvas.setSketchMode(this.lastSelectSM, true);
                }
            } else {
                this.sketchCanvas.setSketchMode(so, true);
                if (release && !nomore && this.periodicSystemDialog != null) {
                    this.periodicSystemDialog.releaseAll();
                }
            }
        }
    }

    void backToSketching(boolean setsm) {
        MolEditor ed = this.getEditor();
        if (setsm) {
            ed.setSketchMode(ed.getSketchMode(), false);
        }
        int opts0 = this.getDispopts() & 0xFFFFFFC7;
        this.setDispopts(opts0, false, true);
    }

    public boolean pressButton(boolean nomore) {
        return this.pressButton(this.getLastSelectSM(), nomore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pressButton(SketchMode sm, boolean nomore) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            Molecule mol = sm.getMol();
            if (mol != null && !this.getEditor().isAllowed(mol)) {
                return false;
            }
            boolean select = this.getEditor().hasSelection();
            if (!nomore && this.periodicSystemDialog != null) {
                this.periodicSystemDialog.setMolecule(mol);
            }
            this.beginHourglass();
            SketchMode prev = this.getEditor().getSketchMode();
            try {
                MolEditor ed = this.getEditor();
                this.sketchCanvas.setSketchMode(sm, true);
                if (ed.getSketchMode() == prev) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this.endHourglass();
            }
            if (sm.isRubber() && select && prev.isSelector()) {
                this.setSketchMode(prev, false, false, false, false);
                return true;
            }
            return sm instanceof BondSM;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mbuttonfit() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            if (this.mbutton != null) {
                Molecule m = this.sketchCanvas.getMol();
                Container p = this.mbutton.getParent();
                if (p != null) {
                    this.mpainter.setBoundsFor(m, false, false);
                    Dimension d = MolButton.paintSize(p.getSize());
                    this.mpainter.setScreen(d);
                    double scale = this.mpainter.maxScale(d);
                    if (this.buttonMaxScale > 0.0 && scale > this.buttonMaxScale) {
                        scale = this.buttonMaxScale;
                    }
                    this.mpainter.setScale(scale);
                }
                this.mbutton.setRotDiff(0.2617993877991494);
                this.mbutton.setMol(m);
                this.mbutton.setPainter(this.mpainter);
                this.mbutton.repaint();
            }
            if (this.hasStatusBar) {
                this.getStatusBar().update();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.requestFocusInWindow();
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void changeDim() {
        Molecule m = this.getEditor().getMol();
        if (this.getCleanDim() == 2) {
            m.setDim(3);
            this.setCleanDim(3);
            return;
        } else {
            MoleculeGraph umol = m.getGraphUnion();
            boolean is3d = false;
            for (int i = 0; i < umol.getAtomCount() && !is3d; ++i) {
                MolAtom a = umol.getAtom(i);
                if (a.getZ() == 0.0) continue;
                is3d = true;
            }
            if (is3d) {
                int r = JOptionPane.showConfirmDialog(this, "Switching to 2D mode is only possible after cleaning the molecule in 2D.\nDo you want to clean it?", "Clean in 2D?", 0, 2);
                if (r != 0) return;
                this.doClean(2);
                return;
            } else {
                this.doClean(2);
            }
        }
    }

    public boolean getWinmode() {
        if (this.mframe != null) {
            return this.mframe.getContentPane() == this;
        }
        return this.applet == null;
    }

    public void setWinmode(boolean x) {
        this.setWinmode(x, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setWinmode(boolean x, boolean transfering) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            Boolean old = this.mframe != null ? new Boolean(this.mframe.getContentPane() == this) : new Boolean(this.applet == null);
            if (this.applet != null || this.mvindex >= 0) {
                this.setDetached(x);
            }
            if (x) {
                if (this.applet != null) {
                    this.setButtonmode(true);
                    this.makeMyFrame();
                    if (this.mbutton != null) {
                        this.mbutton.setSelected(true);
                    }
                    this.applet.validate();
                    this.setScrollbars();
                }
                this.setCloseEnabled(true);
            } else {
                this.setPeriodicSystemVisible(false);
                if (this.applet != null) {
                    this.sketchCanvas.setPrefsize(this.sketchCanvas.getSize());
                    if (this.mbutton != null) {
                        this.mbutton.setSelected(false);
                    }
                }
                if (this.mvindex >= 0) {
                    this.startstop(true);
                    assert (this.moleculeProvider != null);
                    Object[] v = new Object[]{this.sketchCanvas.getMol().getDocument(), new Integer(this.mvindex), new Boolean(this.sketchCanvas.getEditor().hasChanged())};
                    this.getParentMolPanel().callback("removeSketch", v);
                } else if (this.mframe != null) {
                    this.hideWindow(this.mframe);
                }
                this.setCloseEnabled(this.applet == null);
            }
            this.changeListeners.firePropertyChange("winmode", old, new Boolean(x));
            if (this.autoScale) {
                this.autoScale();
            }
            this.transfer(transfering);
        }
    }

    private void transfer(boolean transfering) {
        if (this.moleculeProvider != null) {
            if (!transfering && this.isTransferCanceled()) {
                this.moleculeProvider.setMolecule(this.mvindex, null, false);
            } else {
                if (!this.transferSelection) {
                    this.getEditor().unselect();
                }
                this.moleculeProvider.setMolecule(this.mvindex, this.sketchCanvas.getMol(), this.sketchCanvas.getEditor().hasChanged() || this.transferSelection);
            }
        }
    }

    private boolean isTransferCanceled() {
        if (!this.showTransferDialog || !this.sketchCanvas.getEditor().hasChanged()) {
            return false;
        }
        return this.showConfirmTransferDialog() == 1;
    }

    @Override
    public Object[] getLoadSaveArgs(File f, String opts, String what, Molecule mol) {
        Object[] v = new Object[]{f, opts, what, what.startsWith("save") ? mol : null};
        return v;
    }

    @Override
    public boolean molLoaderFinished(MolLoader loader) {
        boolean secondRun = loader.isSecondRun();
        if (super.molLoaderFinished(loader)) {
            return true;
        }
        boolean isMolLoaderFinished = false;
        if (!secondRun) {
            return false;
        }
        long id = loader.getId();
        if (id >= 196608L && id < 262144L) {
            return false;
        }
        Molecule[] mols = loader.getMols();
        if (id == 66048L) {
            String text = loader.getAbbrevGroups();
            if (text != null) {
                this.abbrevGroups = new AbbrevGroupCollection(text);
                this.initAbbrevGroups();
                this.initUserTemplates();
            }
        } else {
            this.molLoaded(mols, id);
            isMolLoaderFinished = true;
        }
        loader.clear();
        if (isMolLoaderFinished && this.applet != null) {
            final String action = this.molLoaderFinishedJs;
            if (this.molLoaderFinishedJs != null) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        SketchPanel.this.js(action);
                    }
                };
                t.start();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object callback(String method, Object arg) {
        Object ret = super.callback(method, arg);
        if (ret != null) {
            return ret;
        }
        if (method.equals("setFileFromLoadSave")) {
            Object object = this.getMolPanelLock();
            synchronized (object) {
                CallbackIface mod = (CallbackIface)arg;
                Molecule m = (Molecule)mod.callback("getMol", null);
                if (m != null) {
                    Molecule[] mols = new Molecule[]{m};
                    this.molLoaded(mols, 0L);
                }
            }
            return null;
        }
        if (method.equals("savePerformed")) {
            this.isSavedBeforeExit = true;
            this.getEditor().savePerformed();
            if (this.hasStatusBar) {
                this.getStatusBar().update();
            }
            return null;
        }
        if (method.equals("getMol")) {
            Molecule m = this.getMol().cloneMoleculeWithDocument();
            m.setGUIContracted(false);
            return m;
        }
        if (method.equals("getSketchPanel")) {
            return this;
        }
        if (method.equals("keyBufferCleared")) {
            this.repaint();
            return null;
        }
        return null;
    }

    public void setUsrAbbrevGroups(int i, Molecule[] mols) {
        AbbrevGroupCollection v;
        this.usrAbbrevGroups[i] = v = new AbbrevGroupCollection(mols);
        this.initAbbrevGroups();
    }

    @Override
    public void molLoaded(Molecule[] mols, long id) {
        if (this.getComponentCount() == 0) {
            return;
        }
        Molecule m = mols != null && mols.length > 0 ? mols[0] : null;
        super.molLoaded(mols, id);
        for (int i = 0; mols != null && i < mols.length; ++i) {
            Molecule mm = mols[i];
            if (mm == null) continue;
            MolPainter p = this.getCanvas().getPainter();
            Color bg = p != null ? p.getBackground() : this.getMolbg();
            this.painterCommon.fillUnsetSetPaletteInDoc(mm, bg);
        }
        if (id == 0L) {
            this.setMol(m, true);
            if (m instanceof RgMoleculeGraphIface && ((RgMoleculeGraphIface)((Object)m)).getRgroupCount() > 0) {
                this.zoomToScaffold();
                this.setScale(28.0);
                this.setScrollbars(true, false);
                this.getEditor().unhistorize();
                this.getEditor().historizeAfterZoom(false, new MoleculeGraph[]{((RgMoleculeGraphIface)((Object)m)).getRootG()});
            }
        } else if (id == 131072L) {
            SketchMode sm = this.getEditor().createSM(m);
            this.setSketchMode(sm, false, false, false, true);
        } else if (id == 131073L) {
            SketchMode sm = this.getEditor().createSM(m);
            this.setSketchMode(sm, true, false, false, true);
        }
        if (this.getMol() != null && !this.isValenceCheckEnabledParameter) {
            this.getMol().setValenceCheckEnabled(false);
        }
    }

    @Override
    public void updateMol(int index, Molecule mol) {
        this.setMol(mol, false);
    }

    public void makeMyFrame() {
        if (this.mframe == null) {
            this.mframe = new JFrame();
            this.mframe.setTitle("MarvinSketch");
            this.mframe.getContentPane().setLayout(new GridLayout(1, 1));
            this.mframe.addWindowListener(this);
            this.getDockHandler().setRootPane(this.mframe.getRootPane());
        }
        this.setDetached(true);
        boolean oldValue = this.getWinmode();
        this.mframe.setContentPane(this);
        if (this.changeListeners != null) {
            this.changeListeners.firePropertyChange("winmode", oldValue, this.getWinmode());
        }
        this.mframe.pack();
        this.initCursor();
        this.showWindow(this.mframe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        Component comp;
        super.propertyChange(ev);
        String name = ev.getPropertyName();
        Object value = ev.getNewValue();
        Object src = ev.getSource();
        Component component = comp = src instanceof Component ? (Component)src : null;
        if (name.equals("ancestor")) {
            Container p = comp.getParent();
            if (p != null && comp == this.mbutton) {
                Object object = this.getMolPanelLock();
                synchronized (object) {
                    Dimension d = p.getSize();
                    this.mbutton.setReqSize(d);
                    this.mbuttonfit();
                    p.validate();
                }
            }
        } else if (name.equals("chiralitySupport")) {
            int v = -1;
            for (int i = RS_OPTIONS.length - 1; i >= 0 && v == -1; --i) {
                if (!RS_OPTIONS[i].equals(value)) continue;
                v = i;
            }
            if (v == -1) {
                try {
                    v = new Integer(value.toString());
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            this.sketchCanvas.getEditor().setChiralitySupport(v);
            MolPainter p = this.mpainter;
            if (p != null) {
                p.getCommon().setChiralitySupport(v);
            }
        } else if (name.equals("terminalBondDeletionStyle")) {
            this.getEditor().setDeleteRemovesTerminalAtoms(value.equals("withAtom"));
        }
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        if (ev.getSource() == this.sketchCanvas) {
            if (this.sketchCanvas.getMol() != null) {
                this.updateNameBox();
            }
            this.setScrollbars(true);
        }
    }

    @Override
    public void componentShown(ComponentEvent ev) {
        if (ev.getSource() == this.sketchCanvas) {
            this.setScrollbars(true);
        }
    }

    @Override
    public void componentMoved(ComponentEvent ev) {
    }

    @Override
    public void componentHidden(ComponentEvent ev) {
    }

    public MolButton getMButton() {
        return this.mbutton;
    }

    public int getMVIndex() {
        return this.mvindex;
    }

    public void setMol(Molecule m, boolean init) {
        MDocument doc;
        if ((m = m != null ? ((doc = m.getDocument()) != null ? doc.cloneMainMolecule() : m.cloneMolecule()) : new Molecule()) != null && !this.isValenceCheckEnabledParameter) {
            m.setValenceCheckEnabled(false);
        }
        final Molecule m1 = m;
        if (SwingUtilities.isEventDispatchThread()) {
            this.setMolInAwtThread(m1);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SketchPanel.this.setMolInAwtThread(m1);
                }
            });
        }
    }

    private void setMolInAwtThread(Molecule m1) {
        MolEditor med;
        this.scrlpos = false;
        this.setCleanDim(m1.getDim());
        this.sketchCanvas.setMol(m1);
        this.updateControls();
        this.mbuttonfit();
        if (this.getAutoScale()) {
            this.autoScale();
        }
        if ((med = this.getEditor()) != null && med.isMultipageEnabled()) {
            med.getDocument().getPageSettings().setSelectedPage(0);
            this.fitPage(med.getDocument().getPageSettings());
        }
    }

    public void setMol(String s, String opts) {
        if (s == null || s.trim().length() == 0) {
            this.molLoaded(null, 0L);
        } else {
            this.startLoader(s, opts, 0L, false);
        }
    }

    public void setMol(File f, String opts) {
        this.openMolfile(f, opts);
    }

    public Molecule getMol() {
        return this.sketchCanvas.getMol();
    }

    @Override
    public void setCleanDim(int dim) {
        int prevdim = this.getCleanDim();
        if (dim != prevdim) {
            super.setCleanDim(dim);
            Color c = this.getMolbg();
            this.setDefaultMolbg(c, prevdim);
            c = this.getDefaultMolbg(dim);
            this.setMolbg(c);
            String rendering = this.getRendering();
            this.setDefaultRendering(rendering, prevdim);
            rendering = this.getDefaultRendering(dim);
            this.setRendering(rendering);
            if (this.hasStatusBar) {
                this.getStatusBar().setDim(dim);
            }
        }
    }

    @Override
    public MDocument getDocument(int icell) {
        if (icell == 0) {
            Molecule mol = this.sketchCanvas.getMol();
            return mol.getDocument();
        }
        return null;
    }

    @Override
    public void repaintMolComponent(int icell) {
        if (icell == 0) {
            this.sketchCanvas.repaint();
            this.mbuttonfit();
        }
    }

    @Override
    public int getMolCount() {
        return 1;
    }

    public Molecule getPiece() {
        return this.sketchCanvas.getPiece();
    }

    public Object getObjectAtPointer() {
        return this.sketchCanvas.getEditor().getObjectAtPointer();
    }

    @Override
    public void setDispopts(int opts, boolean save, boolean setmenus) {
        MolPainterCommon common;
        super.setDispopts(opts, save, setmenus);
        this.painterCommon.setDispopts(opts);
        if (this.mpainter != null && (common = this.mpainter.getCommon()) != null) {
            common.setDispopts(opts);
        }
        this.mbuttonfit();
        if (this.sketchCanvas != null) {
            this.sketchCanvas.repaint();
        }
    }

    @Override
    public void setColorScheme(String v) {
        super.setColorScheme(v);
        this.userSettings.setSketchColorScheme(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoScale(boolean as) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            super.setAutoScale(as);
            if (as) {
                this.autoScale();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAtomsize(double l) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            super.setAtomsize(l);
            this.sketchCanvas.setAtomAndBondSizes(l, this.getBondSpacing());
            this.setScrollbars();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBondSpacing(double w) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            super.setBondSpacing(w);
            this.sketchCanvas.setAtomAndBondSizes(this.getUserSettings().getAtomSize(), w);
            this.setScrollbars();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAtomFont(Font f) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            super.setAtomFont(f);
            if (this.mpainter != null) {
                this.mpainter.getCommon().setBaseFont(f);
                this.mpainter.resetFonts();
            }
            this.getEditor().getPainter().resetFonts();
        }
    }

    public double getScale() {
        return this.sketchScale;
    }

    public void setScale(double m) {
        Double old = new Double(this.sketchScale);
        this.sketchScale = m;
        this.changeProperty("scale", String.valueOf(m));
        this.changeListeners.firePropertyChange("scale", old, new Double(m));
        this.userSettings.setProperty("imageScale", String.valueOf(m), false);
    }

    public void setMagnification(double zoom) {
        double scale = zoom * 28.0;
        if (scale != this.getScale()) {
            this.setScale(scale);
            this.scrlpos = false;
            this.setScrollbars();
        }
    }

    public double getStickdst() {
        return this.sketchCanvas.getEditor().getStickdst();
    }

    public void setStickdst(double l) {
        MolEditor med = this.sketchCanvas.getEditor();
        Double old = new Double(med.getStickdst());
        med.edit(13, l);
        this.changeProperty("stickdst", String.valueOf(l));
        this.changeListeners.firePropertyChange("stickdst", old, new Double(l));
        this.sketchCanvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMergedst() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            return this.sketchCanvas.getEditor().getMergedst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMergedst(double l) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            MolEditor med = this.sketchCanvas.getEditor();
            Double old = new Double(med.getMergedst());
            med.edit(12, l);
            this.changeProperty("mergedst", String.valueOf(l));
            this.changeListeners.firePropertyChange("mergedst", old, new Double(l));
            this.sketchCanvas.repaint();
        }
    }

    public int getUndo() {
        return this.sketchCanvas.getEditor().getUndo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUndo(int d) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            MolEditor med = this.sketchCanvas.getEditor();
            Integer old = new Integer(med.getUndo());
            med.setUndo(d);
            this.sketchCanvas.getEditor().setUndo(d);
            this.changeProperty("undo", String.valueOf(d));
            this.changeListeners.firePropertyChange("undo", old, new Integer(d));
            this.updateControls();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHistory() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.sketchCanvas.getEditor().clearHistory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistory(History hist) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.sketchCanvas.getEditor().setHistory(hist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public History getHistory() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            return this.sketchCanvas.getEditor().getHistory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValenceErrorVisible(boolean v) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.painterCommon.setValenceErrorVisible(v);
            super.setValenceErrorVisible(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMarvinViewVisible(boolean in3d) {
        this.beginHourglass();
        try {
            this.setMarvinViewVisible(in3d, this.getEditor().getDocument(), null, null);
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBondDraggedAlong(boolean v) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.sketchCanvas.getEditor().setBondDraggedAlong(v);
            super.setBondDraggedAlong(v);
        }
    }

    public boolean getReactionSupport() {
        return this.getEditor().isReactionSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReactionSupport(boolean v) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            MolEditor med = this.getEditor();
            boolean reactionSupport = med.isReactionSupported();
            Boolean old = new Boolean(reactionSupport);
            if (reactionSupport != v) {
                Boolean val = new Boolean(v);
                med.setReactionSupported(v);
                this.changeListeners.firePropertyChange("reactionSupport", old, val);
            }
        }
    }

    @Override
    public void setDebug(int debug) {
        super.setDebug(debug);
        DnD dnd = this.sketchDnD;
        if (dnd != null) {
            dnd.setDebug(debug);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackground(Color color) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            super.setBackground(color);
            SketchPanel.setBackgroundRecursively(this, color);
        }
    }

    @Override
    public Color getMolbg() {
        return this.getEditor().getPainter() == null ? super.getBackground() : this.getEditor().getPainter().getBackground();
    }

    @Override
    public void setMolbg(Color c) {
        if (this.getEditor().getPainter() != null) {
            this.getEditor().getPainter().setBackground(c);
        }
        super.setBackground(c);
    }

    @Override
    protected void setMarvinCursor(Cursor cursor) {
        SketchCanvas c = this.sketchCanvas;
        if (c != null) {
            this.sketchCanvas.setCursor(cursor);
        }
    }

    @Override
    public void setAtomSetColor(int i, Color color) {
        MDocument doc = this.getMol().getDocument();
        if (doc != null) {
            if (color == null) {
                doc.setAtomSetColorMode(i, 2);
            } else {
                doc.setAtomSetRGB(i, color.getRGB());
            }
        }
        super.setAtomSetColor(i, color);
    }

    @Override
    public void setBondSetColor(int i, Color color) {
        MDocument doc = this.getMol().getDocument();
        if (doc != null) {
            if (color == null) {
                doc.setBondSetColorMode(i, 2);
            } else {
                doc.setBondSetRGB(i, color.getRGB());
            }
        }
        super.setBondSetColor(i, color);
    }

    private static void setBackgroundRecursively(Container container, Color color) {
        for (int i = container.getComponentCount() - 1; i >= 0; --i) {
            Component c = container.getComponent(i);
            if (!(c instanceof SketchCanvas)) {
                c.setBackground(color);
            }
            if (!(c instanceof Container)) continue;
            SketchPanel.setBackgroundRecursively((Container)c, color);
        }
    }

    @Override
    public void addRecentFileToUserSettings(File f) {
        if (f != null) {
            this.userSettings.addToSketchRecentFileList(f);
        }
    }

    @Override
    public void setSaveCwdToUserSettings(File f) {
        if (f != null) {
            if (f.isFile()) {
                f = f.getParentFile();
            }
            this.userSettings.setSketchSaveWorkingDir(f.getAbsolutePath());
        }
    }

    @Override
    public void setLoadCwdToUserSettings(File f) {
        if (f != null) {
            if (f.isFile()) {
                f = f.getParentFile();
            }
            this.userSettings.setSketchLoadWorkingDir(f.getAbsolutePath());
        }
    }

    @Override
    public File getLoadCwdFromUserSettings() {
        return this.userSettings.getSketchLoadWorkingDir();
    }

    @Override
    public File getSaveCwdFromUserSettings() {
        return this.userSettings.getSketchSaveWorkingDir();
    }

    @Override
    public Color getDefaultMolbg() {
        return this.getDefaultMolbg(this.getCleanDim());
    }

    private Color getDefaultMolbg(int dim) {
        UserSettings settings = this.getUserSettings();
        if (settings != null) {
            return dim == 3 ? settings.getSketchMolbg3d() : settings.getSketchMolbg2d();
        }
        return null;
    }

    @Override
    public void setDefaultMolbg(Color c) {
        this.setDefaultMolbg(c, this.getCleanDim());
    }

    private void setDefaultMolbg(Color c, int d) {
        UserSettings settings = this.getUserSettings();
        if (d == 3 || d == 0) {
            settings.setSketchMolbg3d(c);
        }
        if (d == 2 || d == 0) {
            settings.setSketchMolbg2d(c);
        }
    }

    @Override
    protected String getDefaultColorSchemePropertyName() {
        return "sketchColorScheme";
    }

    @Override
    public String getDefaultColorScheme() {
        return this.getUserSettings().getSketchColorScheme();
    }

    @Override
    public void setDefaultColorScheme(String c) {
        this.setSketchColorScheme(c);
    }

    @Override
    public String getDefaultImplicitH() {
        return this.getUserSettings().getSketchImplicitH();
    }

    @Override
    public void setDefaultImplicitH(String s) {
        this.setSketchImplicitH(s);
    }

    @Override
    protected String getDefaultImplicitHPropertyName() {
        return "sketchImplicitH";
    }

    @Override
    public String getDefaultRendering() {
        return this.getDefaultRendering(this.getCleanDim());
    }

    private String getDefaultRendering(int dim) {
        UserSettings settings = this.getUserSettings();
        return dim == 3 ? settings.getSketchRendering3d() : settings.getSketchRendering2d();
    }

    @Override
    public void setDefaultRendering(String s) {
        this.setDefaultRendering(s, this.getCleanDim());
    }

    private void setDefaultRendering(String s, int d) {
        UserSettings settings = this.getUserSettings();
        if (d == 3 || d == 0) {
            settings.setSketchRendering3d(s);
        }
        if (d == 2 || d == 0) {
            settings.setSketchRendering2d(s);
        }
    }

    @Override
    public void setDefaultNavmode(String s) {
    }

    @Override
    public String getDefaultRenderingPropertyName() {
        return this.getCleanDim() == 3 ? "sketchRendering3d" : "sketchRendering2d";
    }

    @Override
    public String getDefaultAnyBond() {
        return this.getUserSettings().getSketchAnyBond();
    }

    @Override
    public String getDefaultAnyBondPropertyName() {
        return "sketchAnyBond";
    }

    @Override
    public String getCarbonVisibility() {
        return this.painterCommon.getCarbonVisibility();
    }

    @Override
    public void setCarbonVisibility(String s) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setCarbonVisibility(s);
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
        this.userSettings.setSketchCarbonVisibility(s);
    }

    @Override
    public String getLigandOrderVisibility() {
        return this.painterCommon.getLigandOrderVisibility();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLigandOrderVisibility(String visibility) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.painterCommon.setLigandOrderVisibility(visibility);
            this.userSettings.setSketchLigandOrderVisibility(visibility);
        }
    }

    @Override
    public String getDefaultCarbonVisibilityPropertyName() {
        return "sketchCarbonVisibility";
    }

    @Override
    public String getDefaultLigandOrderVisibilityPropertyName() {
        return "sketchLigandOrderVisibility";
    }

    @Override
    public Color getAtomSetColor(int i) {
        MolPainter p = this.getCanvas().getPainter();
        return this.painterCommon.getAtomSetColor(i, null, p.getColors());
    }

    void updateSketcherMenus() {
        this.fireChangeEvent();
        this.updatePagesMenu();
        if (this.sketchCanvas.getEditor().getFocusedMTextBox() != null) {
            this.setEditorMode(1);
        } else {
            this.setEditorMode(0);
        }
    }

    private void setEditorMode(int mode) {
        MObjectEditor prevobjed = this.objectEditor;
        MObjectEditor nextobjed = null;
        if (mode == 1) {
            MolEditor med = this.getEditor();
            if (this.textBoxEditor == null) {
                MObjectEditor t = (MObjectEditor)MarvinModule.load("sketch.swing.MTextBoxEditor", this);
                t.init(this);
                this.textBoxEditor = t;
                this.sketchKeyBindings.setTextBoxEditor(this.textBoxEditor);
            }
            nextobjed = this.textBoxEditor;
            MTextBox mo = med.getFocusedMTextBox();
            this.textBoxEditor.setMObject(mo);
        }
        if (prevobjed != nextobjed) {
            if (prevobjed != null) {
                prevobjed.endEditing();
            }
            if (nextobjed != null) {
                nextobjed.beginEditing();
            }
        }
        this.objectEditor = nextobjed;
    }

    public TextEditor getTextEditor() {
        if (this.textBoxEditor != null && this.textBoxEditor instanceof TextEditor) {
            return (TextEditor)((Object)this.textBoxEditor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateControls() {
        MolEditor med = this.sketchCanvas.getEditor();
        int moldim = med.getMolDim();
        if (moldim == 3) {
            this.setCleanDim(moldim);
        }
        this.updateSketcherMenus();
        Object object = this.getMolPanelLock();
        synchronized (object) {
            Molecule mol = med.getPiece();
            if (mol != null && mol.isBond() && this.periodicSystemDialog != null) {
                this.periodicSystemDialog.releaseAll();
            }
        }
        this.mbuttonfit();
    }

    @Override
    protected void clean(int index) {
        this.sketchCanvas.clean(this.getCleanDim());
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SketchPanel.this.clean0();
                }
            });
        } else {
            this.clean0();
        }
    }

    private void clean0() {
        MolEditor med = this.getEditor();
        this.scrlpos = med.hasSelection() && !med.isAllSelected();
        this.setScrollbars(true);
        this.mbuttonfit();
    }

    @Override
    protected boolean regenBonds(int icell) {
        boolean ok = super.regenBonds(icell);
        if (ok) {
            this.getEditor().edit(10);
            this.getEditor().historize();
            this.getEditor().setDocumentEdited();
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initCursor() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            super.initCursor(this);
            super.initCursor(this.applet);
        }
    }

    @Override
    protected void repaintMols() {
        SketchCanvas b = this.sketchCanvas;
        if (b != null) {
            b.repaint();
        }
    }

    public boolean canRemoveAbsChiral() {
        MolEditor moledit = this.sketchCanvas.getEditor();
        return moledit.canSetAbsStereo(false);
    }

    public boolean canSetAbsChiral() {
        MolEditor moledit = this.sketchCanvas.getEditor();
        return moledit.canSetAbsStereo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDetached(boolean v) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            if (this.isDetached() == v) {
                return;
            }
            this.detached = v;
            this.setDetached0(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDetached0(boolean v) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            Boolean old = new Boolean(!v);
            Boolean val = new Boolean(v);
            this.changeListeners.firePropertyChange("detachMode", old, val);
        }
    }

    public JToolBar getToolbar(String name) {
        return this.dockPane.getToolBar(name);
    }

    public String[] getToolbarIDs() {
        return this.dockPane.getToolBarNames();
    }

    public boolean isToolbarVisible(String name) {
        return this.dockPane.isToolBarVisible(name);
    }

    public void setToolbarVisible(String name, boolean b) {
        if (b) {
            this.dockPane.dockToolBar(name);
        } else {
            this.dockPane.hideToolBar(name);
        }
        if (this.isToolbarVisible() != b) {
            this.updateToolbarVisibility();
        }
    }

    private void updateToolbarVisibility() {
        boolean oldValue = this.toolbarVisible;
        this.toolbarVisible = this.hasVisibleToolbar();
        this.changeListeners.firePropertyChange("toolbarVisible", oldValue, this.isToolbarVisible());
    }

    private boolean hasVisibleToolbar() {
        String[] ids = this.dockPane.getToolBarNames();
        for (int i = 0; i < ids.length; ++i) {
            if (!this.dockPane.isToolBarVisible(ids[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isToolbarVisible() {
        return this.toolbarVisible;
    }

    public void setToolbarVisible(boolean b) {
        if (b == this.isToolbarVisible()) {
            return;
        }
        boolean oldValue = this.isToolbarVisible();
        this.toolbarVisible = b;
        this.setToolbarVisibleImpl(b);
        this.changeListeners.firePropertyChange("toolbarVisible", oldValue, this.isToolbarVisible());
    }

    private void setToolbarVisibleImpl(boolean b) {
        if (this.dockPane == null) {
            return;
        }
        String[] ids = this.dockPane.getToolBarNames();
        for (int i = 0; i < ids.length; ++i) {
            this.setToolbarVisible(ids[i], b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setButtonmode(boolean x) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            if (this.getMVIndex() >= 0 || this.applet == null) {
                return;
            }
            if (x) {
                MolPainter painter;
                Molecule m = this.sketchCanvas.getMol();
                MolButton b = this.mbutton;
                Dimension d = this.applet.getContentPane().getSize();
                d = MolButton.paintSize(d);
                if (b == null) {
                    this.mbutton = b = new MolButton(null, 1);
                    b.setStyle(2);
                    b.addMouseListener((MouseListener)((Object)this.applet));
                    b.setToolTipText("Click to show/hide sketcher window");
                    b.setBackground(this.getBackground());
                    b.setReqSize(d);
                }
                if ((painter = this.mpainter) == null) {
                    this.createMButtonPainter(m, d);
                }
                b.setMol(m);
                b.setPainter(this.mpainter);
                this.applet.setContentPane(b);
                if (!this.hasmenubar || !this.hasbuttonmenubar) {
                    this.applet.setJMenuBar(null);
                }
                this.mbuttonfit();
            } else {
                this.applet.setContentPane(this);
                this.applet.requestFocusInWindow();
            }
            if (x) {
                if (this.hasmenubar) {
                    this.setMenuBar(this.applet.getRootPane(), this.getViewButtonMenuBar());
                    if (this.mframe != null) {
                        JRootPane mfroot = this.mframe.getRootPane();
                        this.getDockHandler().setRootPane(mfroot);
                    }
                }
            } else {
                this.getDockHandler().setRootPane(this.rootPane);
            }
            this.applet.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clipboardOp(int op) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            MolEditor med = this.getEditor();
            try {
                if (op == 0) {
                    Molecule[] mols = new Molecule[]{this.getMClipboardMol()};
                    if (mols[0] != null) {
                        int id;
                        Molecule m = this.sketchCanvas.getMol();
                        boolean empty = true;
                        if (m != null) {
                            MDocument d = m.getDocument();
                            empty = d != null ? med.isEmpty() : m.isEmpty();
                        }
                        int n = id = empty ? 0 : 131073;
                        if (mols[0].getDocument() != null && m != null && m.getDocument() != null && empty) {
                            ColorSetUtil.mergeSets(mols[0].getDocument(), m.getDocument());
                            mols[0].getDocument().cloneSets(m.getDocument());
                        }
                        this.prepareMol(mols[0]);
                        this.molLoaded(mols, id);
                    }
                } else {
                    Molecule m = med.getMolSelection();
                    MolPainter p = med.getPainter();
                    m.transform(p.getRTransformRef());
                    String fmt = "default";
                    if (op == 2) {
                        fmt = "smiles";
                    } else if (op == 4) {
                        fmt = "dialog";
                    }
                    this.setMClipboardMol(m.getDocument(), p, fmt);
                    if (op == 3) {
                        this.sketchCanvas.delSel();
                    }
                    this.sketchCanvas.reset();
                    this.mbuttonfit();
                }
            }
            catch (SecurityException sex) {
                sex.printStackTrace();
                this.getErrorDisplay().firewallError(sex, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DnD getDnD() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            String jver;
            if (this.sketchDnD == null && !(jver = System.getProperty("java.version")).startsWith("1.1")) {
                this.sketchDnD = new DnD("sketch.swing.SketchDnD", this.sketchCanvas, this, this, 3, "ACTION_COPY | ACTION_MOVE", this.getDebug());
            }
            return this.sketchDnD;
        }
    }

    public SketchCanvas getCanvas() {
        return this.sketchCanvas;
    }

    public MolEditor getEditor() {
        return this.sketchCanvas.getEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLoadingAbbreviations() {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            if (this.abbrevGroupsFile != null) {
                this.startLoader(this.abbrevGroupsFile, null, 66048L, false);
            }
        }
    }

    private void setMenuBar(JRootPane rootPane, JMenuBar menubar) {
        if (rootPane == null || !this.hasmenubar) {
            return;
        }
        boolean changed = false;
        if (SketchPanel.getMarvinMenuBar(rootPane) != null) {
            changed = SketchPanel.updateMarvinMenuBar(rootPane, menubar);
        } else if (rootPane.getJMenuBar() != menubar) {
            rootPane.setJMenuBar(menubar);
            changed = true;
        }
        if (changed) {
            this.fireMenuBarChanged(menubar);
            rootPane.validate();
            Color bg = this.getBackground();
            Color fg = this.getForeground();
            if (menubar != null) {
                SketchPanel.setColors(menubar, bg, fg);
                menubar.repaint();
            }
        }
    }

    protected void fireMenuBarChanged(JMenuBar menubar) {
        for (int i = 0; i < this.menuBarChangeListeners.size(); ++i) {
            MenuBarChangeListener l = (MenuBarChangeListener)this.menuBarChangeListeners.elementAt(i);
            l.menuBarChanged(menubar);
        }
    }

    protected JMenuBar getViewButtonMenuBar() {
        if (this.hasmenubar && this.hasbuttonmenubar && this.viewButtonMenuBar == null) {
            this.viewButtonMenuBar = this.createViewButtonMenuBar();
        }
        return this.viewButtonMenuBar;
    }

    protected JMenuBar createViewButtonMenuBar() {
        return this.guiModule.getViewButtonMenuBar();
    }

    @Override
    public void makeHelpMenu(Container menu, boolean popup, Object target) {
        this.guiModule.populateHelpMenu(menu);
    }

    private boolean canDockWindowSketcher() {
        if (this.applet == null || !this.isInJMSketch()) {
            return false;
        }
        Dimension sz = this.applet.getSize();
        boolean b = sz.width >= 400 && sz.height >= 300;
        return b;
    }

    private boolean isInJMSketch() {
        return this.applet != null && this.applet.getClass().getName().equals("chemaxon.marvin.applet.JMSketch") || this.applet.getClass().getName().equals("chemaxon.marvin.applet.JMSketchLaunch");
    }

    private void createMButtonPainter(Molecule m, Dimension d) {
        MolPainterCommon common = new MolPainterCommon();
        int opts = this.painterCommon.getDispopts();
        common.setDispopts(opts);
        MolPainter p = new MolPainter(common);
        p.setAtomSize(this.getUserSettings().getAtomSize());
        if (m != null) {
            p.setBoundsFor(m, false, false);
        }
        if (d != null) {
            p.setScreen(d);
            p.setScale(p.maxScale(d));
        }
        this.mpainter = p;
    }

    public void autoScale() {
        if (this.mpainter == null) {
            this.createMButtonPainter(null, null);
            MolPainterCommon common = this.mpainter.getCommon();
            if (!common.isAtomSymbolsVisible3D()) {
                int opts = common.getDispopts();
                common.setDispopts(opts |= 0x400);
            }
            common.setImplicitH("all");
        }
        Molecule mol = this.sketchCanvas.getMol();
        Dimension bsize = this.sketchCanvas.getSize();
        if (bsize.width * bsize.height > 0) {
            bsize.width -= this.getScrollbarExt();
            bsize.height -= this.getScrollbarExt();
        }
        MolEditor med = this.getEditor();
        if (mol == null) {
            return;
        }
        if (mol.getGraphUnion().getAtomCount() > 0) {
            this.mpainter.setBoundsFor(mol, false, true);
            if (med.isMultipageEnabled()) {
                this.setMaxScale(bsize, this.mpainter.calcMolMultipageBoundingRectangle(med.getDocument()));
            } else {
                double ms = this.mpainter.maxScale(bsize);
                if (this.maxScale > 0.0 && ms > this.maxScale) {
                    ms = this.maxScale;
                }
                this.setScale(ms);
            }
        } else if (med.isMultipageEnabled()) {
            this.setMaxScale(bsize, this.mpainter.calcMolMultipageRectangle(med.getDocument()));
        }
        this.scrlpos = false;
        this.setScrollbars(true);
    }

    private void setMaxScale(Dimension bsize, Dimension bounds) {
        double m1 = (double)bsize.width / (double)bounds.width;
        double m2 = (double)bsize.height / (double)bounds.height;
        double m = m1 > m2 ? m2 : m1;
        this.setScale(m * 1.54);
    }

    private void initTransient() {
        this.abbrevGroupLock = new Object();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initTransient();
        this.sketchDnD = null;
        this.getDnD();
        this.initAbbrevGroups();
        this.initUserTemplates();
        if (this.rlogicDialog != null) {
            this.rlogicDialog.callback("show", this.sketchCanvas.getMol());
        }
        if (this.groupCreationDialogHandler != null) {
            this.groupCreationDialogHandler.callback("show", this.sketchCanvas.getMol());
        }
        if (this.periodicSystemDialog != null && this.isPeriodicSystemVisible()) {
            this.periodicSystemDialog.open();
        }
    }

    public static long getTotalInstanceNumber() {
        return total;
    }

    public static long getLiveInstanceNumber() {
        return live;
    }

    protected void finalize() throws Throwable {
        --live;
        if (this.getDebug() != 0) {
            System.err.println("SketchPanel#" + this.hashCode() + " died");
        }
        super.finalize();
    }

    private void fitPageWidth() {
        MolEditor med = this.getEditor();
        DPoint3 oldUpperLeft = med.getSelectedMultipageCell();
        double m = med.getWidthFitScale(this.sketchCanvas.getSize());
        this.setScale(this.getScale() * m);
        DPoint3 upperLeft = med.getSelectedMultipageCell();
        this.scroll((int)Math.ceil(upperLeft.x - 2.0), (int)Math.ceil(upperLeft.y - oldUpperLeft.y));
    }

    private void fitPageHeight() {
        MolEditor med = this.getEditor();
        DPoint3 oldUpperLeft = med.getSelectedMultipageCell();
        double m = med.getHeightFitScale(this.sketchCanvas.getSize());
        this.setScale(this.getScale() * m);
        DPoint3 upperLeft = med.getSelectedMultipageCell();
        this.scroll((int)Math.ceil(upperLeft.x - oldUpperLeft.x), (int)Math.ceil(upperLeft.y - 2.0));
    }

    public void centraliseSelectedPage(PageSettings ps) {
        MolEditor med = this.getEditor();
        int selectedPage = ps.getSelectedPage();
        Dimension canvasSize = this.sketchCanvas.getSize();
        ps.setSelectedPage(selectedPage);
        DPoint3 upperLeft = med.getSelectedMultipageCell();
        Dimension d = med.getMultipageCellBounds();
        this.scroll((int)Math.ceil(upperLeft.x - (double)((canvasSize.width - d.width) / 2)), (int)Math.ceil(upperLeft.y - (double)((canvasSize.height - d.height) / 2)));
    }

    private void fitPage(PageSettings ps) {
        MolEditor med = this.getEditor();
        int selectedPage = ps.getSelectedPage();
        Dimension canvasSize = this.sketchCanvas.getSize();
        double m1 = med.getHeightFitScale(canvasSize);
        double m2 = med.getWidthFitScale(canvasSize);
        double m = Math.min(m1, m2);
        this.setScale(this.getScale() * m);
        ps.setSelectedPage(selectedPage);
        DPoint3 upperLeft = med.getSelectedMultipageCell();
        Dimension d = med.getMultipageCellBounds();
        if (m == m1) {
            this.scroll((int)Math.ceil(upperLeft.x - (double)((canvasSize.width - d.width) / 2)), (int)Math.ceil(upperLeft.y - 2.0));
        } else {
            this.scroll((int)Math.ceil(upperLeft.x - 2.0), (int)Math.ceil(upperLeft.y - (double)((canvasSize.height - d.height) / 2)));
        }
    }

    private void previousPage(PageSettings ps) {
        int previousPage = ps.getSelectedPage() - 1;
        if (previousPage >= 0) {
            ps.setSelectedPage(previousPage);
        } else {
            ps.setSelectedPage(0);
        }
        this.updatePage(ps);
    }

    private void nextPage(PageSettings ps) {
        int lastPage;
        int nextPage = ps.getSelectedPage() + 1;
        if (nextPage <= (lastPage = ps.getColumnCount() * ps.getRowCount() - 1)) {
            ps.setSelectedPage(nextPage);
        } else {
            ps.setSelectedPage(lastPage);
        }
        this.updatePage(ps);
    }

    private void firstPage(PageSettings ps) {
        ps.setSelectedPage(0);
        this.updatePage(ps);
    }

    private void lastPage(PageSettings ps) {
        ps.setSelectedPage(ps.getColumnCount() * ps.getRowCount() - 1);
        this.updatePage(ps);
    }

    private void updatePage(PageSettings ps) {
        this.centraliseSelectedPage(ps);
        this.sketchCanvas.repaint();
        if (this.hasStatusBar) {
            this.getStatusBar().update();
        }
    }

    public void doGoToPage() {
        PageSettings ps = this.getEditor().getDocument().getPageSettings();
        int x = 0;
        try {
            x = Integer.valueOf(this.getStatusBar().getSelectedPageField().getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (x > 0 && x <= ps.getColumnCount() * ps.getRowCount()) {
            ps.setSelectedPage(x - 1);
        } else {
            PagesActions.showErrorMessageDialog(this.sketchCanvas);
        }
        this.updatePage(ps);
    }

    public void doAddMulticenter() {
        MolEditor med = this.getEditor();
        if (med != null) {
            med.createMulticenter();
        }
        this.doSetSelectionMove(-1);
        this.sketchCanvas.repaint();
        this.fireChangeEvent();
    }

    public void doCreateMarkush() {
        MolEditor med = this.getEditor();
        if (med != null) {
            med.addMarkushBond();
        }
        this.sketchCanvas.repaint();
    }

    public void updatePagesMenu() {
        this.fireChangeEvent(new SketchChangeEvent(this, 1));
    }

    public void startPrint() {
        CallbackIface mm = (CallbackIface)MarvinModule.load("common.swing.Print", this);
        if (mm != null) {
            mm.callback("setAtomSize", this.getUserSettings().getAtomSize());
            mm.callback("setBondSpacing", new Double(this.getBondSpacing()));
            mm.callback("setDispopts", new Integer(this.painterCommon.getDispopts()));
            MolEditor medit = this.getEditor();
            mm.callback("setDocument", medit.getDocument());
            this.endHourglass();
            mm.callback("print", this);
        }
    }

    public void fitFragment(boolean selection, MoleculeGraph[] molg, int id) {
        Rectangle bounds;
        MolEditor med = this.getEditor();
        double oldScale = med.getPainter().getScale();
        Dimension canvasSize = this.sketchCanvas.getSize();
        if (selection) {
            MoleculeGraph[] mg = new MoleculeGraph[]{med.getSelectionMolecule()};
            if (mg[0].isEmpty()) {
                return;
            }
            bounds = med.getPainter().fitFragment(mg, id, canvasSize);
            this.setScale(med.getPainter().getScale() / oldScale * this.getScale());
        } else {
            bounds = med.getPainter().fitFragment(molg, id, canvasSize);
            this.setScale(med.getPainter().getScale() / oldScale * this.getScale());
        }
        this.scroll(bounds.x, bounds.y);
    }

    public SketchMode createSM(Molecule m) {
        SketchMode sm = this.getEditor().createSM(m);
        this.setSketchMode(sm, false, false, false, true);
        return sm;
    }

    @Override
    public void setGlobalGUIProperties(MPropertyContainer gp) {
        super.setGlobalGUIProperties(gp);
        if (this.globalGUIProperties != null) {
            if (this.getCleanDim() == 2) {
                this.userSettings.setSketchMolbg2d(this.getMolbg());
            } else {
                this.userSettings.setSketchMolbg3d(this.getMolbg());
            }
        }
    }

    boolean hasMenuBar() {
        return this.hasmenubar;
    }

    public JMenuBar getCurrentMenuBar() {
        return this.hasmenubar ? this.currentSketcherMenuBar : null;
    }

    public void updateStatusBar() {
        this.getStatusBar().update();
    }

    private void setCurrentMenubarEnabled(boolean enabled) {
        if (this.currentSketcherMenuBar == null) {
            return;
        }
        this.currentSketcherMenuBar.setEnabled(enabled);
        for (int i = 0; i < this.currentSketcherMenuBar.getMenuCount(); ++i) {
            this.currentSketcherMenuBar.getComponent(i).setEnabled(enabled);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.sketchCanvas.setEnabled(enabled);
        if (this.hscrollbar != null) {
            this.hscrollbar.setEnabled(enabled);
        }
        if (this.vscrollbar != null) {
            this.vscrollbar.setEnabled(enabled);
        }
        this.setCurrentMenubarEnabled(enabled);
        String[] ids = this.dockPane.getToolBarNames();
        for (int i = 0; i < ids.length; ++i) {
            this.guiModule.getToolBarController(ids[i]).setEnabled(enabled);
        }
        if (this.hasStatusBar) {
            this.getStatusBar().setEnabled(enabled);
        }
    }

    private void updateNameBox() {
        Molecule mol = this.getMol();
        MDocument doc = mol.getDocument();
        if (doc != null) {
            for (int i = doc.getObjectCount() - 1; i >= 0; --i) {
                if (!(doc.getObject(i) instanceof MNameTextBox)) continue;
                MNameTextBox textBox = (MNameTextBox)doc.getObject(i);
                textBox.setPreferredWidth((double)this.sketchCanvas.getWidth() / (this.getEditor().getPainter().getScale() / 1.54));
            }
        }
    }

    public void useRecent(Molecule mol) {
        mol.moveTo(this.getEditor().getPointerPos());
        SketchMode sm = this.getEditor().createSM(mol);
        if (!this.pressButton(sm, false)) {
            this.getCanvas().setSketchMode(sm, false);
        }
        this.requestFocusInWindow();
    }

    private SketchMode getLastSelectSM() {
        if (this.lastSelectSM == null) {
            this.lastSelectSM = this.createDefaultSelectSM();
        }
        return this.lastSelectSM;
    }

    public void useDefaultSelectionMode() {
        this.sketchCanvas.setSketchMode(this.getLastSelectSM(), true);
    }

    private RectangleSelectSM createDefaultSelectSM() {
        return new RectangleSelectSM(this.getEditor());
    }

    @Override
    public void setMClipboardMol(MDocument doc, MolPainter painter, String fmt) throws SecurityException {
        super.setMClipboardMol(doc, painter, fmt);
    }

    public void showCustomizeDialog() {
        this.showConfigurationDialog("showCustomizeDialog");
    }

    JPopupMenu showPopup(MouseEvent e) {
        PointedObject po = this.getEditor().getObjectForPopup();
        if (po instanceof MObjectPO && this.isReactionArrow(((MObjectPO)po).getMObject())) {
            return null;
        }
        String id = null;
        id = po instanceof MObjectPO ? "object" : (po instanceof AtomPO ? "atom" : (po instanceof BondPO ? "bond" : "edit"));
        return this.guiModule.showPopup(id, e);
    }

    private boolean isReactionArrow(MObject o) {
        Molecule molg = this.getEditor().getMol();
        if (molg instanceof RgMolecule) {
            molg = ((RgMolecule)molg).getRoot();
        }
        return molg instanceof RxnMolecule && o instanceof MPolyline && o == ((RxnMolecule)molg).getItsArrow();
    }

    public void setPersonalizationEnbaled(boolean b) {
        boolean oldValue = this.isPersonalizationEnabled();
        this.personalizationEnabled = b && this.isWriteEnabled() && this.isReadEnabled();
        this.firePropertyChange("personalizationEnabled", oldValue, this.isPersonalizationEnabled());
    }

    public boolean isPersonalizationEnabled() {
        return this.personalizationEnabled && this.isWriteEnabled() && this.isReadEnabled() && this.shortcutURL == null && this.configurationURL == null && this.serializedConfigurationURL == null;
    }

    private boolean isPersonalizationSaveEnabled() {
        return this.isPersonalizationEnabled() && !this.useComponentActions;
    }

    private void loadPersonalization() {
        if (this.getGUIModule().isConfigurationLoaded()) {
            return;
        }
        try {
            if (this.isPersonalizationEnabled()) {
                this.guiModule.setPersonalizationDirectory(this.customizationDirectory);
                this.guiModule.loadPersonalisation();
            } else if (this.configurationURL != null || this.shortcutURL != null) {
                this.guiModule.loadPersonalisation(this.configurationURL, this.shortcutURL);
            }
        }
        catch (IOException e) {
            this.getErrorDisplay().error("Missing or invalid configuration file!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markMenuDirty() {
        Object object = this.saveLock;
        synchronized (object) {
            this.menuChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePersonalisation() {
        if (!this.isPersonalizationSaveEnabled()) {
            return;
        }
        Object object = this.saveLock;
        synchronized (object) {
            if (!this.menuChanged) {
                return;
            }
            try {
                this.menuChanged = false;
                this.guiModule.writePersonalisation();
            }
            catch (IOException e) {
                this.getErrorDisplay().error("Error saving personalisation!", e);
            }
        }
    }

    public synchronized GUIModule getGUIModule() {
        if (this.guiModule == null) {
            try {
                this.guiModule = new SketchGUIModule(this, this.serializedConfigurationURL);
                this.guiModule.setToolbarFloatable(this.toolbarFloatable);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Error loading GUI configuration!", e);
            }
            this.guiModule.addPropertyChangeListener("guiRegistry", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SketchPanel.this.hasmenubar) {
                                SketchPanel.this.currentSketcherMenuBar = SketchPanel.this.guiModule.getMenuBar();
                                SketchPanel.this.fireMenuBarChanged(SketchPanel.this.guiModule.getMenuBar());
                            }
                        }
                    });
                }
            });
            this.updateModuleActionMap();
        }
        return this.guiModule;
    }

    private void updateModuleActionMap() {
        if (this.guiModule == null || this.rootPane == null) {
            return;
        }
        this.guiModule.setActionMap(this.useComponentActions ? this.rootPane.getActionMap() : null);
    }

    public void groupReactionFrags(int type) {
        this.getEditor().edit(15, type);
        this.sketchCanvas.reset();
    }

    public void groupReactionSplit(int type) {
        this.getEditor().edit(23, type);
        this.sketchCanvas.reset();
    }

    public void changeFocus2Canvas() {
        this.sketchCanvas.requestFocusInWindow();
    }

    public boolean isFocusOnCanvas() {
        return this.sketchCanvas.isFocusOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showConfigurationDialog(String command) {
        this.beginHourglass();
        try {
            CallbackIface f = (CallbackIface)MarvinModule.load("sketch.swing.GUIConfigurationDialog", this);
            if (f == null) {
                return;
            }
            if (this.isPersonalizationEnabled()) {
                this.getDockHandler().removeChangeListener(this);
            }
            f.callback("setComponent", this);
            f.callback("setModule", this.getGUIModule());
            f.callback(command, null);
            this.markMenuDirty();
            this.savePersonalisation();
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            if (this.isPersonalizationEnabled()) {
                this.getDockHandler().addChangeListener(this);
            }
            this.endHourglass();
        }
    }

    public void showGUIConfigurationDialog() {
        this.showConfigurationDialog("showGUIConfigurationDialog");
    }

    public boolean isCloseEnabled() {
        return this.closeEnabled;
    }

    public void setCloseEnabled(boolean b) {
        boolean oldValue = this.closeEnabled;
        this.closeEnabled = b;
        this.firePropertyChange("closeEnabled", oldValue, b);
    }

    public boolean isTransferButtonVisible() {
        return this.transferButtonVisible;
    }

    public void setTransferButtonVisible(boolean b) {
        boolean oldValue = this.isTransferButtonVisible();
        this.transferButtonVisible = b;
        this.firePropertyChange("transferButtonVisible", oldValue, this.isTransferButtonVisible());
    }

    public void doLicenses() {
        JDialog d = LicenseManagerGUI.createDialog(this);
        d.setVisible(true);
        LicenseManagerGUI.doLicenseCheck(d);
    }

    @Override
    public void updateBounds() {
        this.mpainter.setBoundsFor(this.getEditor().getMol(), false, false);
    }

    public void setAutoCheckStructure(boolean b) {
        this.userSettings.setAutoCheckStructure(b);
    }

    public boolean isAutoCheckStructure() {
        return this.userSettings.isAutoCheckStructure();
    }

    private synchronized AloeDockHandler getDockHandler() {
        if (this.dockHandler == null) {
            this.dockHandler = new AloeDockHandler(null, this.dockPane, this.guiModule, this.hasmenubar);
        }
        return this.dockHandler;
    }

    public MoleculeGraph zoomToScaffold() {
        Molecule mol;
        MDocument doc = this.getEditor().getDocument();
        Molecule molg = mol = doc != null ? (Molecule)doc.getMainMoleculeGraph() : null;
        RgMoleculeGraphIface rgmol = (RgMoleculeGraphIface)((Object)molg);
        MoleculeGraph mg = rgmol.getRootG();
        this.fitFragment(false, new MoleculeGraph[]{mg}, 0);
        return mg;
    }

    public int getHScrollBarPos() {
        return this.hscrollbar.getValue();
    }

    public int getVScrollBarPos() {
        return this.vscrollbar.getValue();
    }

    public List<String> getDisabledGroupTypes() {
        if (this.disabledGroupTypes != null) {
            return Collections.unmodifiableList(this.disabledGroupTypes);
        }
        return new ArrayList<String>();
    }

    public void setDisabledGroupTypes(List<String> disabledGroupTypes) {
        this.disabledGroupTypes = disabledGroupTypes;
    }

    @Override
    public void updateCheckers() {
        CheckerStatusbarComponent.getInstance(this).forceCheckerConfigReload();
    }

    static {
        total = 0L;
        live = 0L;
        COPY_DEFAULT = 1;
        COPY_AS_SMILES = 2;
        bgscheduler = null;
        bgloader = null;
        preschedule = null;
        preloader = null;
        RESOURCES = SketchPanel.getResourceBundle(SketchPanel.class.getName());
    }

    private static enum Mode {
        ATOM("atom", true),
        BOND("bond", true),
        SELECT("rectangleSelectMode"),
        LASSO_SELECT("lassoSelectMode"),
        STRUCTURE_SELECT("moleculeSelectMode"),
        ERASE("eraseMode"),
        BOLD("boldMode"),
        CHAIN("insertChain"),
        ELECTRON_FLOW_1("insertElectronFlow"),
        ELECTRON_FLOW_2("insertElectronFlow2"),
        REACTION_ARROW("reactionArrow0"),
        RETROSYNTHETIC_ARROW("reactionArrow1"),
        RESONANCE_ARROW("reactionArrow2"),
        EQUILIBRIUM_ARROW("reactionArrow3"),
        INCREASE_CHARGE("increaseCharge"),
        DECREASE_CHARGE("decreaseCharge"),
        ASSIGN_ATOM("Merge3DMapping"),
        SWITCH_RADICAL("radical.radN"),
        RADICAL_OFF("radical.rad0"),
        MONOVALENT_RADICAL("radical.rad1"),
        INCREASE_LONE_PAIRS("lonePair.lpN");

        private final String actionID;
        private final boolean partial;

        private Mode(String id) {
            this(id, false);
        }

        private Mode(String id, boolean partial) {
            this.actionID = id;
            this.partial = partial;
        }

        public String getActionID() {
            return this.actionID;
        }

        private String getID() {
            return this.name().replace("_", "");
        }

        private boolean isValidID(String id) {
            return this.partial ? id.startsWith(this.getID()) : id.equals(this.getID());
        }

        public static Mode forName(String id) {
            if (id == null) {
                return null;
            }
            String uID = id.toUpperCase();
            for (Mode mode : Mode.values()) {
                if (!mode.isValidID(uID)) continue;
                return mode;
            }
            return null;
        }

        public static int getFlag(String s) {
            String[] t = s.split(":");
            if (t.length == 1) {
                return -1;
            }
            try {
                return Integer.parseInt(t[1]);
            }
            catch (NumberFormatException ignored) {
                return -1;
            }
        }
    }
}

