/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import chemaxon.marvin.common.swing.CommonStatusBar;
import chemaxon.marvin.sketch.MolEditor;
import chemaxon.marvin.sketch.swing.DimButton;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.modules.checker.CheckerStatusbarComponent;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SketchStatusBar
extends CommonStatusBar
implements MouseListener {
    private static final long serialVersionUID = -1446485354473544523L;
    private SketchPanel sketchPanel;
    private JLabel modifiedLabel;
    public DimButton dimButton;
    private JComponent checkerControl = null;

    public SketchStatusBar(SketchPanel skpan, CommonStatusBar.PageActionProvider pagesActions) {
        super(pagesActions);
        this.sketchPanel = skpan;
        FlowLayout fl = new FlowLayout(3);
        fl.setVgap(0);
        this.setLayout(fl);
        this.dimButton = new DimButton(skpan.getCleanDim());
        this.add(this.dimButton);
        this.dimButton.addMouseListener(this);
        this.modifiedLabel = new JLabel("");
        Font f = this.dimButton.getFont();
        Font font = new Font(f.getName(), 0, f.getSize());
        this.modifiedLabel.setFont(font);
        this.add(this.modifiedLabel);
        this.add(this.getCheckerControl());
    }

    void update() {
        MolEditor med = this.sketchPanel.getEditor();
        boolean modified = med.isDocumentEdited();
        this.modifiedLabel.setText(modified ? " * " : "");
        this.dimButton.setDim(this.sketchPanel.getCleanDim());
        this.update(med.getDocument());
        this.validate();
    }

    @Override
    public void relayout(boolean addPagesItems) {
        this.removeAll();
        this.add(this.dimButton);
        this.add(this.modifiedLabel);
        if (addPagesItems) {
            this.add(this.getPagesPanel());
        }
        this.add(this.getCheckerControl());
    }

    void setDim(int dim) {
        this.dimButton.setDim(dim);
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        this.sketchPanel.changeFocus2Canvas();
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        Object target = ev.getSource();
        if (target == this.dimButton) {
            boolean histEnabled = this.sketchPanel.getEditor().setHistorizeEnabled(false);
            this.sketchPanel.changeDim();
            this.sketchPanel.getEditor().setHistorizeEnabled(histEnabled);
            this.sketchPanel.getEditor().historize();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        int i;
        super.setEnabled(enabled);
        Component[] comps = this.getComponents();
        for (i = 0; i < comps.length; ++i) {
            comps[i].setEnabled(enabled);
        }
        if (this.hasPagesPanel()) {
            comps = this.getPagesPanel().getComponents();
            for (i = 0; i < comps.length; ++i) {
                comps[i].setEnabled(enabled);
            }
        }
    }

    private JComponent getCheckerControl() {
        if (this.checkerControl == null) {
            this.checkerControl = CheckerStatusbarComponent.getInstance(this.sketchPanel);
        }
        return this.checkerControl;
    }
}

