/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing;

import chemaxon.marvin.common.swing.MoleculeProvider;
import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.awt.Rectangle;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class SubstituentMoleculeProvider
implements MoleculeProvider {
    private final SketchPanel origPanel;
    private final SketchPanel newPanel;
    private final JDialog newPanelContainer;

    public SubstituentMoleculeProvider(SketchPanel origPanel, SketchPanel newPanel, JDialog container) {
        this.origPanel = origPanel;
        this.newPanel = newPanel;
        this.newPanelContainer = container;
    }

    @Override
    public Molecule getMolecule(int index) {
        return null;
    }

    @Override
    public void setMolecule(int ignored, Molecule mol, boolean changed) {
        if (changed) {
            MoleculeGraph[] mols = new MoleculeGraph[]{this.origPanel.getMol(), mol};
            CleanUtil.arrangeMolecules(mols, 2, -1);
            Molecule m = new Molecule();
            m.fuse(mols[0]);
            m.fuse(mols[1]);
            this.origPanel.setMol(m, false);
            final Rectangle rec1 = this.origPanel.getCanvas().getPainter().getBoundsFor(mols, this.origPanel.getScale());
            final Rectangle rec2 = this.origPanel.getCanvas().getPainter().getBoundsFor(new MDocument(mols[1]), this.origPanel.getScale());
            Rectangle canvSize = this.origPanel.getCanvas().getVisibleRect();
            if (rec1.width >= canvSize.width || rec1.height >= canvSize.height) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SubstituentMoleculeProvider.this.origPanel.scroll((rec1.width - rec2.width) / 2, 0);
                    }
                });
            }
        }
        this.newPanel.setMoleculeProvider(null);
        this.newPanel.startstop(true);
        this.newPanel.exit();
        this.newPanelContainer.setVisible(false);
        this.newPanelContainer.dispose();
    }
}

