/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchAction;
import chemaxon.marvin.uif.util.listener.WeakPropertyChangeListener;
import java.beans.PropertyChangeEvent;

public abstract class AbstractPropertyAction
extends AbstractSketchAction {
    private final String[] propertyNames;

    public AbstractPropertyAction(String propertyName) {
        this(new String[]{propertyName});
    }

    public AbstractPropertyAction(String[] propertyNames) {
        this.propertyNames = (String[])propertyNames.clone();
    }

    public AbstractPropertyAction(SketchPanel panel, String propertyName) {
        this(panel, new String[]{propertyName});
    }

    public AbstractPropertyAction(SketchPanel panel, String[] propertyNames) {
        super(panel);
        this.propertyNames = (String[])propertyNames.clone();
        this.init();
    }

    private void init() {
        this.getPanel().addPropertyChangeListener(new PropertyHandler(this, this.getPanel()));
    }

    protected abstract void propertyChanged();

    @Override
    public void setSketchPanel(SketchPanel panel) {
        super.setSketchPanel(panel);
        this.init();
        this.propertyChanged();
    }

    public final void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null || this.isObservedProperty(evt.getPropertyName())) {
            this.propertyChanged();
        }
    }

    private boolean isObservedProperty(String propertyName) {
        for (int i = 0; i < this.propertyNames.length; ++i) {
            if (!propertyName.equals(this.propertyNames[i])) continue;
            return true;
        }
        return false;
    }

    private static class PropertyHandler
    extends WeakPropertyChangeListener {
        public PropertyHandler(AbstractPropertyAction target, SketchPanel source) {
            super(target, source);
        }

        @Override
        protected void propertyChanged(Object target, Object source, PropertyChangeEvent evt) {
            ((AbstractPropertyAction)target).propertyChange(evt);
        }
    }
}

