/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMoleculeGraphIface;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ZoomModel {
    public static final double ZOOM_FACTOR = 1.25;
    private static final String ALL = "all.label";
    private static final String SCAFFOLD = "scaffold.label";
    private static final String SELECTION = "selection.label";
    private static final String MORE = "more.label";
    private static final int MAX_RGROUP_COUNT = 4;
    private static final double[] VISIBLE_ZOOM_VALUES = new double[]{400.0, 200.0, 150.0, 100.0, 75.0, 50.0, 25.0};
    private static final double[] ZOOM_VALUES = new double[]{1.0, 8.333333015441895, 12.5, 25.0, 33.33333206176758, 50.0, 66.66666412353516, 75.0, 100.0, 125.0, 150.0, 200.0, 300.0, 400.0, 600.0, 800.0, 1200.0, 1600.0, 2400.0, 3200.0, 6400.0};
    private static final double MIN_ZOOM_VALUE = ZOOM_VALUES[0];
    private static final double MAX_ZOOM_VALUE = ZOOM_VALUES[ZOOM_VALUES.length - 1];
    private SketchPanel panel;
    private static final ResourceBundle bundle = ResourceBundle.getBundle(ZoomModel.class.getPackage().getName() + ".resources." + ZoomModel.class.getSimpleName());
    private NumberFormat numberFormat;
    private NumberFormat percentFormat;

    public ZoomModel(SketchPanel panel) {
        this.panel = panel;
        this.numberFormat = NumberFormat.getNumberInstance();
        this.percentFormat = NumberFormat.getPercentInstance();
    }

    public String getSelectedItem() {
        return this.format(this.getNormalizedScale(), true);
    }

    public double getNormalizedScale() {
        return this.panel.getScale() / 28.0 * 100.0;
    }

    public boolean canZoomIn() {
        return this.getNormalizedScale() < MAX_ZOOM_VALUE;
    }

    public boolean canZoomOut() {
        return this.getNormalizedScale() > MIN_ZOOM_VALUE;
    }

    public void zoomOut(int mouseX, int mouseY) {
        if (!this.canZoomOut()) {
            return;
        }
        this.centeredZoom(mouseX, mouseY, this.getNormalizedScale() * 0.01, ZOOM_VALUES[Math.max(0, this.getZoomLevelIndex(this.getNormalizedScale(), false))] * 0.01);
    }

    public void zoomOut() {
        if (!this.canZoomOut()) {
            return;
        }
        this.zoom(ZOOM_VALUES[Math.max(0, this.getZoomLevelIndex(this.getNormalizedScale(), false))] / 100.0);
    }

    public void zoomIn(int mouseX, int mouseY) {
        if (!this.canZoomIn()) {
            return;
        }
        this.centeredZoom(mouseX, mouseY, this.getNormalizedScale() / 100.0, ZOOM_VALUES[Math.min(ZOOM_VALUES.length - 1, this.getZoomLevelIndex(this.getNormalizedScale(), true) + 1)] / 100.0);
    }

    public void zoomIn() {
        if (!this.canZoomIn()) {
            return;
        }
        this.zoom(ZOOM_VALUES[Math.min(ZOOM_VALUES.length - 1, this.getZoomLevelIndex(this.getNormalizedScale(), true) + 1)] / 100.0);
    }

    private int getZoomLevelIndex(double zoomValue, boolean includeLowerBound) {
        for (int i = ZOOM_VALUES.length - 1; i >= 0; --i) {
            if (!(ZOOM_VALUES[i] < zoomValue) && (!includeLowerBound || ZOOM_VALUES[i] != zoomValue)) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedItem(String value) {
        try {
            double d = this.parse(value);
            this.zoom(d);
            this.panel.requestFocus();
            return;
        }
        catch (ParseException parseException) {
            if (this.equals(ALL, value)) {
                this.zoomAll();
            } else if (this.equals(SELECTION, value)) {
                this.zoomSelection();
            } else if (this.equals(SCAFFOLD, value)) {
                this.zoomScaffold();
            } else if (this.equals(MORE, value)) {
                this.showMoreDialog();
            } else if (value.toUpperCase().startsWith("R")) {
                this.zoomRGroup(value);
            }
            this.panel.requestFocus();
            return;
        }
    }

    private void centeredZoom(int centerX, int centerY, double oldValue, double newValue) {
        double revRatio = 1.0 - oldValue / newValue;
        int dx = (int)Math.round(revRatio * (double)(centerX - this.panel.getCanvas().getWidth() / 2));
        int dy = (int)Math.round(revRatio * (double)(centerY - this.panel.getCanvas().getHeight() / 2));
        boolean histEnabled = this.panel.getEditor().setHistorizeEnabled(false);
        this.panel.setScale(newValue * 28.0);
        this.panel.getEditor().setHistorizeEnabled(histEnabled);
        this.panel.getEditor().historize();
        this.panel.adjustScrollbars(dx, dy, true, true);
    }

    private void zoom(double newValue) {
        boolean histEnabled = this.panel.getEditor().setHistorizeEnabled(false);
        this.panel.setScale(newValue * 28.0);
        this.panel.getEditor().setHistorizeEnabled(histEnabled);
        this.panel.getEditor().historize();
        this.panel.setScrollbars(true, true);
    }

    private void zoomAll() {
        boolean histEnabled = this.panel.getEditor().setHistorizeEnabled(false);
        this.panel.autoScale();
        this.panel.getEditor().setHistorizeEnabled(histEnabled);
        this.panel.getEditor().historize();
        this.panel.setScrollbars(false, true);
    }

    private void zoomScaffold() {
        if (this.hasRScaffold()) {
            boolean histEnabled = this.panel.getEditor().setHistorizeEnabled(false);
            MoleculeGraph mg = this.panel.zoomToScaffold();
            this.panel.getEditor().setHistorizeEnabled(histEnabled);
            this.panel.getEditor().historizeAfterZoom(false, new MoleculeGraph[]{mg});
            this.panel.setScrollbars(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zoomSelection() {
        if (this.panel.getEditor().hasSelection()) {
            boolean histEnabled = this.panel.getEditor().setHistorizeEnabled(false);
            try {
                this.panel.fitFragment(true, null, 0);
            }
            finally {
                this.panel.getEditor().setHistorizeEnabled(histEnabled);
                this.panel.getEditor().historizeAfterZoom(true, null);
                this.panel.setScrollbars(false, true);
            }
        }
    }

    private void showMoreDialog() {
        if (!this.hasRGroups()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] groups = ZoomModel.this.getRGroupLabels();
                Object result = JOptionPane.showInputDialog(ZoomModel.this.panel, bundle.getString("popup.message"), bundle.getString("popup.title"), -1, null, groups, groups[0]);
                if (result != null) {
                    ZoomModel.this.zoomRGroup(result.toString());
                }
            }
        });
    }

    private void zoomRGroup(String value) {
        try {
            this.zoomRGroup(Long.parseLong(value.substring(1)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void zoomRGroup(long id) {
        if (!this.hasRGroups()) {
            return;
        }
        boolean histEnabled = this.panel.getEditor().setHistorizeEnabled(false);
        Molecule molg = this.panel.getEditor().getMol();
        RgMoleculeGraphIface rgmol = (RgMoleculeGraphIface)((Object)molg);
        int index = ZoomModel.getRGroupIndex(rgmol, id);
        if (index == -1) {
            return;
        }
        MoleculeGraph[] mg = new MoleculeGraph[rgmol.getRgroupMemberCount(index)];
        for (int i = 0; i < mg.length; ++i) {
            mg[i] = rgmol.getRgroupMemberG(index, i);
        }
        this.panel.fitFragment(false, mg, (int)id);
        this.panel.getEditor().setHistorizeEnabled(histEnabled);
        this.panel.getEditor().historizeAfterZoom(false, mg);
        this.panel.setScrollbars(false, true);
    }

    public String[] getItems() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < VISIBLE_ZOOM_VALUES.length; ++i) {
            result.add(this.format(VISIBLE_ZOOM_VALUES[i], true));
        }
        if (this.panel.isRgroupsVisible()) {
            result.add(bundle.getString(ALL));
        }
        if (this.panel.getEditor().hasSelection()) {
            result.add(bundle.getString(SELECTION));
        }
        if (this.hasRScaffold()) {
            result.add(bundle.getString(SCAFFOLD));
            RgMoleculeGraphIface rgmol = (RgMoleculeGraphIface)((Object)this.getMolecule());
            result.addAll(Arrays.asList(this.getRGroupLabels(4)));
            if (rgmol.getRgroupCount() > 4) {
                result.add(bundle.getString(MORE));
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean hasRScaffold() {
        Molecule molg = this.getMolecule();
        return molg != null && molg instanceof RgMoleculeGraphIface && ((RgMoleculeGraphIface)((Object)molg)).getRgroupCount() > 0;
    }

    private String[] getRGroupLabels() {
        return this.getRGroupLabels(-1);
    }

    private String[] getRGroupLabels(int maxCount) {
        if (!this.hasRGroups()) {
            return new String[0];
        }
        RgMoleculeGraphIface rgmol = (RgMoleculeGraphIface)((Object)this.panel.getEditor().getMol());
        int count = rgmol.getRgroupCount();
        if (maxCount > 0) {
            count = Math.min(count, maxCount);
        }
        String[] result = new String[count];
        for (int i = 0; i < result.length; ++i) {
            result[i] = "R" + rgmol.getRgroupId(i);
        }
        return result;
    }

    private Molecule getMolecule() {
        MDocument doc = this.panel.getEditor().getDocument();
        Molecule mol = doc != null ? (Molecule)doc.getMainMoleculeGraph() : null;
        return mol;
    }

    private boolean hasRGroups() {
        Molecule molg = this.panel.getEditor().getMol();
        return molg != null && molg instanceof RgMoleculeGraphIface && ((RgMoleculeGraphIface)((Object)molg)).getRgroupCount() > 0;
    }

    private static int getRGroupIndex(RgMoleculeGraphIface rgmol, long id) {
        int k = rgmol.getRgroupCount();
        for (int i = 0; i < k; ++i) {
            if ((long)rgmol.getRgroupId(i) != id) continue;
            return i;
        }
        return -1;
    }

    private String format(double d, boolean percent) {
        if (percent) {
            return this.percentFormat.format(d / 100.0);
        }
        return this.numberFormat.format(d);
    }

    private double parse(String value) throws ParseException {
        try {
            return this.percentFormat.parse(value).doubleValue();
        }
        catch (ParseException parseException) {
            return this.numberFormat.parse(value).doubleValue() / 100.0;
        }
    }

    private boolean equals(String key, String value) {
        return bundle.getString(key).equalsIgnoreCase(value);
    }
}

