/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.ZoomModel;
import chemaxon.marvin.uif.util.listener.WeakPropertyChangeListener;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class ZoomTool {
    private static final String TOOLTIP = "Zoom Level";
    private static final String PROTOTYPE_VALUE = "9999%";
    private SketchPanel panel;
    private ZoomModel zoomModel;
    private JComboBox comboBox;
    private Model comboBoxModel;

    public ZoomTool(SketchPanel panel) {
        this.panel = panel;
        this.zoomModel = new ZoomModel(panel);
        this.comboBoxModel = new Model(this.zoomModel);
    }

    public JComponent getTool() {
        if (this.comboBox == null) {
            this.comboBox = this.createTool();
            this.panel.addPropertyChangeListener(new ScaleHandler(this, this.panel));
            this.scaleChanged();
        }
        return this.comboBox;
    }

    private JComboBox createTool() {
        JComboBox result = new JComboBox(this.comboBoxModel){

            @Override
            public Dimension getMaximumSize() {
                return super.getPreferredSize();
            }

            @Override
            public int getItemCount() {
                Model dm;
                if (this.dataModel instanceof Model && !(dm = (Model)this.dataModel).isUpdating()) {
                    dm.update();
                }
                return super.getItemCount();
            }
        };
        result.setToolTipText(TOOLTIP);
        result.setAlignmentX(0.0f);
        result.setAlignmentY(0.5f);
        result.setPrototypeDisplayValue(PROTOTYPE_VALUE);
        result.addPropertyChangeListener("editor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JComboBox box = (JComboBox)evt.getSource();
                ZoomTool.configureEditor(box);
            }
        });
        result.setEditable(true);
        result.addItemListener(new ItemHandler());
        result.putClientProperty(this, this);
        ZoomTool.configureEditor(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scaleChanged() {
        if (this.comboBoxModel.isUpdating()) {
            return;
        }
        this.comboBoxModel.setUpdating(true);
        try {
            this.comboBox.setSelectedItem(this.zoomModel.getSelectedItem());
        }
        finally {
            this.comboBoxModel.setUpdating(false);
        }
    }

    private void selectedItemChanged() {
        if (this.comboBoxModel.isUpdating()) {
            return;
        }
        if (this.comboBox.getSelectedItem() == null) {
            this.scaleChanged();
            return;
        }
        this.zoomModel.setSelectedItem(this.comboBox.getSelectedItem().toString());
    }

    private static void configureEditor(JComboBox box) {
        if (box.getEditor() != null && box.getEditor().getEditorComponent() instanceof JTextField) {
            JTextField field = (JTextField)box.getEditor().getEditorComponent();
            field.setColumns(PROTOTYPE_VALUE.length());
            field.setToolTipText(TOOLTIP);
        }
    }

    private class ItemHandler
    implements ItemListener {
        private ItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ZoomTool.this.selectedItemChanged();
            }
        }
    }

    private static class ScaleHandler
    extends WeakPropertyChangeListener {
        public ScaleHandler(ZoomTool target, SketchPanel source) {
            super(target, source);
        }

        @Override
        protected void propertyChanged(Object target, Object source, PropertyChangeEvent evt) {
            if (evt.getPropertyName() == null || "scale".equals(evt.getPropertyName())) {
                ((ZoomTool)target).scaleChanged();
            }
        }
    }

    private static class Model
    extends DefaultComboBoxModel {
        private boolean updating;
        private ZoomModel zoomModel;

        public Model(ZoomModel zoomModel) {
            this.zoomModel = zoomModel;
        }

        public boolean isUpdating() {
            return this.updating;
        }

        public void setUpdating(boolean b) {
            this.updating = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() {
            this.updating = true;
            try {
                Object selected = this.getSelectedItem();
                this.removeAllElements();
                String[] values = this.zoomModel.getItems();
                for (int i = 0; i < values.length; ++i) {
                    this.addElement(values[i]);
                }
                this.setSelectedItem(selected);
            }
            finally {
                this.updating = false;
            }
        }
    }
}

