/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractDynamicAction;
import chemaxon.marvin.sketch.swing.actions.atom.ChargeAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MolAtom;
import java.util.ArrayList;
import javax.swing.Action;

public class AtomChargeListAction
extends AbstractDynamicAction
implements PopupActionProvider {
    public static final int MAX_CHARGE = 2;

    public AtomChargeListAction() {
    }

    public AtomChargeListAction(SketchPanel panel) {
        super(panel);
    }

    @Override
    protected Object getSelection() {
        return this.getSelectedAtom(false);
    }

    @Override
    protected Action[] createActions(Object selection) {
        Action[] result = this.createActions();
        this.updateActions(result, (MolAtom)selection);
        return result;
    }

    @Override
    protected Action[] updateActions(Action[] actions, Object selection) {
        this.updateActions(actions, (MolAtom)selection);
        return actions;
    }

    private void updateActions(Action[] actionList, MolAtom atom) {
        for (int i = 0; i < actionList.length; ++i) {
            if (actionList[i] == null) continue;
            ((ChargeAction)actionList[i]).setAtom(atom);
        }
    }

    @Override
    public Action createLocalInstance(Context context) {
        MolAtom atom = AtomChargeListAction.lookupAtom(context, false);
        return atom != null && !AtomChargeListAction.isSGroupAtom(atom) ? this.createLocalInstance(atom) : null;
    }

    private ChargeAction[] createActions() {
        int i;
        ArrayList<ChargeAction> result = new ArrayList<ChargeAction>();
        for (i = 2; i >= 1; --i) {
            result.add(this.createAction(-i));
        }
        result.add(this.createAction(0));
        for (i = 1; i <= 2; ++i) {
            result.add(this.createAction(i));
        }
        result.add(this.createAction(Integer.MAX_VALUE));
        return result.toArray(new ChargeAction[result.size()]);
    }

    private ChargeAction createAction(int charge) {
        return new ChargeAction(this.getPanel(), charge);
    }
}

