/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.actions.AbstractDynamicAction;
import chemaxon.marvin.sketch.swing.actions.atom.EnhancedStereoAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MolAtom;
import java.util.ArrayList;
import javax.swing.Action;

public class AtomEnhancedStereoListAction
extends AbstractDynamicAction
implements PopupActionProvider {
    public static final int MAX_STEREO_ITEMS = 2;
    private final int stereoItemCount;

    public AtomEnhancedStereoListAction(int stereoItemCount) {
        this.stereoItemCount = stereoItemCount;
    }

    public AtomEnhancedStereoListAction() {
        this(2);
    }

    @Override
    protected Action[] createActions(Object selection) {
        int i;
        ArrayList<EnhancedStereoAction> result = new ArrayList<EnhancedStereoAction>();
        result.add(this.createAction(0));
        result.add(this.createAction(1));
        for (i = 1; i <= this.stereoItemCount; ++i) {
            result.add(this.createAction(2, i));
        }
        result.add(this.createAction(2, -1));
        for (i = 1; i <= this.stereoItemCount; ++i) {
            result.add(this.createAction(3, i));
        }
        result.add(this.createAction(3, -1));
        return this.updateActions(result.toArray(new Action[result.size()]), selection);
    }

    private EnhancedStereoAction createAction(int flag) {
        return this.createAction(flag, -1);
    }

    private EnhancedStereoAction createAction(int flag, int stereo) {
        return new EnhancedStereoAction(this.getPanel(), flag, stereo);
    }

    @Override
    protected Object getSelection() {
        return this.getSelectedAtom();
    }

    @Override
    protected Action[] updateActions(Action[] actions, Object selection) {
        this.update(actions, selection);
        return actions;
    }

    private void update(Action[] actions, Object selection) {
        MolAtom atom = (MolAtom)selection;
        for (int i = 0; i < actions.length; ++i) {
            ((EnhancedStereoAction)actions[i]).setAtom(atom);
        }
    }

    @Override
    public Action createLocalInstance(Context context) {
        MolAtom atom = AtomEnhancedStereoListAction.lookupAtom(context);
        return atom != null ? this.createLocalInstance(atom) : null;
    }
}

