/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractDynamicAction;
import chemaxon.marvin.sketch.swing.actions.atom.IsotopeAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MolAtom;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;

public class AtomIsotopeListAction
extends AbstractDynamicAction
implements PopupActionProvider {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(AtomIsotopeListAction.class.getName());

    public AtomIsotopeListAction() {
    }

    public AtomIsotopeListAction(SketchPanel panel) {
        super(panel);
    }

    @Override
    protected Object getSelection() {
        return this.getSelectedAtom();
    }

    @Override
    protected Action[] createActions(Object selection) {
        if (selection == null) {
            return new Action[0];
        }
        MolAtom atom = (MolAtom)selection;
        ArrayList<IsotopeAction> result = new ArrayList<IsotopeAction>();
        result.add(new IsotopeAction(this.getPanel(), atom, bundle.getString("noneLabel"), 0));
        int z = atom.getAtno();
        for (int i = 0; i < 300; ++i) {
            int isoType = MolAtom.isotopeType(z, i);
            if (isoType <= 0) continue;
            this.addIsotope(result, atom, i, isoType, false);
            if (z != 1 || i != 2 && i != 3) continue;
            this.addIsotope(result, atom, i, isoType, true);
        }
        return result.size() > 1 ? result.toArray(new Action[result.size()]) : new Action[]{};
    }

    private void addIsotope(List result, MolAtom atom, int a, int isoType, boolean specSymPreferred) {
        int z = atom.getAtno();
        String sym = MolAtom.symbolOf(z);
        String specSym = MolAtom.symbolOf(z, a);
        StringBuffer buffer = new StringBuffer(specSymPreferred ? specSym : sym);
        if (!specSymPreferred || specSym.equals(sym)) {
            buffer.append('-');
            buffer.append(a);
        }
        if (isoType > 1) {
            buffer.append(" *");
        }
        if (specSymPreferred) {
            a |= 0x1000;
        }
        result.add(new IsotopeAction(this.getPanel(), atom, buffer.toString(), a));
    }

    @Override
    protected Action[] updateActions(Action[] actions, Object selection) {
        return this.createActions(selection);
    }

    @Override
    public Action createLocalInstance(Context context) {
        MolAtom atom = AtomIsotopeListAction.lookupAtom(context);
        return atom != null ? this.createLocalInstance(atom) : null;
    }
}

