/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractDynamicAction;
import chemaxon.marvin.sketch.swing.actions.atom.LinkNodeAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Action;

public class AtomLinkNodeListAction
extends AbstractDynamicAction
implements PopupActionProvider {
    private static final int MAX_LINK_NUMBER = 100;
    private ResourceBundle bundle = ResourceBundle.getBundle(AtomLinkNodeListAction.class.getName());

    public AtomLinkNodeListAction() {
    }

    public AtomLinkNodeListAction(SketchPanel panel) {
        super(panel);
    }

    @Override
    protected Action[] createActions(Object selection) {
        int start;
        MolAtom atom;
        Parameter p = (Parameter)selection;
        MolAtom molAtom = atom = p != null ? p.atom : null;
        if (atom == null || !LinkNodeAction.isEnabledFor(atom)) {
            return new Action[0];
        }
        ArrayList<LinkNodeAction> result = new ArrayList<LinkNodeAction>();
        result.add(new LinkNodeAction(this.getPanel(), this.bundle.getString("noneLabel"), atom, p.middleAtom, 1));
        int min = atom.getMinRepetitions();
        for (int i = start = min == 1 ? min + 1 : min; i <= 100; ++i) {
            result.add(new LinkNodeAction(this.getPanel(), "L" + min + "-" + i, atom, p.middleAtom, i));
        }
        return result.toArray(new Action[result.size()]);
    }

    private MolAtom getMiddleSelectionAtom() {
        MoleculeGraph molg = this.getEditor().getSelectionDocument().getMainMoleculeGraph();
        if (this.getEditor().isLinkNodeCreationPossible() && molg.getAtomCount() != 1) {
            return this.getEditor().getMiddleSelectionAtom();
        }
        return null;
    }

    @Override
    protected Object getSelection() {
        boolean middleAtom = false;
        MolAtom atom = this.getSelectedAtom(false);
        if (atom == null) {
            atom = this.getMiddleSelectionAtom();
            middleAtom = true;
        }
        return this.isAllowed(atom) ? new Parameter(atom, middleAtom) : null;
    }

    @Override
    protected Action[] updateActions(Action[] actions, Object selection) {
        return this.createActions(selection);
    }

    @Override
    public Action createLocalInstance(Context context) {
        boolean middleAtom = false;
        MolAtom atom = AtomLinkNodeListAction.lookupAtom(context, false);
        if (atom == null) {
            atom = this.getMiddleSelectionAtom();
            middleAtom = true;
        }
        return this.isAllowed(atom) ? this.createLocalInstance(new Parameter(atom, middleAtom)) : null;
    }

    private boolean isAllowed(MolAtom atom) {
        return atom != null && atom.getAtno() != 137;
    }

    private static class Parameter {
        private final MolAtom atom;
        private final boolean middleAtom;

        private Parameter(MolAtom atom, boolean middleAtom) {
            this.atom = atom;
            this.middleAtom = middleAtom;
        }
    }
}

