/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractDynamicAction;
import chemaxon.marvin.sketch.swing.actions.atom.RgroupAttachmentAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Action;

public class AtomRgroupAttachmentListAction
extends AbstractDynamicAction
implements PopupActionProvider {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(AtomRgroupAttachmentListAction.class.getName());

    public AtomRgroupAttachmentListAction() {
    }

    public AtomRgroupAttachmentListAction(SketchPanel panel) {
        super(panel);
    }

    @Override
    protected Object getSelection() {
        return this.getSelectedAtom();
    }

    @Override
    protected Action[] createActions(Object selection) {
        if (selection == null) {
            return new Action[0];
        }
        MolAtom atom = (MolAtom)selection;
        ArrayList<RgroupAttachmentAction> result = new ArrayList<RgroupAttachmentAction>();
        result.add(new RgroupAttachmentAction(this.getPanel(), atom, bundle.getString("noneLabel"), 0));
        MoleculeGraph parent = atom.getParent();
        for (int i = 1; i <= parent.getMaxRgroupAttachmentPointOrder(); ++i) {
            result.add(new RgroupAttachmentAction(this.getPanel(), atom, Integer.toString(i), i));
        }
        return result.size() > 1 ? result.toArray(new Action[result.size()]) : new Action[]{};
    }

    @Override
    protected Action[] updateActions(Action[] actions, Object selection) {
        return this.createActions(selection);
    }

    @Override
    public Action createLocalInstance(Context context) {
        MolAtom atom = AtomRgroupAttachmentListAction.lookupAtom(context);
        return atom != null ? this.createLocalInstance(atom) : null;
    }
}

