/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractDynamicAction;
import chemaxon.marvin.sketch.swing.actions.atom.ValenceAction;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.PopupActionProvider;
import chemaxon.struc.MolAtom;
import java.util.ArrayList;
import javax.swing.Action;

public class AtomValenceListAction
extends AbstractDynamicAction
implements PopupActionProvider {
    private static final int MAX_VALENCE_INDEX = 8;

    public AtomValenceListAction() {
    }

    public AtomValenceListAction(SketchPanel panel) {
        super(panel);
    }

    @Override
    protected Action[] createActions(Object selection) {
        ArrayList<ValenceAction> result = new ArrayList<ValenceAction>();
        result.add(new ValenceAction(this.getPanel(), -1));
        result.add(new ValenceAction(this.getPanel(), 0));
        for (int i = 1; i <= 8; ++i) {
            result.add(new ValenceAction(this.getPanel(), i));
        }
        return this.updateActions(result.toArray(new Action[result.size()]), selection);
    }

    @Override
    protected Object getSelection() {
        return this.getSelectedAtom(false);
    }

    @Override
    protected Action[] updateActions(Action[] actions, Object selection) {
        for (int i = 0; i < actions.length; ++i) {
            ((ValenceAction)actions[i]).setAtom((MolAtom)selection);
        }
        return actions;
    }

    @Override
    public Action createLocalInstance(Context context) {
        MolAtom atom = AtomValenceListAction.lookupAtom(context, false);
        return atom != null && !AtomValenceListAction.isSGroupAtom(atom) ? this.createLocalInstance(atom) : null;
    }
}

