/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchAction;
import chemaxon.marvin.sketch.swing.actions.atom.MenuUtil;
import chemaxon.marvin.uif.action.support.AbstractStateAction;
import chemaxon.struc.MolAtom;
import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class ChargeAction
extends AbstractStateAction {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(ChargeAction.class.getName());
    private SketchPanel panel;
    private MolAtom atom;
    private int charge;

    ChargeAction(SketchPanel panel, int charge) {
        super(ChargeAction.createName(charge));
        this.panel = panel;
        this.charge = charge;
        this.setRadio(true);
        this.update();
    }

    private static String createName(int charge) {
        if (charge == Integer.MAX_VALUE) {
            try {
                return bundle.getString("custom.label");
            }
            catch (MissingResourceException e) {
                return "Custom...";
            }
        }
        String prefix = charge > 0 ? "+" : "";
        return prefix + Integer.toString(charge);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.charge == Integer.MAX_VALUE) {
            Integer c = MenuUtil.showIntegerInputDialog(this.panel, bundle.getString("message"), bundle.getString("title"));
            if (c == null) {
                return;
            }
            this.charge = c;
        }
        this.panel.getCanvas().setCharge(this.atom, this.charge);
    }

    void setAtom(MolAtom atom) {
        this.atom = atom;
        this.update();
    }

    private void update() {
        this.setEnabled(AbstractSketchAction.isNormalAtom(this.atom));
        this.setSelected(this.isEnabled() && this.atom != null && this.atom.getCharge() == this.charge);
    }
}

