/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.sketch.swing.actions.atom;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.sketch.swing.actions.AbstractSketchAction;
import chemaxon.marvin.sketch.swing.actions.SketchPanelAware;
import chemaxon.marvin.sketch.swing.actions.atom.MenuUtil;
import chemaxon.marvin.uif.action.ComponentProvider;
import chemaxon.marvin.uif.action.Context;
import chemaxon.marvin.uif.action.DynamicMenuProvider;
import chemaxon.marvin.uif.action.PopupActionProvider;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class CustomMenuAction
extends AbstractSketchAction
implements ComponentProvider.MenuItemProvider,
PopupActionProvider {
    private int maxRowCount;
    private DynamicMenuProvider delegate;

    public CustomMenuAction(DynamicMenuProvider delegate) {
        this(delegate, -1);
    }

    public CustomMenuAction(DynamicMenuProvider delegate, int maxRowCount) {
        this.init(delegate, maxRowCount);
    }

    public CustomMenuAction(SketchPanel panel, DynamicMenuProvider delegate) {
        this(panel, delegate, -1);
    }

    public CustomMenuAction(SketchPanel panel, DynamicMenuProvider delegate, int maxRowCount) {
        super(panel);
        this.init(delegate, maxRowCount);
    }

    private void init(DynamicMenuProvider delegate, int maxRowCount) {
        this.delegate = delegate;
        this.maxRowCount = maxRowCount;
    }

    @Override
    public void setSketchPanel(SketchPanel panel) {
        super.setSketchPanel(panel);
        if (this.delegate instanceof SketchPanelAware) {
            ((SketchPanelAware)((Object)this.delegate)).setSketchPanel(panel);
        }
    }

    @Override
    public JMenuItem getMenuItem() {
        JMenu result = new JMenu(this);
        result.addMenuListener(new MenuHandler(this.maxRowCount, this.delegate));
        return result;
    }

    @Override
    public Action createLocalInstance(Context context) {
        if (this.delegate instanceof PopupActionProvider) {
            PopupActionProvider popupProvider = (PopupActionProvider)((Object)this.delegate);
            Action popupInstance = popupProvider.createLocalInstance(context);
            if (popupInstance instanceof DynamicMenuProvider) {
                return new CustomMenuAction(this.getPanel(), (DynamicMenuProvider)((Object)popupInstance), this.maxRowCount);
            }
            return popupInstance;
        }
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private static class MenuHandler
    implements MenuListener {
        private int maxRow;
        private DynamicMenuProvider provider;
        private Action[] currentActions;

        public MenuHandler(int maxRow, DynamicMenuProvider provider) {
            this.maxRow = maxRow;
            this.provider = provider;
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            Action[] actions = this.provider.getMenuItems();
            this.currentActions = actions;
            MenuUtil.fill(menu, Arrays.asList(this.currentActions), this.maxRow);
        }
    }
}

